<!doctype html>
<html class="no-js" lang="en">

<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title><?php echo $__env->yieldContent('title'); ?> </title>
   <?php echo $__env->yieldContent('meta_tags'); ?>
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
   <?php if(
        request()->routeIs('web') || 
        request()->routeIs('shop') || 
        request()->routeIs('service.details') || 
        request()->routeIs('terms.condition') || 
        request()->routeIs('privacy.policies') || 
        request()->routeIs('about-us') || 
        request()->routeIs('blogs') || 
        request()->routeIs('blog/details') || 
        request()->routeIs('thankyou')
    ): ?>
   <link rel="canonical" href="<?php echo e(URL::current()); ?>" />
   <?php endif; ?>
   <!-- Place favicon.ico in the root directory -->
   <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('web/assets/img/favicon.png')); ?>">
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
   <!-- CSS here -->
   <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700;800;900;1000&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap" rel="stylesheet">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/bootstrap.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/animate.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/swiper-bundle.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/splide.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/slick.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/nouislider.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/datepicker.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/magnific-popup.css')); ?>">
   <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/font-awesome-pro.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/flaticon_kleaso.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/circularProgressBar.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/spacing.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('web/assets/css/main.css')); ?>">
   
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/rateYo/2.3.4/jquery.rateyo.min.css" integrity="sha512-JEUoTOcC35/ovhE1389S9NxeGcVLIqOAEzlpcJujvyUaxvIXJN9VxPX0x1TwSo22jCxz2fHQPS1de8NgUyg+nA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"/>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.css" integrity="sha512-rd0qOHVMOcez6pLWPVFIv7EfSdGKLt+eafXh4RO/12Fgr41hDQxfGvoi1Vy55QIVcQEujUE1LQrATCLl2Fs+ag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
   <link rel="stylesheet" href="<?php echo e(asset('css/global.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('css/all.min.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('css/all.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('css/spacing.css')); ?>">
   <!--<link rel="stylesheet" href="<?php echo e(asset('css/free.css')); ?>">-->
   <link rel="stylesheet" href="<?php echo e(asset('css/header.css')); ?>">

   

   <link href="https://fonts.googleapis.com/css?family=Raleway" rel="stylesheet">
   <!-- <script src="<?php echo e(asset('web/assets/js/vendor/jquery.js')); ?>"></script> -->


<!-- Global site tag (gtag.js) - Google Ads: 350704877 -->
 <script async src="https://www.googletagmanager.com/gtag/js?id=AW-350704877"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-350704877');
</script>
 

<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-TKS4QEPSDW"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-TKS4QEPSDW');
</script>

<meta name="facebook-domain-verification" content="97qpektjgtqcac301tpqh9r5j9gfom" /> 


<!-- Google Tag Manager -->
 <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-M4H95Q76');</script>
<!-- End Google Tag Manager -->
 
   <!-- JS here -->
   <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "jqydfnxqiq");
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "WebSite",
  "name": "Urbanmop.com",
  "url": "https://www.urbanmop.com/",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "https://www.urbanmop.com/search?query={search_term_string}",
    "query-input": "required name=search_term_string"
  }
}</script>
  <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "Urbanmop.com",
  "image": "https://www.urbanmop.com/public/web/urbanmop-meta-ogg.png",
  "@id": "https://www.urbanmop.com/#organisation",
  "url": "https://www.urbanmop.com/",
  "telephone": "+971585814007",
  "priceRange": "$$",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "The Iridium - Office 101 - Umm Suqeim St - Al Barsha 1",
    "addressLocality": "Dubai",
    "postalCode": "0",
    "addressCountry": "AE"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 25.1186798,
    "longitude": 55.2071932
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Sunday",
      "Saturday"
    ],
    "opens": "09:00",
    "closes": "17:00"
  },
  "sameAs": [
    "https://www.facebook.com/UrbanMop.UAE",
    "https://x.com/urbanmop",
    "https://www.instagram.com/urbanmop.uae/",
    "https://www.youtube.com/@urbanmop5452",
    "https://www.urbanmop.com/",
    "https://ae.linkedin.com/company/urbanmopcom"
  ]
}
</script>


<!-- Meta Pixel Code -->
<script>

!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '516865673183946');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=516865673183946&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->



  <style>


    .error {
         color: red;
      }

    .global_find-service-input{
        box-shadow: none !important;
    }
    

      #snackbar {
        visibility: hidden;
        min-width: 250px;
        margin-left: -125px;
        background-color: #333;
        color: #fff;
        text-align: center;
        border-radius: 2px;
        padding: 16px;
        position: fixed;
        z-index: 1;
        left: 40%;
        bottom: 30px;
        font-size: 17px;
      }

      #snackbar.show {
        visibility: visible;
        -webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
        animation: fadein 0.5s, fadeout 0.5s 2.5s;
      }

      @-webkit-keyframes fadein {
        from {bottom: 0; opacity: 0;} 
        to {bottom: 30px; opacity: 1;}
      }

      @keyframes  fadein {
        from {bottom: 0; opacity: 0;}
        to {bottom: 30px; opacity: 1;}
      }

      @-webkit-keyframes fadeout {
        from {bottom: 30px; opacity: 1;} 
        to {bottom: 0; opacity: 0;}
      }

      @keyframes  fadeout {
        from {bottom: 30px; opacity: 1;}
        to {bottom: 0; opacity: 0;}
      }



      @media  only screen and (max-width: 2400px) and (min-width: 768px)  {


      	.tp-header-market span{
      		margin-left: 1px !important;
    		font-size: 12px !important;
      	}

      	.tp-header-market a {
    		display: block !important;
		}
      #mobile-call-header{
            display: none !important;
          }

          #mobile-header-content{
          	display: none !important;
          }
      }



      @media  only screen and (max-width: 768px) and (min-width: 200px)  {

    

      	.tp-header-market a{
      		display: block !important;
      	}

		.tp-header-market span{
      		margin-left: 1px !important;
    		/*font-size: 12px !important;*/
		}

      	#login-button-desktop{
      		display: none !important;
      	}

        #head-call-label, #head-call-first, #head-call-second{
          display: none !important;
        }

        .tp-header-logo img{
          width: 95px !important;
        }

        .tp-header-logo {
          padding-top: 0px !important;
          padding-bottom: 0px !important;
        }

        .tp-header-space .col-4 {
          padding-left: 5px !important;
          padding-right: 5px !important;
          }

      #head-call-first-mobile{
      	font-size: 12px !important;
		margin-bottom: 10px !important;
      	width: 100% !important;
        background-color: #0c203e !important;
        margin-right: 0px !important;
        padding: 2px 10px!important;
        color: #fff !important;
        border: 1px solid #142f58 !important;
        font-weight: 500 !important;
        box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
        -webkit-box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
        -moz-box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
      }

      #head-call-second-mobile {
      	font-size: 12px !important;
      		width: 100% !important;
          background-color: #e8ac18 !important;
          padding: 2px 10px !important;
          color: #000 !important;
          
          border: 1px solid #e8ac18 !important;
          color: #fff !important;
          font-weight: 600 !important;
          box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
          -webkit-box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
          -moz-box-shadow: 0px 2px 5px 1px rgba(0,0,0,0.41) !important;
      }

      #head-call-label-mobile {
        padding: 5px 0px !important;
        font-size: 18px !important;
        background-color: transparent !important;
        color: #1b1b1b !important;
        font-weight: 600 !important;
        margin-right: 0px !important;
        }


      .tp-header-space .col-8{
        padding-left: 0px !important;
        padding-right: 0px !important;
      }

      #mobile-login{
        padding: 0px 0px !important;
      }

      #mobile-search-bar .search-form{
        padding-right:0px !important;
        padding-left: 10px !important
      }


      }
      .tp-footer-area{
         margin-top: 10px !important;
      }

      .login-btn {
          padding: 10px 18px;
          margin-left: 10px;
          background-color: black;
          box-shadow: 0 11px 16px 0 rgba(0,0,0,0.2), 0 6px 20px 0 rgba(0,0,0,0.19);
      }
      
      body, h1, h2, h3, h4, h5. h6, ol, ul, li, p, input, textarea, label, span{
          font-family: "DM Sans", sans-serif !important;
      }
      
       .btn-header{
            display: flex;
            align-items: center;
            gap: 5px;
            height: 48px;
            /* min-width: 48.5px; */
            justify-content: center;
            padding: 12px 18px;
            white-space: pre;
            font-size: 16px !important;
        }
        
        .btn-header span{
            white-space: pre;
            font-size: 16px !important;
        }
        
         #global_searchInput {
            width: 100%;
            padding: 10px;
            border: 0px solid #686767;
            border-radius: 10px 0 0 10px;
            font-size: 1rem;
          
          }
          
          .form-input-1{
              font-size: 16px;
              width: 100%;
              padding: 10px 20px;
              border:2px solid var(--primary-color-opacity) !important;
              border-radius: 6px;
              transition: all 0.3s ease-in-out;
              color: var(--black-color) !important;
              background-color: var(--white-color) !important;
              background: var(--white-color) !important;
              min-height: 52px !important;
              text-align: left !important;
              line-height: normal !important;
            }
            
            select.form-input-1{
              min-height: 52px !important;
            }
            
            .form-input-1:focus {
  outline: 0;
  border-color: var(--primary-color) !important;
}

@media(max-width:991px){
  .form-input-1{
    min-width: 100%;
    min-height: 52px;
  }
}


        
        textarea{
          font-size: 16px;
          width: 100%;
          padding: 10px 20px;
          border:2px solid var(--primary-color-opacity) !important;
          border-radius: 6px;
          transition: all 0.3s ease-in-out;
          min-height: 150px;
          color: var(--black-color);
          resize: none;
          background: var(--white-color) !important;
              line-height: normal;
        }
        
        textarea:focus {
          outline: 0;
          border-color: var(--primary-color) !important;
        }
        
        
        .modal-footer .btn{
                padding: 12px 30px !important;
        }
        
        .cart-header .item-count{
            position: absolute;
            width: 20px;
            height: 20px;
            top: -10px;
            right: -10px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%);
            color: #fff;
            font-size: 12px !important;
        }
        
        
   </style>

</head>

<body >
   <!-- <div id="loading">
      <div id="loading-center">
         <div id="loading-center-absolute">
            <div class="tp-loading-content text-center">
               <div class="loading-infinity">
                  <div><span></span></div>
                  <div> <span></span></div>
                  <div> <span></span></div>
                  <img src="<?php echo e(url('web/assets/img/Urbanmop-Loader-256.gif')); ?>" height="100px" width="100px">
               </div>
            </div>
         </div>
      </div>
   </div> -->
   <!-- pre loader area end -->


    
   <header class="p-0">
         <nav class="navbar navbar-light bg-light navbar-expand-md better-bootstrap-nav-left">
            <div class="container">
               <div class="d-flex align-items-center gap-2 w-md-100 flex-md-nowrap flex-wrap">
                  <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                     <img src="<?php echo e(asset('web/assets/img/logo/urban-mop-horz.svg')); ?>" alt="Logo" title="Logo">
                  </a>
                  <div class="dropdown w-md-100 location-area-box">
                  <!--<a href="#!" class="location-header dropdown-toggle" id="locationDropdown" -->
                  <button class="location-header dropdown-toggle" id="locationDropdown" 
                  <?php if(auth()->guard()->check()): ?>
                  <?php
                        $addressCount = App\Address::where(['user_id' => auth()->user()->id])->count();
                  ?>
                  <?php if($addressCount > 1): ?>
                        data-bs-toggle="dropdown"
                  <?php endif; ?>
               <?php endif; ?>
                  aria-expanded="false">
                     <i class="fal fa-map-marker-alt"></i>
                     <span id="selectedLocation"  class="w-md-100" <?php echo e(!auth()->check() ? ' data-bs-toggle=modal data-bs-target=#loginModal onclick=handleLocationClick()' : ''); ?> >
                        <?php if(auth()->guard()->check()): ?>
                              <?php
                                 $activeAddress = App\Address::where(['user_id' => auth()->user()->id, 'is_active' => 1])->first();
                              ?>
                              <?php if($activeAddress): ?>
                                 <?php echo e($activeAddress->flat_no); ?>, <?php echo e($activeAddress->building); ?> - <?php echo e($activeAddress->city->name ?? 'N/A'); ?>, <?php echo e($activeAddress->locality_info->name ?? 'N/A'); ?>

                              <?php else: ?>
                                 <span id="liveLocation">Fetching location...</span>
                              <?php endif; ?>
                        <?php else: ?>
                              Select Location
                        <?php endif; ?>
                     </span>
                  </button>
                  <!--</a>-->
                  <script>
                     function handleLocationClick() {
                        
                        const selectedLocation = document.getElementById('selectedLocation');
                     
                        if (selectedLocation && selectedLocation.textContent.trim() == 'Select Location') {
                              showlogin(); 
                        }
                     }
                  </script>
                  <script>
                  document.addEventListener('DOMContentLoaded', function () {


                     
                     const liveLocationElement = document.getElementById('liveLocation');

                     if (liveLocationElement) {
                        // Check if Geolocation API is supported
                        if (navigator.geolocation) {
                              navigator.geolocation.getCurrentPosition(
                                 function (position) {
                                    const { latitude, longitude } = position.coords;

                                    // Use Google Maps API or Geocoder to fetch address details
                                    const geocoder = new google.maps.Geocoder();
                                    const latlng = { lat: latitude, lng: longitude };

                                    geocoder.geocode({ location: latlng }, function (results, status) {
                                          if (status === 'OK' && results[0]) {
                                             liveLocationElement.textContent = results[0].formatted_address;
                                          } else {
                                             liveLocationElement.textContent = 'Unable to fetch location.';
                                          }
                                    });
                                 },
                                 function (error) {
                                    liveLocationElement.textContent = 'Location access denied.';
                                 }
                              );
                        } else {
                              liveLocationElement.textContent = 'Geolocation is not supported.';
                        }
                     }
                  });


                  </script>
                     <?php if(auth()->guard()->check()): ?>
                        <?php
                           $addresses = App\Address::where(['user_id' => auth()->user()->id, 'is_active' => 0])->get();
                        ?>
                     <?php endif; ?>
                        <?php if(auth()->guard()->check()): ?>
                           <ul class="dropdown-menu" aria-labelledby="locationDropdown">
                                 <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                       <a class="dropdown-item" href="javascript:void(0)" onclick="setActiveAddress(<?php echo e($address->id); ?>)">
                                          <?php echo e($address->flat_no); ?>, <?php echo e($address->building); ?> - <?php echo e($address->city->name ?? 'N/A'); ?>, <?php echo e($address->locality_info->name ?? 'N/A'); ?>

                                       </a>
                                    </li>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           </ul>
                        <?php else: ?>
                           <ul class="dropdown-menu" aria-labelledby="locationDropdown">
                              <li><button class="dropdown-item" data-bs-target="#loginModal" data-bs-toggle="modal" onclick="handleLocationClick()">Login to Select Location</button></li>
                              <!--<li><a class="dropdown-item" href="#!" data-bs-target="#loginModal" data-bs-toggle="modal" onclick="handleLocationClick()">Login to Select Location</a></li>-->
                           </ul>
                        <?php endif; ?>


                  </div>

                  <script>
                     function updateAddress(addressId, addressText) {
                        jQuery.ajax({
                           url: `<?php echo e(url('update_address')); ?>/${addressId}`,
                           method: 'POST',
                           headers: {
                              'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                           },
                           success: function (response) {
                              if (response.success) {
                                 // Update the selected location
                                 jQuery('#selectedLocation').text(addressText);

                                 // Fetch and update the dropdown menu dynamically
                                 jQuery.ajax({
                                    url: `<?php echo e(url('get_user_addresses')); ?>`, 
                                    method: 'GET',
                                    success: function (data) {
                                       let dropdownMenu = jQuery('#dropdownMenu');
                                       dropdownMenu.empty(); 

                                       jQuery.each(data, function (index, address) {
                                          dropdownMenu.append(`
                                             <li>
                                                <a class="dropdown-item" href="javascript:void(0)" onclick="updateAddress(${address.id}, '${address.address}')">
                                                   ${truncateAddress(address.address, 20)}
                                                </a>
                                             </li>
                                          `);
                                       });

                                       console.log('Dropdown menu updated successfully.');
                                    },
                                    error: function (error) {
                                       console.error('Error fetching addresses:', error);
                                    }
                                 });
                              } else {
                                 alert(response.error || 'Failed to update the address.');
                              }
                           },
                           error: function (error) {
                              console.error('Error updating address:', error);
                           }
                        });
                     }

                     // Helper function to truncate address text
                     function truncateAddress(text, maxLength) {
                        return text.length > maxLength ? text.substring(0, maxLength) + '...' : text;
                     }
                  </script>


               </div>
               <script>
                  function selectCity(cityName) {
                   
        document.getElementById('selectedLocation').textContent = cityName;
                  }
               </script>
     <!-- gap-3 gap-lg-4 -->
             <div class="d-flex  align-items-center position-md-absolute right-md-10 top-md-10">
                 <button id="search-toggle" class="d-block d-lg-none position-relative" style="right: 0;">
                     <i class="fal fa-search" id="login"></i>
                 </button>
                 <div class="search-container position-relative p-0 d-none d-lg-block">
                     <form action="<?php echo e(route('search')); ?>"  method="Get" class="w-100">
                         <input type="search" style="padding-left: 15px;" placeholder="Search here..." id="global_searchInput" class="global_find-service-input" name="title" value="" />
                         <button type="submit"><i class="fal fa-search"></i></button>
                     </form>
                 </div>

<?php if(Auth::user()): ?>

<div class="dropdown profile-dropdown">
    <button class="dropdown-toggle btn-1 btn-header d-sm-flex show" style="white-space: pre; border: 0 !important" type="button" data-bs-toggle="dropdown" aria-expanded="true">
    <i class="fas fa-user"></i>  <span class="d-none d-md-block"> Hi, <?php echo e(auth()->user()->name); ?></span>
    </button>
    <ul class="dropdown-menu" data-bs-popper="static">
        <li><a class="dropdown-item" href="<?php echo e(url('profile')); ?>">My Profile</a></li>
        <li><a class="dropdown-item" href="<?php echo e(url('my-bookings')); ?>">My Bookings</a></li>
        <li><a class="dropdown-item" href="<?php echo e(url('my-wallet')); ?>">My Wallet</a></li>
        <li><a class="dropdown-item" href="<?php echo e(url('saved-locations')); ?>">Saved Locations</a></li>
        <li><a class="dropdown-item" href="<?php echo e(url('my-rewards')); ?>">My Rewards</a></li>
        <!-- <li><a class="dropdown-item" href="<?php echo e(url('delete-account')); ?>">Delete Account</a></li> -->
        <li><a class="dropdown-item" href="<?php echo e(url('logout-user')); ?>">Logout</a></li>
    </ul>
</div>


   <?php if(auth()->guard()->check()): ?>
      <a href="<?php echo e(route('cart.list')); ?>" class="d-none d-lg-block cart-header position-relative">
         <span class="item-count"><?php echo e(App\Card::where(['is_checkout' => 'Processing','user_id' => auth()->user()->id])->whereNotNull('g_total')->where('g_total', '>', 0)->count()); ?></span><img src="<?php echo e(asset('images/cart.svg')); ?>" style="min-width: 26px;" class="img-fluid" alt="">
      </a>
   <?php else: ?>
      <a href="#" data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()" class="d-none d-lg-block cart-header position-relative">
         <span class="item-count"><?php echo e(App\Card::where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()); ?></span><img src="<?php echo e(asset); ?>" style="min-width: 26px;" class="img-fluid" alt="">
      </a>
   <?php endif; ?>

<?php else: ?>

   <div class="tp-header-market btn-header  p-relative" id="mobile-login">

      <button type="button" class="btn-1 btn-header d-sm-flex ms-2 ms-md-0" style="white-space: pre;" data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()"><i class="fas fa-user"></i> <span class="d-none d-md-block">Login/Register</span></button>
      
   </div>
   <script>

      let item_object_detail = null;

      // Get selected maid details
      const maidSelected = document.querySelector('input[name="maid_id"]:checked');
      const maidDetails = maidSelected ? {
         maid_id: maidSelected.value,
         maid_name: maidSelected.nextElementSibling.textContent.trim(),
         attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
         category_id: maidSelected.getAttribute('data-category-id'),
         sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
         child_category_id: maidSelected.getAttribute('data-child-category-id')
      } : {};

      // Get selected hours
      const hourSelected = document.querySelector('input[name="hour_id"]:checked');
      const hourDetails = hourSelected ? {
         hour_id: hourSelected.value,
         hour_name: hourSelected.nextElementSibling.textContent.trim(),
         attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
         category_id: hourSelected.getAttribute('data-category-id'),
         sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
         child_category_id: hourSelected.getAttribute('data-child-category-id')
      } : {};

      item_object_detail = JSON.stringify([
      {
         attribute_item_id: maidDetails.attribute_item_id,
         category_id: maidDetails.category_id,
         sub_category_id: maidDetails.sub_category_id,
         child_category_id: maidDetails.child_category_id,
         attribute_qty: 1 
      },
      {
         attribute_item_id: hourDetails.attribute_item_id,
         category_id: hourDetails.category_id,
         sub_category_id: hourDetails.sub_category_id,
         child_category_id: hourDetails.child_category_id,
         attribute_qty: 1 
      }
      ]);

      console.log(item_object_detail);
   </script>
   <?php if(auth()->guard()->check()): ?>
      <a href="<?php echo e(route('cart.list')); ?>" class="d-none d-lg-block cart-header position-relative">
         <span class="item-count"></span><img src="<?php echo e(asset('images/cart.svg')); ?>" style="min-width: 25px;" class="img-fluid" alt="">
      </a>
   <?php else: ?>
      <a href="#" data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()" class="d-none d-lg-block cart-header position-relative">
         <span class="item-count"><?php echo e(App\Card::where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()); ?></span><img src="<?php echo e(asset('images/cart.svg')); ?>" style="min-width: 25px;" class="img-fluid" alt="">
      </a>
   <?php endif; ?>
   
  
   <!-- <div class="tp-header-market  p-relative " id="mobile-login">
      <button type="button" class="btn-1 btn-heade" style="white-space: pre;" onclick="showsignup()"><i class="fas fa-user"></i> <span class="d-none d-md-block">Sign Up</span></button>
          
   </div>     -->
<?php endif; ?>
             </div>
         </div>
     </nav>
     <div id="search-overlay">
         <div class="search-container">
             <form action="<?php echo e(route('search')); ?>" method="Get">
                 <input type="search" placeholder="Search here..." id="global_searchInput" class="global_find-service-input" name="title" value="<?php echo e(request()->search); ?>" />
                 <button type="submit">Search</button>
             </form>
             <ul id="global_suggestionList" class="suggestion-list"></ul>
             <button id="search-close">
                 <i class="fal fa-times"></i>
             </button>
         </div>
     </div>
   </header>

   <!-- header area end -->

   <!-- mobile menu style start -->
   <div class="tp-offcanvas-area fix">
      <div class="tp-side-info">
         <div class="tp-side-logo">
            <a href="<?php echo e(url('/')); ?>">
               <img src="<?php echo e(asset('web/assets/img/logo/urban-mop-icon.svg')); ?>" alt="Logo" title="Logo">
            </a>
         </div>
         <div class="tp-side-close">
            <button> <i class="fa-thin fa-xmark"></i></button>
         </div>
         <div class="tp-mobile-menu-pos"></div>
         <div class="tp-side-content p-relative">
            <div class="tp-sidebar__contact">
               <h4 class="tp-sidebar-title">Contact Info</h4>
               <ul>

                  <li class="d-flex align-items-center">
                     <div class="tp-sidebar__contact-text">
                        <a href="tel:088889797697"><i class="far fa-phone"></i> 088889797697</a>
                     </div>
                  </li>
                  <li class="d-flex align-items-center">
                     <div class="tp-sidebar__contact-text">
                        <a href="mailto:Kleasoinfo@gmail.com"><i class="fal fa-envelope"></i> info@gmail.com</a>
                     </div>
                  </li>
               </ul>
            </div>
            <div class="tp-sidebar-icons tp-btn-effect-blue">
               <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
               <a href="#"><i class="fa-brands fa-twitter"></i></a>
               <a href="#"><i class="fa-brands fa-skype"></i></a>
               <a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
            </div>
         </div>
      </div>
      <div class="offcanvas-overlay"></div>
   </div>
   <div class="container">
      <?php if(session()->has('success')): ?>

         <div class="alert alert-success alert-dismissible" id="alert" onclick="hide('alert')">

            <button type="button" class="close" data-dismiss="alert">&times;</button>

              <?php echo e(session()->get('success')); ?>


         </div>

      <?php endif; ?>

      <?php if(session()->has('error')): ?>

         <div class="alert alert-danger alert-dismissible" id="alert" onclick="hide('alert')">

            <button type="button" class="close" data-dismiss="alert">&times;</button>

              <?php echo e(session()->get('error')); ?>


         </div>

      <?php endif; ?> 
   </div>

   <main>
    <div id="snackbar">Please Select Any Item</div>
      <?php echo $__env->yieldContent('content'); ?>
      
   </main>

   <!-- footer area start -->
   

   <footer>
      <!-- <img src="assets/images/footer-left-shape.png" alt="" class="line-shape"> -->
      <div class="container">
          <div class="footer-top">
              <div class="row">
                  <div class="col-md-6 col-lg-5 orange-box-mob">
                      <div class="footer-widget with-logo">
                          <!-- <h4>About Us</h4> -->
                          <div class="footer-logo">
                              <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('web/assets/img/logo/footer-logo.svg')); ?>" alt=""></a>
                          </div>
                          <p class="text-white custom_footer_txt">UrbanMop is a part of Urban Service LLC, driven by a vision to deliver the best home services across the UAE.</p>
                          <ul class="social-links-footer">
                              <li><a href="https://www.facebook.com/UrbanMop.UAE" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                              <li><a href="https://x.com/urbanmop" target="_blank"><i class="fab fa-twitter"></i></a></li>
                              <li><a href="https://www.instagram.com/urbanmop.uae/" target="_blank"><i class="fab fa-instagram"></i></a></li>
                              <li><a href="https://www.linkedin.com/company/urbanmop-uae" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                          </ul>
                      </div>
                  </div>
                  <div class="col-6 col-lg-2">
                      <div class="footer-widget">
                          <h4>Explore On</h4>
                          <ul class="footer-menu">
                              <li><a href="<?php echo e(route('about-us')); ?>">About Us</a></li>
                              <li><a href="<?php echo e(route('terms.condition')); ?>">Terms & Conditions</a></li>
                              <li><a href="<?php echo e(route('privacy.policies')); ?>">Privacy Policies</a></li>
                              
                              <li><a href="<?php echo e(route('contact.support')); ?>">Contact Support</a></li>
                              <li><a href="<?php echo e(route('delete.account.get')); ?>">Delete Account</a></li>
                              <li><a href="<?php echo e(route('become-a-vendor')); ?>">Become a Partner</a></li>
                              <li><a href="<?php echo e(route('blogs')); ?>">Blog</a></li>
                          </ul>
                      </div>
                  </div>
                  <div class="col-6 col-lg-2">
                      <div class="footer-widget">
                          <?php
                              $services = \App\Category::orderBy('order_column', 'ASC')
                                 ->where('parent_id', 0)
                                 ->take(4) // Limit to top 4 services
                                 ->get()
                                 ->map(function ($service) {
                                       $serviceAttributeValueItem = \App\ServiceAttributeValueItem::where('category_id', $service->id)
                                          ->with('service')
                                          ->first();

                                       return $serviceAttributeValueItem && $serviceAttributeValueItem->service ? $serviceAttributeValueItem->service : null;
                                 })
                                 ->filter();
                           ?>

                           <h4>Our Premium Service</h4>
                           <ul class="footer-menu">
                              <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <li>
                                       <a href="<?php echo e(route('service.details', $service->slug)); ?>">
                                          <?php echo e($service->name); ?>

                                       </a>
                                 </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           </ul>

                      </div>
                  </div>
                  <div class="col-md-6 col-lg-3 mt-3 mt-md-0">
                      <div class="footer-widget">
                          <h4>Contact Us</h4>
                          <ul class="footer-menu">
                           <li><i class="fal fa-phone-alt me-2 text-primary"></i> 
                           <a href="tel:+971-52-618-8291">+971-52-618-8291</a></li>
                           <li><i class="fal fa-phone-alt me-2 text-primary"></i> 
                           <a href="tel:+971-58-581-4007">+971-58-581-4007</a></li>
                           <li><i class="fal fa-envelope me-2 text-primary"></i>
                           <a href="mailto:booking@urbanmop.com ">booking@urbanmop.com </a></li>
                           <li><i class="fal fa-map-marker-alt me-2 text-primary"></i>
                           <span class="text-white mt-0 mb-0 mb-0">Al Barsha, Dubai, UAE</span></li>
                          </ul>
                          <div class="information">
                              <!-- <div class="info">
                                  <div class="icon-footer">
                                      <i class="fal fa-phone-alt"></i>
                                  </div>
                                  <div class="desc">
                                      <a href="tel:+971-52-618-8291">+971-52-618-8291</a><br/>
                                      <a href="tel:+971-58-581-4007">+971-58-581-4007</a>
                                  </div>
                              </div> -->
                              <!-- <div class="info">
                                  <div class="icon-footer">
                                      <i class="fal fa-envelope"></i>
                                  </div>
                                  <div class="desc">
                                      <a href="mailto:booking@urbanmop.com ">booking@urbanmop.com </a>
                                  </div>
                              </div> -->
                              <!-- <div class="info">
                                  <div class="icon-footer">
                                      <i class="fal fa-map-marker-alt"></i>
                                  </div>
                                  <div class="desc">
                                      <p class="text-white mt-0 mb-0 mb-0">Al Barsha, Dubai, UAE</p>
                                  </div>
                              </div> -->
                          </div>
                          
                      </div>
                  </div>
              </div>
          </div>
          <div class="footer-bottom">
              <div class="row align-items-center">
                  <div class="col-12">
                      <div class="text-center">
                          <span class="text-white">Copyright © <script>document.write(new Date().getFullYear())</script> All Rights Reserved by UrbanMop.</span>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </footer>
  
      <div class="float-links">
        <a class="c-btn-phone" href="tel:+971-52-618-8291" aria-label="Phone Number">
            <i class="fal fa-phone"></i>
        </a>
        <a class="c-btn-whatsapp" href="https://api.whatsapp.com/send?phone=971585989960&text=Hello" aria-label="Whatsapp">
            <i class="fab fa-whatsapp"></i>
        </a>
        <!--<a class="c-btn-mail" href="mailto:booking@urbanmop.com" aria-label="Email">-->
        <!--    <i class="fal fa-envelope-open"></i>-->
        <!--</a>-->
    </div>

    <div class="back-to-top" id="back-to-top"><i class="fas fa-arrow-up"></i></div>

    <div class="bottom-bar-main">
        <ul class="navbar-nav">
            <li class="nav-link">
                <a href="<?php echo e(route('shop')); ?>" class="nav-item <?php echo e(Request::is('/') ? 'active' : ''); ?>"> <span><img src="<?php echo e(asset('images/home.svg')); ?>" alt=""></span>Home</a>
            </li>
            <?php if(auth()->guard()->check()): ?>
               <li class="nav-link">
                  <a href="<?php echo e(url('my-bookings')); ?>" class="nav-item <?php echo e(Request::is('my-bookings') ? 'active' : ''); ?>"><span><img src="<?php echo e(asset('images/booking.svg')); ?>" alt=""></span>Booking</a>
               </li>
            <?php else: ?>
               <li class="nav-link">
                  <a data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()" class="nav-item"><span><img src="<?php echo e(asset('images/booking.svg')); ?>" alt=""></span>Booking</a>
               </li>
            <?php endif; ?>
            <?php if(auth()->guard()->check()): ?>
               <li class="nav-link">
                  <a href="<?php echo e(route('cart.list')); ?>" class="nav-item <?php echo e(Request::is('cart') ? 'active' : ''); ?>"><span><img src="<?php echo e(asset('images/cart.svg')); ?>" alt=""></span>Cart</a>
               </li>
            <?php else: ?>
               <li class="nav-link">
                  <a data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()" class="nav-item"><span><img src="<?php echo e(asset('images/cart.svg')); ?>" alt=""></span>Cart</a>
               </li>
            <?php endif; ?>
            <?php if(auth()->guard()->check()): ?>
               <li class="nav-link">
                  <a href="<?php echo e(route('show.profile')); ?>" class="nav-item <?php echo e(Request::is('profile') ? 'active' : ''); ?>"><span><img src="<?php echo e(asset('images/profile.svg')); ?>" alt=""></span>Profile</a>
               </li>
            <?php else: ?>
               <li class="nav-link">
                  <a data-bs-toggle="modal" data-bs-target="#loginModal" onclick="showlogin()" class="nav-item"><span><img src="<?php echo e(asset('images/profile.svg')); ?>" alt=""></span>Profile</a>
               </li>
            <?php endif; ?>
        </ul>
    </div>


   <!-- This is what will be included inside the popup -->
   <div class="popupk" id="popupk">
      <div class="mybgs1"> <p class="mybgs"><img src="<?php echo e(asset('web/assets/img/1.svg')); ?>"></p></div>
      <div class="text-center p-5">
         <div class="popupcloseicon"><a href="javascript:void(0);" onclick="hide('popupk')">X</a></div>
         
         <h5 class="mt-15 text-center">Sign Up</h5>
         <p class="mt-10">Enter your mobile number to get started.</p>
         <p id="errormsg" ></p>
          <div class="input-container">
             <i><img src="<?php echo e(asset('web/assets/img/uae-icone-1.png')); ?>" class="input_icon"></i>
             <!-- <input class="input-field" type="text" name="phone" id="rphoneno" placeholder="+971"> -->
               <div class="input-group mb-3">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="basic-addon1" style="height: 100%;">971</span>
                 </div>
                 <input type="text" id="rphoneno" name="phone" class="form-control" placeholder="Enter Your Mobile Number" aria-label="Enter Your Mobile Number" aria-describedby="basic-addon1">
               </div>
            </div>
            <p class="numbererror error"></p>


        <div class="text-center mt-3">
         <button class="urban_btn" type="button" onclick="rsendOTP()"> Next</button>
        </div>

        <p class="mt-15">New to UrbanMop? <button onclick="showlogin()" class="text-orange">Log In</button></p>  
      </div>
      <div class="mybgs1"> <p class="mybgs2"><img src="<?php echo e(asset('web/assets/img/2.svg')); ?>"></p></div>
     
   </div>




   <!-- Login Modal -->
   <!-- Include CSS for intl-tel-input -->
   <link rel="stylesheet" 
      href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
      integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
      crossorigin="anonymous" referrerpolicy="no-referrer" />

   <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <!--<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable  modal-sm">-->
      <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
         <div class="modal-content">
               <div class="modal-header">
                  <h5 class="modal-title fs-5" id="exampleModalLabel">Log In / Register</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               </div>
               <div class="modal-body">
                  
            <p class="numbererror error"></p>
                  <div class="mb-3 text-center modal-number">
                     <div class="input-group">
                           <!-- Dial Code Input with Flag -->
                           <div class="input-group-prepend">
                              <input type="hidden" id="otp-dial-code" 
                                 class="form-control" value="+971" 
                                 required style="width:120px; text-align: center;">
                           </div>

                           <!-- Phone Number Input -->
                           <input type="tel" id="phoneno" name="phone" 
                              class="form-control form-input-1" placeholder="Mobile number" 
                              oninput="validateInput(event)" pattern="[0-9]*" inputmode="numeric">
                     </div>
                  </div>
                  <button class="btn btn-1 w-100" onclick="sendOTP()">Log In</button>
                  <!--<a href="#!" class="btn btn-1 w-100" onclick="sendOTP()">Log In</a>-->
               </div>
         </div>
      </div>
   </div>

   <script>
      // Initialize intl-tel-input with only UAE as available country
      document.addEventListener('DOMContentLoaded', function () {
         const dialCodeInput = document.getElementById('otp-dial-code');
         const options = {
            initialCountry: "ae", // Default to UAE
            onlyCountries: ["ae"], // Restrict to UAE
            separateDialCode: true,
            preferredCountries: ["ae"],
         };

         // Initialize intl-tel-input
         const iti = window.intlTelInput(dialCodeInput, options);

         // Optional: Prevent changing country manually
         dialCodeInput.addEventListener('countrychange', function () {
            iti.setCountry("ae");
         });
      });
   </script>
   
   <!-- Include JS for intl-tel-input -->
   <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
      integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
      crossorigin="anonymous" referrerpolicy="no-referrer"></script>
   <script>
      // Select the Back-to-Top button
      const backToTopButton = document.getElementById('back-to-top');

      // Function to handle scroll event
      window.addEventListener('scroll', () => {
      // Check if screen width is greater than 767px
      if (window.innerWidth > 767) {
         // Show the button if scrolled down 200px, hide otherwise
         if (window.scrollY > 200) {
            backToTopButton.classList.add('show');
         } else {
            backToTopButton.classList.remove('show');
         }
      } else {
         // Always hide the button if screen width is 767px or less
         backToTopButton.classList.remove('show');
      }
      });

      // Scroll smoothly to the top when the button is clicked
      backToTopButton.addEventListener('click', () => {
      window.scrollTo({
         top: 0,
         // behavior: 'smooth'
      });
      });


   </script>
   <script>
      (function() {
         const dialCodeInput = document.querySelector("#otp-dial-code");

         const iti = intlTelInput(dialCodeInput, {
               initialCountry: "AE",            // Automatically detect the user's country
               separateDialCode: false,         // Display only the dial code in the input
               autoPlaceholder: "polite",       // Use a smart placeholder
               // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js", // Required for formatting
         });

         dialCodeInput.addEventListener("countrychange", function() {
               const countryData = iti.getSelectedCountryData();
               console.log(`Selected country: ${countryData.name}, Dial Code: ${countryData.dialCode}`);
         });
      })();
   </script>


   <!-- Custom OTP Modal -->
   <div class="modal fade" id="otpmodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" >
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable  modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fs-5" id="exampleModalLabel">OTP</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="hide('otpModal')"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <h3 class="fs-5 mb-20">The verification code has been sent to your phone 
                    <span>on <b id="phonetext"></b></span> - <a href="javascript:void(0)" class="text-secondary" data-bs-toggle="modal" data-bs-target="#loginModal" onclick="return_login()">Change</a></h3>
                    <!-- <h5 class="fs-4 mb-20 d-flex w-100 justify-content-between">
                        
                    </h5> -->

                    <form action="<?php echo e(url('login-with-otp')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="userInput d-flex justify-content-center text-center otp-inputs mb-20">
                            <input type="tel" id="ist" name="otp1" class="form-input-1 form-control-1 m-1 p-0" maxlength="1" onkeyup="clickEvent(this, 'sec', null)" required>
                            <input type="tel" id="sec" name="otp2" class="form-input-1 form-control-1 m-1 p-0" maxlength="1" onkeyup="clickEvent(this, 'third', 'ist')" required>
                            <input type="tel" id="third" name="otp3" class="form-input-1 form-control-1 m-1 p-0" maxlength="1" onkeyup="clickEvent(this, 'fourth', 'sec')" required>
                            <input type="tel" id="fourth" name="otp4" class="form-input-1 form-control-1 m-1 p-0" maxlength="1" onkeyup="clickEvent(this, null, 'third')" required>
                        </div>

                        <h3 class="fs-5 mb-20">Code not received? <a href="javascript:void(0)" onclick="sendOTP()" class="text-secondary">Resend OTP</a></h3>

                        <span class="otperror text-danger"></span>

                        <input type="hidden" name="phoneno" id="valphoneno">
                        <input type="hidden" name="data_from" id="data_from">

                        <div class="text-center mt-3">
                            <button type="button" onclick="loginUser()" class="btn btn-1 w-100">Verify OTP</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


   <script>
      function validateInput(event) {
         const input = event.target;
         input.value = input.value.replace(/[^0-9]/g, '');
      }
   </script>





   
   <input type="hidden" value="<?php echo e(Auth::user()?Auth::user()->id:''); ?>" class="user_id">
   <!-- <script src="<?php echo e(asset('web/assets/js/vendor/jquery.js')); ?>"></script> -->
   <!-- <script src="<?php echo e(asset('web/assets/js/vendor/waypoints.js')); ?>"></script> -->
   <script src="<?php echo e(asset('web/assets/js/bootstrap-bundle.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/meanmenu.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/swiper-bundle.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/splide.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/slick.min.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/nouislider.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/magnific-popup.js')); ?>"></script>
   <!-- <script src="<?php echo e(asset('web/assets/js/nice-select.js')); ?>"></script> -->
   <script src="<?php echo e(asset('web/assets/js/wow.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/datepicker.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/isotope-pkgd.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/imagesloaded-pkgd.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/jquery.appear.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/jquery.knob.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/circularProgressBar.min.js')); ?>"></script>
   <script src="<?php echo e(asset('web/assets/js/purecounter.js')); ?>"></script>
   <!-- <script src="<?php echo e(asset('web/assets/js/ajax-form.js')); ?>"></script> -->
   <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
   
   <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>

   <script src="<?php echo e(asset('web/assets/js/main.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

   <?php echo $__env->yieldContent('script'); ?>

   <!------- pop up login start---->
   <script>
      jQuery(".select2").select2({
         dropdownParent: $('#staticBackdropLabel')
      });


      jQuery(".js-example-basic-multiple-service").select2({
         placeholder: "Select Service"
      });
      

      $(".flatpickr-input").flatpickr({

      disableMobile: "true",

      dateFormat: "d-m-Y"

      });
         
     
    </script>
   
   <script>
      function alertfun() {
         jQuery('#snackbar').text('Please Select Any Item');
        var x = document.getElementById("snackbar");
        x.className = "show";
        setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
   </script>
   <script>
      function meterialalert() {
        jQuery('#snackbar').text('Please Select Materials Charge');
        var x = document.getElementById("snackbar");
        x.className = "show";
        setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
   </script>
   <script>
     function minCartAlert(netval) {
        jQuery(".minalert").show();
        var msg = 'Add '+netval+' AED to complete the booking';
        jQuery('.minalert').text(msg);
        setTimeout(function(){ jQuery(".minalert").hide(); }, 5000);
     }
   </script>
   <script>
   function sendOTP() {
      var phone = document.getElementById("phoneno").value;
      console.log('Phone clicked:', phone);

      if (phone.length > 8 && phone.length < 13) {
         if (phone !== '') {
               jQuery.ajax({
                  type: 'GET',
                  url: "<?php echo e(url('check-mobile-no')); ?>",
                  data: {
                     phone: phone
                  },
                  dataType: 'json',
                  success: function (res) {
                     console.log(res);
                     if (res.status === "True") {
                        // Hide login modal
                        const loginModal = bootstrap.Modal.getInstance(document.getElementById('loginModal'));
                        loginModal.hide();

                        // Ensure all existing backdrops are removed
                        removeBackdrops();
                        
                           document.getElementById('loginModal').style.display = 'none';
                           const otpModal = new bootstrap.Modal(document.getElementById('otpmodal'));
                           otpModal.show();

                           document.getElementById('otpmodal').style.display = 'block';
                           document.getElementById("phonetext").innerHTML = phone;
                           document.getElementById("valphoneno").value = phone;
                           document.getElementById("data_from").value = 'login';

                           jQuery.ajax({
                              type: 'GET',
                              url: "<?php echo e(url('send-login-otp')); ?>",
                              data: {
                                 phone: phone
                              },
                              dataType: 'json',
                              success: function (data) {
                                 console.log(data);
                               
                              },
                              error: function (data) {
                                 console.log('Error sending OTP:', data);
                              }
                           });
                     } else {
                           jQuery('.numbererror').text(res.msg);
                     }
                  },
                  error: function (res) {
                     console.log('Error checking mobile number:', res);
                  }
               });
         }
      } else {
         jQuery('.numbererror').text('Please enter a valid phone number between 9 and 12 digits');
      }
   }
   function removeBackdrops() {
      document.querySelectorAll('.modal-backdrop').forEach(backdrop => backdrop.remove());
   }

   function return_login() {
      
      jQuery('#otpmodal').hide();
      jQuery('#popup').show();
      // var id = '#popup';      
      // $('#otpmodal').style.display ='none';
      // $(id).style.display ='block';
   }

   function rsendOTP() {
      var phone = document.getElementById("rphoneno").value;
      if(phone.length > 8 && phone.length < 13){
         if(phone !==''){
            document.getElementById("errormsg").innerHTML = '';
            var id = 'popupk';
            $(id).style.display ='none';
            $('otpmodal').style.display ='block';
            document.getElementById("errormsg").innerHTML = '';
            document.getElementById("valphoneno").value = phone;
            document.getElementById("data_from").value = 'login';
            jQuery.ajax({
                 
                  type: 'Get',
                  url: "<?php echo e(url('register-user')); ?>",
                  data: {
                           phone: phone,
                       },
                  dataType: 'json',
                  success: function (data) {
                     console.log(data);
                                      
                  },
                  error: function (data) {
                      console.log(data);
                  }
            });
         }
      } else {
         jQuery('#errormsg').text('Please Enter Valid Number');
      }
   }
</script>

<script>
  
    function loginUser() {
        
      var phoneno = jQuery('#valphoneno').val();
      var otp1 = jQuery('#ist').val();
      var otp2 = jQuery('#sec').val();
      var otp3 = jQuery('#third').val();
      var otp4 = jQuery('#fourth').val();
      jQuery('.otperror').text('');
      if(otp1 && otp2 && otp3 && otp4){
          jQuery.ajax({
                headers: {
                     'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                 },   
                type: 'Post',
                url: "<?php echo e(url('login-with-otp')); ?>",
                data: {
                         phoneno: phoneno,
                         otp1: otp1,
                         otp2: otp2,
                         otp3: otp3,
                         otp4: otp4,
                     },
                dataType: 'json',
                success: function (data) {
                  if(data.status){
                     if(data.is_new_user == "1"){
                        const baseURL = window.location.origin+'/profile';
                        window.location.href = baseURL;
                     } else{
                        location.reload();
                     }
                  } else {
                    jQuery('.otperror').text(data.msg);
                  }
                },
                error: function (data) {
                    console.log(data);
                }
          });
      } else {
          jQuery('.otperror').text('Enter OTP.');
      }
    }

</script>

  <script>
      $ = function(id) {
        return document.getElementById(id);
      }
      
      var show = function(id) {
        
         $(id).style.display ='block';
      }
      var hide = function(id) {
         $(id).style.display ='none';
      }


      function showlogin(){
         jQuery('#popup').show();
         jQuery('#popupk').hide();
      }

      function showsignup(){
         jQuery('#popup').hide();
         jQuery('#popupk').show();
      }

      function showuserd(){
         jQuery('.user-dashboard').show();
        
      }

      

      jQuery(".popup_close").click(function(){
   jQuery(".user-dashboard").hide();
});


jQuery('.v-c-d').hide();
jQuery(".view-o-d").click(function(){
   jQuery(".v-c-d").fadeToggle();
});

jQuery().ready(function(){

   jQuery('.alert').delay(2000);
   jQuery('.alert').hide(3000);
   // getLetLong();
})

function clickEvent(current, nextFieldId, prevFieldId) {
    if (current.value.length === 1 && nextFieldId) {
        document.getElementById(nextFieldId).focus();
    } else if (current.value.length === 0 && prevFieldId) {
        document.getElementById(prevFieldId).focus();
    }

    // Handling backspace to clear the current field
    current.addEventListener('keydown', function (e) {
        if (e.key === 'Backspace' && prevFieldId && current.value.length === 0) {
            document.getElementById(prevFieldId).focus();
        }
    });
}

      </script>

<script>
   function showForm(formid, buttonid, addbtn='') {
      jQuery(buttonid).hide();
      jQuery(formid).css("display", "block");
      jQuery("."+addbtn).click();
   }
</script>

<script>
function add_booking(cls) {
    var getFormData = '.add_booking_from' + cls;
    
    // Manually collect data from inputs inside the span
    var formData = {};
    jQuery(getFormData).find('input').each(function() {
        var input = jQuery(this);
        formData[input.attr('name')] = input.val();
    });

    console.log('Collected Form Data:', formData);

    jQuery.ajax({
        headers: {
            'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "<?php echo e(route('add.attribute.card')); ?>",
        data: formData, 
        dataType: 'json',
        success: function (data) {

            jQuery('#first_btn').attr("disabled",false);
            jQuery('.item-count').each(function() {
               jQuery('.item-count').text(data.res.total_cart);  
            });
     
            console.log('Success Response:', data);
            
            jQuery('.updated-price').each(function() {
               jQuery('.updated-price').text('AED '+data.res.gtotal);  
            });
     
            jQuery('.formqty' + cls).val(data.res.qty);       
            jQuery('.cardlist').html(data.modal_view);   
            
            const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";
            if(isCategoryYes) {
                jQuery('.summary-cards').html(data.modal_view_services);   
                jQuery('.summary-cards-maid').html("");  
            } else { 
                jQuery('.summary-cards').html("");  
            }
            
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            alert('Error: Could not process the request.');
        }
    });
}

</script>
<script>
   function removeBooking(cls) {
      var removeFormServiceId = '.removeFormServiceId'+cls;
      var removeFormCardId = '.removeFormCardId'+cls;
      var removeFormCardAtrId = '.removeFormCardAtrId'+cls;
      jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "<?php echo e(url('remove/card/attribute')); ?>",
            // data: jQuery(getremoveForm).serialize(),
            data: {
               card_id : jQuery(removeFormCardId).val(),
               card_atr_id : jQuery(removeFormCardAtrId).val(),
               service_id : jQuery(removeFormServiceId).val(),
            },
            dataType: 'json',
            success: function (res) {
                 console.log(res);
           
                 jQuery.ajax({
                        headers: {
                               'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                           },    
                        type: 'Post',
                        url: "<?php echo e(route('get.card.booking')); ?>",
                        data: {
                           service_id : jQuery('.service_id').val(),
                        },
                        dataType: 'json',
                        success: function (response) {
                             jQuery('.cardlist').html('');       
                             jQuery('.cardlist').html(response.modal_view); 
                             const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";

                              if(isCategoryYes) {
                                 jQuery('.summary-cards').html(response.modal_view_services);   
                                 jQuery('.summary-cards-maid').html(""); 
                              } else { 
                                 jQuery('.summary-cards').html(""); 
                              }
                        },
                        error: function (response) {
                            console.log(response);
                        }
                  });         
            },
            error: function (res) {
                console.log(res);
            }
      });
   }
</script>

<script>
   function removeBookingSec(card_id, card_atr_id) {
     
      jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "<?php echo e(url('remove/card/attribute')); ?>",
            data: {
               card_id : card_id,
               card_atr_id : card_atr_id,
               service_id : jQuery('.service_id').val(),
            },
            dataType: 'json',
            success: function (res) {
                 console.log(res);

                 jQuery.ajax({
                        headers: {
                               'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                           },    
                        type: 'Post',
                        url: "<?php echo e(route('get.card.booking')); ?>",
                        data: {
                           service_id : jQuery('.service_id').val(),
                        },
                        dataType: 'json',
                        success: function (response) {
                             console.log(response);
                             jQuery('.cardlist').html('');       
                             jQuery('.cardlist').html(response.modal_view);             
                        },
                        error: function (response) {
                            console.log(response);
                        }
                  });         
            },
            error: function (res) {
                console.log(res);
            }
      });
   }
</script>

<script>
   function minus_booking(cls) {
    
      var getFormData      = '.add_booking_from'+cls;
      var formqty          = '.formqty'+cls;
      var buttonForms      = '#buttonForms'+cls;
      var buttonForm       = '#buttonForm'+cls;
      var buttonFormss     = '#buttonFormss'+cls;
      
      jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "<?php echo e(url('minus_booking')); ?>",
            data: jQuery(getFormData).serialize(),
            dataType: 'json',
            success: function (data) {
                 console.log(data);
                 if(data.res.qty=='0'){
                     jQuery(buttonFormss).css("display", "block");
                     jQuery(buttonForm).css("display", "block");
                     jQuery(buttonForms).css("display", "block");
                     jQuery(getFormData).css("display", "none"); 
                     jQuery(buttonFormss).css("margin-left", "72%");
                     
                 }
                  jQuery('.updated-price').each(function() {
                     jQuery('.updated-price').text('AED '+data.res.gtotal);  
                  });
                 jQuery(formqty).val(data.res.qty);       
                 jQuery('.cardlist').html('');       
                 jQuery('.cardlist').html(data.modal_view);             
            },
            error: function (data) {
                console.log(data);
            }
      });
   }
</script>

<script>
   function getLocality(city_id) {
      jQuery('.localitylist').html('');  
      jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "<?php echo e(url('get_locality')); ?>",
            data: {
               city_id : city_id,
            },
        
            success: function (data) {
                  console.log(data); 
                 jQuery('.localitylist').html('');  

                 jQuery('.localitylist').html(data.modal_view);     

            },
            error: function (data) {
                console.log(data);
            }
      });
   }
</script>

<script>
   function removeBookingAtr(card_id, card_atr_id) {
      jQuery.ajax({
         headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            },    
         type: 'Post',
         url: "<?php echo e(url('remove/booking/attribute')); ?>",
         data: {
            card_id : card_id,
            card_atr_id : card_atr_id,
         },
         dataType: 'json',
         success: function (response) {
              jQuery('.couponerror').text('');       
              jQuery('.text-success').text('');  
              jQuery('.coupon_code').val('');     
              jQuery('.cardlist').html('');       
              jQuery('.cardlist').html(response.modal_view);    
              
              
            jQuery('.updated-price').each(function() {
               jQuery('.updated-price').text('AED '+response.g_total);  
            });

              const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";

               if(isCategoryYes) {
                  jQuery('.summary-cards').html(response.modal_view_services);   
                  jQuery('.summary-cards-maid').html(""); 
               } else { 
                  jQuery('.summary-cards').html(""); 
               }

               if(response.g_total <= 0){
                    jQuery('#first_btn').attr("disabled",true);
                    jQuery('.choose_time').hide();    
                     jQuery('.payment').hide(); 
                     jQuery('.location').hide();    
                     return move('selection');
               }
         },
         error: function (response) {
             console.log(response);
         }
      });      
   }
</script>
<script>
   let lastModal = 'Show';
   function showCard() {
     if(lastModal=='Show'){
      jQuery('.cardmodal').hide();   
      lastModal = 'Hide';  
     } else {
      jQuery('.cardmodal').show(); 
      lastModal = 'Show';
     }
     
   }
</script>

<script>
   function getLiveAddres(requ) {
      jQuery.ajax({
         headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            },    
         type: 'Post',
         url: "<?php echo e(url('get/live/address')); ?>",
         data: {
           location : requ,
         },
         dataType: 'json',
         success: function (response) {
              console.log(response);
              jQuery('#browsers').html(response.res);      
         },
         error: function (response) {
             console.log(response);
         }
      });      
   }
</script>

<script>
   function getLetLong() {
      jQuery.ajax({
         headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            },    
         type: 'Post',
         url: "<?php echo e(url('get/lat/long')); ?>",
         data: {
           location : jQuery('.live_address').val(),
         },
         dataType: 'json',
         success: function (response) {
              console.log(response);
              if(response.status=='1'){
                 jQuery('#latitude').val(response.latitude);
                 jQuery('#longitude').val(response.longitude);
                 map = new google.maps.Map(document.getElementById('add-map'), {
                    center: { lat: response.latitude, lng: response.longitude }, // Default to centering at (0, 0)
                    zoom: 15 // Adjust the zoom level as desired
                 });

                 // Create a marker at the default location (0, 0)
                 marker = new google.maps.Marker({
                    position: { lat: response.latitude, lng: response.longitude },
                    map: map,
                    draggable: true // Allow the marker to be dragged
                 });

                 // Add an event listener to update the latitude and longitude when the marker is dragged
                 marker.addListener('dragend', function() {
                    updateCoordinates(marker.getPosition());
                 });
               }    
         },
         error: function (response) {
             console.log(response);
         }
      });      
   }

   

</script>

<script>
  jQuery(document).ready(function() {

  jQuery('#phoneno').on('keypress', function(e) {
          
            var phone = jQuery('#phoneno').val();
            console.log('phone ', phone);
            var regex = new RegExp("^[0-9\b]+$");
            var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
            // for 10 digit number only
            if (phone.length > 10) {
                e.preventDefault();
                return false;
            }
            
            if (regex.test(str)) {
                return true;
            }
            e.preventDefault();
            return false;
        });

   });
</script>

<script>
  jQuery(document).ready(function() {

      jQuery('#rphoneno').on('keypress', function(e) {
          
          var phone = jQuery('#rphoneno').val();
          console.log(phone);
          var regex = new RegExp("^[0-9\b]+$");
          var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
          // for 10 digit number only
          if (phone.length > 10) {
              e.preventDefault();
              return false;
          }
          
          if (regex.test(str)) {
              return true;
          }
          e.preventDefault();
          return false;
      });

   });
</script>
 

<!--Start of Tawk.to Script-->
<!-- <script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/604fd78bf7ce1827093061e5/1f0ru3ug1';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script> -->
<!--End of Tawk.to Script-->
 
<!-- Smartlook start -->
<!-- <script type='text/javascript'>
  window.smartlook||(function(d) {
    var o=smartlook=function(){ o.api.push(arguments)},h=d.getElementsByTagName('head')[0];
    var c=d.createElement('script');o.api=new Array();c.async=true;c.type='text/javascript';
    c.charset='utf-8';c.src='https://web-sdk.smartlook.com/recorder.js';h.appendChild(c);
    })(document);
    smartlook('init', 'e9a6d5723514ca51f4910f893c9cbd6d05820ae1', { region: 'eu' });
</script> -->
<!-- Smartlook end -->

<!--<a href="https://api.whatsapp.com/send?phone=971526188291&text=Hello" class="wp-float" target="_blank">-->
<!--<img class="wp-my-float" src="https://www.urbanmop.com/whatsapp/images/whatsapp.svg" width="75px">-->
<!--</a>-->

<style>

.wp-float{
    position:fixed;
    bottom:15px;
    left:22px;
    text-align:center;
    font-size:30px;
    z-index:100;
}

.wp-my-float{
    margin-top:16px;
}

</style>

<?php if(strpos(url()->current(), 'service/booking') !== false || strpos(url()->current(), 'saved-locations') !== false): ?>

<?php else: ?>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU"></script>
<?php endif; ?>

  <script>

   let map22, marker;
   function updateCoordinates(latLng) {
      document.getElementById('latitude').value = latLng.lat().toFixed(6);
      document.getElementById('longitude').value = latLng.lng().toFixed(6);
   }
  </script>

  <script>
        function removeCoupon(argument) {
          jQuery.ajax({
              headers: {
                     'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                 },    
              type: 'Post',
              url: "<?php echo e(url('remove-coupon')); ?>",
              data: {
                card_id : jQuery('.card_id').val(),
              },
              success: function (data) {
                   console.log(data);
                   if(data.status=='True'){
                    var service_id = data.service_id;
                    jQuery('.couponerror').text(data.msg);
                    jQuery('.text-success').text('');
                    jQuery('.coupon_code').val('');
                    jQuery.ajax({
                          headers: {
                                 'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                             },    
                          type: 'Post',
                          url: "<?php echo e(route('get.card.booking')); ?>",
                          data: {
                             service_id : service_id,
                          },
                          dataType: 'json',
                          success: function (response) {
                               console.log(response);
                               // jQuery('.couponerror').html('');       
                               jQuery('.cardlist').html(response.modal_view);             
                          },
                          error: function (response) {
                              console.log(response);
                          }
                    }); 
                   } else {
                    jQuery('.couponerror').text(data.msg);
                   }                          
              },
              error: function (data) {
                  console.log(data);
              }
        });
        }
      </script>

      <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.js" integrity="sha512-Ysw1DcK1P+uYLqprEAzNQJP+J4hTx4t/3X2nbVwszao8wD+9afLjBQYjz7Uk4ADP+Er++mJoScI42ueGtQOzEA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script>
         var swiper = new Swiper(".pickup-left-off", {
            spaceBetween: 20,
            slidesPerView: 3,
            loop: true,
         //   centeredSlides: true,
            autoplay: {
               delay: 2500,
               disableOnInteraction: false,
            },
            pagination: {
               el: ".swiper-pagination",
               clickable: true,
            },
            navigation: {
               nextEl: ".swiper-button-next",
               prevEl: ".swiper-button-prev",
            },
            breakpoints: {
               "0": {
               slidesPerView: 1,
               spaceBetween: 10,
               },
               "767": {
               slidesPerView: 2,
               spaceBetween: 20,
               },
               "991": {
               slidesPerView: 3,
               spaceBetween: 20,
               },
               "1440": {
               slidesPerView: 4,
               spaceBetween: 20,
               },
            },
         });
         
         var swiper1 = new Swiper(".cleaning-pest-control", {
            spaceBetween: 10,
            slidesPerView: 2.5,
            loop: true,
         //   centeredSlides: true,
            autoplay: {
               delay: 2500,
               disableOnInteraction: false,
            },
            pagination: {
               el: ".swiper-pagination",
               clickable: true,
            },
            navigation: {
               nextEl: ".swiper-button-next",
               prevEl: ".swiper-button-prev",
            },
            breakpoints: {
               "0": {
               slidesPerView: 2.5,
               spaceBetween: 10,
               },
               "767": {
               slidesPerView: 3.2,
               spaceBetween: 10,
               },
               "991": {
               slidesPerView: 4.5,
               spaceBetween: 10,
               },
               "1440": {
               slidesPerView: 5,
               spaceBetween: 10,
               },
            },
         });
         // $("#rateYo").rateYo({
         //       starWidth: "26px",
         //       normalFill: "#D4D4D4",
         //       spacing: "5px",
         //          ratedFill: "#FF9100",
         //          'starSvg':`<svg version="1.1"
         //          xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:a="http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"
         //          x="0px" y="0px" width="528.1px" height="512.1px" viewBox="0 0 528.1 512.1" style="enable-background:new 0 0 528.1 512.1;"
         //          xml:space="preserve">
         //          <path d="M292.8,18C287.5,7,276.3,0,264,0s-23.4,7-28.8,18l-64.3,132.3L27.3,171.5c-12,1.8-22,10.2-25.7,21.7s-0.7,24.2,7.9,32.7
         //          L113.7,329L89.1,474.7c-2,12,3,24.2,12.9,31.3s23,8,33.8,2.3l128.3-68.5l128.3,68.5c10.8,5.7,23.9,4.9,33.8-2.3s14.9-19.3,12.9-31.3
         //          L414.4,329l104.2-103.1c8.6-8.5,11.7-21.2,7.9-32.7s-13.7-19.9-25.7-21.7l-143.7-21.2L292.8,18z"/>
         //          </svg>`,
         //          halfStar: true,
         // });
         
        const searchToggle = document.getElementById('search-toggle');
        const searchOverlay = document.getElementById('search-overlay');
        const searchClose = document.getElementById('search-close');
        
        searchToggle.addEventListener('click', () => {
          searchOverlay.classList.toggle('active');
        });
        
        searchClose.addEventListener('click', () => {
          searchOverlay.classList.remove('active');
        });

            
      </script>


    <script>
        // AJAX to fetch addresses
      function fetchAddresses() {
        jQuery.ajax({
            url: `<?php echo e(url('get_user_addresses')); ?>`, // Adjust URL as needed
            method: 'GET',
            success: function (data) {
                console.log("Fetched data:", data); // Debug to check the data
                const dropdownMenu = jQuery('.dropdown-menu');
    
                if (dropdownMenu.length) {
                    dropdownMenu.empty(); // Clear existing items
                    if (data.length > 0) {
                        data.forEach(address => {
                            dropdownMenu.append(`
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0)" onclick="setActiveAddress(${address.id})">
                                        ${address.flat_no}, ${address.building} - ${address.city_name}, ${address.locality_name}
                                    </a>
                                </li>
                            `);
                        });
                    } else {
                        dropdownMenu.append('<li><span class="dropdown-item">No addresses available</span></li>');
                    }
                } else {
                    console.error("Dropdown menu not found");
                }
            },
            error: function (error) {
                console.error("Error fetching addresses:", error);
            }
        });
    }


        // Set active address
        function setActiveAddress(addressId) {
            jQuery.ajax({
                url: `<?php echo e(url('update_address')); ?>/${addressId}`,
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                success: function (response) {
                    if (response.success) {
                        jQuery('#selectedLocation').text(`${response.data.flat_no}, ${response.data.building} - ${response.data.city_name}, ${response.data.locality_name}`);
                        fetchAddresses();
                        let fullAddress = `${response.data.flat_no}, ${response.data.building} - ${response.data.city_name}, ${response.data.locality_name}`;
                    
                        if (window.location.href.includes("service/booking")) {
                           const userAddressField = document.getElementById('user-address');
                           const userAddressFields = document.getElementById('user-address-edit');

                           if (userAddressField && userAddressFields) {
                              // Update the content of the user address field
                              userAddressField.textContent = fullAddress;
                              userAddressField.setAttribute('data-address', response.data.id);

                              // Update the content of the user address edit field
                              userAddressFields.textContent = fullAddress;
                              userAddressFields.setAttribute('data-address', fullAddress);
                           }
                        } else {
                           // Reload the page if the URL doesn't contain "service/booking"
                           location.reload();
                        }

                    } else {
                        alert('Error updating address');
                    }
                },
                error: function () {
                    alert('An error occurred while updating the address.');
                }
            });
        }
    </script>

<script>
      Fancybox.bind('[data-fancybox]', {
        //
      });    
    </script>



</body>

</html><?php /**PATH /home/urbanmop/public_html/stage/resources/views/web/layout/header.blade.php ENDPATH**/ ?>