<?php $__env->startSection('title','Delete Account - UrbanMop'); ?>
<?php $__env->startSection('meta_tags'); ?>
<meta name="description" content="If you'd like to delete your UrbanMop account, follow the simple steps on this page. We're here to assist with any questions or concerns you may have during the process.">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<section class="mt-30 mb-30">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-10 col-lg-6">
                <div class="card">
                    <h1 class="card-header bg-1 h5 text-center border-0">Delete Account</h1>
                    <div class="card-body">
                        <form action="<?php echo e(route('delete.account')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12 mb-20">
                                    <input type="text" class="form-input-1" name="name" value="" placeholder="Name" required>
                                </div>
                                <div class="col-12 mb-20">
                                    <input type="email" class="form-input-1" name="email" value="" placeholder="Email" required>
                                </div>

                                <!-- Include CSS for intl-tel-input (v24.6.0) -->
                                <link rel="stylesheet" 
                                href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
                                integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
                                crossorigin="anonymous" referrerpolicy="no-referrer" />

                                <div class="form-group col-12 mb-20">
                                    <div class="input-group">
                                        <!-- Dial Code Input with Flag -->
                                        <div class="input-group-prepend">
                                            <input type="tel" name="dial_code" id="dial-code" 
                                                class="form-control" value="+<?php echo e(ltrim(auth()->user()->dial_code ?? '971', '+')); ?>" 
                                                required style="width:120px; text-align: center;">
                                        </div>

                                        <!-- Phone Number Input -->
                                        <input type="text" id="phone-number" class="form-control" 
                                            name="phone" value="" 
                                            placeholder="Enter phone number" required>
                                    </div>
                                </div>

                                <!-- Include JS for intl-tel-input (v24.6.0) -->
                                <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
                                        integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
                                        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

                                <script>
                                    (function() {
                                        const dialCodeInput = document.querySelector("#dial-code");

                                        const iti = intlTelInput(dialCodeInput, {
                                            initialCountry: "AE",  
                                            separateDialCode: false,  
                                            autoPlaceholder: "polite",  
                                            // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js",
                                        });

                                        dialCodeInput.addEventListener("countrychange", function() {
                                            const countryData = iti.getSelectedCountryData();
                                            console.log(`Selected country: ${countryData.name}, Dial Code: ${countryData.dialCode}`);
                                        });
                                    })();
                                </script>

                                <div class="col-12 mb-20">
                                    <textarea name="comments" placeholder="Your comments" id="" required></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-1 w-100">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/urbanmop/public_html/resources/views/web/delete_account.blade.php ENDPATH**/ ?>