<!DOCTYPE html>
<html>
<head>
    <style>
        .pac-container {
            z-index: 9999 !important;
            position: absolute !important;
        }
    </style>
</head>
<body>
    <input id="autocomplete" type="text" placeholder="Enter a location" style="width: 100%; padding: 8px;" autocomplete="off">
    <input type="text" id="selected-address" readonly style="width: 100%; margin-top: 10px;">
    <div id="add-map" style="height: 300px; width: 100%; margin-bottom: 20px;"></div>

    <script>
        function initMap() {
            const defaultLocation = { lat: 25.276987, lng: 55.296249 };
            const UAE_BOUNDS = {
                north: 26.084,
                south: 22.633,
                east: 56.381,
                west: 51.484,
            };

            const map = new google.maps.Map(document.getElementById('add-map'), {
                center: defaultLocation,
                zoom: 12,
                restriction: {
                    latLngBounds: UAE_BOUNDS,
                    strictBounds: true,
                },
            });

            const marker = new google.maps.Marker({
                position: defaultLocation,
                map: map,
                draggable: true
            });

            const geocoder = new google.maps.Geocoder();

            function updateAddress(location) {
                geocoder.geocode({ location }, (results, status) => {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('selected-address').value = results[0].formatted_address;
                    } else {
                        console.error('Failed to retrieve address:', status);
                    }
                });
            }

            // Set default address
            updateAddress(defaultLocation);

            // Update address when the marker is dragged
            marker.addListener('dragend', function () {
                updateAddress(marker.getPosition());
            });

            // Autocomplete functionality
            const autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'), {
                bounds: new google.maps.LatLngBounds(
                    { lat: UAE_BOUNDS.south, lng: UAE_BOUNDS.west },
                    { lat: UAE_BOUNDS.north, lng: UAE_BOUNDS.east }
                ),
                strictBounds: true,
            });

            autocomplete.addListener('place_changed', function () {
                const place = autocomplete.getPlace();
                if (place.geometry && place.geometry.location) {
                    map.setCenter(place.geometry.location);
                    marker.setPosition(place.geometry.location);
                    updateAddress(place.geometry.location);
                }
            });
        }
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU&libraries=places&callback=initMap" async defer></script>
</body>
</html>
