@extends('web.layout.header')
@section('content')

<section class="mt-30 mb-30">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-11 col-md-7 col-lg-6">
                <div class="text-center">
                    <img src="https://dxbitprojects.com/urbanmob/v2/assets/images/tick.svg" class="img-fluid mb-20" alt="">
                    <h1 class="fs-2 fw-600">Congratulations</h1>
                    <p>Your order has been successfully placed!</p>
                </div>

                <div class="card mb-20">
                    <div class="card-body">
                        @php
                            $count = 0;
                        @endphp
                    @foreach($cards_details as $card)
                        @php
                            if($card['service_id'] == 10){
                                $count = 1;
                            }
                        @endphp
                        <div class="mb-3">
                            <h4 class="fs-5">{{$card['service_name']}}</h4>
                            @if(count($card['attributes']) > 0)
                                @foreach($card['attributes'] as $attribute)
                                    <div class="d-flex justify-content-between">
                                        @php
                                            $maidCount = 1; 
                                            $get_price = $card['service_price'];
                                        @endphp

                                        @if($attribute->attribute_name == "Maids")
                                            @php
                                                preg_match('/\d+/', $attribute->attribute_item_name, $matches);
                                                $maidCount = $matches[0] ?? 1; // Extract maid count
                                                $get_price = $card['service_price'] * $maidCount; // Update get_price based on maids
                                            @endphp

                                            <p>{{ $attribute->attribute_item_name }} (AED {{ $card['service_price'] }} x {{ $maidCount }})</p>
                                            <p style="display:none;">AED {{ $get_price }}</p>
                                        @elseif($attribute->attribute_name == "Hours")
                                            @php
                                                $hourlyPrice = $get_price * $attribute->attribute_price; // Calculate hourly rate
                                            @endphp

                                            <p>{{ $attribute->attribute_item_name }} (AED {{ $get_price }} x {{ $attribute->attribute_price }} hours)</p>
                                            <p style="display:none;">AED {{ $hourlyPrice }}</p>
                                        @else
                                            @php
                                                $additionalPrice = $attribute->attribute_price * $attribute->attribute_qty; // Calculate additional attribute cost
                                            @endphp

                                            <p>{{ $attribute->attribute_item_name }}</p>
                                            <p style="display:none;">AED {{ $attribute->attribute_price }} x {{ $attribute->attribute_qty }} = AED {{ $additionalPrice }}</p>
                                        @endif
                                    </div>
                                @endforeach

                            @endif
                        </div>
                    @endforeach

                    
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5">Sub Total</h4>
                            <h4 class="text-end mb-0 fs-5">AED {{ number_format($sub_total, 2) }}</h4>
                        </div>
                        <hr>
                        @if($count == 1)
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-1 fs-5">Material Charge</h4>
                            <h4 class="text-end mb-1 fs-5">AED {{ number_format($material_charge, 2) }}</h4>
                        </div>
                        <hr>
                    @endif
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5">Tip</h4>
                            <h4 class="text-end mb-0 fs-5">AED {{ number_format($tip, 2) }}</h4>
                        </div>
                        <hr>
                        @if($coupon_discount > 0)
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">Coupon Discount</h4>
                                <h4 class="text-end mb-0 fs-5">- AED {{ number_format($coupon_discount, 2) }}</h4>
                            </div>
                            <hr>
                        @endif
                        @if($payment_type == 2)
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">COD Charge</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{ number_format($surcharge, 2) }}</h4>
                            </div>
                            <hr>
                        @endif
                        @if($cod_charge > 0)
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">Surcharge</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{ number_format($cod_charge, 2) }}</h4>
                            </div>
                            <hr>
                        @endif
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5 fw-600">Total</h4>
                            <h4 class="text-end mb-0 fs-5 text-secondary fw-600">AED {{ number_format($total, 2) }}</h4>
                        </div>
                    </div>
                </div>

                <a href="{{route('shop')}}" class="btn btn-2 w-100">Book Another Service</a>
            </div>
        </div>
    </div>
</section>

@endsection
