@extends('web.layout.header')
@section('title','My Profile')
@section('content')

<section class="mt-30 mb-30">
    <div class="container">
        <div class="row gx-3 align-items-center">
            <div class="col-12 mb-20">
                <h3 class="fs-4 mb-0">My Wallet</h3>
            </div>

            <div class="col-12 mb-20">
                <div class="wallet-info" style="background: url( {{ url('web/assets/img/wallet-05454545405054.png') }} ),
				 linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%);background-size: contain;background-position: left bottom;background-repeat: no-repeat;">
                    <div class="row align-items-center">
                        <div class="col-4 col-lg-5 text-center">
                            <img src="https://dxbitprojects.com/urbanmob/v2/assets/images/wallet-white.png" class="img-fluid" alt="">
                        </div>
                        <div class="col-8 col-lg-7">
                            <div class="wallet-info-content">
                                <h1 class="text-white">AED {{ $total ?? '0.00' }}</h1>
                                <h2 class="fs-4 mb-0 text-white date">
                                    Updated <br class="d-md-none"> {{ optional($walletData['last_transaction'])['created_at_display'] ?? 'Not available' }}
                                </h2>
                            </div>
                        </div>
                    </div>                    
                </div>
            </div>

            <div class="col-12 mb-20">
                <div class="row">
                    <span class="col-lg-9 mb-15 mb-lg-0">
                        <h3 class="fs-3 mb-10 fw-600">Transaction</h3>
                        <p class="mb-0">
                            Last Updated {{ optional($walletData['last_transaction'])['created_at_display'] ?? 'Not available' }}
                        </p>
                    </span>
                    <div class="col-lg-3"> 
                        <a href="#!" class="btn btn-1 w-100" data-bs-toggle="modal" data-bs-target="#rechargemodal">Recharge Wallet</a>
                    </div>
                </div>
            </div>

            @if (empty($walletData['transaction']['list']))
                <div class="col-12 text-center mt-50 mb-50">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="no-results-div">
                                <img src="{{asset('images/empty-wallet.svg')}}" class="img-fluid mb-3">
                                <h3>Your Wallet is Empty</h3>
                            </div>
                        </div>
                    </div>
                </div>
            @else

            @foreach ($walletData['transaction']['list'] as $transaction)
            <div class="col-lg-6 mb-15">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-10 d-flex align-items-center justify-content-between w-100 gap-2">
                            <h4 class="mb-0 fs-6 fw-600">#{{ $transaction->transaction_id }}</h4>
                            <h5 class="mb-0 fs-14">{{ $transaction->created_at_display }}</h5>
                        </div>
                        <div class="mb-0 d-flex align-items-center justify-content-between w-100 gap-2">
                            <h4 class="mb-0 fs-14">{{ $transaction->pay_type ?? 'N/A' }}</h4>
                            <h5 class="mb-0 fs-6 fw-600"><b class="text-secondary">{{$transaction->type=="credit" ? "+" : "-"}}{{ $transaction->amount }} AED</b></h5>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach

            @endif
        </div>
    </div>
</section>

<div class="modal fade" id="rechargemodal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Recharge Wallet</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-20 text-center">
                    <input type="number" style="pointer-events: all !important;" id="rechargeAmount" name="amount" class="form-input-1" placeholder="Enter Amount" min="1" required>
                </div>


                <div class="row package-selector">

                    <div class="col-12 mb-10">
                        <h3 class="fs-5 mb-0">Payment Methods</h3>
                    </div>

                    <div class="col-12 mb-10">
                        <label class="control w-100" for="rechargewallet1">
                            <input type="radio" name="rechargewallet" id="rechargewallet1" checked>
                            <span class="control__content w-100">
                                <i class="fal fa-check mx-0"></i>
                                <div class="w-100">
                                    <h5 class="h6 mb-0 d-flex gap-2 align-items-center">
                                        <img src="{{ asset('web/assets/img/telr-logo.svg') }}" class="img-fluid"> Debit/Credit Card
                                    </h5>
                                </div>
                            </span>
                        </label>
                    </div>

                    <!-- <div class="col-12 mb-10">
                        <label class="control w-100" for="rechargewallet2">
                            <input type="radio" name="rechargewallet" id="rechargewallet2">
                            <span class="control__content w-100">
                                <i class="fal fa-check mx-0"></i>
                                <div class="w-100">
                                    <h5 class="h6 mb-0 d-flex gap-2 align-items-center">
                                        <img src="https://dxbitprojects.com/urbanmob/v2/assets/images/careempay.svg" class="img-fluid">
                                    </h5>
                                </div>
                            </span>
                        </label>
                    </div>

                    <div class="col-12 mb-10">
                        <label class="control w-100" for="rechargewallet3">
                            <input type="radio" name="rechargewallet" id="rechargewallet3">
                            <span class="control__content w-100">
                                <i class="fal fa-check mx-0"></i>
                                <div class="w-100">
                                    <h5 class="h6 mb-0 d-flex gap-2 align-items-center">
                                        <img src="https://dxbitprojects.com/urbanmob/v2/assets/images/applepay.svg" class="img-fluid">
                                    </h5>
                                </div>
                            </span>
                        </label>
                    </div>

                    <div class="col-12 mb-20">
                        <label class="control w-100" for="rechargewallet4">
                            <input type="radio" name="rechargewallet" id="rechargewallet4">
                            <span class="control__content w-100">
                                <i class="fal fa-check mx-0"></i>
                                <div class="w-100">
                                    <h5 class="h6 mb-0 d-flex gap-2 align-items-center">
                                        <img src="https://dxbitprojects.com/urbanmob/v2/assets/images/tamara.svg" class="img-fluid"> Cash
                                    </h5>
                                </div>
                            </span>
                        </label>
                    </div> -->

                    
                </div>

                <a href="javascript:void(0)" class="btn btn-1 w-100" onclick="initRecharge()">Proceed</a>   
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Complete Your Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <iframe id="paymentFrame" src="" style="width: 100%; height: 600px; border: none;"></iframe>
            </div>
        </div>
    </div>
</div>

<script src="https://js.stripe.com/v3/?cache_bust={{ time() }}"></script>

<script>
// function initRecharge() {
//     const amount = document.getElementById('rechargeAmount').value;
//     let paymentType = document.querySelector('input[name="rechargewallet"]:checked').id;

//     if(paymentType == "rechargewallet1"){
//         paymentType = 1;
//     }
//     if (!amount || amount <= 0) {
//         alert('Please enter a valid amount.');
//         return;
//     }

//     fetch('{{ url("wallet/init") }}', {
//         method: 'POST',
//         headers: {
//             'Content-Type': 'application/json',
//             'X-CSRF-TOKEN': '{{ csrf_token() }}'
//         },
//         body: JSON.stringify({
//             amount: amount,
//             payment_type: paymentType
//         })
//     })
//     .then(response => response.json())
//     .then(data => {
//         if (data.status === "1") {
//             loadStripeModal(data.oData.payment_ref);
//         } else {
//             alert(data.message || 'Failed to initialize recharge.');
//         }
//     })
//     .catch(error => console.error('Error:', error));
// }

// function loadStripeModal(clientSecret) {
//     const stripe = Stripe('pk_test_51KdqxdBjsMxFtgBeSKmSXVjwG6yqKIUT89jWGFrZcON2gxqhtfhH6EFSHYVdrqPAU4UxEsIlAUEhnmPAlkvxMkzK0009RlNxWJ');
//     stripe.redirectToCheckout({ sessionId: clientSecret });
// }

function initRecharge() {
    const amount = document.getElementById('rechargeAmount').value;
    let paymentType = document.querySelector('input[name="rechargewallet"]:checked').id;

    if (paymentType === "rechargewallet1") {
        paymentType = 1;
    }
    if (!amount || amount <= 0) {
        alert('Please enter a valid amount.');
        return;
    }

    fetch('{{ url("wallet/init") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            amount: amount,
            payment_type: paymentType
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === "1") {
            redirectToTelrCheckout(data.oData.checkout_url);
        } else {
            alert(data.message || 'Failed to initialize recharge.');
        }
    })
    .catch(error => console.error('Error:', error));
}

function redirectToTelrCheckout(checkoutUrl) {
    if (checkoutUrl) {
        window.location.href = checkoutUrl; 
    } else {
        alert('Checkout URL not provided. Please try again.');
    }
}

</script>
@endsection
