@foreach($packages as $key => $package)
    <li class="w-100">
        <label class="control w-100" for="package{{ $key + 1 }}">
            <input 
                type="radio" 
                name="package" 
                id="package{{ $key + 1 }}" 
                value="{{ $package->id }}" 
                onclick="collectAttributesData({{ $package->amount }}, {{ $package->id }}, {{ $package->total_sessions ?? 0 }}, {{ $package->free_sessions ?? 0 }}, {{ $package->per_week ?? 1 }})" 
                class="{{(($selected_package_id == $package->id) || ($key == 0 && $selected_package_id == 0)) ? 'active' : ''}}"
                {{(($selected_package_id == $package->id) || ($key == 0 && $selected_package_id == 0)) ? 'checked' : ''}}
            >
            <span class="control__content w-100">
                <i class="fal fa-check mb-4"></i>
                <div class="w-100">
                    <div class="d-flex flex-column flex-md-row">
                        <h5 class="fs-5 fw-bold">{{ $package->name }}</h5>
                        @if($package->total_sessions && $package->free_sessions)
                            <h4 class="fs-5 text-muted fw-medium"><span class="d-none d-md-inline-block ms-2 me-1">-</span> {{ $package->total_sessions }} Sessions + {{ $package->free_sessions }} Free</h4>
                        @endif
                    </div>
                    <h4 class="mb-0 fs-5 d-flex justify-content-between fw-bold" style="margin-right: -20px;">
                        AED {{ number_format($package->amount, 2) }}
                        @if($package->save_amount)
                            <span class="text-primary fw-medium fs-6">Save AED {{ number_format($package->save_amount, 2) }}</span>
                        @endif
                    </h4>
                </div>
            </span>
        </label>
    </li>
@endforeach