@extends('web.layout.header')
@section('content')
@section('meta_tags')
<meta name="description" content="Urbanmop is your one-stop destination to get trusted expert professionals near you right at your doorstep, covering all your home services, home repair, and beauty needs.">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/rateYo/2.3.4/jquery.rateyo.min.css" integrity="sha512-JEUoTOcC35/ovhE1389S9NxeGcVLIqOAEzlpcJujvyUaxvIXJN9VxPX0x1TwSo22jCxz2fHQPS1de8NgUyg+nA==" crossorigin="anonymous" referrerpolicy="no-referrer">

<section class="pageBannerSection" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url(assets/images/maid_service.jpg);">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="pageBannerContent text-center">
                    <h1 class="text-white">Booking Detail</h1>
                    <div class="pageBannerPath">
                        <a href="index.php">Home</a> &gt; 
                        <span>Booking Detail</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="arrow-down">
        <a href="#down"><i class="fal fa-chevron-down"></i></a>
    </div>
</section>

<section class="sec-m-top mb-30" id="down">
    <div class="container">
        <div class="row">
            @if (empty($cartItem))
                <div class="col-12 text-center mt-50 mb-50">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="no-results-div">
                                <img src="{{asset('images/no-booking.png')}}" class="img-fluid mb-3">
                                <h3>No Booking Found!</h3>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="col-lg-12 mb-4">
                    <div class="card cart-card overflow-hidden">
                        <div class="card-body">
                            <div class="cart-item">
                                <div class="cart-item-product d-flex gap-3 align-items-center">
                                    <div class="cart-item-img bg-1">
                                        @php
                                            // Retrieve the service thumbnail by service_id
                                            $service = \App\Service::find($cartItem['service_id']);
                                        @endphp
                                        <img src="{{ asset('uploads/service/' . ($service->thumbnail_img ?? 'default.jpg')) }}" class="img-fluid" alt="Service Image">
                                    </div>

                                    <div class="card-item-details w-100">
                                    <div class="d-flex w-100 gap-2 align-items-center justify-content-between">
                                            <h4 class="mb-2 fw-600 fs-5">{{ $cartItem['service_name'] }}</h4>

                                            <h4 class="mb-0 fw-600 fs-6 amount text-secondery">
                                                @switch($cartItem['status'])
                                                    @case('Accept')
                                                        Accepted
                                                        @break

                                                    @case('Mark As Arrived')
                                                        En route to work
                                                        @break

                                                    @default
                                                        {{ $cartItem['status'] }}
                                                @endswitch
                                            </h4>


                                        </div>
                                        <div class="d-flex w-100 gap-2 align-items-end justify-content-between">

                                            <!-- Attributes -->
                                            @if (!empty($cartItem['card_attribute']))
                                                <div class="mt-2">
                                                    @foreach ($cartItem['card_attribute'] as $attribute)
                                                        <span class="mb-0 fs-5">{{ $attribute['attribute_item_name'] }}</span>
                                                        @if (!$loop->last)
                                                            x 
                                                        @endif
                                                    @endforeach
                                                </div>
                                            @endif
                                            <h4 class="mb-0 fw-600 fs-5">AED {{ number_format($cartItem['amount'], 2) }} </h4>
                                            @if($assigned_staff->count() > 0)
                                            <a href="#!" data-bs-toggle="modal" data-bs-target="#assign_staff" class="text-primary">Assigned Staff ({{$assigned_staff->count()}})</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                            
                            </div>
                        </div>

                        <div class="card-header bg-1 border-0">
                            <div class="cart-item-footer">
                                <div class="cart-item-timing">
                                    @if($cartItem['service_id'] == 10)
                                        <h4 class="mb-1 fw-600 fs-5">{{ App\Slot::find($cartItem['session_time'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-5 mt-0">
                                            @php
                                            $selected_date=\Carbon\Carbon::parse($cartItem['session_date'])->format('d-m-Y');
                                            @endphp
                                            {{ \Carbon\Carbon::parse($cartItem['session_date'])->format('d-m-Y') ?? 'Not specified' }}</p>
                                    @else
                                        <h4 class="mb-1 fw-600 fs-5">{{ App\Slot::find($cartItem['slot_id'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-14 mt-0">
                                            @php
                                            $selected_date=\Carbon\Carbon::parse($cartItem['date'])->format('d-m-Y');
                                            @endphp
                                            {{ \Carbon\Carbon::parse($cartItem['date'])->format('d-m-Y') ?? 'Not specified' }}
                                        </p>
                                    @endif
                                </div>
                                <div class="cart-item-btns">
                                    @if($cartItem['status'] == "In Progress")
                                        <?php
                                            $address = isset($cartItem['address_id']) ? \App\Address::find($cartItem['address_id']) : null;
                                            $latitude = $address->latitude ?? '';
                                            $longitude = $address->longitude ?? '';
                                            $mapLink = !empty($latitude) && !empty($longitude)
                                                ? "https://www.google.com/maps/search/?api=1&query={$latitude},{$longitude}"
                                                : null;
                                        ?>
                                        <a 
                                            href="{{ $mapLink ?? '#' }}" 
                                            target="{{ $mapLink ? '_blank' : '_self' }}" 
                                            class="btn btn-secondary p-2 {{ $mapLink ? '' : 'disabled' }}" 
                                            style="text-decoration: none; display:none;"
                                        >
                                            <img src="{{ asset('images/location.svg') }}" class="img-fluid" width="24" alt="Location">
                                        </a>

                                    @endif
                                    
                                    <!--<a href="#!" class="btn btn-secondary p-2"><img src="{{ url('images/support_img.svg') }}" class="img-fluid" width="24" alt=""></a>-->
                                    @if($vendor)
                                        @if(in_array($cartItem['status'],['Pending','Accept','In Progress']))
                                        <a href="tel:+{{$vendor->dial_code}}{{$vendor->phone}}" class="btn btn-secondary p-2 ms-2"><img src="{{ asset('images/call.svg') }}" class="img-fluid" width="24" alt=""></a>
                                        @endif
                                    @endif
                                    @if($cartItem['status'] == "Completed")
                                        <a href="javascript:void(0)" 
                                        class="btn btn-secondary p-2 reorder-btn ms-2" 
                                        data-card-id="{{ $cartItem['id'] }}"
                                        onclick="handleReorder({{ $cartItem['id'] }})">
                                        <img src="{{ asset('images/return.svg') }}" class="img-fluid" width="24" alt="Reorder">
                                        </a>
                                        @php
                                        $rating = \App\Review::find($cartItem['id']); 
                                       
                                        @endphp
                                        @if(empty($rating))
                                        <a href="#!" 
                                            class="btn btn-2 ms-2" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#reviewrating" 
                                            data-service-id="{{ $cartItem['service_id'] }}"
                                            data-cart-id="{{ $cartItem['id'] }}">Rating</a>
                                        @endif
                                    @endif

                                    @if(in_array($cartItem['status'],['Pending','Accept']))
                                    <a href="#!" 
                                        class="btn btn-2 ms-2" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#modifyModal" 
                                        data-service-id="{{ $cartItem['service_id'] }}"
                                        data-cart-date="{{ $cartItem['date'] }}"
                                        data-cart-slot="{{ $cartItem['slot_id'] }}"
                                        data-cart-id="{{ $cartItem['id'] }}">Modify?</a>
                                    @endif
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if($cartItem['service_id'] == 10)
                <div class="col-12 mb-4">
                    <a href="#!" class="w-100" data-bs-toggle="modal" data-bs-target="#sessionhistory">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-secondary h6 d-flex align-items-center justify-content-between">Session History <i class="fas fa-chevron-right h6"></i></h4>
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-1 fs-5 fw-600">{{ $cartItem['session_history']['free_session'] }}/{{ $cartItem['session_history']['total_session'] }} Session</h4>
                                    <h4 class="text-end mb-1 fs-5 text-muted">{{ $cartItem['session_history']['per_week'] }} Session Per Week</h4>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endif
            
            <div class="col-12 mb-4">
                <a href="#!" class="btn btn-2 justify-content-between w-100" data-bs-toggle="modal" data-bs-target="#servicedetails" style="border-radius: 10px !important; padding: 12px 20px;"> Service Details <i class="fas fa-chevron-right"></i> </a>
            </div>

            <div class="col-lg-6 col-12 mb-4">
                <h3 class="fs-4 mb-2">Details</h3>
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-1 fs-5 fw-600">Booking ID</h4>
                            <h4 class="text-end mb-1 fs-5">#{{$cartItem['id']}}</h4>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-1 fs-5 fw-600">Transaction ID</h4>
                            <h4 class="text-end mb-1 fs-5">#{{$cartItem['tran_id']}}</h4>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5 fw-600">Status</h4>
                            <h4 class="text-end mb-0 fs-5 text-primary">
                                @switch($cartItem['status'])
                                    @case('Accept')
                                        Accepted
                                        @break

                                    @case('Mark As Arrived')
                                        En route to work
                                        @break

                                    @default
                                        {{ $cartItem['status'] }}
                                @endswitch
                            </h4>

                        </div>
                        <hr>
                        @if(array_key_exists('coupon_amount', $cartItem) && !empty($cartItem['coupon_amount']))
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Coupon</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{$cartItem['coupon_amount']}}</h4>
                            </div>
                            <hr>
                        @endif

                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5 fw-600">Sub Total</h4>
                            <h4 class="text-end mb-0 fs-5">AED {{$cartItem['subtotal']}}</h4>
                        </div>
                        @php
                            $total_amount_total = (float)$cartItem['subtotal'];
                        @endphp
                        <hr>
                        @if(array_key_exists('material_charge', $cartItem) && !empty($cartItem['material_charge']))
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Material Price</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{$cartItem['material_charge']}}</h4>
                            </div>
                            <hr>
                        @endif
                        

                        <?php 
                             $order = \App\Order::find($cartItem['order_id']); 
                            
                            ?>
                        @if(isset($order->tip_amount) && $order->tip_amount  > 0)
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">Tip</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{ number_format($order->tip_amount/$order_count , 2) }}</h4>
                            </div>
                            <hr>
                            <?php $total_amount_total += (float) ($order->tip_amount/$order_count); ?>
                        @endif
                        
                        
                        @if($cartItem['surcharge'] > 0)
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">Surcharge</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{ number_format($cartItem['surcharge'], 2) }}</h4>
                            </div>
                            <hr>
                            <?php $total_amount_total += (float) $cartItem['surcharge']; ?>
                        @endif
                        
                        @if($order->payment_type == 2)
                            @if($cartItem['cod_charge'] > 0)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">Cod charge</h4>
                                    <h4 class="text-end mb-0 fs-5">AED {{ number_format($cartItem['cod_charge'], 2) }}</h4>
                                </div>
                                <hr>
                                <?php $total_amount_total += (float) $cartItem['cod_charge']; ?>
                            @endif              
                        @endif
                        @php
                            $parent_cart_id = (string) optional(\App\Card::where('revisit_id', $cartItem['id'])->first())->id ?? "";                ;
                        @endphp
                        @if(empty($parent_cart_id))
                            <?php
                                $total_amount_total -=$coupon_amount;
                            ?>  
                            @if($coupon_amount > 0)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">Coupon Discount</h4>
                                    <h4 class="text-end mb-0 fs-5">- AED {{ $coupon_amount }}</h4>
                                </div>
                                <hr>
                                
                            @endif
                        @endif
                        <div class="d-flex justify-content-between gap-2">
                            <h4 class="mb-0 fs-5 fw-600">Total</h4>
                            <h4 class="text-end mb-0 fs-5 fw-600">AED {{number_format($g_total,2)}}</h4>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-12">
            <div class="row">
                <div class="col-12 mb-4">
                    <h3 class="fs-4 mb-2">Location</h3>
                    <div class="card">
                        <div class="card-body">
                            @if($cartItem['address_type'] == "-")
                            -
                            @else
                                <h6>{{$cartItem['address_type']}}</h6>
                                <h5 class="mb-0 fs-5">{{ $cartItem['flat_no'] }}, {{ $cartItem['building'] }} - {{ $cartItem['city_name'] ?? 'N/A' }}, {{ $cartItem['locality_name'] ?? 'N/A' }}</h5>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <h3 class="fs-4 mb-2">Contact Details</h3>
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Name</h4>
                                <h4 class="text-end mb-0 fs-5">{{ $cartItem['user_name'] }}</h4>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Mobile Number</h4>
                                <h4 class="text-end mb-0 fs-5">{{ strpos($cartItem['user_dial_code'], '+') === 0 ? $cartItem['user_dial_code'] : '+' . $cartItem['user_dial_code'] }}
                                {{ $cartItem['user_phone'] }}</h4>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Email Address</h4>
                                <h4 class="text-end mb-0 fs-5">{{ $cartItem['user_email'] }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>


            @if($cartItem['status'] == 'Completed' && $cartItem['revisit_id'] == null)
                @if($cartItem['service_completed_date']) 
                    @php
                        $originalDate = \Carbon\Carbon::parse($cartItem['service_completed_date']);
                        $currentDate = \Carbon\Carbon::now();
                        $daysSinceService = $originalDate->diffInDays($currentDate);
                    @endphp
                    @if($daysSinceService <= 90)
                        <div class="col-12">
                            <h3 class="fs-4 mb-2">Revisit Details</h3>
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between gap-2">
                                        @if($daysSinceService >= 21)
                                            <a href="#!" 
                                                class="btn btn-2" 
                                                data-bs-toggle="modal" 
                                                id="disclaimerModalId" 
                                                data-bs-target="#disclaimerModal" 
                                                data-service-id="{{ $cartItem['service_id'] }}"
                                                data-cart-date="{{ $cartItem['date'] }}"
                                                data-cart-slot="{{ $cartItem['slot_id'] }}"
                                                data-cart-id="{{ $cartItem['id'] }}">Schedule a Revisit
                                            </a>
                                        @else
                                            <a href="#!" 
                                                class="btn btn-2" 
                                                data-bs-toggle="modal" 
                                                id="scheduleButton" 
                                                data-bs-target="#scheduleModal" 
                                                data-service-id="{{ $cartItem['service_id'] }}"
                                                data-cart-date="{{ $cartItem['date'] }}"
                                                data-cart-slot="{{ $cartItem['slot_id'] }}"
                                                data-cart-id="{{ $cartItem['id'] }}">Schedule a Revisit
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
            @endif

            @if($cartItem['revisit_id'] != null)
                @php
                    $revisit_card = \App\Card::find($cartItem['revisit_id'])->toArray();
                @endphp
                <div class="col-12">
                    <h3 class="fs-4 mb-2">Revisit Details</h3>
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between gap-2">
                                <div class="col-lg-12 mb-4">
                                    <div class="card cart-card overflow-hidden">
                                        <div class="card-body">
                                            <div class="cart-item">
                                                <div class="cart-item-product d-flex gap-3 align-items-center">
                                                    <div class="cart-item-img bg-1">
                                                        @php
                                                            // Retrieve the service thumbnail by service_id
                                                            $service = \App\Service::find($revisit_card['service_id']);
                                                        @endphp
                                                        <img src="{{ asset('uploads/service/' . ($service->thumbnail_img ?? 'default.jpg')) }}" class="img-fluid" alt="Service Image">
                                                    </div>

                                                    <div class="card-item-details w-100">
                                                    <div class="d-flex w-100 gap-2 align-items-center justify-content-between">
                                                            <h4 class="mb-2 fw-600 fs-5">{{ $revisit_card['service_name'] }}</h4>

                                                            <h4 class="mb-0 fw-600 fs-6 amount text-secondery">
                                                                @switch($revisit_card['status'])
                                                                    @case('Accept')
                                                                        Accepted
                                                                        @break

                                                                    @case('Mark As Arrived')
                                                                        En route to work
                                                                        @break

                                                                    @default
                                                                        {{ $revisit_card['status'] }}
                                                                @endswitch
                                                            </h4>


                                                        </div>
                                                        <div class="d-flex w-100 gap-2 align-items-end justify-content-between">

                                                            <!-- Attributes -->
                                                            @if (!empty($revisit_card['card_attribute']))
                                                                <div class="mt-2">
                                                                    @foreach ($revisit_card['card_attribute'] as $attribute)
                                                                        <span class="mb-0 fs-5">{{ $attribute['attribute_item_name'] }}</span>
                                                                        @if (!$loop->last)
                                                                            x 
                                                                        @endif
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                            <h4 class="mb-0 fw-600 fs-5">AED {{ number_format($revisit_card['amount'], 2) }} </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card-header bg-1 border-0">
                                            <div class="cart-item-footer">
                                                <div class="cart-item-timing">
                                                    <h4 class="mb-1 fw-600 fs-5">{{ App\Slot::find($revisit_card['slot_id'])->name ?? "-" }}</h4>
                                                    <p class="mb-0 text-muted fs-14 mt-0">
                                                        @php
                                                        $selected_date=\Carbon\Carbon::parse($revisit_card['date'])->format('d-m-Y');
                                                        @endphp
                                                        {{ \Carbon\Carbon::parse($revisit_card['date'])->format('d-m-Y') ?? 'Not specified' }}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="{{ route('booking-detail',$revisit_card['id']) }}" class="overlay-link-service"></a>
                    
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>

<style>
    hr{
        margin: 5px 0px
    }
</style>

<div class="modal fade" id="modifyModal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="exampleModalLabel">Modify Booking</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <div class="row">
                  <div class="col-12 mb-20">
                        <a href="#!" 
                            class="btn-outline w-100" 
                            data-bs-toggle="modal" 
                            data-bs-target="#rescheduleModal" 
                            data-bs-dismiss="modal" 
                            id="rescheduleButton" 
                            data-service-id=""
                            data-cart-id=""
                            data-cart-date=""
                            data-cart-slot=""
                        > 
                            <span class="d-flex gap-2 align-items-center">
                                <i class="fal fa-calendar-alt"></i> Reschedule Booking
                            </span> 
                            <i class="far fa-angle-right text-secondary"></i>
                        </a>

                  </div>
                  @if($cartItem['status'] == "Pending")
                  <div class="col-12 mb-20">
                        <a href="#!" class="btn-outline w-100" data-bs-toggle="modal" data-bs-target="#cancelModal" data-bs-dismiss="modal"> <span class="d-flex gap-2 align-items-center"><i class="fal fa-calendar-times"></i> Cancel Booking</span> <i class="far fa-angle-right text-secondary"></i></a>
                  </div>
                  @endif
                  <div class="col-12">
                        <a href="#!" class="btn-outline w-100"> <span class="d-flex gap-2 align-items-center"><i class="fal fa-headset"></i> Get Support</span> <i class="far fa-angle-right text-secondary"></i></a>
                  </div>
               </div>
            </div>
      </div>
   </div>
</div>

<div class="modal fade" id="disclaimerModal" tabindex="-1" aria-labelledby="exampleModalLabelSchedule" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabelSchedule">Schedule a Revisit</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                
                    <div class="col-12">
                        It is recommended to schedule a revisit after 21 days to ensure the effectiveness of pesticide activation.
                    </div>
                    <div class="col-6 mt-3">
                        <button type="button" class="btn btn-2" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                    </div>
                    <div class="col-6 mt-3">
                        
                        <a href="#!" 
                            class="btn btn-1 mx-auto me-0" 
                            data-bs-toggle="modal" 
                            id="scheduleButton" 
                            data-bs-target="#scheduleModal" 
                            data-service-id="{{ $cartItem['service_id'] }}"
                            data-cart-date="{{ $cartItem['date'] }}"
                            data-cart-slot="{{ $cartItem['slot_id'] }}"
                            data-cart-id="{{ $cartItem['id'] }}">Proceed</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="scheduleModal" tabindex="-1" aria-labelledby="exampleModalLabelSchedule" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabelSchedule">Modify Date and Time</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 mb-4">
                        <div class="position-relative">
                            <input type="date" class="form-input-1 form-control" id="date-picker-schedule" placeholder="Select Date">
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <ul id="time-slots-list-schedule" class="row gx-2">
                            <!-- Time slots will be dynamically generated here -->
                        </ul>
                    </div>
                    <div class="col-12">
                        <button id="scheduleProceedButton" class="btn btn-1 text-center w-100">Proceed</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="rescheduleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Modify Date and Time</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 mb-4">
                        <input type="date" class="form-input-1" id="date-picker" placeholder="Select Date">
                    </div>
                    <div class="col-12 mb-4">
                        <ul id="time-slots-list" class="row">
                            <!-- Time slots will be dynamically generated here -->
                        </ul>
                    </div>
                    <div class="col-12">
                        <button id="proceedButton" class="btn btn-1 text-center w-100">Proceed</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="servicedetails" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Service Details</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                @if(!empty($cartItem['card']['card_attribute']))
                    <div class="card">
                        <div class="card-body">
                            @foreach($cards_details as $card)
                                <div class="mb-3">
                                    <h4 class="fs-5">{{$card['service_name']}}</h4>
                                    @if(count($card['attributes']) > 0)
                                        @foreach($card['attributes'] as $attribute)
                                            <div class="d-flex justify-content-between">
                                                @php
                                                    $maidCount = 1; 
                                                    $get_price = $card['service_price'];
                                                @endphp

                                                @if($attribute->attribute_name == "Maids")
                                                    @php
                                                        preg_match('/\d+/', $attribute->attribute_item_name, $matches);
                                                        $maidCount = $matches[0] ?? 1; // Extract maid count
                                                        $get_price = $card['service_price'] * $maidCount; // Update get_price based on maids
                                                    @endphp

                                                    <p>{{ $attribute->attribute_item_name }} (AED {{ $card['service_price'] }} x {{ $maidCount }})</p>
                                                    <p>AED {{ $get_price }}</p>
                                                @elseif($attribute->attribute_name == "Hours")
                                                    @php
                                                        $hourlyPrice = $get_price * $attribute->attribute_price; // Calculate hourly rate
                                                    @endphp

                                                    <p>{{ $attribute->attribute_item_name }} (AED {{ $get_price }} x {{ $attribute->attribute_price }} hours)</p>
                                                    <p>AED {{ $hourlyPrice }}</p>
                                                @else
                                                    @php
                                                        $additionalPrice = $attribute->attribute_price * $attribute->attribute_qty; // Calculate additional attribute cost
                                                    @endphp

                                                    <p>{{ $attribute->attribute_item_name }}</p>
                                                    <p>AED {{ $attribute->attribute_price }} x {{ $attribute->attribute_qty }} = AED {{ $additionalPrice }}</p>
                                                @endif
                                            </div>
                                        @endforeach

                                    @endif
                                </div>
                            @endforeach
                            @if($cartItem['service_id'] == 10)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-1 fs-5">Material Charge</h4>
                                    <h4 class="text-end mb-1 fs-5">AED {{isset($cartItem['material_charge'])?$cartItem['material_charge']:'0'}}</h4>
                                </div>
                                <hr>
                            @endif
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5">Sub Total</h4>
                                <h4 class="text-end mb-0 fs-5">AED {{ number_format($cartItem['total'], 2) }}</h4>
                            </div>
                            <hr>
                            <?php $total_amount = (float) $cartItem['total'];
                            
                            ?>

                                <?php 
                                $order = \App\Order::find($cartItem['order_id']); 

                                ?>
                            @if( isset($order->tip_amount) && $order->tip_amount > 0)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">Tip</h4>
                                    <h4 class="text-end mb-0 fs-5">AED {{ number_format($order->tip_amount/$order_count, 2) }}</h4>
                                </div>
                                <hr>
                                <?php $total_amount += (float) ($order->tip_amount/$order_count); ?>
                            @endif
                            @if($cartItem['surcharge'] > 0)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">Surcharge</h4>
                                    <h4 class="text-end mb-0 fs-5">AED {{ number_format($cartItem['surcharge'], 2) }}</h4>
                                </div>
                                <hr>
                                <?php $total_amount += (float) $cartItem['surcharge']; ?>
                            @endif
                            @if(isset($order) && $order->payment_type == 2)
                                @if($cartItem['cod_charge'] > 0)
                                    <div class="d-flex justify-content-between gap-2">
                                        <h4 class="mb-0 fs-5">Cod charge</h4>
                                        <h4 class="text-end mb-0 fs-5">AED {{ number_format($cartItem['cod_charge'], 2) }}</h4>
                                    </div>
                                    <hr>
                                    <?php $total_amount += (float) $cartItem['cod_charge']; ?>
                                @endif
                            @endif
                            @php
                                $parent_cart_id = (string) optional(\App\Card::where('revisit_id', $cartItem['id'])->first())->id ?? "";
                            @endphp
                            @if(empty($parent_cart_id))
                                @if($coupon_amount > 0)
                                    <div class="d-flex justify-content-between gap-2">
                                        <h4 class="mb-0 fs-5">Coupon Discount</h4>
                                        <h4 class="text-end mb-0 fs-5">- AED {{ $coupon_amount }}</h4>
                                    </div>
                                    <hr>
                                    <?php $total_amount -= (float) ($coupon_amount); ?>
                                @endif
                            @endif
                            @if($order->payment_type == 2)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">COD Charge</h4>
                                    <h4 class="text-end mb-0 fs-5">AED {{ number_format($surcharge, 2) }}</h4>
                                </div>
                                <hr>
                                <?php $total_amount += (float) $surcharge; ?>
                            @endif
                            @if($cod_charge > 0)
                                <div class="d-flex justify-content-between gap-2">
                                    <h4 class="mb-0 fs-5">Surcharge</h4>
                                    <h4 class="text-end mb-0 fs-5">AED {{ number_format($cod_charge, 2) }}</h4>
                                </div>
                                <hr>
                                <?php $total_amount += (float) $cod_charge; ?>
                            @endif
                            <div class="d-flex justify-content-between gap-2">
                                <h4 class="mb-0 fs-5 fw-600">Total</h4>
                                <h4 class="text-end mb-0 fs-5 text-secondary fw-600">AED {{ number_format($total_amount, 2) }}</h4>
                            </div>
                        </div>
                    </div>
                @else
                    <p>No service details available.</p>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="exampleModalLabel">Cancel Booking</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <div class="row">
                  <div class="col-12 text-center">
                        <p class="mb-10">Would you like to proceed with canceling? <br>
                        This will cancel your booking.</p>

                        <p class="text-secondary mb-20 fw-600">25 AED Cancellation Fees Will Apply</p>
                        <div class="d-flex align-items-center gap-3 justify-content-between">
                           <a href="#!" class="btn btn-2 w-100" data-bs-dismiss="modal">No</a>
                           <a href="javascript:void(0)" class="btn btn-1 w-100" id="confirmCancelButton" data-cart-id="">Yes, Proceed</a>
                        </div>
                  </div>
               </div>
            </div>
      </div>
   </div>
</div>

<div class="modal fade" id="assign_staff" tabindex="-1" aria-labelledby="assignStaffLabel" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="assignStaffLabel">Assigned Staff</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- <h4 id="modal-text">Hello Worlds</h4> -->
                <div id="staff-list">
                     @foreach($assigned_staff->toArray() as $staff)
                    <p>Staff : {{$staff['staff']['first_name']}} {{$staff['staff']['last_name']}}<p>
                    <p>Phone : {{$staff['staff']['dial_code']}} {{$staff['staff']['phone']}}<p>
                    <p>Status : {{$staff['status']}}</p>
                    @endforeach
                    
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="backToSessionHistory">Back</button>
            </div>
      </div>
   </div>
</div>



<div class="modal fade" id="sessionhistory" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="exampleModalLabel">Session History</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="d-flex align-items-end justify-content-between mb-3">
                    <span> 
                        
                                   
                    <h4 class="mb-1 fs-5 fw-600">{{ $cartItem['session_history']['free_session'] }}/{{ $cartItem['session_history']['total_session'] }} Session</h4>
                    <h4 class="text-end mb-1 fs-5 text-muted">{{ $cartItem['session_history']['per_week'] }} Session Per Week</h4>
                    </span>

                    <span>
                        <h4 class="mb-0 fs-6 fw-600 text-muted">Current Session</h4>
                        <h4 class="text-end mb-0 fs-5">Session {{ $cartItem['session_history']['completed_session'] }}</h4>
                    </span>
                </div>
                <?php
                    $key = 1;
                ?>
                <div class="multiple-card-items">
                    @foreach($cartItem['session_history']['sessions'] as $index => $item)
                        <div class="card mb-2 session-card" 
                            data-bs-toggle="modal" 
                            data-bs-target="#assign_staff"
                            data-session-number="Session {{ $index + 1 }}"
                            data-session-id="{{ $item['id'] }}"> <!-- Store session ID -->
                            <div class="card-body">
                                <div class="cart-item">
                                    <div class="cart-item-product d-flex gap-3 align-items-center">
                                        
                                        <div class="card-item-details w-100">
                                            <div class="d-flex w-100 gap-2 align-items-center justify-content-between">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="mb-1 fs-5 fw-600">Session {{ $index + 1 }}</h4>
                                                    @if(\App\StaffSession::where('session_id',$item['id'])->count() > 0)
                                                        <h5 class="mb-1 fs-5 text-muted fw-medium ms-1"> - Staff ({{ \App\StaffSession::where('session_id',$item['id'])->count() }})</h5>
                                                    @endif
                                                    @if($item['status'] == "Expired")
                                                    <a href="#!" 
                                                    class="btn btn-2 ms-4" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#modifyModal" 
                                                    data-service-id="{{ $cartItem['service_id'] }}"
                                                    data-cart-date="{{ $cartItem['date'] }}"
                                                    data-cart-slot="{{ $cartItem['slot_id'] }}"
                                                    style="font-size: 13px;padding: 8px 12px;height: 35px;line-height: 35px;"
                                                    data-cart-id="{{ $cartItem['id'] }}">Modify?</a>
                                                    @endif
                                                </div>
                                                <h4 class="mb-0 mt-0 fw-600 fs-6 text-success">{{ $item['status'] }}</h4>
                                            </div>
                                            <div class="d-flex w-100 gap-2 align-items-end justify-content-between">
                                                <p class="mb-1 mt-0 text-muted fs-5">{{ \Carbon\Carbon::parse($item['date'])->format('d-m-Y')  }}</p>
                                                <h4 class="mb-0 mt-0 fw-600 fs-6">{{ App\Slot::find($item['time'])->name ?? "-" }}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach


                </div>
            </div>
      </div>
   </div>
</div>
<div class="modal fade" id="reviewrating" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Make a Review Rating</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body">
                <form action="javascript:;" id="reviewForm">
                    <div class="mb-3 text-center">
                        <div id="rateYo" class="mx-auto" style="width: 150px;"></div>
                        <input type="hidden" name="rating" id="rating" value="0">
                    </div>

                    <div class="mb-3">
                        <h3 class="fs-5 mb-3">You can write your detailed review here</h3>
                        <textarea name="review" id="review" placeholder="Enter here" class="form-control" required></textarea>
                    </div>
                    
                    <input type="hidden" name="cart_id" id="cart_id">
                    <input type="hidden" name="service_id" id="service_id">
                    
                    <button type="submit" class="btn btn-1 w-100">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/rateYo/2.3.4/jquery.rateyo.min.js" integrity="sha512-09bUVOnphTvb854qSgkpY/UGKLW9w7ISXGrN0FR/QdXTkjs0D+EfMFMTB+CGiIYvBoFXexYwGUD5FD8xVU89mw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Attach click event to buttons that trigger the review form modal
        document.querySelectorAll('[data-bs-target="#reviewrating"]').forEach(button => {
            button.addEventListener("click", function () {
                const cartId = button.getAttribute('data-cart-id');
                const serviceId = button.getAttribute('data-service-id');

                // Set values in the modal form
                document.getElementById('cart_id').value = cartId;
                document.getElementById('service_id').value = serviceId;
            });
        });

        // Handle review form submission
        const reviewForm = document.getElementById('reviewForm');
        if (reviewForm) {
            reviewForm.addEventListener('submit', function (e) {
                e.preventDefault(); // Prevent the default form submission

                const formData = new FormData(reviewForm);
                const formDataObject = {};
                formData.forEach((value, key) => {
                    formDataObject[key] = value;
                });

                fetch("{{ route('submit-review') }}", {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token for security
                    },
                    body: JSON.stringify(formDataObject)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showToast(data.message, 'success');
                        const modal = document.getElementById('reviewrating');
                        const backdrop = document.querySelector('.modal-backdrop');

                        modal.classList.remove('show'); // Hide modal
                        document.body.classList.remove('modal-open'); // Remove body class
                        if (backdrop) backdrop.remove(); // Remove backdrop
                        reviewForm.reset();
                        // location.reload(); 
                    } else {
                        alert('Something went wrong. Please try again.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while processing your request.');
                });
            });
        }
    });
</script>

<script>
jQuery("#rateYo").rateYo({
                starWidth: "20px",
                rating: jQuery('#rating').val(),
                spacing: "2px",
                ratedFill: "#ed5636",
                'starSvg':`<svg version="1.1"
                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:a="http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"
                x="0px" y="0px" width="528.1px" height="512.1px" viewBox="0 0 528.1 512.1" style="enable-background:new 0 0 528.1 512.1;"
                xml:space="preserve">
                <path d="M292.8,18C287.5,7,276.3,0,264,0s-23.4,7-28.8,18l-64.3,132.3L27.3,171.5c-12,1.8-22,10.2-25.7,21.7s-0.7,24.2,7.9,32.7
                L113.7,329L89.1,474.7c-2,12,3,24.2,12.9,31.3s23,8,33.8,2.3l128.3-68.5l128.3,68.5c10.8,5.7,23.9,4.9,33.8-2.3s14.9-19.3,12.9-31.3
                L414.4,329l104.2-103.1c8.6-8.5,11.7-21.2,7.9-32.7s-13.7-19.9-25.7-21.7l-143.7-21.2L292.8,18z"/>
                </svg>`,
                // halfStar: true,
                onChange: function (rating, rateYoInstance) {

                    jQuery('#rating').val(rating);
                }
            });
        </script>
<script>
    function showToast(message, type = 'warning') {
        // Create the toast container if it doesn't exist
        let toastContainer = document.querySelector('.toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
            document.body.appendChild(toastContainer);
        }

        // Create the toast element
        const toastElement = document.createElement('div');
        toastElement.className = `toast align-items-center text-bg-${type} border-0`;
        toastElement.setAttribute('role', 'alert');
        toastElement.setAttribute('aria-live', 'assertive');
        toastElement.setAttribute('aria-atomic', 'true');

        // Create the toast content
        const toastContent = `
            <div class="d-flex">
                <div class="toast-body">
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        `;
        toastElement.innerHTML = toastContent;

        // Append the toast element to the container
        toastContainer.appendChild(toastElement);

        // Initialize and show the toast
        const toast = new bootstrap.Toast(toastElement);
        toast.show();

        // Automatically remove the toast element after it's hidden
        toastElement.addEventListener('hidden.bs.toast', () => {
            toastElement.remove();
        });
    }
     @if($cartItem['service_id'] == 10)
    const slotId = "{{ $cartItem['session_time']}}";
    @else
    const slotId = "{{ $cartItem['slot_id']}}";
    @endif
    const selected_date = "{{ $selected_date}}";
    
    document.addEventListener("DOMContentLoaded", function() {
        // Select all session cards
        const sessionCards = document.querySelectorAll(".session-card");

        sessionCards.forEach(card => {
            card.addEventListener("click", function() {
                const sessionNumber = this.getAttribute("data-session-number"); // Get session name
                const sessionId = this.getAttribute("data-session-id"); // Get session ID

                // Update modal title
                // document.getElementById("modal-text").textContent = sessionNumber;

                // Clear previous staff list and show loading
                const staffListContainer = document.getElementById("staff-list");
                staffListContainer.innerHTML = '<p class="text-muted">Loading staff details...</p>';

                // Fetch staff details for the selected session
                fetch(`/get-session-staff/${sessionId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            let staffHtml = '<ul class="list-group">';
                            data.staff.forEach(staff => {
                                let statusText;
                                switch (staff.status) {
                                    case 'Accept':
                                        statusText = 'Accepted';
                                        break;
                                    case 'Mark As Arrived':
                                        statusText = 'En route to work';
                                        break;
                                    default:
                                        statusText = staff.status; // Retain the original status if no match
                                }

                                staffHtml += `<li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>${staff.name}</span>
                                                <span>${staff.phone}</span>
                                                <span class="badge  bg-secondary">${statusText}</span>
                                            </li>`;


                            });
                            staffHtml += '</ul>';
                            staffListContainer.innerHTML = staffHtml;
                        } else {
                            staffListContainer.innerHTML = `<p class="text-danger">${data.message}</p>`;
                        }
                    })
                    .catch(error => {
                        console.error("Error fetching staff data:", error);
                        staffListContainer.innerHTML = `<p class="text-danger">Error fetching staff details.</p>`;
                    });
            });
        });

        // Back button functionality
        document.getElementById("backToSessionHistory").addEventListener("click", function() {
            // Close assign_staff modal
            let assignStaffModal = bootstrap.Modal.getInstance(document.getElementById("assign_staff"));
            assignStaffModal.hide();

            // Show sessionhistory modal
            setTimeout(() => {
                let sessionHistoryModal = new bootstrap.Modal(document.getElementById("sessionhistory"));
                sessionHistoryModal.show();
            }, 500); // Delay to allow smooth transition
        });
    });


   
    document.addEventListener("DOMContentLoaded", function () {
        let currentCartIdForCancel = null;

        // Attach cart ID to cancel modal when Modify button is clicked
        document.querySelectorAll('[data-bs-target="#modifyModal"]').forEach(modifyBtn => {
            modifyBtn.addEventListener("click", function () {
                const cartId = this.getAttribute("data-cart-id");
                document.querySelector('#cancelModal #confirmCancelButton').setAttribute('data-cart-id', cartId);
            });
        });

        // Handle cancel confirmation
        document.getElementById('confirmCancelButton').addEventListener('click', function () {
            currentCartIdForCancel = this.getAttribute('data-cart-id');
            if (!currentCartIdForCancel) {
                alert('Invalid booking ID.');
                return;
            }
            const currentURL = window.location.href;
            const baseURL = currentURL.split('/booking-detail')[0] + '/';
            fetch(`${baseURL}booking/cancel`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    booking_id: currentCartIdForCancel
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Your booking has been successfully canceled.');
                    location.reload();
                } else {
                    alert('Failed to cancel the booking: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while processing your request.');
            });
        });
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    jQuery.noConflict();
    function handleReorder(cardId) {
       
        console.log("Button clicked, Card ID:", cardId);

        if (!cardId) {
            alert('Card ID not found.');
            return;
        }

        fetch('{{ url("reorder") }}/' + cardId, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            console.log("Server response:", data);
            if (data.success) {
                alert('Reorder successful!');
            } else {
                alert('Reorder failed: ' + data.message);
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert('An error occurred while processing your request.');
        });
    }

    document.addEventListener("DOMContentLoaded", function () {
        const rescheduleButton = document.getElementById("rescheduleButton");
        const scheduleModalId = document.getElementById("disclaimerModalId");
        const scheduleModal = document.getElementById("scheduleButton");
        const datePickerschedule = document.getElementById("date-picker-schedule");
        const datePicker = document.getElementById("date-picker");
        const slotsListschedule = document.getElementById("time-slots-list-schedule");
        const slotsList = document.getElementById("time-slots-list");
        const proceedButton = document.getElementById("proceedButton");
        let currentCartId = null;
        let currentCartDate = null;
        let currentCartSlot = null;
        let serviceId = null;

        document.querySelectorAll('[data-bs-target="#modifyModal"]').forEach(modifyBtn => {
            modifyBtn.addEventListener("click", function () {
                const serviceIds = this.getAttribute("data-service-id");
                rescheduleButton.setAttribute("data-service-id", serviceIds);

                const cartId = this.getAttribute("data-cart-id");
                rescheduleButton.setAttribute("data-cart-id", cartId);
                
                const cartDate = this.getAttribute("data-cart-date");
                rescheduleButton.setAttribute("data-cart-date", cartDate);
                
                const cartSlot = this.getAttribute("data-cart-slot");
                rescheduleButton.setAttribute("data-cart-slot", cartSlot);
            });
        });

        scheduleModal.addEventListener("click", function () {
            serviceId = this.getAttribute("data-service-id");
            currentCartId = this.getAttribute("data-cart-id");
            currentCartDate = this.getAttribute("data-cart-date");
            currentCartSlot = this.getAttribute("data-cart-slot");
            console.log('scheduleModal: '+currentCartId+" " +serviceId+" "+currentCartDate+" "+currentCartSlot);

            fetchTimeSlots(currentCartDate, currentCartSlot);
        });
        

        rescheduleButton.addEventListener("click", function () {
            serviceId = this.getAttribute("data-service-id");
            currentCartId = this.getAttribute("data-cart-id");
            currentCartDate = this.getAttribute("data-cart-date");
            currentCartSlot = this.getAttribute("data-cart-slot");

            fetchTimeSlots(currentCartDate, currentCartSlot);
        });

        scheduleButton.addEventListener("click", function () {
            serviceId = this.getAttribute("data-service-id");
            currentCartId = this.getAttribute("data-cart-id");
            currentCartDate = this.getAttribute("data-cart-date");
            currentCartSlot = this.getAttribute("data-cart-slot");
            
            fetchTimeSlots(currentCartDate, currentCartSlot);
        });

        function getTodayDate() {
            const today = new Date();
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, '0');
            const day = String(today.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        const today = getTodayDate();
        datePicker.value = selected_date;
        datePicker.min = today;
        datePickerschedule.value = today;
        datePickerschedule.min = today;

        function fetchTimeSlots(date, preselectedSlot = null) {

            fetch("{{ route('slots_list') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ date: date, service_id: serviceId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "1") {
    const slotsData = data.data;
                  
   // datePicker.value = date;
    datePicker.min = getTodayDate(); 
    datePickerschedule.value = date;
    datePickerschedule.min = getTodayDate(); 

    // Populate slotsList
    slotsList.innerHTML = ''; 
    slotsData.forEach(slot => {
        if (slot.available && !slot.is_past_slot) {
            const listItem = document.createElement("li");
            listItem.className = 'col-6 mb-4';
            listItem.innerHTML = `
                <label class="control w-100" for="time_slotsList_${slot.slot_id}">
                    <input type="radio" name="time" id="time_slotsList_${slot.slot_id}" value="${slot.slot_id}" ${slot.slot_id === preselectedSlot ? 'checked' : ''}>
                    <span class="control__content fs-14 text-center w-100 justify-content-center">
                        ${slot.slot_name}
                    </span>
                </label>
            `;
            slotsList.appendChild(listItem);
        }
    });

    // Populate slotsListschedule
    slotsListschedule.innerHTML = ''; 
    slotsData.forEach(slot => {
        if (slot.available && !slot.is_past_slot) {
            const listItem = document.createElement("li");
            listItem.className = 'col-6 mb-4';
            listItem.innerHTML = `
                <label class="control w-100" for="time_slotsListschedule_${slot.slot_id}">
                    <input type="radio" name="time_schedule" id="time_slotsListschedule_${slot.slot_id}" value="${slot.slot_id}" ${slot.slot_id === preselectedSlot ? 'checked' : ''}>
                    <span class="control__content fs-14 text-center w-100 justify-content-center">
                        ${slot.slot_name}
                    </span>
                </label>
            `;
            slotsListschedule.appendChild(listItem);
        }
    });
    const targetDiv = document.getElementById('time_slotsList_'+slotId);
                   // alert('time_slotsList_'+slotId);
                    targetDiv.click();
}

            })
            .catch(error => console.error("Error fetching time slots:", error));
        }

        fetchTimeSlots(today); 
        datePicker.addEventListener("change", function () {
            const selectedDate = this.value;
            fetchTimeSlots(selectedDate);
        });
        datePickerschedule.addEventListener("change", function () {
            const selectedDate = this.value;
            fetchTimeSlots(selectedDate);
        });

        proceedButton.addEventListener("click", function () {
            const selectedSlot = document.querySelector('input[name="time"]:checked');
            if (!selectedSlot) {
                alert('Please select a time slot.');
                return;
            }

            fetch("{{ route('reschedule') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    date: datePicker.value,
                    slot_id: selectedSlot.value,
                    card_id: currentCartId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    console.log('Reschedule successful!');
                    location.reload();
                } else {
                    alert('Failed to reschedule: ' + data.message);
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert('An error occurred while processing your request.');
            });
        });

        
        scheduleProceedButton.addEventListener("click", function () {
            const selectedSlot = document.querySelector('input[name="time_schedule"]:checked');
            if (!slotsListschedule) {
                alert('Please select a time slot.');
                return;
            }
            console.log('revisit: '+currentCartId);
            fetch("{{ route('revisit') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    date: datePickerschedule.value,
                    slot_id: selectedSlot.value,
                    old_booking_id: currentCartId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    console.log('Revisit successful!');
                    location.reload();
                } else {
                    alert('Failed to reschedule: ' + data.message);
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert('An error occurred while processing your request.');
            });
        });
    });

</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const dateInput = document.getElementById('date-picker-schedule');

        dateInput.addEventListener('change', function () {
            // Get the selected date value
            const selectedDate = new Date(dateInput.value);

            // Format the date to dd/mm/yyyy
            const formattedDate = selectedDate.toLocaleDateString('en-GB', {
                day: '2-digit',
                month: '2-digit',
                year: 'numeric'
            });

            // Display the formatted date in the input field
            dateInput.value = formattedDate;
        });
    });
</script>


@endsection
