@extends('layouts.dashboard')

@section('content')

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">Edit Vendor</h3>

                        </div>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            <div class="card-body">

                            <form action="{{ route('vendor.update', $value->id) }}" method="POST">
                                <div class="modal-body text-left">
                                    <div class="row">
                                    @csrf

                                    <div class="form-group col-lg-6">
                                        <label class="text-dark">Full Name<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="name" value="{{ $value->name }}" required>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="text-dark">Email<span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" name="email" value="{{ $value->email }}" required>
                                    </div>

                                    <!-- Include CSS for intl-tel-input (v24.6.0) -->
                                    <link rel="stylesheet" 
                                    href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
                                    integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
                                    crossorigin="anonymous" referrerpolicy="no-referrer" />

                                    <div class="form-group mobile-number-dailcode col-lg-6">
                                        <label class="text-dark">Phone<span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <!-- Dial Code Input with Flag -->
                                            <div class="input-group-prepend">
                                                <input type="hidden" name="dial_code" id="dial-code" 
                                                    class="form-control" value="+{{ ltrim($value->dial_code ?? '971', '+') }}" 
                                                    required style="width:120px; text-align: center;">
                                            </div>

                                            <!-- Phone Number Input -->
                                            <input type="tel" id="phone-number" class="form-control" 
                                                name="phone" value="{{ $value->phone }}" oninput="validateInput(event)"
                                                placeholder="Enter phone number" pattern="[0-9]*" inputmode="numeric" required>
                                        </div>
                                    </div>

                                    <!-- Include JS for intl-tel-input (v24.6.0) -->
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
                                            integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
                                            crossorigin="anonymous" referrerpolicy="no-referrer"></script>

                                    <script>
                                        // Initialize intl-tel-input within an IIFE to avoid redeclaration errors
                                        (function() {
                                            const dialCodeInput = document.querySelector("#dial-code");

                                            const iti = intlTelInput(dialCodeInput, {
                                                initialCountry: "AE",            // Automatically detect the user's country
                                                separateDialCode: true,            // Display only the dial code in the input
                                                autoPlaceholder: "polite",         // Use a smart placeholder
                                                // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js", // Required for formatting
                                            });

                                            // Handle the country change event (optional)
                                            dialCodeInput.addEventListener("countrychange", function() {
                                                const countryData = iti.getSelectedCountryData();
                                                console.log(`Selected country: ${countryData.name}, Dial Code: ${countryData.dialCode}`);
                                            });
                                        })();
                                    </script>
                                    <script>
                                        function validateInput(event) {
                                            const input = event.target;
                                            input.value = input.value.replace(/[^0-9]/g, '');
                                        }
                                    </script>

                                    <div class="form-group col-lg-6">
                                        <label class="text-dark">Service<span class="text-danger">*</span></label>
                                        <select class="form-control select2-new" id="service-select" name="service_id[]" data-placeholder="Select Service" multiple required>
                                            <option value=""></option>
                                            @foreach($service as $ser)
                                                <option 
                                                    data-category="{{ $seller ? optional(\App\SellerService::where(['seller_id' => $seller->id, 'service_id' => $ser->id])->first())->commission ?? $ser->category->commission : $ser->category->commission }}" 
                                                    value="{{ $ser->id }}" 
                                                    {{ in_array($ser->id, $seller_service_id) ? 'selected' : '' }}>
                                                    {{ $ser->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="seller_id" value="{{ $seller ? $seller->id : '' }}">
                                    </div>
                                    </div>
                                    <div id="selected-services" class="mt-3 row"></div>

                                    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
                                    <script>
                                        $(document).ready(function () {
                                            // Initialize select2
                                            $('#service-select').select2();

                                            const selectedServicesContainer = document.getElementById('selected-services');
                                            const selectedServices = new Set(); // Track already added services to prevent duplicates

                                            // Function to append service and commission fields
                                            function appendService(serviceId, serviceName, commissionValue = '') {
                                                if (!selectedServices.has(serviceId)) {
                                                    // Append the selected service and commission field
                                                    const serviceElement = document.createElement('div');
                                                    serviceElement.classList.add('form-group', 'col-lg-4', 'col-md-6');
                                                    serviceElement.innerHTML = `

                                                            <label class="text-dark">${serviceName}</label>
                                                            <input type="hidden" name="services[${serviceId}][id]" value="${serviceId}">
                                                            <input type="number" class="form-control" name="services[${serviceId}][commission]" placeholder="Enter Commission %" value="${commissionValue}" required>
                                                        
                                                    `;
                                                    selectedServicesContainer.appendChild(serviceElement);
                                                    selectedServices.add(serviceId);
                                                }
                                            }

                                            // Pre-load selected services
                                            $('#service-select option:selected').each(function () {
                                                const serviceId = $(this).val();
                                                const serviceName = $(this).text();
                                                const defaultCommission = $(this).data('category') || '';
                                                appendService(serviceId, serviceName, defaultCommission);
                                            });

                                            // Handle selection changes
                                            $('#service-select').on('select2:select', function (e) {
                                                const serviceId = e.params.data.id;
                                                const serviceName = e.params.data.text;

                                                // Access the original option element to get the commission value
                                                const optionElement = $(`#service-select option[value="${serviceId}"]`);
                                                const commission = optionElement.data('category') || '';

                                                appendService(serviceId, serviceName, commission);
                                            });

                                            // Handle deselect event
                                            $('#service-select').on('select2:unselect', function (e) {
                                                const serviceId = e.params.data.id;

                                                // Remove the corresponding service element
                                                $(`#selected-services .remove-service[data-id="${serviceId}"]`).closest('.form-group').remove();
                                                selectedServices.delete(serviceId);
                                            });

                                            // Event delegation for remove buttons
                                            $(document).on('click', '.remove-service', function () {
                                                const serviceId = $(this).data('id');

                                                // Remove from select2 and delete from container
                                                const selectedOptions = $('#service-select').val();
                                                $('#service-select').val(selectedOptions.filter(id => id !== serviceId)).trigger('change');
                                                $(`#selected-services .remove-service[data-id="${serviceId}"]`).closest('.form-group').remove();
                                                selectedServices.delete(serviceId);
                                            });
                                        });
                                    </script>

                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label class="text-dark">Emirate<span class="text-danger">*</span></label>
                                        <select class="form-control select2" name="city_id" id="city-select" required>
                                            <option value="">Select Emirate</option>
                                            @foreach($cities as $city)
                                                <option value="{{ $city->id }}" 
                                                    {{ $seller && $seller->city == $city->id ? 'selected' : '' }}>
                                                    {{ $city->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="text-dark">Area<span class="text-danger">*</span></label>
                                        <select class="form-control select2" name="locality_id" id="locality-select" required>
                                            <option value="">Select Area</option>
                                            @foreach($localities as $locality)
                                                <option value="{{ $locality->id }}" 
                                                    {{ $seller && $seller->locality == $locality->id ? 'selected' : '' }}>
                                                    {{ $locality->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>
                                </div>

                                <div class="text-right">
                                    <button type="submit" class="btn btn-success bg-grad-4">Update</button>
                                </div>
                            </form>

                            <script>
                                // Handle dynamic locality loading when the city is changed
                                document.getElementById('city-select').addEventListener('change', function () {
                                    const cityId = this.value;
                                    const localitySelect = document.getElementById('locality-select');

                                    // Clear existing localities
                                    localitySelect.innerHTML = '<option value="">Select Locality</option>';

                                    if (cityId) {
                                        const baseURL = document.querySelector('meta[name="base-url"]').getAttribute('content');

                                        fetch(`${baseURL}/localities/${cityId}`)
                                            .then(response => response.json())
                                            .then(data => {
                                                data.forEach(locality => {
                                                    const option = new Option(locality.name, locality.id);
                                                    localitySelect.add(option);
                                                });
                                            })
                                            .catch(error => console.error('Error fetching localities:', error));
                                    }
                                });
                            </script>


                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->


@endsection      



       