@extends('layouts.dashboard')

@section('content')
<div class="content-body">
<div class="container-fluid">
    <div class="card shadow-sm mt-4">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0">Package Details</h3>
            <a href="{{ route('packages') }}" class="btn btn-light btn-sm">Back to Packages</a>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Package Details -->
                <div class="col-md-6">
                    <h5 class="text-primary">Package Information</h5>
                    <table class="table table-bordered">
                        <tr>
                            <td><strong>Package Name:</strong></td>
                            <td>{{ $package->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Amount:</strong></td>
                            <td>{{ number_format($package->amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Save Amount:</strong></td>
                            <td>{{ number_format($package->save_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Total Sessions:</strong></td>
                            <td>{{ $package->total_sessions }}</td>
                        </tr>
                        <tr>
                            <td><strong>Free Sessions:</strong></td>
                            <td>{{ $package->free_sessions }}</td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $package->description }}</td>
                        </tr>
                    </table>
                </div>

                <!-- Days Information -->
                <div class="col-md-6">
                    <h5 class="text-primary">Available Days</h5>
                    <ul class="list-group">
                        @if($package->days && count($package->days) > 0)
                            @foreach($package->days as $day)
                                <li class="list-group-item">{{ $day }}</li>
                            @endforeach
                        @else
                            <li class="list-group-item">No days selected.</li>
                        @endif
                    </ul>
                </div>
            </div>

        </div>
    </div>
</div>
</div>
@endsection
