@extends('layouts.dashboard')

@section('content')
<div class="content-body">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <h3 class="ml-1">Edit Emirates</h3>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end d-flex">
            <a href="{{ route('localities.index') }}" class="btn btn-rounded bg-grad-4 ml-4">Back</a>
        </div>
    </div>

    <div class="container-fluid">
        @include('flash_msg')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('locality.update', $locality->id) }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label>Locality Name</label>
                                <input type="text" name="name" value="{{ $locality->name }}" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label>Emirate</label>
                                <select name="city_id" class="form-control" required>
                                    <option value="">Select Emirate</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->id }}" {{ $locality->city_id == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <button type="submit" class="btn btn-success">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
