<!-- Maid Service Second Option -->
<label>Choose Maids</label>
<select name="attribute_id" id="attribute_id" class="form-control" onchange="handleAttributeChange(this)">
    <option value="">Select Attribute</option>
    @foreach(App\ServiceAttributeValue::where('ser_attr_val_item_id', $serviceItem->id)->get() as $key => $attributeItems)
        @if($attributeItems->attributeItem)
        <option 
            value="{{ $attributeItems->id }}" 
            data-attribute='{{ json_encode($attributeItems) }}' 
           > <!-- Mark the first item as selected -->
            {{$attributeItems->attributeItem->value}} (AED {{$attributeItems->attribute_price}})
        </option>
        @endif
    @endforeach
</select>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const dropdown = document.getElementById('attribute_id');

        // Automatically trigger the first item's change event if it exists
        if (dropdown.options.length > 1) {
            dropdown.dispatchEvent(new Event('change'));
        }
    });

    // Handle dropdown change
    function handleAttributeChange(selectElement) {
        const selectedOption = selectElement.options[selectElement.selectedIndex];

        // Parse the data-attribute JSON for the selected option
        const attributeData = selectedOption.dataset.attribute 
            ? JSON.parse(selectedOption.dataset.attribute) 
            : null;

        if (attributeData) {
            calculateMaterial(attributeData);
        }
    }
</script>

<input type="hidden" name="service" value="maid">
