@extends('layouts.dashboard')

@section('content')
<div class="content-body">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <h3 class="ml-1">Emirates</h3>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <a href="{{ route('city.create') }}">
                <button type="button" class="btn btn-rounded bg-grad-4 ml-4">
                    <span class="btn-icon-left text-primary">
                        <i class="fa fa-plus color-primary"></i> 
                    </span>
                    Add Emirate
                </button>
            </a>
        </div>
    </div>

    <div class="container-fluid">
        @include('flash_msg')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($cities as $key => $city)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $city->name }}</td>
                                            <td class="text-right">
                                                <a href="{{ route('city.edit', $city->id) }}">
                                                    <button type="button" class="btn btn-outline-primary btn-sm" title="Edit">
                                                        <i class="fa fa-pencil" aria-hidden="true"></i>
                                                    </button>
                                                </a>
                                                <a href="{{ route('city.delete', $city->id) }}" onclick="return confirm('Are you sure?')">
                                                    <button type="button" class="btn btn-outline-primary btn-sm" title="Delete">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </a>
                                                <a href="{{ url('localities/info/' . $city->id) }}">
                                                    <button type="button" class="btn btn-outline-secondary btn-sm" title="View Localities">
                                                        <i class="fa fa-map-marker" aria-hidden="true"></i> Localities
                                                    </button>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('#example').DataTable({
                dom: 'Bfrtip',
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
            });
        });
    </script>  
@endsection 
