@extends('layouts.dashboard')
<!-- <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.2.0/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet"> -->
@section('content')
<style>
    .dt-buttons {
            display: none;
    }
    tfoot input {
        width: 100%;
        padding: 3px;
        box-sizing: border-box;
    }

    .card-card-body {
    padding: 0rem .25rem !important;
        }

        table.dataTable tbody td {
    padding: 5px !important;
    line-height: 24px !important;
    font-size: 13px !important;
        }

    #action-buttons-booking .btn{
        margin: 2px 4px !important;
    }

    .pd-1 {
        padding: 2% !important;
    }

    .mr-5 {
        margin-right: 5px !important;
        margin-top: 5px !important;
    }

    #posts_filter {
        display: none;
    }
    .dataTables_scrollHeadInner,
    .dataTable{
        margin: 0 !important;
        width: 100%  !important;
    }
    .nk-sidebar .metismenu > li > a{
        text-decoration: none;
    }
    .color-primary {
        color: #ff9100 !important;
    }
    .bg-grad-4{
        color: white;
    }
    .btn-primary{
        border-color: #ffb72c;
    }
    .select2-dropdown {
        z-index: 1060 !important;  /* Higher than the modal itself (usually 1050) */
    }
</style>
<!-- DataTables Buttons CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">Bookings</h3>

                        </div>

                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                      
                        <a href="{{ route('draft.bookings') }}">

                            <button type="button" class="btn btn-rounded bg-grad-4 ml-4 text-white">

                                <span class="btn-icon-left text-primary">

                                    <i class="fa fa-list color-primary"></i> 

                                </span>
                                Draft Bookings

                            </button>

                        </a>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-12">

                        <div class="card">
                            
                            <div class="card-body">

                                <form action="{{ route('bookings.search') }}" method="Get">
                                    
                                    <div class="row">
                                    
                                        <div class="col-lg-3 form-group">

                                            <label>Booking ID</label>
                                            
                                            <input type="text" name="booking_id" class="form-control" placeholder="Search By Booking ID">

                                        </div>
                                        <div class="col-lg-3 form-group">

                                            <label>Payment Transaction ID</label>
                                            
                                            <input type="text" name="payment_id" class="form-control" value="" placeholder="Search By payment Transaction ID">

                                        </div>

                                        <!-- <div class="col-lg-3 form-group">

                                            <label>Slot Date</label>
                                            
                                            <input type="date" name="slot_date" class="form-control" placeholder="Search By Slot Date">

                                        </div> -->

                                        <div class="col-lg-3 form-group">
                                            <label>From Date</label>
                                            <input type="date" name="from_date" id="from_date" class="form-control" placeholder="From Date">
                                        </div>
                                        <div class="col-lg-3 form-group">
                                            <label>To Date</label>
                                            <input type="date" name="to_date" id="to_date" class="form-control" placeholder="To Date">
                                        </div>

                                        <script>
                                            document.addEventListener('DOMContentLoaded', function () {
                                                // Add event listeners for date validation
                                                const fromDateInput = document.getElementById('from_date');
                                                const toDateInput = document.getElementById('to_date');

                                                fromDateInput.addEventListener('change', function () {
                                                    // Ensure `to_date` is greater than or equal to `from_date`
                                                    if (toDateInput.value && new Date(toDateInput.value) < new Date(this.value)) {
                                                        alert("To Date cannot be earlier than From Date");
                                                        toDateInput.value = ""; // Clear the `to_date` field
                                                    }
                                                    toDateInput.min = this.value; // Set `to_date` minimum to `from_date`
                                                });

                                                toDateInput.addEventListener('change', function () {
                                                    // Ensure `to_date` is greater than or equal to `from_date`
                                                    if (fromDateInput.value && new Date(this.value) < new Date(fromDateInput.value)) {
                                                        alert("To Date cannot be earlier than From Date");
                                                        this.value = ""; // Clear the `to_date` field
                                                    }
                                                });
                                            });
                                        </script>



                                        <div class="col-lg-3 form-group">

                                            <label>Vendor Company</label>

                                            <select class="form-control vendor_name" name="vendor_name">
                                                <option value="">Select Company</option>
                                                
                                                @foreach($vendors_list as $vendor)
                                                <option value="{{$vendor->seller?$vendor->seller->company_name:'No Company'}}"> {{$vendor->seller?$vendor->seller->company_name:'No Company'}}</option>
                                                @endforeach
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Customer Name</label>
                                            <select class="form-control customer_name" name="customer_name">
                                                <option value="">Select Customer</option>
                                                @foreach($customers as $vendor)
                                                <option value="{{$vendor->name?$vendor->name:'No Company'}}"> {{$vendor->name?$vendor->name:'No Company'}}</option>
                                                @endforeach
                                            </select>
                                            
                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Customer Mobile No.</label>
                                            
                                            <input type="number" name="customer_number" min="0" id="customer-number" class="form-control" placeholder="Search By Customer Mobile Number">

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Service Name</label>
                                            
                                            <input type="text" name="service_name" class="form-control" placeholder="Search By Service Name">

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Service Status</label>
                                            
                                            <select class="form-control" name="service_status">
                                                <option value="">Select Service Status</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Accept">Accept</option>
                                                <option value="In Progress">In Progress</option>
                                                <option value="Mark As Arrived">Mark As Arrived</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Canceled">Canceled</option>
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Payment Mode</label>
                                            
                                            <select class="form-control" name="payment_mode">
                                                <option value="">Select Payment Mode</option>
                                                <option value="2">Cash</option>
                                                <option value="1">Card</option>
                                                <option value="3">Wallet</option>
                                                <option value="5">Reward Points</option>
                                                <option value="6">Apple Pay</option>
                                                <option value="4">Tabby</option>
                                                
                                                
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Payment Status</label>
                                            
                                            <select class="form-control" name="payment_status">
                                                <option value="">Select Payment Status</option>
                                                <option value="True">True</option>
                                                <option value="False">False</option>
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Pending Approval</label>
                                            
                                            <select class="form-control" name="pending_approval">
                                                <option value="">Select Pending Approval</option>
                                                <option value="Approved">Not Approved</option>
                                                <option value="Not Approved">Approved</option>
                                            </select>

                                        </div>

                                        <!-- <div class="col-lg-3 form-group">

                                            <label>Payment ID</label>
                                            
                                            <input type="text" name="payment_id" class="form-control" placeholder="Search By Payment ID">

                                        </div> -->

                                        <div class="col-lg-5 form-group mt-4">
                                            <button class="btn btn-primary mt-1" style="border-color: #ffb72c;" type="submit">Search</button>
                                            <button class="btn btn-danger mt-1" type="reset">Clear</button>
                                            <button id="exportButton" class="btn btn-secondary mt-1" type="button">Export</button>
                                        </div>

                                    </div>

                                </form>
                                
                            </div>

                        </div>

                        <div class="card pd-1">

                            <div class="card-body card-card-body">                                

                                <div class="table-responsive">

                                    <table id="posts" class="table table-striped" >

                                        <thead>

                                            <tr>

                                                <th>#</th>

                                                <th>Booking ID/Trans ID</th>
                                                <th>Slot ID</th>
                                                <th>Slot Date </th>
                                                <th>Slot Time </th>
                                                
                                                <th>Company<br> Name</th>

                                                <th style="width: 65px;">Customer<br> Name</th>

                                                <th>Service<br> Name</th>

                                                <th>Booking<br> Price</th>

                                                <th>Service <br>Status</th>

                                                <th>Payment <br>Type / Collect</th>

                                                <th>Payment <br>Status</th>

                                                <th class="text-center">Action</th>

                                            </tr>

                                        </thead>

                                    </table>

                                </div>                          

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->

        <!-- Modal -->
        <div class="modal fade" id="payPayment" tabindex="-1" role="dialog" aria-labelledby="payPaymentLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="payPaymentLabel">Update Payment</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('update.live.payment') }}" method="POST">
                    @csrf
                        <div class="modal-body">
                            <input type="hidden" name="booking_id" class="booking_id">
                            <div class="form-group">
                                <label for="">Payment Mode</label>
                                <select name="payment_moad" class="form-control payment_moad" required>
                                    <option value="">Select Payment Mode</option>
                                    <option value="2">Cash</option>
                                    <option value="1">Card</option>
                                    <option value="3">Wallet</option>
                                    <option value="5">Reward Points</option>
                                    <option value="6">Apple Pay</option>
                                    <option value="4">Tabby</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="">Payment Transaction ID </label>
                                <input type="text" name="tran_id" class="form-control tran_id" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Change Company</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('change.vendor') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="booking_id" class="booking_id">
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-lg-12">
                                    <select class="form-control vendor_id" name="vendor_id">
                                        <option value="">Select Company</option>
                                        @foreach($vendors_list as $vendor)
                                        <option value="{{$vendor->id}}"> {{$vendor->seller?$vendor->seller->company_name:'No Company'}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Change</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Password Verification Modal -->
<div class="modal fade" id="passwordModal" tabindex="-1" role="dialog" aria-labelledby="passwordModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordModalLabel">Enter Password</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="passwordForm">
                    <div class="form-group">
                        <label for="userPassword">Password</label>
                        <input type="password" class="form-control" id="userPassword" name="password" required>
                    </div>
                    <input type="hidden" id="actionUrl" name="actionUrl">
                </form>
                <div id="errorMessage" class="text-danger" style="display: none;">Incorrect password. Please try again.</div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="confirmAction">Confirm</button>
            </div>
        </div>
    </div>
</div>


@endsection 

  
@section('script')


<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>

    <script>
    

$(document).ready(function () {
   
   
    $('select').each(function () {
        var placeholder = $(this).data('placeholder') || "Select an option";
        $(this).select2({
            placeholder: placeholder,
            allowClear: true
        });
    });
    
    document.getElementById("customer-number").addEventListener("input", function (e) {
        if (e.target.value < 0) {
            e.target.value = ""; // Clear the input if negative value is entered
        }
    });

    let actionUrl = '';

    // Open modal on button click
    $(document).on('click', '.action-btn', function (e) {
        e.preventDefault();
        actionUrl = $(this).data('url'); // Get the action URL
        $('#actionUrl').val(actionUrl); // Store it in the modal
        $('#passwordModal').modal('show');
    });

    // Handle password verification
    $('#confirmAction').click(function () {
        const password = $('#userPassword').val();
        const url = $('#actionUrl').val();

        if (!password) {
            $('#errorMessage').text('Password is required.').show();
            return;
        }

        $.ajax({
            url: '{{ route("verify.password") }}', // Route for password verification
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: { password: password },
            success: function (response) {
                if (response.success) {
                    // Password verified, redirect to the action URL
                    window.location.href = url;
                } else {
                    $('#errorMessage').text('Incorrect password. Please try again.').show();
                }
            },
            error: function () {
                $('#errorMessage').text('An error occurred. Please try again.').show();
            }
        });
    });
});

        
        $(document).ready(function () {
            var table = $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
            "scrollX": true,
            "pageLength": 25,
            "searching": true,
            "destroy": true, // Ensures re-initialization without duplication
            "ajax": {
                "url": "{{ route('get.bookings') }}",
                "dataType": "json",
                "type": "POST",
                "data": { _token: "{{csrf_token()}}" }
            },
            "columns": [
                { "data": "No" },
                { "data": "BookingId" },
                { "data": "SlotId" },
                { "data": "SlotDate" },
                { "data": "SlotTime" },
                { "data": "CompanyName" },
                { "data": "CustomerName" },
                { "data": "ServiceName" },
                { "data": "BookingPrice" },
                { "data": "ServiceStatus" },
                { "data": "PaymentType" },
                { "data": "PaymentStatus" },
                { "data": "options" }
            ],
            "order": [[0, "desc"]],
            "dom": 'Bfrtip',
            "buttons": [
                {
                    extend: 'csv',
                    className: 'btn btn-primary',
                    text: 'Export CSV'
                }
            ]
        });

            // Trigger DataTable export functionality when the custom Export button is clicked
            $('#exportButton').on('click', function () {
                table.button('.buttons-csv').trigger(); // Trigger CSV export
            });
        });
    </script>

    <script>
        function payPayment(params) {
            $('.booking_id').val(params.id);
            // $('.payment_moad').val(params.payment_moad);
            // $('.tran_id').val(params.paymentLinkId);
        }
    </script>

    <script>
        function changeVendor(params) {
            $('.booking_id').val(params.id);
            $('.vendor_id').val(params.accept_user_id);
        }
    </script>
    <script>
    $('.vendor_name').select2({
        dropdownParent: $('#exampleModal')
    });
</script>
@endsection         