<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterAddFieldsToOfflineBookings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('offline_bookings', function (Blueprint $table) {
            //
            $table->double("off_sub_total")->default(0);
            $table->double("off_grand_total")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('offline_bookings', function (Blueprint $table) {
            //
            $table->dropColumn("off_sub_total");
            $table->dropColumn("off_grand_total");
        });
    }
}
