<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id(); 
            $table->string('name', 100)
                  ->nullable()
                  ->collation('utf8mb3_unicode_ci'); 
            $table->string('email', 100)
                ->nullable()
                ->collation('utf8mb3_unicode_ci'); 
            $table->string('message', 255)
                ->nullable()
                ->collation('utf8mb3_unicode_ci'); 
            $table->timestamp('created_at')
                  ->useCurrent(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contacts');
    }
}
