<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class VendorCardStatus extends Model
{

    protected $table = 'vendor_card_status';

    protected $fillable = [
        'vendor_id',
        'card_id',
        'status',
    ];


    /**
     * Relationship to the Card model.
     */
    public function card()
    {
        return $this->belongsTo(Card::class, 'card_id');
    }

    /**
     * Relationship to the User model.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'vendor_id', 'id');
    }
}
