<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Packages extends Model
{
    protected $fillable = [
        'status', 'name', 'amount','description','service_id', 'price_currency', 'save_amount', 'total_sessions', 'free_sessions', 'days', 'per_week'
    ];

    protected $casts = [
        'days' => 'array',
    ];
    
     /**
     * Get the vendor data.
     */
    public function service()
    {
        return $this->belongsTo(Service::class);
    }
    
    public function toArray()
    {
        return $this->castToStrings(parent::toArray());
    }

    protected function castToStrings($array)
    {
        $result = [];
        foreach ($array as $key => $value) {
            $key = (string) $key; // Convert key to string
            if (is_array($value) || is_object($value)) {
                $result[$key] = $this->castToStrings((array) $value); // Recursive conversion
            } elseif (is_scalar($value)) {
                $result[$key] = (string) $value; // Convert scalar value to string
            } else {
                $result[$key] = json_encode($value); // Handle other cases (e.g., NULL)
            }
        }
        return $result;
    }
}
