<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Locality extends Model
{
    protected $guarded = [];
    public $timestamps = false; 

    public function sellers()
    {
        return $this->hasMany(Seller::class, 'locality_id'); 
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id'); // Define relationship to City
    }
}