<?php
namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Traits\FirebaseTrait; // Assuming you have a Firebase trait for handling notifications

class SendNotificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $deviceTokens;
    protected $firebaseUserKey;
    protected $title;
    protected $body;
    protected $cardId;

    /**
     * Create a new job instance.
     */
    public function __construct($deviceTokens, $firebaseUserKey, $title, $body, $cardId)
    {
        $this->deviceTokens = $deviceTokens;
        $this->firebaseUserKey = $firebaseUserKey;
        $this->title = $title;
        $this->body = $body;
        $this->cardId = $cardId;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        // Send notification to Firebase
        if (!empty($this->firebaseUserKey)) {
            $notificationData = [
                "title" => $this->title,
                "description" => $this->body,
                "notificationType" => 'card_payment_update',
                "createdAt" => now()->format('Y-m-d H:i:s'),
                "cardId" => (string)$this->cardId,
                "status" => "1",
                "url" => "",
                "imageURL" => '',
                "read" => "0",
                "seen" => "0",
            ];

            \App\Facades\Firebase::sendNotification(
                $this->firebaseUserKey,
                $notificationData
            );
        }

        // Send push notification to user device
        if (!empty($this->deviceTokens)) {
            send_single_notification(
                $this->deviceTokens,
                [
                    "title" => $this->title,
                    "body" => $this->body,
                    "icon" => 'myicon',
                    "sound" => 'default',
                    "click_action" => "EcomNotification",
                ],
                [
                    "type" => 'card_payment_update',
                    "notificationID" => time(),
                    "status" => "1",
                    "imageURL" => "",
                    "cardId" => (string)$this->cardId,
                ]
            );
        }
    }
}
