<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Packages;
use App\PackageItem;
use App\PackageAddons;
use App\PackageAddonItems;
use App\User;
use App\PackageLeave;

class PackageController extends Controller
{
    public function index()
    {   
        $packages = Packages::orderBy('id','DESC')->paginate(10);
        //dd($packages);
        return view('packages', compact(['packages']));
    }

    public function package_detail($id)
    {   
        $id=decrypt($id);
        $package = Packages::where('id',$id)->first();
        $package->days = $package->days ? json_decode($package->days, true) : [];
        if($package){
            return view('package_detail',compact('package'));
        }
        else{
            return redirect()->route('home')
                        ->with('warning','Something is wrong, Try Later!');
        }
    }

    public function addons()
    {   
        $addons = PackageAddons::with('customer','vendor')->paginate(10);
        //dd($packages);
        return view('package_addons', compact(['addons']));
    }

    public function addon_detail($id)
    {
        $id=decrypt($id);
        $addon = PackageAddons::where('id',$id)->with('items','customer','vendor')->first();
        //dd($package);
        if($addon){
            return view('package_addon_detail',compact('addon'));
        }
        else{
            return redirect()->route('home')
                        ->with('warning','Something is wrong, Try Later!');
        }
    }

    public function package_leave()
    {   
        $list = PackageLeave::with('package')->orderBy('leave_date','DESC')->paginate(10);
        //dd($list);
        return view('package_leaves', compact(['list']));
    }

    public function create()
    {
        return view('package_create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:100',
            'amount' => 'required|numeric',
            'description' => 'nullable|string',
            'save_amount' => 'nullable|string',
            'total_sessions' => 'nullable|string',
            'free_sessions' => 'nullable|string',
            'per_week' => 'nullable|string',
            // 'days' => 'nullable|array', 
            // 'days.*' => 'string|in:Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday',
       ]);
   
        // Convert the days array to JSON
        // $validated['days'] = json_encode($request->input('days'));
        $validated['service_id'] = "10";

        Packages::create($validated);
    
        return redirect()->route('packages')->with('success', 'Package created successfully!');
    }    

    public function edit($id)
    {
        $id = decrypt($id);
        $package = Packages::findOrFail($id);

        return view('package_edit', compact('package'));
    }

    public function update(Request $request, $id)
    {
        $id = decrypt($id);
    
        $validated = $request->validate([
            'name' => 'required|string|max:100',
            'amount' => 'required|numeric',
            'description' => 'nullable|string',
            'save_amount' => 'nullable|string',
            'total_sessions' => 'nullable|string',
            'free_sessions' => 'nullable|string',
            'per_week' => 'nullable|string',
            // 'days' => 'nullable|array', // Ensure days is an array
            // 'days.*' => 'string|in:Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday', // Validate allowed days
        ]);
    
        $package = Packages::findOrFail($id);
    
        // Update all fields, including encoding `days` as JSON
        $package->update([
            'name' => $validated['name'],
            'amount' => $validated['amount'],
            'description' => $validated['description'] ?? null,
            'save_amount' => $validated['save_amount'] ?? null,
            'total_sessions' => $validated['total_sessions'] ?? null,
            'free_sessions' => $validated['free_sessions'] ?? null,
            'per_week' => $validated['per_week'] ?? null,
            // 'days' => json_encode($validated['days'] ?? []), // Encode days as JSON
        ]);
    
        return redirect()->route('packages')->with('success', 'Package updated successfully!');
    }    
    
    public function destroy($id)
    {
        $id = decrypt($id);
        $package = Packages::findOrFail($id);
        $package->delete();

        return redirect()->route('packages')->with('success', 'Package deleted successfully!');
    }

    public function toggleStatus(Request $request, $id)
    {
        $package = Packages::findOrFail($id);

        // Update the status
        $package->update(['status' => $request->status]);

        return response()->json(['success' => true, 'message' => 'Status updated successfully!']);
    }

    public function toggleAvailability($id)
    {
        $user = User::findOrFail($id);

        $user->is_available = !$user->is_available;
        $user->save();

        return response()->json([
            'success' => true,
            'message' => 'Availability status updated successfully.',
            'is_available' => $user->is_available,
        ]);
    }


}
