<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Notification;
use Carbon\Carbon;
use App\User;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;

class NotificationController extends Controller
{
    protected $firebaseService;

    // Inject FirebasePushNotificationService through the constructor
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    public function index()
    {
        $data['data'] = Notification::where('type','Vendor')->orderBy('id', 'DESC')->get();
        $data['type'] = 'vendor';
        return view('notification.index',$data);
    }

    public function customer()
    {
        $data['data'] = Notification::where('type','Customer')->orderBy('id', 'DESC')->get();
        $data['type'] = 'customer';
        return view('notification.index',$data);
    }

    public function send_noti(Request $request)
    {
        if($request->type=='Vendor'){
            // $users = User::where('id','1161')->get();
            $users = User::where(['role' => 'vendor'])->get();
            // $users = User::where('role','vendor')->where('is_active','1')->where('is_verified','1')->get();
        } else {
            // $users = User::where('role','customer')->where('is_active','1')->where('is_verified','1')->get();
            // $users = User::where('id','453')->get();
            $users = User::where(['role' => 'customer'])->get();
        }

        foreach ($users as $key => $val) {
            if(isset($val->user_device_token)){
                $device_tokens = $val->user_device_token;
                
                $title  = 'Urbanmop';
                $body   = $request->title;
                $text   = $request->description;    
                

                $firebase_user_key = $val->firebase_user_key;
                    
                $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                    "title" => $title,
                    "description" => $body,
                    "notificationType" => 'card_payment_update',
                    "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                    "status" => "1",
                    "url" => "",
                    "imageURL" => '',
                    "read" => "0",
                    "seen" => "0",
                ];
                $this->database->getReference()->update($notification_data);

                
                send_single_notification(
                    $device_tokens,
                    [
                        "title" => $title,
                        "body" => $body,
                        "icon" => 'myicon',
                        "sound" => 'default',
                        "click_action" => "EcomNotification",
                    ],
                    [
                        "type" => 'public_notification',
                        "notificationID" => time(),
                        "status" => "1",
                        "imageURL" => "",
                    ]
                );
            }
        }
        
        $params['type']         = $request->type;
        $params['title']        = $request->title;
        $params['description']  = $request->description;
        $res = Notification::create($params);

        if($res){

            return redirect()->back()->with('success','Notification send successfully.');

        } else {

            return redirect()->back()->with('error','Something want wrong. Try again.');

        }
    }

    public function delete($id='')
    {

        Notification::whereId($id)->delete();

        return redirect()->back()->with('error','Delete successfully.');
    }
}
