<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Address;
use Illuminate\Support\Facades\Http;
class UpdateLatLng extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:latlng';
    protected $description = 'Update latitude and longitude for existing addresses';

    public function handle()
    {
        $records = Address::whereNull('latitude')->orWhereNull('longitude')->get();
        $c=0;
        foreach ($records as $record) {
            $c++;
            $address = urlencode($record->address);
            $apiKey = 'AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU';
            $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

            $response = Http::get($url)->json();

            if ($response['status'] === 'OK') {
                $location = $response['results'][0]['geometry']['location'];
                $record->latitude = $location['lat'];
                $record->longitude = $location['lng'];
                $record->save();

                $this->info("Updated: {$record->address} -> ({$location['lat']}, {$location['lng']})");
            } else {
                $this->error("Failed: {$record->address}");
            }
        }
        echo $c." records updated";
        $this->info('Latitude and Longitude update process completed.');
    }
}
