<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\OfflineBooking;
use App\Address;

class OfflineSlotChangeMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'offline_slot_change:mail {id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $booking_id = $this->argument("id");
        $card = OfflineBooking::with(['card_attribute','user','category','slot','sessionPackages','sessionPackages.slot'])->where(['id'=>$booking_id])->get()->first();
        if(is_numeric($card->address_id)){
            $address_data = Address::with(['city','locality_info'])->where(['id'=>$card->address_id])->get()->first();
        }else{
            $address_data = json_decode($card->address_id);
        }
        //echo '<pre>'; print_r($card->toArray());  exit;
        
        
        if($card->user && $card->user->email){
          $d=  \Mail::send('email_v2.offline_slot_change', compact('card', 'address_data'), function ($message) use ($card) {
                    $message->to($card->user ? $card->user->email : '')
                            ->bcc(['anilnavis@gmail.com', 'sooraja2solution@gmail.com','urbanmop.uae@gmail.com'])
                            ->subject('Slot Changed!');
                });
            print_r($d);
                
        }
        return 0;
    }
}
