<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Card;
use App\User;
use Carbon\Carbon;

class NotifyExpiredJobs extends Command
{
    protected $signature = 'notify:expired-jobs';
    protected $description = 'Send notifications for expired jobs';

    public function handle()
    {
        Log::info("Notification Process Start...");

        $expiredCards = Card::with('slot')
            ->where('is_checkout', 'Done')
            ->where('notification_sent', false)
            ->where(function ($query) {
                $query->where(function ($subQuery) {
                    $subQuery->where('service_id', '!=', 10)
                    ->where('status', 'Expired');
                        // ->where(function ($innerQuery) {
                        //     $innerQuery->where(DB::raw('DATE(date)'), '<', Carbon::today()->toDateString())
                        //         ->orWhere(function ($dateQuery) {
                        //             $dateQuery->where('status', 'Expired')
                        //                 ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString())
                        //                 ->whereHas('slot', function ($timeQuery) {
                        //                     $timeQuery->whereRaw("TIME(check_in) < ?", [Carbon::now('Asia/Dubai')->format('H:i:s')]);
                        //                 });
                        //         });
                        // });
                })->orWhere(function ($query) {
                    $query->where('service_id', 10)
                        ->whereHas('sessionPackages', function ($subQuery) {
                            $subQuery->where(DB::raw('DATE(date)'), '<', Carbon::today()->toDateString())
                                ->orWhere(function ($dateQuery) {
                                    $dateQuery->where('status', 'Expired')
                                        ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString())
                                        ->whereHas('slot', function ($timeQuery) {
                                            $timeQuery->whereRaw("TIME(check_in) < ?", [Carbon::now('Asia/Dubai')->format('H:i:s')]);
                                        });
                                });
                        });
                });
            })
            ->get();

        if ($expiredCards->isNotEmpty()) {
            foreach ($expiredCards as $card) {
                // Only notify for cards with status 'Pending' or 'Accept'
                if ($card->status == "Pending" || $card->status == "Accept") {
                    // Notify the user who created the card
                    $this->notifyUser($card->user_id, $card);

                    // Notify the user who accepted the card
                    if ($card->accept_user_id) {
                        $this->notifyUser($card->accept_user_id, $card);
                    }
                }

                // Mark the card as notified
                $card->update(['notification_sent' => true]);
            }

            Log::info("Notifications sent for expired jobs.");
        } else {
            Log::info("No expired jobs found for notification.");
        }
    }

    /**
     * Send notification to the specified user.
     *
     * @param int $userId
     * @param Card $card
     * @return void
     */
    private function notifyUser($userId, $card)
    {
        $user = User::find($userId);

        if ($user) {
            $device_tokens = $user->user_device_token;

            if (!empty($device_tokens) && $device_tokens != '0') {
                if (strlen($device_tokens) > 70) {
                    $title = "-" . $card->id;
                    $body = "Your booking for {$card->service_name} has expired.";
                    $text = "Your booking for {$card->service_name} is no longer valid due to expiration.";

                    send_single_notification(
                        $device_tokens,
                        [
                            "title" => $title,
                            "body" => $body,
                            "icon" => 'myicon',
                            "sound" => 'default',
                            "click_action" => "EcomNotification",
                        ],
                        [
                            "type" => 'expired_job_notification',
                            "notificationID" => time(),
                            "status" => "0",
                            "imageURL" => "",
                            "cardId" => (string)$card->id,
                        ]
                    );

                    Log::info("Notification sent to user ID {$userId} for card ID {$card->id}.");
                }
            }
        }
    }
}
