<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\MailJobs;

class MailInit extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mailinit:job {id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $id = $this->argument("id");
        $data = MailJobs::find($id);

        $array = json_decode($data->json_array);
        \Mail::to($data->to_email)->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
        return 0;
    }
}
