<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BellBookingUser extends Model
{
    protected $table = 'bell_bookings_users';
    
    protected $guarded = [];
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    
    public function toArray()
    {
        $array = parent::toArray();
    
        // Replace all null values with empty strings and convert integers to strings
        return array_map(function($value) {
            if ($value === null) {
                return "";
            }
    
            // Convert integers to strings
            if (is_int($value)) {
                return (string) $value;
            }
    
            return $value;
        }, $array);
    }
}
