@extends('web.layout.header')
@section('title',$service->meta_title)
@section('meta_tags')
<meta name="description" content="{{$service->meta_description}}">
@endsection
@section('content')

    <section class="pageBannerSection" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url({{ $service_header && $service_header->photos ? URL::to('/') . '/uploads/service/gallery/'.$service_header->photos : URL::to('/').'/web/Banner-not-found.jpg' }});">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="pageBannerContent text-center">
                <h1 class="text-white">Booking</h1>
                <div class="pageBannerPath">
                  <a href="index.php">Home</a> &gt; 
                   <span>Booking</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="arrow-down">
            <a href="#down"><i class="fal fa-chevron-down"></i></a>
        </div>
    </section>

	<section class="sec-m-top mb-30" id="down">
        <div class="container">
            <div class="row">
                <div class="col-12 mb-30">
                    <div class="card border-0 selected-booking" style="background: url('{{ asset('images/booking-bg.jpg') }}');">
                        <div class="card-body p-0">
                            <div class="row align-items-center">
                                <div class="col-lg-8 order-2 order-lg-1">
                                    <div class="p-2">
                                        <h4 class="h5 text-white">{!! $service->name !!}</h4>
                                        <h3 class="h3 text-white mb-1">Start just <b>AED {{$service->price ?? ''}}</b></h3>
                                        <a href="#!" class="review-rating-btn" data-bs-toggle="modal" data-bs-target="#viewreviewModal"><i class="fas fa-star text-secondary"></i> <b class="text-secondary">4.84</b> (797 Reviews &amp; Ratings)</a>
                                    </div>
                                </div>
                                <div class="col-lg-4 text-end mb-4 mb-lg-0 order-1 order-lg-2">
                                    <div class="selected-booking-img bg-1 w-100">
										<img width="100" height="100" src="{{ asset('uploads/service/'.$service->thumbnail_img) }}" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <form id="msform">
                        <!-- progressbar -->
                        <ul id="progressbar">
                            <li class="active" id="account"><strong>Selection</strong></li>
                            <li id="personal"><strong>Location</strong></li>
                            <li id="payment"><strong>Choose Time</strong></li>
                            <li id="confirm"><strong>Payment</strong></li>
                        </ul>
                        <div class="progress">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                        </div>
                        <br>
                        <!-- fieldsets -->
                        <fieldset class="selection">
                            <div class="form-card">

                                @if(App\ServiceAttributeValueItem::where('service_id',$service->id)->count() && App\ServiceAttributeValueItem::where('service_id',$service->id)->with('sub_category')->first()->sub_category)
        
                                    @foreach(App\ServiceAttributeValueItem::where('service_id',$service->id)->groupBy('sub_category_id')->get() as $key => $ser_atr_item)

                                        @if($ser_atr_item->sub_category)

                                            <div class="card mb-2 p-2" id="{{ str_replace(' ','_',$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:'')}}">
                                                <div class="row align-items-center card_entry_d" >
                                                    <div class="col-md-2 col-3">
                                                        @if($ser_atr_item->sub_category && $ser_atr_item->sub_category->icon)
                                                            <img src="{{ asset('uploads/category/'.$ser_atr_item->sub_category->icon) }}" class="img-fluid w-100px rounded-start" alt="{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}" title="{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}" >
                                                        @else
                                                            <img src="{{ asset('web/Thumbnail-not-found.jpg') }}" class="img-fluid rounded-start w-100px " alt="{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}" title="{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}">
                                                        @endif
                                                    </div>
                                                    <div class="col-md-6 col-5 p-0">
                                                        <h5 class="card-title">{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}</h5>
                                                        <p class="card-text" id="sub-desc-cat">{{substr($ser_atr_item->sub_category?$ser_atr_item->sub_category->meta_description:'','0','300')}} </p>
                                                    </div>
                                                    <div class="col-md-4 col-4 ps-0 text-center">
                                                            @if(isset($ser_atr_item->child_category_id) && $ser_atr_item->child_category_id)
                                                            <button type="button" class="btn-sm " data-bs-toggle="modal" data-bs-target="#exampleModal{{$key}}">
                                                                <span>+</span> Add
                                                            </button>
                                                        @else 
                                                            <button type="button" class="btn-sm " data-bs-toggle="modal" data-bs-target="#attributeModal{{$key}}">
                                                                <span>+</span> Add
                                                            </button>
                                                        @endif
                                                        <p class="card-text" ><small>Starting AED {{$ser_atr_item->sub_category?$ser_atr_item->sub_category->price:''}}</small></p>
                                                    </div>
                                                </div>
                                            </div> 

                                        @endif
                                        @if(isset($ser_atr_item->child_category_id) && $ser_atr_item->child_category_id)

                                            <div class="modal fade" id="exampleModal{{$key}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                            <div class="modal-body">
                                                            
                                                            @foreach(App\ServiceAttributeValueItem::where('service_id',$service->id)->where('sub_category_id',$ser_atr_item->sub_category_id)->get() as $index => $child_ser_atr_item)
                                                                <div class="card mb-2 p-2">
                                                                    <div class="row align-items-center">
                                                                        <div class="col">
                                                                            @if($child_ser_atr_item->child_category)
                                                                                <img src="{{ asset('uploads/child-category/'.$child_ser_atr_item->child_category->icon) }}" class="img-fluid w-80px rounded-start" alt="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}" title="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}" >
                                                                            @else
                                                                                        <img src="{{ asset('web/Thumbnail-not-found.jpg') }}" class="img-fluid w-80px  rounded-start" alt="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}" title="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}" >
                                                                            @endif
                                                                        </div>
                                                                        <div class="col">
                                                                            <div class="text-left" >
                                                                                <h6 class="card-title">{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}</h6>
                                                                            </div>
                                                                        </div>
                                                                            <div class="col">
                                                                            <div class="text-left " >
                                                                                    <button type="button" class="btn btn-warning btn-sm  pr-3 pl-3 pt-1 pb-1" onclick="OpenAttrModel({{$child_ser_atr_item->child_category_id}},{{$child_ser_atr_item->id}},{{$key}})">
                                                                                    <span>+</span> Add
                                                                                </button>
                                                                                <input type="hidden" class="sub_cate_name{{$child_ser_atr_item->id}}" value="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}">
                                                                                    <p class="card-text  m-0" >Starting AED {{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->price:''}}</p>
                                                                                </div>
                                                                            </div>
                                                                    </div>
                                                                </div>									      

                                                            @endforeach
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-dark modelclose" id="attrclose" data-bs-dismiss="modal">OK</button>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        @else 
                                            <?php
                                                $attribute_ids = [];
                                                foreach (App\ServiceAttributeValueItem::where('service_id',$service->id)->where('sub_category_id',$ser_atr_item->sub_category_id)->get() as $value) {
                                                    array_push($attribute_ids, $value->id);
                                                }
                                            ?>
                                            <!-- Modal -->
                                            <div class="modal fade" id="attributeModal{{$key}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                            <div class="modal-body sub-category-popup">
                                                                @foreach(App\ServiceAttributeValue::whereIn('ser_attr_val_item_id',$attribute_ids)->get() as $attr => $attributeItems)
                                                                    @if($attributeItems->attributeItem)
                                                                    <div class="card mb-2">
                                                                        <div class="row align-items-center">
                                                                                <div class="col-8">
                                                                                <div class="card-body p-2" >
                                                                                    <h6 class="card-title">{{$attributeItems->attributeItem->value}}</h6>
                                                                                    <p class="m-0">Starting AED {{$attributeItems->attribute_price}}</p>
                                                                                </div>
                                                                                </div>
                                                                            <div class="col-4">
                                                                                <div class="d-flex align-items-center" >
                                                                                    <?php $formid =  'addattrforms'.$attributeItems->id.''; $buttonForm =  'buttonForms'.$attributeItems->id.''; $add_booking_from = 'add_booking_from'.$attributeItems->id.''; $addbtn = 'addbtn'.$attributeItems->id.'';?>
                                                                                    <button class="add-button-color-change" onclick="showForm({{$formid}}, {{$buttonForm}}, {{$attributeItems->id}})" id="{{$buttonForm}}">+ Add</button>
                                                                                    <form action="#" method="POST" enctype="multipart/form-data" id="{{$formid}}" class="{{$add_booking_from}}" style="display: none;">
                                                                                            @csrf
                                                                                            <input type="hidden" name="service_id" value="{{$service->id}}">
                                                                                            <input type="hidden" name="category_id" value="{{$service->category_id}}">
                                                                                            <input type="hidden" name="main_sub_cat_id" value="{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->id:''}}">
                                                                                            <input type="hidden" name="sub_cate_id" value="{{$ser_atr_item->sub_category_id}}">
                                                                                            <input type="hidden" name="attribute_id" value="{{$attributeItems->attribute_id}}">
                                                                                            <input type="hidden" name="attribute_name" value="{{$attributeItems->attribute?$attributeItems->attribute->name:''}}">
                                                                                            <input type="hidden" name="attribute_item_id" value="{{$attributeItems->attribute_item_id}}">
                                                                                            <input type="hidden" name="attribute_item_name" value="{{$attributeItems->attributeItem?$attributeItems->attributeItem->value:''}}">
                                                                                            <input type="hidden" name="attribute_price" value="{{$attributeItems->attribute_price}}">
                                                                                            
                                                                                        <button type="button" id="sub" class="minus" onclick="minus_booking({{$attributeItems->id}})">-</button>
                                                                                            <input type="number" id="1" value="1" min="1" class='quantity formqty{{$attributeItems->id}}' max="10" style="width:50px!important; padding:0!important"  />
                                                                                            <button type="button" id="add" class="plus {{$addbtn}}" onclick="add_booking({{$attributeItems->id}})">+</button>
                                                                                    </form>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @endforeach

                                                            </div>
                                                            <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark modelclose" data-bs-dismiss="modal">OK</button>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>

                                        @endif
                                    @endforeach

                                @else

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-3 mb-0">Choose Maids</h3>
                                        </div>
                                        <div class="col-12">
                                        <ul class="selector">
                                            <?php
                                                $maid_attribute_ids = [];
                                                foreach (App\ServiceAttributeValueItem::where('service_id', $service->id)->get() as $prt => $value) {
                                                    if ($prt == '0') {
                                                        $maid_attribute_ids[] = $value->id;
                                                    }
                                                }
                                            ?>
                                            @foreach (App\ServiceAttributeValue::whereIn('ser_attr_val_item_id', $maid_attribute_ids)->get() as $key => $attributeItem)
                                            <li>
                                                <label class="control" for="maid_{{ $attributeItem->id }}">
                                                    <input type="radio" name="maid_id" id="maid_{{ $attributeItem->id }}" 
                                                        value="{{ $attributeItem->id }}" 
                                                        data-attribute-item-id="{{ $attributeItem->attribute_item_id }}" 
                                                        data-sub-category-id="{{ $attributeItem->sub_category_id }}" 
                                                        data-category-id="{{ $attributeItem->category_id }}" 
                                                        data-child-category-id="{{ $attributeItem->child_category_id }}" 
                                                        {{ $selectedMaidId == $attributeItem->attribute_item_id ? 'checked' : '' }} 
                                                        onclick="collectAttributesData()">
                                                    <span class="control__content"><i class="fal fa-check"></i> {{ $attributeItem->attributeItem->value }}</span>
                                                </label>
                                            </li>
                                            @endforeach
                                        </ul>
                                        </div>
                                    </div>

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-3 mb-0">Choose Hours</h3>
                                        </div>
                                        <div class="col-12">
                                        <?php
                                            $hour_attribute_ids = [];
                                            foreach (App\ServiceAttributeValueItem::where('service_id', $service->id)->get() as $prt => $value) {
                                                if ($prt == '1') {
                                                    $hour_attribute_ids[] = $value->id;
                                                }
                                            }
                                        ?>
                                        <ul class="selector">
                                        @foreach (App\ServiceAttributeValue::whereIn('ser_attr_val_item_id', $hour_attribute_ids)->get() as $key => $attributeItem)
                                            <li>
                                                <label class="control" for="hour_{{ $attributeItem->id }}">
                                                    <input type="radio" name="hour_id" id="hour_{{ $attributeItem->id }}" 
                                                        value="{{ $attributeItem->id }}" 
                                                        data-attribute-item-id="{{ $attributeItem->attribute_item_id }}" 
                                                        data-sub-category-id="{{ $attributeItem->sub_category_id }}" 
                                                        data-category-id="{{ $attributeItem->category_id }}" 
                                                        data-child-category-id="{{ $attributeItem->child_category_id }}" 
                                                        {{ $selectedHourId == $attributeItem->attribute_item_id ? 'checked' : '' }} 
                                                        onclick="collectAttributesData()">
                                                    <span class="control__content"><i class="fal fa-check"></i> {{ $attributeItem->attributeItem->value }}</span>
                                                </label>
                                            </li>
                                        @endforeach
                                        </ul>
                                        </div>
                                    </div>

                                    <input type="hidden" name="item_object" id="item_object">

                                    <script>
                                        function collectAttributesData() {
                                            const itemObjects = [];

                                            // Get selected maid attribute
                                            const maidSelected = document.querySelector('input[name="maid_id"]:checked');
                                            if (maidSelected) {
                                                itemObjects.push({
                                                    attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
                                                    attribute_qty: 1,
                                                    sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
                                                    category_id: maidSelected.getAttribute('data-category-id'),
                                                    child_category: maidSelected.getAttribute('data-child-category-id')
                                                });
                                            }

                                            // Get selected hour attribute
                                            const hourSelected = document.querySelector('input[name="hour_id"]:checked');
                                            if (hourSelected) {
                                                itemObjects.push({
                                                    attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
                                                    attribute_qty: 1,
                                                    sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
                                                    category_id: hourSelected.getAttribute('data-category-id'),
                                                    child_category: hourSelected.getAttribute('data-child-category-id')
                                                });
                                            }

                                            // Convert the itemObjects array to JSON and store it in the hidden input
                                            document.getElementById('item_object').value = JSON.stringify(itemObjects);
                                            submitForm();
                                        }

                                    </script>

                                    @if($service->material_status=='True')
                                        <div class="row mb-30">
                                            <div class="col-12 mb-20">
                                                <h3 class="fs-3 mb-0">Would you like us to bring cleaning materials?</h3>
                                            </div>
                                            <div class="col-12">
                                                <ul class="selector">
                                                    <li>
                                                        <label class="control" for="yes">
                                                            <input type="radio" name="yenno" id="yes" onclick="setMaterialStatus('Apply')" 
                                                                {{ $selectedMaterial == 'Apply' ? 'checked' : '' }}>
                                                            <span class="control__content">
                                                                <i class="fal fa-check"></i> Yes
                                                            </span>
                                                        </label>
                                                    </li>
                                                    <li>
                                                        <label class="control" for="no">
                                                            <input type="radio" name="yenno" id="no" onclick="setMaterialStatus('No')" 
                                                                {{ $selectedMaterial == 'No' ? 'checked' : '' }}>
                                                            <span class="control__content">
                                                                <i class="fal fa-check"></i> No
                                                            </span>
                                                        </label>
                                                    </li>
                                                </ul>

                                                <input type="hidden" name="material_status" id="material_status" value="{{$service->material_status == 'True' ? 'Apply' : 'No'}}">

                                                <input type="hidden" name="service_id" id="service_id" value="{{$service->id}}">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-3 mb-0">Want to share important information/details?</h3>
                                        </div>
                                        <div class="col-12">
                                            <textarea name="note" id="note" placeholder="Enter here">{{$cartItem->note ?? ""}}</textarea>
                                        </div>
                                    </div>

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-3 mb-0">Select Your Package</h3>
                                        </div>
                                        
                                        <div class="col-12">
                                            <ul class="selector package-selector">
                                                <li class="w-100">
                                                    <label class="control w-100" for="package1">
                                                        <input type="radio" name="package" id="package1">
                                                        <span class="control__content w-100">
                                                            <i class="fal fa-check"></i>
                                                            <div class="">
                                                                <h5 class="h6">One Time Booking</h5>
                                                                <h4 class="mb-0 h5">75.99 AED</h4>
                                                            </div>
                                                        </span>
                                                    </label>
                                                </li>
                                                <li class="w-100">
                                                    <label class="control w-100" for="package2">
                                                        <input type="radio" name="package" id="package2" checked="">
                                                        <span class="control__content w-100">
                                                            <i class="fal fa-check"></i>
                                                            <div class="w-100">
                                                                <h4 class="h5">3 Sessions + 1 Free</h4>
                                                                <h5 class="h6">1 Session Per Week</h5>
                                                                <h4 class="mb-0 fs-5 d-flex justify-content-between">AED 225.00 <span>Save AED 75.00</span></h4>
                                                            </div>
                                                        </span>
                                                    </label>
                                                </li>
                                                <li class="w-100">
                                                    <label class="control w-100" for="package3">
                                                        <input type="radio" name="package" id="package3">
                                                        <span class="control__content w-100">
                                                            <i class="fal fa-check"></i>
                                                            <div class="w-100">
                                                                <h4 class="h5">6 Sessions + 2 Free</h4>
                                                                <h5 class="h6">1 Session Per Week</h5>
                                                                <h4 class="mb-0 fs-5 d-flex justify-content-between">AED 225.00 <span>Save AED 75.00</span></h4>
                                                            </div>
                                                        </span>
                                                    </label>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                @endif	 

                            </div>
                            <input type="button" name="next" class="next action-button" onclick="move('location')" value="Proceed">
                        </fieldset>
                        <fieldset class="location">
                            <div class="form-card">
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <div class="d-flex gap-2 justify-content-between align-items-center">
                                            <h3 class="fs-3 mb-0">Location</h3>
                                            <a href="#!" class="btn btn-2" data-bs-toggle="modal" data-bs-target="#changelocation">Change Location</a>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h6>Home</h6>
												<h5 class="mb-0 fs-5" id="user-address" data-address="
													@auth
														{{ App\Address::where(['is_active' => 1, 'user_id' => auth()->user()->id])->first()->address ?? '-' }}
													@else
														-
													@endauth
												">
													@auth
														{{ App\Address::where(['is_active' => 1, 'user_id' => auth()->user()->id])->first()->address ?? '-' }}
													@else
														-
													@endauth
												</h5> </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-3 mb-0">Contact Details</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Name</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->name }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Mobile Number</h4>
                                                    @auth
														<h4 class="text-end mb-0 fs-5">{{ auth()->user()->dial_code }} {{ auth()->user()->phone }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Email Address</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->email }}</h4>
													@else
														-
													@endauth
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-3 mb-0 text-start">Want add alternative number?</h3>
                                    </div>
									 <!-- Include CSS for intl-tel-input (v24.6.0) -->
									 <link rel="stylesheet" 
                                    href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
                                    integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
                                    crossorigin="anonymous" referrerpolicy="no-referrer" />

                                    <div class="form-group col-lg-6">
                                        <div class="input-group">
                                            <!-- Dial Code Input with Flag -->
                                            <div class="input-group-prepend">
                                                <input type="tel" name="dial_code" id="dial-code" 
                                                    class="form-control" value="+{{ ltrim($cartItem->dial_code ?? '971', '+') }}" 
                                                    required style="width:120px; text-align: center;">
                                            </div>

                                            <!-- Phone Number Input -->
                                            <input type="text" id="phone-number" class="form-control" 
                                                name="phone" value="{{ $cartItem->alternative_number }}" 
                                                placeholder="Enter phone number" required>
                                        </div>
                                    </div>

                                    <!-- Include JS for intl-tel-input (v24.6.0) -->
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
                                            integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
                                            crossorigin="anonymous" referrerpolicy="no-referrer"></script>

                                    <script>
                                        // Initialize intl-tel-input within an IIFE to avoid redeclaration errors
                                        (function() {
                                            const dialCodeInput = document.querySelector("#dial-code");

                                            const iti = intlTelInput(dialCodeInput, {
                                                initialCountry: "AE",            // Automatically detect the user's country
                                                separateDialCode: false,            // Display only the dial code in the input
                                                autoPlaceholder: "polite",         // Use a smart placeholder
                                                // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js", // Required for formatting
                                            });

                                            // Handle the country change event (optional)
                                            dialCodeInput.addEventListener("countrychange", function() {
                                                const countryData = iti.getSelectedCountryData();
                                                console.log(`Selected country: ${countryData.name}, Dial Code: ${countryData.dialCode}`);
                                            });
                                        })();
                                    </script>
                                    <div class="col-lg-6"></div>
                            </div>
                            <div class="text-end mb-30">
                                    <h5 class="mb-0 fs-5 updated-price">AED 0</h5>
                                    <h6 class="fs-6 text-muted">Total Amount</h6>
                            </div>
                            <input type="button" name="next" class="next action-button" onclick="move('choose_time')" value="Choose Timing">
                            <input type="button" name="previous" class="previous action-button-previous" onclick="move('selection')" value="Previous" />
                        </fieldset>
                        <fieldset class="choose_time">
                            <div class="form-card">
                                <div class="row mb-30">
									<div class="col-12 mb-20">
										<h3 class="fs-3 mb-0 text-start">Select 2 Preferred Days</h3>
									</div>
									<div class="col-12 mb-20">
										<ul class="selector" id="preferred-days-list">
										</ul>
									</div>


									<div class="col-12 mb-20">
										<h3 class="fs-3 mb-0 text-start">Choose Date</h3>
									</div>
									<div class="col-12 mb-3">
                                        <input type="date" id="date-picker" class="form-control" 
                                             />
                                    </div>


									<div class="col-12 mb-20">
										<h3 class="fs-3 mb-0 text-start">Choose Time Slot</h3>
									</div>
									<div class="col-12">
										<ul class="selector" id="time-slots-list">
											<!-- Time slots will be dynamically loaded here -->
										</ul>
									</div>


                                </div>
                                <div class="text-end mb-30">
                                        <h5 class="mb-0 fs-5 updated-price">AED 0</h5>
                                        <h6 class="fs-6 text-muted">Total Amount</h6>
                                </div>
                            </div>
                            <input type="button" name="next" class="next action-button" onclick="move('payment')" value="Payment">
                            <input type="button" name="previous" class="previous action-button-previous" onclick="move('location')" value="Previous" />
                        </fieldset>
                        <fieldset class="payment">
                            <div class="form-card">

                                <div class="row mb-30">
                                    <div class="col-12">
                                        <div class="card">
											<div class="card-body" id="summary-card">
												<h4 class="text-secondary h5">Maid Service</h4>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-1 fs-5">Maid Service x <span id="summary-service-quantity">0</span></h4>
													<h4 class="text-end mb-1 fs-5">AED <span id="summary-service-price">0.00</span></h4>
												</div>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-1 fs-5">Maid <span id="summary-service-hours">0</span> hr</h4>
													<h4 class="text-end mb-1 fs-5"><span id="summary-service-count">0</span></h4>
												</div>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-0 fs-5">Material Price</h4>
													<h4 class="text-end mb-0 fs-5">AED <span id="summary-material-price">0.00</span></h4>
												</div>
												<hr>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-0 fs-5">Date</h4>
													<h4 class="text-end mb-0 fs-5"><span id="summary-selected-date">N/A</span></h4>
												</div>
												<hr>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-0 fs-5">Time</h4>
													<h4 class="text-end mb-0 fs-5"><span id="summary-selected-time">N/A</span></h4>
												</div>
											</div>

                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-3 mb-0">Location</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h6>Home</h6>
												<h5 class="mb-0 fs-5">
													@auth
														{{ App\Address::where(['is_active' => 1, 'user_id' => auth()->user()->id])->first()->address ?? '-' }}
													@else
														-
													@endauth
												</h5>
											</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-3 mb-0">Contact Details</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
												<div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Name</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->name }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Mobile Number</h4>
                                                    
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->dial_code }} {{ auth()->user()->phone }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Email Address</h4>
													
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->email }}</h4>
													@else
														-
													@endauth
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="checkout.php" class="btn btn-2 mt-2 float-end mx-2">Proceed to Pay</a>
                                <a class="btn btn-1 mt-2 float-end" onclick="addToCart(event)">Add to Cart</a>
								<!-- href="{{ route('cart.list') }}" -->
                            </div>
                            <input type="button" name="previous" class="previous action-button-previous" onclick="move('choose_time')" value="Previous" />
                        </fieldset>
                    </form>

                </div>
            </div>
        </div>
    </section>

    <!-- Change Location Modal -->
    <div class="modal fade" id="changelocation" tabindex="-1" aria-labelledby="changelocationLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-5" id="changelocationLabel">Change Location</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center">
                        <div class="mb-3">
                            <a href="#!" class="btn btn-1 w-100" data-bs-toggle="modal" data-bs-target="#addressmodal" data-bs-dismiss="modal">Add New Location</a>
                        </div>
                        <div class="row" id="address-list">
                            <!-- Address list will be dynamically loaded here -->
                        </div>
                        <div class="col-12">
                            <button type="button" class="btn btn-1 w-100" data-bs-dismiss="modal">Proceed</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Event to load addresses when the "Change Location" modal is shown
        document.getElementById('changelocation').addEventListener('show.bs.modal', function () {
            loadAddressList();
        });

        // Function to load address list dynamically
        function loadAddressList() {
            const addressListContainer = document.getElementById('address-list');
            addressListContainer.innerHTML = '<p>Loading addresses...</p>'; // Temporary loading message

            fetch("{{ route('address.list') }}") 
            .then(response => response.json())
            .then(data => {
                addressListContainer.innerHTML = ''; // Clear loading message
                data.forEach(address => {
                    const addressHtml = `
                        <div class="col-12 mb-3" id="address-${address.id}">
                            <div class="address-box card position-relative">
                                <div class="card-body">
                                    <label class="w-100">
                                        <input type="radio" name="address" value="${address.id}" id="add${address.id}">
                                        <div class="content text-start position-relative">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <h6 class="mb-0 fs-5 fw-bold">${address.address}</h6>
                                                <div class="address-box-action d-flex align-items-center gap-3">
                                                    <i class="fal fa-check tick fs-5"></i>
                                                    <a href="#!" class="address-box-delete-btn fs-5" data-address-id="${address.id}">
                                                        <i class="fal fa-trash-alt"></i> Delete
                                                    </a>
                                                    <a href="#!" class="address-box-edit-btn fs-5" data-bs-toggle="modal" data-bs-target="#editAddressModal" data-address-id="${address.id}">
                                                        <i class="fal fa-edit"></i> Edit
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>`;
                    addressListContainer.insertAdjacentHTML('beforeend', addressHtml);
                });

            })
            .catch(error => {
                console.error('Error fetching address list:', error);
                addressListContainer.innerHTML = '<p>Error loading addresses. Please try again later.</p>';
            });
        }
    </script>

    <!-- Add Address Modal -->
    <div class="modal fade" id="addressmodal" tabindex="-1" aria-labelledby="addressmodalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-5" id="addressmodalLabel">Add Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="addAddressForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="flat_no" placeholder="Flat No/Office No/Villa" required>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="building" placeholder="Building name" required>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="citySelect" class="form-input-1" name="city_id" required>
                                    <option value="">Select Emirates</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="localitySelect" class="form-input-1" name="locality" required>
                                    <option value="">Select Locality</option>
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <ul class="selector">
                                    <li>
                                        <label class="control" for="home">
                                            <input type="radio" name="address_type" value="Home" id="home" checked>
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Home
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="office">
                                            <input type="radio" name="address_type" value="Office" id="office">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Office
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="work">
                                            <input type="radio" name="address_type" value="Work" id="work">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Work
                                            </span>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-1 w-100">Save Address</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Address Modal -->
    <div class="modal fade" id="editAddressModal" tabindex="-1" aria-labelledby="editAddressModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-5" id="editAddressModalLabel">Edit Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editAddressForm" method="POST">
                    @csrf
                    <input type="hidden" name="address_id" id="editAddressId"> <!-- No default value -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="flat_no" id="editFlatNo" placeholder="Flat No/Office No/Villa" required>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="building" id="editBuilding" placeholder="Building name" required>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="editCitySelect" class="form-input-1" name="city_id" required>
                                    <option value="">Select Emirates</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="editLocalitySelect" class="form-input-1" name="locality" required>
                                    <option value="">Select Locality</option>
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <ul class="selector">
                                    <li>
                                        <label class="control" for="editaddress_typeHome">
                                            <input type="radio" name="address_type" value="Home" id="editaddress_typeHome">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Home
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="editaddress_typeOffice">
                                            <input type="radio" name="address_type" value="Office" id="editaddress_typeOffice">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Office
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="editaddress_typeWork">
                                            <input type="radio" name="address_type" value="Work" id="editaddress_typeWork">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Work
                                            </span>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-1 w-100">Update Address</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>	


@endsection

<script>

    // Function to update address list dynamically in the Change Location modal
    function updateAddressList() {
        fetch("{{ route('address.list') }}")
            .then(response => response.json())
            .then(data => {
                const addressContainer = document.querySelector('#changelocation .row');
                addressContainer.innerHTML = '';

                data.forEach(address => {
                    const addressHtml = 
                        `<div class="col-12 mb-3">
                            <div class="address-box card position-relative">
                                <div class="card-body">
                                    <label class="w-100">
                                        <input type="radio" name="address" value="${address.id}" id="add${address.id}">
                                        <div class="content text-start position-relative">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <h6 class="mb-0 fs-5 fw-bold">${address.address}</h6>
                                                <div class="address-box-action d-flex align-items-center gap-3">
                                                    <i class="fal fa-check tick fs-5"></i>
                                                    <a href="#" class="address-box-delete-btn fs-5">
                                                        <i class="fal fa-trash-alt"></i> Delete
                                                    </a>
                                                    <a href="#" class="address-box-edit-btn fs-5">
                                                        <i class="fal fa-edit"></i> Edit
                                                    </a>
                                                </div>
                                            </div>
                                            <p class="mb-0">${address.details}</p>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>`;
                    addressContainer.insertAdjacentHTML('beforeend', addressHtml);
                });
            })
            .catch(error => console.error('Error fetching address list:', error));
    }

    document.getElementById('addAddressForm').addEventListener('submit', function (event) {
        event.preventDefault();

        const formData = new FormData(this);

        fetch("{{ route('address.save') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const addressModal = bootstrap.Modal.getInstance(document.getElementById('addressmodal'));
                addressModal.hide();

                updateAddressList();

                const changeLocationModal = new bootstrap.Modal(document.getElementById('changelocation'));
                changeLocationModal.show();
            }
        })
        .catch(error => console.error('Error saving address:', error));
    });

    // Function to load localities based on selected city
    function loadLocalities(cityId, localitySelectId) {
        const localitySelect = document.getElementById(localitySelectId);
        localitySelect.innerHTML = '<option value="">Select Locality</option>';

        if (cityId) {
            fetch(`/localities/${cityId}`)
                .then(response => response.json())
                .then(data => {
                    data.forEach(locality => {
                        const option = new Option(locality.name, locality.id);
                        localitySelect.add(option);
                    });
                })
                .catch(error => console.error('Error fetching localities:', error));
        }
    }

    // Attach change event to city select in Add Address modal to load localities
    document.getElementById('citySelect').addEventListener('change', function () {
        loadLocalities(this.value, 'localitySelect');
    });

    // Attach change event to city select in Edit Address modal to load localities
    document.getElementById('editCitySelect').addEventListener('change', function () {
        loadLocalities(this.value, 'editLocalitySelect');
    });

    // Load address list when the "Change Location" modal is shown
    document.getElementById('changelocation').addEventListener('show.bs.modal', function () {
        loadAddressList();
    });

    // Function to load the address list dynamically
    function loadAddressList() {
        const addressListContainer = document.getElementById('address-list');
        addressListContainer.innerHTML = '<p>Loading addresses...</p>';

        fetch("{{ route('address.list') }}")
            .then(response => response.json())
            .then(data => {
                addressListContainer.innerHTML = '';
                data.forEach(address => {
                    const addressHtml = `
                        <div class="col-12 mb-3" id="address-${address.id}">
                            <div class="address-box card position-relative">
                                <div class="card-body">
                                    <label class="w-100">
                                        <input type="radio" name="address" value="${address.id}" id="add${address.id}">
                                        <div class="content text-start position-relative">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <h6 class="mb-0 fs-5 fw-bold">${address.address}</h6>
                                                <div class="address-box-action d-flex align-items-center gap-3">
                                                    <i class="fal fa-check tick fs-5"></i>
                                                    <a href="#!" class="address-box-delete-btn fs-5" data-address-id="${address.id}">
                                                        <i class="fal fa-trash-alt"></i> Delete
                                                    </a>
                                                    <a href="#!" class="address-box-edit-btn fs-5" data-bs-toggle="modal" data-bs-target="#editAddressModal" data-address-id="${address.id}">
                                                        <i class="fal fa-edit"></i> Edit
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>`;
                    addressListContainer.insertAdjacentHTML('beforeend', addressHtml);
                });
            })
            .catch(error => {
                console.error('Error fetching address list:', error);
                addressListContainer.innerHTML = '<p>Error loading addresses. Please try again later.</p>';
            });
    }

    // Use event delegation for edit functionality
    document.getElementById('address-list').addEventListener('click', function (event) {
        const editButton = event.target.closest('.address-box-edit-btn');
        if (editButton) {
            const addressId = editButton.getAttribute('data-address-id');
            
            // Fetch address data for editing
            fetch(`/address/${addressId}/edit`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate form fields with the fetched data
                        document.getElementById('editAddressId').value = data.data.id;
                        document.getElementById('editFlatNo').value = data.data.flat_no;
                        document.getElementById('editBuilding').value = data.data.building;
                        document.getElementById('editCitySelect').value = data.data.city_id;

                        // Load localities for the selected city and set the selected locality
                        loadLocalities(data.data.city_id, 'editLocalitySelect');
                        setTimeout(() => {
                            document.getElementById('editLocalitySelect').value = data.data.locality;
                        }, 200);

                        document.getElementById(`editaddress_type${data.data.address_type}`).checked = true;
                    } else {
                        console.error('Error: Address not found');
                    }
                });
        }
    });

    // Delete address functionality
    document.getElementById('address-list').addEventListener('click', function (event) {
        const deleteButton = event.target.closest('.address-box-delete-btn');
        if (deleteButton) {
            const addressId = deleteButton.getAttribute('data-address-id');
            if (confirm("Are you sure you want to delete this address?")) {
                fetch(`/address/${addressId}/delete`, {  // Adjust route as needed
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Remove the address element from the DOM
                        document.getElementById(`address-${addressId}`).remove();
                    } else {
                        alert("Error deleting address. Please try again.");
                    }
                })
                .catch(error => console.error('Error deleting address:', error));
            }
        }
    });

    // Load address list when the "Change Location" modal is shown
    document.getElementById('changelocation').addEventListener('show.bs.modal', function () {
        loadAddressList();
    });

    // Use event delegation for edit functionality
    document.getElementById('address-list').addEventListener('click', function (event) {
        const editButton = event.target.closest('.address-box-edit-btn');
        if (editButton) {
            const addressId = editButton.getAttribute('data-address-id');
            
            // Fetch address data for editing
            fetch(`/address/${addressId}/edit`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate form fields with the fetched data
                        document.getElementById('editAddressId').value = data.data.id;
                        document.getElementById('editFlatNo').value = data.data.flat_no;
                        document.getElementById('editBuilding').value = data.data.building;
                        document.getElementById('editCitySelect').value = data.data.city_id;

                        // Load localities for the selected city and set the selected locality
                        loadLocalities(data.data.city_id);
                        setTimeout(() => {
                            document.getElementById('editLocalitySelect').value = data.data.locality;
                        }, 200);

                        document.getElementById(`editaddress_type${data.data.address_type}`).checked = true;
                    } else {
                        console.error('Error: Address not found');
                    }
                })
                .catch(error => console.error('Error fetching address:', error));
        }
    });

    // Submit edited address with AJAX
    document.getElementById('editAddressForm').addEventListener('submit', function (event) {
        event.preventDefault();

        const addressId = document.getElementById('editAddressId').value;
        const formData = new FormData(this);

        fetch(`/address/${addressId}/update`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const editModal = bootstrap.Modal.getInstance(document.getElementById('editAddressModal'));
                editModal.hide();
                loadAddressList(); 
                
                const changeLocation = bootstrap.Modal.getInstance(document.getElementById('changelocation'));
                changeLocation.show();
            } else {
                console.error('Error updating address:', data.message);
            }
        })
        .catch(error => console.error('Error updating address:', error));
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
<script>
	function OpenAttrModel(child_id, subid, attrid) {
		
		var attritemmod 		= '#attributeModalSec';
		var sub_cat_name_cls = '.sub_cate_name'+subid;
		var attrmod 			= 'exampleModal'+attrid;
		var sub_cat_name 		= jQuery(sub_cat_name_cls).val();
		var service_id 		= jQuery('.service_id').val();
		jQuery('.subCateName').text(sub_cat_name);
		jQuery('.attributelist').html('')
		jQuery('.modelclose').click();
		if(child_id){
			jQuery.ajax({
              
               headers: {
	                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
	            },
	            type:"POST",
               url: "{{ url('get_child_cat_attr_items') }}",
               data: {
                        child_category_id: child_id, service_id : service_id, sub_cat_id : subid,
                    },
               success: function (res) {
                  console.log(res);

						jQuery('#attrclose').click();
                  jQuery("#attributeModalSec").modal('show');
                  
                  jQuery.each(res, function(key,val) {
			        		var formid =  'addattrformss'+val.id; 
			        		var buttonForm =  'buttonFormss'+val.id;
			        		var add_booking_from = 'add_booking_from'+val.id;
			        		var formqty = 'formqty'+val.id;
			        		var addbtn = 'addbtn'+val.id;
			            jQuery('.attributelist').append('<div class="card mb-2"><div class="row align-items-center"> <div class="col-md-6"> <div class="card-body text-left mt-0" > <h6 class="card-title">'+ val.attributename +'</h6> <p><small>Starting AED '+ val.attribute_price +'</small></p> </div></div><div class="col-md-6"><div class="card-body text-right " ><button class="add-button-color-change" onclick="showForm('+formid+', '+buttonForm+', '+val.id+')" id="'+buttonForm+'">+ Add</button>	<form action="{{ route("add.attribute.card") }}" method="POST" style="display: none;" enctype="multipart/form-data" id="'+formid+'" class="'+add_booking_from+'">@csrf<input type="hidden" name="service_id" value="' + val.service_id + '"><input type="hidden" name="category_id" value="'+ val.category_id +'"><input type="hidden" name="sub_cate_id" value="'+ val.sub_cat_id +'"><input type="hidden" name="main_sub_cat_id" value="'+ val.main_sub_cat_id +'"><input type="hidden" name="child_category_id" value="'+ child_id +'"><input type="hidden" name="attribute_id" value="'+ val.attribute_id +'"><input type="hidden" name="attribute_name" value="'+ val.attribute_name +'"><input type="hidden" name="attribute_item_id" value="'+ val.attribute_item_id +'"><input type="hidden" name="attribute_item_name" value="'+ val.attribute_item_name +'"><input type="hidden" name="attribute_price" value="'+ val.attribute_price +'"><button type="button" id="sub" class="minus" onclick="minus_booking('+val.id+')">-</button><input type="number" id="1" value="1" min="1" class="quantity '+formqty+'" max="10" /><button type="button" onclick="add_booking('+val.id+')" id="add" class="plus '+addbtn+'">+</button></form></div></div></div></div>');
			        });
                  
                  
               },
               error: function (res) {
                   console.log(res);
               }
         });
		}
		
	}
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js" type="text/javascript"></script>
<script>
	jQuery('.v-c-d').hide();
	jQuery(".view-o-d").click(function(){
	   jQuery(".v-c-d").fadeToggle();
	});
</script>

<script>
	function addToCart(event) {
		event.preventDefault(); 
        const selectedDate = document.getElementById('date-picker').value;
        if (!selectedDate) {
            alert("Please select a date.");
            return;
        }

        const selectedSlot = document.querySelector('input[name="time"]:checked');
        const slotId = selectedSlot ? selectedSlot.value : null;
        if (!slotId) {
            alert("Please select a time slot.");
            return;
        }
        
		// Get selected maid details
		const maidSelected = document.querySelector('input[name="maid_id"]:checked');
		const maidDetails = maidSelected ? {
			maid_id: maidSelected.value,
			maid_name: maidSelected.nextElementSibling.textContent.trim(),
			attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
			category_id: maidSelected.getAttribute('data-category-id'),
			sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
			child_category_id: maidSelected.getAttribute('data-child-category-id')
		} : {};

		// Get selected hours
		const hourSelected = document.querySelector('input[name="hour_id"]:checked');
		const hourDetails = hourSelected ? {
			hour_id: hourSelected.value,
			hour_name: hourSelected.nextElementSibling.textContent.trim(),
			attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
			category_id: hourSelected.getAttribute('data-category-id'),
			sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
			child_category_id: hourSelected.getAttribute('data-child-category-id')
		} : {};

		// Get material preference
		const materialPreference = document.querySelector('input[name="yenno"]:checked');
		const materialDetails = materialPreference ? materialPreference.id === 'yes' ? 'Apply' : 'No' : 'No';

		// Get user note
		const userNote = document.getElementById('note').value;

		// Get selected package
		const packageSelected = document.querySelector('input[name="package"]:checked');
		const packageDetails = packageSelected ? {
			package_id: packageSelected.id,
			package_name: packageSelected.nextElementSibling.querySelector('h5').textContent.trim(),
			package_price: packageSelected.nextElementSibling.querySelector('h4').textContent.trim()
		} : {};

		// Get preferred days
		const preferredDays = Array.from(document.querySelectorAll('input[name="preferred_days"]:checked')).map(day => day.value);

		// Get alternate contact number details
		const dialCode = document.getElementById('dial-code').value;
		const phoneNumber = document.getElementById('phone-number').value;
		const alternateNumber = dialCode && phoneNumber ? `${phoneNumber}` : "";

		// Prepare data object
		const cartData = {
			cart_id: "{{ $cartItem->id }}",
			service_id: "{{ $service->id }}",
			item_object: JSON.stringify([
				{
					attribute_item_id: maidDetails.attribute_item_id,
					category_id: maidDetails.category_id,
					sub_category_id: maidDetails.sub_category_id,
					child_category_id: maidDetails.child_category_id,
					attribute_qty: 1 // Define quantity based on selection, here set to 1
				},
				{
					attribute_item_id: hourDetails.attribute_item_id,
					category_id: hourDetails.category_id,
					sub_category_id: hourDetails.sub_category_id,
					child_category_id: hourDetails.child_category_id,
					attribute_qty: 1 
				}
			]),
			note: userNote,
			material_status: materialDetails,
			selected_packages: packageDetails.package_id,
			preffered_days: preferredDays,
			slot_id: slotId,
            date: selectedDate,
			alternative_number: alternateNumber,
			dial_code: dialCode
		};

		// AJAX request to send data to the backend API
		fetch("{{ route('cart.update', $cartItem->id) }}", {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
				"X-CSRF-TOKEN": "{{ csrf_token() }}" // For CSRF protection in Laravel
			},
			body: JSON.stringify(cartData)
		})
		.then(response => response.json())
		.then(data => {
			if (data.success) {
				console.log("Item added to cart successfully:", data);
				alert("Item added to cart!");
                const baseURL = window.location.origin;
                window.location.href = `${baseURL}/cart`;
			} else {
				console.error("Error adding item to cart:", data.message);
				alert("Failed to add item to cart. Please try again.");
			}
		})
		.catch(error => {
			console.error("Error:", error);
			alert("An error occurred. Please try again.");
		});
	}
</script>


<style type="text/css">
   .minus, .plus{
			width:34px!important;
			height:36px!important;
			background-image: linear-gradient(#feb83a, #d84e56)!important;
			border-radius:4px!important;
			padding:8px 5px 8px 5px!important;
			border:1px solid #ddd; color:#fff!important;
		display: inline-block!important;
		vertical-align: middle!important;
		text-align: center!important; margin:0!important;
	}

	.quantity {
		height:37px!important;
		width: 100px!important; margin:0!important;
		text-align: center!important;
		font-size: 14px!important; color:#fff!important;
		border:1px solid #ddd!important;
		border-radius:4px; 	background-image: linear-gradient(#feb83a, #d84e56)!important;
		display: inline-block!important!important;
		vertical-align: middle!important;
	}

</style>
<script type="text/javascript">
               var input = $('.quantity'),
         minValue =  parseInt(input.attr('min')),
         maxValue =  parseInt(input.attr('max'));


         $('.plus').on('click', function () {
         var inputValue = input.val();
         if (inputValue < maxValue) {
         input.val(parseInt(inputValue) + 1);
         }
         });

         $('.minus').on('click', function () {
         var inputValue = input.val();
         if (inputValue < maxValue) {
         input.val(parseInt(inputValue) - 1);
         }
         });

</script>
<script>
	function submitForm(argument) {
		// jQuery('.textgtotal').hide();
		jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "{{ url('get_selected_price') }}",
            data: jQuery('#msform').serialize(),
            dataType: 'json',
            success: function (data) {
            	console.log(data.data);
                 jQuery('.updated-price').html('AED '+data.data.total_amount); 
				 
				 updateSummary("service",data.data);
            },
            error: function (data) {
                console.log(data);
            }
      });
	}
</script>
<script>
	let lasthur = '';
	function getSubItemid(datas) {
		var hurid = '#flexRadioDefault'+datas.id;
		jQuery(lasthur).prop('checked', false);
		lasthur = hurid;
		jQuery('.attribute_detail_id').val(datas.id);
		submitSubAttrForm();
	}
</script>
<script>
	let material = '';
	function submitSubAttrForm() {
		jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "{{ url('update/sub/attribute') }}",
            data: jQuery('.submitSubAttrForm').serialize(),
            dataType: 'json',
            success: function (data) {
            	console.log(data);
                 jQuery('.cardlist').html('');       
                 jQuery('.cardlist').html(data.modal_view); 
                 jQuery('.textgtotal').show();    
                 jQuery('.gtotal').text(data.peramt);  
                  material = data.peramt;
                  jQuery("#flexRadioDefault1").prop('checked', false);
                  jQuery("#flexRadioDefault2").prop('checked', false);
            },
            error: function (data) {
                console.log(data);
            }
      });
	}

	function move(choose){
		const maidSelected = jQuery('input[name="maid_id"]:checked').val();
		const hourSelected = jQuery('input[name="hour_id"]:checked').val();
		if (maidSelected && hourSelected) {
			
			if(choose == "selection"){
				jQuery('.location').hide();    
				jQuery('.selection').show();    

				jQuery('#account').addClass("active");    
				jQuery('#personal').removeClass("active");    
				
				jQuery('.progress-bar').css('width', '25%');
			} else if(choose == 'location'){ 
                collectAttributesData();
				jQuery('.selection').hide();    
				jQuery('.choose_time').hide();    
				jQuery('.location').show();    
				jQuery('#payment').addClass("active");    
				
				jQuery('#personal').addClass("active");    
				jQuery('#account').removeClass("active");    
				jQuery('#payment').removeClass("active");    
				
				jQuery('.progress-bar').css('width', '50%');
			}  else if(choose == 'choose_time'){ 

				let userAddress = jQuery('#user-address').data('address') || "-";
				if(userAddress == '-'){
					alert("Please select address first!");
					return move('location');
				}
				jQuery('.payment').hide();    
				jQuery('.location').hide();    
				jQuery('.choose_time').show();    

				jQuery('#payment').addClass("active");    
				jQuery('#personal').removeClass("active");    
				jQuery('#confirm').removeClass("active");   
				
				jQuery('.progress-bar').css('width', '75%');
			} else if(choose == 'payment'){ 
				updateSummary("time", {});
				jQuery('.choose_time').hide();    
				jQuery('.payment').show();    
				jQuery('#confirm').addClass("active");   
				jQuery('#payment').removeClass("active");     
				
				jQuery('.progress-bar').css('width', '100%');
			}
		} else {
			alert('Please select both the number of maids and hours to proceed.');
		}
	}
</script>
<script>

	function cleaningCheck(argument) {
		if(argument=='Yes'){
			var status = 'Apply';
		} else {
			var status = 'Not';
		}

		jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "{{ url('update/material/charge') }}",
            data: {
            	card_id : jQuery('.cc_card_id').val(),
            	material_amt : material,
            	status : status,
            },
            dataType: 'json',
            success: function (data) {
            	console.log(data);
            	  jQuery('.cardlist').html('');       
                 jQuery('.cardlist').html(data.modal_view);    
                 jQuery('.textgtotal').show();    
                 jQuery('.gtotal').text(data.peramt);  
                  material = data.peramt; 
            },
            error: function (data) {
                console.log(data);
            }
      });
	}
</script>
<script>
	function reloadPage() {
		location.reload();
	}
</script>

<style type="text/css">
	
	#attributeModalSec .card-body p {
    	margin: 0em 0 !important;
    }
	#attributeModalSec .card-body{
			padding: 5px 15px 2px 15px !important;
		}

	#attributeModalSec .card-title {
    margin-bottom: 0px !important;
	}


@media only screen and (max-width: 768px) and (min-width: 200px)  {

	#personal_information input[type="date"]{
		height: 70px !important;
    	line-height: 20px !important;
	}

		#personal_information input[type="date"]{
		padding: 0rem 0.75rem !important;
	}

	}	

</style>

<script>
	function setMaterialStatus(value) {
		document.getElementById('material_status').value = value;
		submitForm();
	}

	function checkSubmitForm() {
		var checkAddress = jQuery('.checkAddress').val();
		if(checkAddress=='True'){
			jQuery('.profile_address_form').submit();
		} else {
			if(jQuery('.live_address').val()==''){
				jQuery('.addresserror').text('This field is required.');
			} else if(jQuery('.flat_no').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('This field is required.');
			} else if(jQuery('.building').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('');
				jQuery('.buildingerror').text('This field is required.');
			} else if(jQuery('.city_val').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('');
				jQuery('.buildingerror').text('');
				jQuery('.cityerror').text('This field is required.');
			} else {
				jQuery.ajax({
			         headers: {
			                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
			            },    
			         type: 'Post',
			         url: "{{ url('get/lat/long') }}",
			         data: {
			           location : jQuery('.live_address').val(),
			         },
			         dataType: 'json',
			         success: function (response) {
			              
			              if(response.status=='1'){
			                 jQuery('#latitude').val(response.latitude);
			                 jQuery('#longitude').val(response.longitude);
			                 map = new google.maps.Map(document.getElementById('map'), {
			                    center: { lat: response.latitude, lng: response.longitude }, // Default to centering at (0, 0)
			                    zoom: 15 // Adjust the zoom level as desired
			                 });

			                 // Create a marker at the default location (0, 0)
			                 marker = new google.maps.Marker({
			                    position: { lat: response.latitude, lng: response.longitude },
			                    map: map,
			                    draggable: true // Allow the marker to be dragged
			                 });

			                 // Add an event listener to update the latitude and longitude when the marker is dragged
			                 marker.addListener('dragend', function() {
			                    updateCoordinates(marker.getPosition());
			                 });
			               } 
			               jQuery('.checkAddress').val('True');
								jQuery('.profile_address_form').submit();   
			         },
			         error: function (response) {
			            jQuery('.checkAddress').val('True');
							jQuery('.profile_address_form').submit();
			         }
			      });
				
			}
			
			// jQuery('.profile_address_form').submit();
		}
	}

    document.addEventListener("DOMContentLoaded", function () {
        // Preferred days data from backend
        const preferredDaysFromBackend = @json(explode(',', $cartItem->preffered_days ?? ''));

        // Fetch preferred days from API
        fetch('/api/preffered_days')
            .then(response => response.json())
            .then(data => {
                if (data.status === "1") {
                    const daysList = document.getElementById("preferred-days-list");
                    const daysData = data.data;

                    // Generate list items for each day
                    daysData.forEach(day => {
                        const isChecked = preferredDaysFromBackend.includes(day.name) ? 'checked' : '';
                        const listItem = document.createElement("li");

                        listItem.innerHTML = `
                            <label class="control" for="day_${day.id}">
                                <input type="checkbox" name="preferred_days" id="day_${day.id}" value="${day.name}" ${isChecked} onclick="handleDaySelection()">
                                <span class="control__content">
                                    <i class="fal fa-check"></i> ${day.name}
                                </span>
                            </label>
                        `;
                        daysList.appendChild(listItem);
                    });
                    handleDaySelection(); // Ensure max selection logic is applied initially
                } else {
                    console.error("Failed to load days:", data.message);
                }
            })
            .catch(error => console.error("Error fetching preferred days:", error));
    });

	// Allow up to 2 preferred days to be selected
	function handleDaySelection() {
		const selectedDays = document.querySelectorAll('input[name="preferred_days"]:checked');
		const checkboxes = document.querySelectorAll('input[name="preferred_days"]');

		// Disable other checkboxes if 2 are already selected
		if (selectedDays.length >= 2) {
			checkboxes.forEach(checkbox => {
				if (!checkbox.checked) {
					checkbox.disabled = true;
				}
			});
		} else {
			// Re-enable all checkboxes if less than 2 are selected
			checkboxes.forEach(checkbox => checkbox.disabled = false);
		}
	}


	 // Set today's date as the minimum date for the date picker
	 function getTodayDate() {
        const today = new Date();
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const day = String(today.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    }

    document.addEventListener("DOMContentLoaded", function () {
        const datePicker = document.getElementById("date-picker");
        const slotsList = document.getElementById("time-slots-list");
        const serviceId = "{{$service->id}}";

        // Set the date picker value and min attribute to today
         // Set today's date as the minimum date
            const today = new Date().toISOString().split("T")[0];
            datePicker.min = today;

            // Use the pre-selected date from the backend or default to today's date
            const preSelectedDate = "{{ $cartItem->date ?? '' }}"; // Make sure this is in YYYY-MM-DD format
            datePicker.value = preSelectedDate || today; // Set the initial date

        // Function to fetch and display available time slots for a given date
        function fetchTimeSlots(date) {
            fetch("{{ route('slots_list') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ date: date, service_id: serviceId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "1") {
                    const slotsData = data.data;

                    // Clear any existing slots
                    slotsList.innerHTML = '';
                    const preSelectedSlotId = "{{ $cartItem->slot_id ?? '' }}"; 

                    // Generate list items for each available slot
                    slotsData.forEach(slot => {
                        if (slot.available && !slot.is_past_slot) {
                            const isChecked = slot.slot_id == preSelectedSlotId ? 'checked' : ''; // Pre-select if matches
                    console.log("slot.slot_id " + slot.slot_id);
                    console.log("preSelectedSlotId " + preSelectedSlotId);
                            const listItem = document.createElement("li");
                            listItem.innerHTML = `
                                <label class="control" for="time_${slot.slot_id}">
                                    <input type="radio" name="time" id="time_${slot.slot_id}" value="${slot.slot_id}" ${isChecked}>
                                    <span class="control__content">
                                        <i class="fal fa-check"></i> ${slot.slot_name}
                                    </span>
                                </label>
                            `;
                            slotsList.appendChild(listItem);
                        }
                    });
                } else {
                    console.error("Failed to load time slots:", data.message);
                }
            })
            .catch(error => console.error("Error fetching time slots:", error));
        }

        // Fetch slots initially for today’s date
        fetchTimeSlots(preSelectedDate || today);

        // Fetch slots whenever a new date is selected
        datePicker.addEventListener("change", function () {
            const selectedDate = this.value;
            fetchTimeSlots(selectedDate);
        });
    });

	// Function to update the summary section
	function updateSummary(status, data) {
		let date = getTodayDate();
		let selectedSlot = document.querySelector('input[name="time"]:checked');
		let selectedTime = selectedSlot ? selectedSlot.nextElementSibling.textContent.trim() : "N/A";
		if(status == "time"){
			document.getElementById('summary-selected-date').textContent = date;
			document.getElementById('summary-selected-time').textContent = selectedTime;
		} else {
			// Check if `data` and `data.attribute` exist and handle missing properties safely
			document.getElementById('summary-service-quantity').textContent = data?.attribute?.[0]?.name || 0;
			document.getElementById('summary-service-price').textContent = data?.attribute?.[0]?.price || 0;
			document.getElementById('summary-service-hours').textContent = data?.attribute?.[1]?.name || 0;
			document.getElementById('summary-service-count').textContent = data?.attribute?.[1]?.price || 0;
			document.getElementById('summary-material-price').textContent = data?.material || 0;
		}
	}

	
</script>

<style type="text/css">
	
	#sub-desc-cat{
		font-size: 13px !important;
	}


	.add-button-color-change{
	background-color: #eab42f !important;
    color: #fff !important;
    padding: 0px 20px !important;
    font-size: 17px !important;
    border-radius: 20px !important;
    font-weight: 600 !important;
    -webkit-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    -moz-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    }

	.attributelist .add-button-color-change, .btn-sm{
	background-color: #eab42f !important;
    color: #fff !important;
    padding: 0px 20px !important;
    font-size: 17px !important;
    border-radius: 20px !important;
    font-weight: 600 !important;
    -webkit-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    -moz-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.75) !important;
    }

    .card-title{
        font-size: 16px !important;
        color:#6a6d7a !important;
    }

    .service_d_content h1, .service_d_content h2, .service_d_content h3, .service_d_content h4, .service_d_content h5, .service_d_content h6{
        color:#6a6d7a !important;
    }

    .cardlist h1, .cardlist h2, .cardlist h3, .cardlist h4, .cardlist h5, .cardlist h6{
        color:#6a6d7a !important;	
    }


    @media only screen and (max-width: 720px) and (min-width: 200px)  {
        .sub-category-popup .col-8, .sub-category-popup .col-4{
            width: 50% !important;
        }
        
    }



</style>
