@extends('web.layout.header')
@section('title',($service->name??""). " Booking - UrbanMop")
@section('meta_tags')
<meta name="description" content="{{($service->name??'') . ' Booking - UrbanMop'}}">
@endsection
@section('content')
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.12.2/lottie.min.js" 
integrity="sha512-jEnuDt6jfecCjthQAJ+ed0MTVA++5ZKmlUcmDGBv2vUI/REn6FuIdixLNnQT+vKusE2hhTk2is3cFvv5wA+Sgg==" 
crossorigin="anonymous" referrerpolicy="no-referrer"></script> -->
<style>
/* Style the parent label or container when disabled */
.disabled {
    background-color: #e0e0e0; /* Light grey background */
    color: #a0a0a0; /* Grey text */
    pointer-events: none; /* Prevent clicks */
    opacity: 0.7; /* Make it look slightly faded */
    cursor: not-allowed; /* Show not-allowed cursor */
}

/* Optional: Add padding and border for better appearance */
.disabled input {
    pointer-events: none;
}
.pac-container {
    z-index: 9999 !important;
    position: absolute !important;
    background-color: white;
    border: 1px solid #ccc;
}

</style>
    <!-- <section class="pageBannerSection" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url({{ $service_header && $service_header->photos ? URL::to('/') . '/uploads/service/gallery/'.$service_header->photos : URL::to('/').'/web/Banner-not-found.jpg' }});">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="pageBannerContent text-center">
                <h1 class="text-white">Booking</h1>
                <div class="pageBannerPath">
                  <a href="index.php">Home</a> &gt; 
                   <span>Booking</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="arrow-down">
            <a href="#down"><i class="fal fa-chevron-down"></i></a>
        </div>
    </section> -->

	<section class="sec-m-top mb-30" id="down">
        <div class="container">
            <div class="row">
                <div class="col-12 mb-30">
                <!-- style="background: url('{{ asset('images/booking-bg.jpg') }}');" -->
                    <div class="card border-0 selected-booking py-3 px-3">
                        <div class="card-body p-0">
                            <div class="row align-items-center">
                                <div class="col pe-0">
                                    <div class="p-2">
                                        <h4 class="h5 text-white mb-1">{!! $service->name !!}</h4>
                                        <h3 class="h4 text-white mb-2 fw-normal">Start just <b>AED {{$service->price ?? ''}}</b></h3>
                                        
                                        <a href="{{route('ratings',$service->id)}}" class="review-rating-btn" ><i class="fas fa-star text-secondary"></i> <b class="text-secondary">{{$average_rating}}</b> ({{$total_reviews}} Reviews & Ratings)</a>
                                    </div>
                                </div>
                                <div class="col-auto text-end mb-lg-0 ps-0">
                                    <div class="selected-booking-img bg-1 w-100 p-3 h-100">
										<img class="img-fluid" src="{{ asset('uploads/service/'.$service->thumbnail_img) }}" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="container-anime" id="animArea"></div>
                        <script>
                            var animation = bodymovin.loadAnimation({
                                container: document.getElementById('animArea'),
                                path: "{{ asset('web/assets/img/UrbanMop-welcome-banner-02.lottie') }}",
                                render: 'svg',
                                loop: true,
                                autoplay: true,
                                name: 'test animation'
                            });
                        </script> -->
                        <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module"></script>
                        
                        <div class="container-anime">
                            <dotlottie-player src="{{ asset('/uploads/gif/'.$data->gif_web) }}" 
                            background="transparent" speed="1" style="width: 100%; height: 100%" direction="1" playMode="normal" 
                            loop autoplay></dotlottie-player>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <form id="msform" class="mt-0" action="javascript:void(0);">
                        <!-- progressbar -->
                        <ul id="progressbar">
                            <li class="active" onclick="move('selection')" id="account"><a<strong>Selection</strong></li>
                            <li id="personal" onclick="move('location')" ><strong>Location</strong></li>
                            <li id="payment" onclick="move('choose_time')"><strong>Choose Time</strong></li>
                            <li id="confirm" onclick="move('payment')"><strong>Confirm</strong></li>
                        </ul>
                        <div class="progress">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                        </div>
                        <br>
                        
                        <fieldset class="selection sticky-wrapper">
                            <div class="row">
                            <div class="col-lg-8">
                                <div class="content">
                            @if(App\ServiceAttributeValueItem::where('service_id',$service->id)->count() && App\ServiceAttributeValueItem::where('service_id',$service->id)->with('sub_category')->first()->sub_category)
                                <div class="form-card">
                                <div class="row gx-3 mb-3">
                                    <input type="hidden" class="is_cate_yes" value="yes"/>
                                    
                                    @foreach(App\ServiceAttributeValueItem::where('service_id',$service->id)->groupBy('sub_category_id')->get() as $key => $ser_atr_item)
                                    
                                        @if($ser_atr_item->sub_category)
                                        
                                    <div class="col-lg-6 col-12">
                                            <div class="card cart-card overflow-hidden mb-10" id="{{ str_replace(' ', '_', $ser_atr_item->sub_category->name) }}">
                                                <div class="card-body">
                                                    <div class="cart-item">
                                                        <div class="cart-item-product d-flex align-items-center">
                                                            <div class="cart-item-img bg-1 p-0 overflow-hidden">
                                                                <img src="{{ $ser_atr_item->sub_category && $ser_atr_item->sub_category->icon 
                                                                    ? asset('uploads/category/' . $ser_atr_item->sub_category->icon) 
                                                                    : asset('web/Thumbnail-not-found.jpg') }}" 
                                                                    class="img-fluid rounded-0 object-fit-cover" 
                                                                    alt="{{ $ser_atr_item->sub_category->name ?? 'N/A' }}">
                                                            </div>
                                                            <div class="card-item-details w-100">
                                                                <h4 class="mb-2 fw-600 fs-4">{{ $ser_atr_item->sub_category->name ?? 'N/A' }}</h4>
                                                                <div class="d-flex w-100 gap-2 align-items-end justify-content-between">
                                                                    <p class="mb-0 text-muted fs-5 mt-0">{{ substr($ser_atr_item->sub_category->meta_description ?? '', 0, 300) }}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-header bg-1 border-0">
                                                    <div class="cart-item-footer">
                                                        <div class="cart-item-timing">
                                                            <h5 class="mb-0 fw-400 fs-5">Starting <b>AED {{ $ser_atr_item->sub_category->price ?? '0.00' }}</b> </h5>
                                                        </div>
                                                        <div class="cart-item-btns">
                                                            @if(isset($ser_atr_item->child_category_id) && $ser_atr_item->child_category_id)
                                                                <a href="#!" class="btn btn-smll-row btn-1" data-bs-toggle="modal" data-bs-target="#exampleModal{{ $key }}">Add</a>
                                                            @else
                                                                <a href="#!" class="btn btn-smll-row btn-1" data-bs-toggle="modal" data-bs-target="#attributeModal{{ $key }}">Add</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        @endif
                                        @if(isset($ser_atr_item->child_category_id) && $ser_atr_item->child_category_id)
                                        
                                            <div class="modal fade" id="exampleModal{{$key}}" tabindex="-1" aria-labelledby="exampleModalLabel1" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel1">{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            @foreach(App\ServiceAttributeValueItem::where('service_id', $service->id)->where('sub_category_id', $ser_atr_item->sub_category_id)->get() as $index => $child_ser_atr_item)
                                                                <div class="card cart-card cart-card-modal overflow-hidden mb-2">
                                                                    <div class="card-body p-2">
                                                                        <div class="cart-item">
                                                                            <div class="cart-item-product d-flex align-items-center">
                                                                                <div class="cart-item-img bg-1 p-0 overflow-hidden">
                                                                                    <img src="{{ $child_ser_atr_item->child_category && $child_ser_atr_item->child_category->icon ? asset('uploads/child-category/'.$child_ser_atr_item->child_category->icon) : asset('web/Thumbnail-not-found.jpg') }}" class="img-fluid rounded-0" alt="{{ $child_ser_atr_item->child_category->name ?? '' }}">
                                                                                </div>
                                                                                <div class="card-item-details w-100">
                                                                                    <h4 class="mb-0 fw-600 fs-5 text-muted">{{ $child_ser_atr_item->child_category->name ?? '' }}</h4>
                                                                                    <div class="cart-item-footer">
                                                                                        <div class="cart-item-timing">
                                                                                            <h4 class="mb-0 fw-600 fs-5">Starting AED {{ $child_ser_atr_item->child_category->price ?? '0.00' }}</h4>
                                                                                        </div>
                                                                                            <input type="hidden" class="sub_cate_name{{$child_ser_atr_item->id}}" value="{{$child_ser_atr_item->child_category?$child_ser_atr_item->child_category->name:''}}"/>
                                                                                        
                                                                                        <div class="cart-item-btns">
                                                                                            <button type="button" class="btn btn-1  btn-smll-row" onclick="OpenAttrModel({{ $child_ser_atr_item->child_category_id }}, {{ $child_ser_atr_item->id }}, {{ $key }})">Add</button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark modelclose" id="attrclose" data-bs-dismiss="modal">OK</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @else 
                                            <?php
                                                $attribute_ids = [];
                                                foreach (App\ServiceAttributeValueItem::where('service_id',$service->id)->where('sub_category_id',$ser_atr_item->sub_category_id)->get() as $value) {
                                                    array_push($attribute_ids, $value->id);
                                                }
                                            ?>
                                            <!-- Modal -->
                                            <div class="modal fade" id="attributeModal{{$key}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">{{$ser_atr_item->sub_category?$ser_atr_item->sub_category->name:''}}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body sub-category-popup">
                                                            @foreach(App\ServiceAttributeValue::whereIn('ser_attr_val_item_id',$attribute_ids)->get() as $attr => $attributeItems)
                                                                @if($attributeItems->attributeItem)
                                                                    <div class="card mb-2">
                                                                        <div class="row align-items-center">
                                                                            <div class="col-8">
                                                                                <div class="card-body p-2" >
                                                                                    <h4 class="mb-0 fw-600 fs-5 text-muted">{{$attributeItems->attributeItem->value}}</h4>
                                                                                    <p class="m-0 text-dark fw-semibold fs-5 cart-item-timing">Starting AED {{$attributeItems->attribute_price}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-4">
                                                                            <div class="card-body p-2 d-flex align-items-center justify-content-end">
                                                                                <?php 
                                                                                    $formid = 'addattrforms' . $attributeItems->id; 
                                                                                    $buttonForm = 'buttonForms' . $attributeItems->id; 
                                                                                    $add_booking_from = 'add_booking_from' . $attributeItems->id; 
                                                                                    $addbtn = 'addbtn' . $attributeItems->id;
                                                                                ?>
                                                                                <button 
                                                                                    class="add-button-color-change btn-smll-row" 
                                                                                    onclick="showForm('#{{ $formid }}', '#{{ $buttonForm }}', '{{$addbtn}}')" 
                                                                                    id="{{ $buttonForm }}"
                                                                                >+ Add</button>
                                                                                
                                                                                <span 
                                                                                    action='{{ route("add.attribute.card") }}' 
                                                                                    method="POST" 
                                                                                    enctype="multipart/form-data" 
                                                                                    id="{{ $formid }}" 
                                                                                    class="{{ $add_booking_from }}" 
                                                                                    style="display: none;"
                                                                                >
                                                                                    @csrf
                                                                                    <input type="hidden" name="service_id" value="{{ $service->id }}">
                                                                                    <input type="hidden" name="category_id" value="{{ $service->category_id }}">
                                                                                    <input type="hidden" name="main_sub_cat_id" value="{{ $ser_atr_item->sub_category ? $ser_atr_item->sub_category->id : '' }}">
                                                                                    <input type="hidden" name="sub_cate_id" value="{{ $ser_atr_item->sub_category_id }}">
                                                                                    <input type="hidden" name="attribute_id" value="{{ $attributeItems->attribute_id }}">
                                                                                    <input type="hidden" name="attribute_name" value="{{ $attributeItems->attribute ? $attributeItems->attribute->name : '' }}">
                                                                                    <input type="hidden" name="attribute_item_id" value="{{ $attributeItems->attribute_item_id }}">
                                                                                    <input type="hidden" name="attribute_item_name" value="{{ $attributeItems->attributeItem ? $attributeItems->attributeItem->value : '' }}">
                                                                                    <input type="hidden" name="attribute_price" value="{{ $attributeItems->attribute_price }}">
                                                                                    <div class="quanity_form">
                                                                                        <button 
                                                                                            type="button" 
                                                                                            class="minus" 
                                                                                            onclick="minus_booking({{ $attributeItems->id }})"
                                                                                        >-</button>
                                                                                        <input 
                                                                                            type="number" 
                                                                                            id="quantity_{{ $attributeItems->id }}" 
                                                                                            value="1" 
                                                                                            min="1" 
                                                                                            max="10" 
                                                                                            class="quantity formqty{{ $attributeItems->id }}" 
                                                                                            style="width:50px!important; padding:0!important" 
                                                                                        />
                                                                                        <button 
                                                                                            type="button" 
                                                                                            class="plus {{ $addbtn }}" 
                                                                                            onclick="add_booking({{ $attributeItems->id }})"
                                                                                        >+</button>
                                                                                    </div>
                                                                                </span>
                                                                            </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark modelclose" data-bs-dismiss="modal">OK</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        @endif

                                    @endforeach
                                </div>

                                    @if($service->material_status=='True')
                                        <div class="row mb-30">
                                            <div class="col-12 mb-20">
                                                <h3 class="fs-4 mb-0">Would you like us to bring cleaning materials?</h3>
                                            </div>
                                            <div class="col-12">
                                            <ul class="selector">
                                                    <?php
                                                        // Fetch the card with the necessary conditions
                                                        $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                            ->where('service_id', $service_id)
                                                            ->where('status', 'Pending')
                                                            ->where('payment_collected', 'No')
                                                            ->where('work_done', 'No')
                                                            ->where('is_checkout', 'Processing')
                                                            ->orderBy('id', 'DESC')
                                                            ->first();
                                                            
                                                        // Determine if material charge is applied
                                                        $materialApplied = $card_info && (float) $card_info->material_charge > 0;
                                                        
                                                    ?>
                                                    <li>
                                                        <label class="control" for="yes">
                                                            <input type="radio" name="yenno" id="yes" onclick="setMaterialStatus('Apply')" 
                                                                {{ $materialApplied ? 'checked' : '' }}>
                                                            <span class="control__content">
                                                                <i class="fal fa-check"></i> Yes
                                                            </span>
                                                        </label>
                                                    </li>
                                                    <li>
                                                        <label class="control" for="no">
                                                            <input type="radio" name="yenno" id="no" onclick="setMaterialStatus('No')" 
                                                                {{ !$materialApplied ? 'checked' : '' }}>
                                                            <span class="control__content">
                                                                <i class="fal fa-check"></i> No
                                                            </span>
                                                        </label>
                                                    </li>
                                                </ul>


                                                <input type="hidden" name="material_status" id="material_status" value="No">

                                                <input type="hidden" name="service_id" id="service_id" value="{{$service->id}}">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-5 mb-0">Want to share important information/details?</h3>
                                        </div>
                                        <div class="col-12">
                                            <textarea name="note" id="note" placeholder="Enter here"></textarea>
                                        </div>
                                    </div>

                                </div>
                            @else
                                <div class="form-card">
                                <input type="hidden" class="is_cate_yes" value="no"/>
                                    
                                

                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-4 mb-0">Choose Maids</h3>
                                    </div>
                                    <div class="col-12">
                                    <ul class="selector">
                                        <?php
                                            $hour_attribute_ids = [];
                                            $selectedHourAttributeItemId = null; // Initialize to hold selected hour attribute_item_id

                                            // Fetch the selected hour attribute item id from CardAttribute if it exists
                                            $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                ->where('service_id', $service->id)
                                                ->where('status', 'Pending')
                                                ->where('payment_collected', 'No')
                                                ->where('work_done', 'No')
                                                ->where('is_checkout', 'Processing')
                                                ->orderBy('id', 'DESC')
                                                ->first();

                                            if ($card_info) {
                                                $selectedHourAttributeItemId = App\CardAttribute::where('card_id', $card_info->id)
                                                    ->where('attribute_name', 'Maids')
                                                    ->value('attribute_item_id');
                                            }

                                            foreach (App\ServiceAttributeValueItem::where('service_id', $service->id)->get() as $prt => $value) {
                                                if ($prt == '0') {
                                                    $hour_attribute_ids[] = $value->id;
                                                }
                                            }

                                            $attributes = App\ServiceAttributeValue::whereIn('ser_attr_val_item_id', $hour_attribute_ids)->get();
                                        ?>

                                        @foreach ($attributes as $key => $attributeItem)
                                            <li class="maid-item-{{$loop->iteration}} @if($loop->iteration == 1) d-none @endif">
                                                <label class="control" for="hour_{{ $attributeItem->id }}">
                                                    <input type="radio" name="hour_id" id="hour_{{ $attributeItem->id }}" value="{{ $attributeItem->id }}" 
                                                        data-attribute-item-id="{{ $attributeItem->attribute_item_id }}" 
                                                        data-sub-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->sub_category_id }}" 
                                                        data-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->category_id }}" 
                                                        data-child-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->child_category_id }}"
                                                        onclick="collectAttributesData()" 
                                                        
                                                        {{ $selectedHourAttributeItemId == $attributeItem->attribute_item_id || (!$selectedHourAttributeItemId && $loop->iteration == 2) ? 'checked' : '' }}> 
                                                    <span class="control__content">
                                                        <i class="fal fa-check"></i> {{ $attributeItem->attributeItem->value }}
                                                    </span>
                                                </label>
                                            </li>
                                        @endforeach
                                    </ul>


                                    </div>
                                </div>
                                
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-4 mb-0">Choose Hours</h3>
                                    </div>
                                    <div class="col-12">
                                    <ul class="selector">
                                        <?php
                                            $maid_attribute_ids = [];
                                            $selectedAttributeItemId = null;

                                            // Fetch the selected attribute item id from CardAttribute if it exists
                                            $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                ->where('service_id', $service->id)
                                                ->where('status', 'Pending')
                                                ->where('payment_collected', 'No')
                                                ->where('work_done', 'No')
                                                ->where('is_checkout', 'Processing')
                                                ->orderBy('id', 'DESC')
                                                ->first();

                                            if ($card_info) {
                                                $selectedAttributeItemId = App\CardAttribute::where('card_id', $card_info->id)
                                                    ->where('attribute_name', 'Hours')
                                                    ->value('attribute_item_id');
                                            }

                                            foreach (App\ServiceAttributeValueItem::where('service_id', $service->id)->get() as $prt => $value) {
                                                if ($prt == '1') {
                                                    $maid_attribute_ids[] = $value->id;
                                                }
                                            }

                                            $attributes = App\ServiceAttributeValue::whereIn('ser_attr_val_item_id', $maid_attribute_ids)->get();
                                        ?>
                                        @foreach ($attributes as $key => $attributeItem)
                                            <li>
                                                <label class="control" for="maid_{{ $attributeItem->id }}">
                                                    <input type="radio" name="maid_id" id="maid_{{ $attributeItem->id }}" value="{{ $attributeItem->id }}" 
                                                        data-attribute-item-id="{{ $attributeItem->attribute_item_id }}" 
                                                        data-sub-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->sub_category_id }}" 
                                                        data-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->category_id }}" 
                                                        data-child-category-id="{{ App\ServiceAttributeValueItem::where('id', $attributeItem->ser_attr_val_item_id)->first()->child_category_id }}"
                                                        onclick="collectAttributesData()"
                                                        
                                                        {{ $selectedAttributeItemId == $attributeItem->attribute_item_id || (!$selectedAttributeItemId && $loop->first) ? 'checked' : '' }}> 
                                                    <span class="control__content">
                                                        <i class="fal fa-check"></i> {{ $attributeItem->attributeItem->value }}
                                                    </span>
                                                </label>
                                            </li>
                                        @endforeach
                                    </ul>


                                    </div>
                                </div>


                                <input type="hidden" name="item_object" id="item_object">
                                
                                <script>
                                var slopt_options = '';
                                    function toggleAllSessionsSameTime(checkbox) {
                                        const sessionDates = document.querySelectorAll(".session-date");
                                        const sessionTimes = document.querySelectorAll(".session-time");

                                        if (checkbox.checked) {
                                            // Set all dates and times to match the first session
                                            const firstDate = sessionDates[0].value;
                                            const firstTime = sessionTimes[0].value;

                                            sessionTimes.forEach((select, index) => {
                                                if (index !== 0) select.value = firstTime;
                                            });
                                        } else {

                                            sessionTimes.forEach((select, index) => {
                                                if (index !== 0) select.selectedIndex = 0;
                                            });
                                        }
                                    }
                                    jQuery(document).ready(function(){
                                        const dropdown2 = document.querySelector(`select[name="hidden-time-slots"]`);
                                    })
                                    
                                    function updateTimeOptions(dateInput, dropdownId) {
                                        console.log(dropdownId);
                                        const selectedDate = new Date(dateInput.value); // Get selected date
                                        const today = new Date(); // Get today's date
                                        
                                        const selectedDateOnly = new Date(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());
                                        const todayOnly = new Date(today.getFullYear(), today.getMonth(), today.getDate());
                                        today.setHours(today.getHours() + 2);
                                        const currentTime = today.toTimeString().split(' ')[0]; // Get current time in HH:mm:ss format
                                        //const isToday = selectedDate.toISOString() === today.toISOString(); // Check if the selected date is today
                                        const isToday = selectedDateOnly.getTime() === todayOnly.getTime(); 
                                            console.log(isToday);
                                        // Get the dropdown
                                        let dropdown = document.querySelector(`select[name="${dropdownId}"]`);
                                        
                                        if (dropdown) { // Ensure dropdown exists
                                            dropdown.querySelectorAll('option').forEach(option => {
                                                console.log("option",option);
                                                const slotTime = option.getAttribute('data-time'); // Get the check-in time
                                                 if (isToday && slotTime) {
                                                    // Convert both slotTime and currentTime to Date objects for comparison
                                                    const slotDateTime = new Date(`${today.toDateString()} ${slotTime}`);
                                                    const currentDateTime = new Date(`${today.toDateString()} ${currentTime}`);
                                    
                                                    console.log("Checking slotTime:", slotTime, "Parsed:", slotDateTime, "Against:", currentDateTime);
                                    
                                                    if (slotDateTime <= currentDateTime) {
                                                        console.log("Disabling:", option);
                                                        option.disabled = true;
                                                    } else {
                                                        option.disabled = false;
                                                    }
                                                } else {
                                                    option.disabled = false;
                                                }
                                            });
                                        }
                                        
                                        let options = Array.from(dropdown.options); // Convert options to an array for easier manipulation
                                            console.log(options);
                                        // Clear the dropdown except the first placeholder option
                                        //const placeholderOption = options[0];
                                        //console.log(placeholderOption);
                                        //dropdown.innerHTML = '';
                                        //dropdown.appendChild(placeholderOption);
                                        // Add back only valid options
                                        // options.slice(1).forEach(option => {
                                        //     const slotTime = option.getAttribute('data-time'); // Get the check-in time
                                        //     // console.log(option);
                                        //     // console.log(currentTime);
                                        //     //  console.log(dropdownId);
                                        //     if(isToday){
                                        //         console.log("im here",slotTime);
                                        //         console.log("currentTime",currentTime);
                                        //         if (slotTime >= currentTime) {
                                        //             console.log("im here 2");
                                        //             option.setAttribute('disabled', 'disabled');
                                        //             dropdown.appendChild(option); // Add valid options back to the dropdown
                                        //         }
                                        //     }else{
                                        //         console.log(dropdownId);
                                        //          dropdown.appendChild(option);
                                        //     }
                                            
                                        // });

                                        
                                    }

                                    function collectAttributesData(amount = 0, packageId = null, totalSessions = null, freeSessions = null, perWeek = null) {
                                        
                                        if(packageId != null){
                                            
                                            let now = new Date();
                                            let today = now.toISOString().split("T")[0];
                                            
                                            // Check if the current time is past 6:30 PM
                                            if (now.getHours() > 18 || (now.getHours() === 18 && now.getMinutes() >= 30)) {
                                               // now.setDate(now.getDate() + 1); // Move to tomorrow
                                            }
                                            
                                            let minDate = now.toISOString().split("T")[0];


                                            const totalSessionsCount = totalSessions + freeSessions; // Total sessions including free ones
                                            const dynamicSessionsContainer = document.getElementById("dynamic-sessions");
                                            const dynamicHeading = document.getElementById("dynamic-heading");
                                            if(totalSessions == 1){
                                                dynamicHeading.innerHTML = `
                                                    <h3 class="fs-3 mb-0 text-start">One Time Booking</h3>
                                                `;
                                            }else{
                                                dynamicHeading.innerHTML = `
                                                    <h3 class="fs-3 mb-0 text-start">${totalSessions} sessions + ${freeSessions} free</h3>
                                                `;
                                            }
                                            // Clear previous sessions
                                            dynamicSessionsContainer.innerHTML = "";

                                            // Create session elements dynamically
                                            for (let i = 1; i <= totalSessionsCount; i++) {
                                                const sessionHTML = `
                                                    <div class="row mb-10">
                                                        <div class="col-12 mb-20 d-flex justify-content-between">
                                                            <h5 class="fs-5 mb-0 text-start">Session ${(i == 1 && totalSessionsCount == 1) ? '' : i}</h5>
                                                            ${(i === 1 && totalSessionsCount != 1) ? `
                                                            <div class="form-check">
                                                                <input class="form-check-input allSessionsSameTime" type="checkbox" id="allSessionsSameTime" onchange="toggleAllSessionsSameTime(this)">
                                                                <label class="form-check-label" for="allSessionsSameTime">
                                                                    All sessions same time
                                                                </label>
                                                            </div>` : ""}
                                                        </div>
                                                        <div class="col-6 mb-3">
                                                            <input type="date" 
                                                                class="form-control form-input-1 session-date" 
                                                                value="{{$maid_slot_date}}"
                                                                name="date${i}" 
                                                                onchange="updateTimeOptions(this, 'time${i}')"
                                                                placeholder="Session date" 
                                                                min="${minDate}"
                                                            />
                                                        </div>
                                                        <div class="col-6 mb-3">
                                                            <select class="form-select session-time" name="time${i}" required>
                                                                <option disabled selected >Session Times</option>
                                                                @foreach($slots as $index => $slot)
                                                                    <option @if($maid_slot_id == $slot->id) selected @endif value="{{ $slot->id }}" data-time="{{ $slot->check_in }}">{{ $slot->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                `;


                                                dynamicSessionsContainer.innerHTML += sessionHTML;
                                            }
                                        }

                                        const itemObjects = [];

                                        // Get selected maid attribute
                                        const maidSelected = document.querySelector('input[name="maid_id"]:checked');
                                        if (maidSelected) {
                                            itemObjects.push({
                                                attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
                                                attribute_qty: 1,
                                                sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
                                                category_id: maidSelected.getAttribute('data-category-id'),
                                                child_category: maidSelected.getAttribute('data-child-category-id')
                                            });
                                        } 
                                        
                                        if(maidSelected.getAttribute('value') == 1489){
                                            jQuery('.maid-item-1').addClass("d-none");
                                            if(document.querySelector('input[name="hour_id"]:checked').getAttribute('value')  == 1723){
                                              jQuery('.maid-item-2').find('[name="hour_id"]').prop("checked", true);
                                            }
                                        }else{
                                            jQuery('.maid-item-1').removeClass("d-none");
                                        }

                                        // Get selected hour attribute
                                        const hourSelected = document.querySelector('input[name="hour_id"]:checked');
                                        
                                        if (hourSelected) {
                                            itemObjects.push({
                                                attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
                                                attribute_qty: 1,
                                                sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
                                                category_id: hourSelected.getAttribute('data-category-id'),
                                                child_category: hourSelected.getAttribute('data-child-category-id')
                                            });
                                        }

                                        // Convert the itemObjects array to JSON and store it in the hidden input
                                        document.getElementById('item_object').value = JSON.stringify(itemObjects);
                                        
                                        submitForm();
                                    }
                                </script>

                                    @if($service->material_status=='True')
                                        <div class="row mb-30">
                                            <div class="col-12 mb-20">
                                                <h3 class="fs-5 mb-0">Would you like us to bring cleaning materials?</h3>
                                            </div>
                                            <div class="col-12">
                                            <ul class="selector">
                                                <?php
                                                    // Fetch the card with the necessary conditions
                                                    $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                        ->where('service_id', $service->id)
                                                        ->where('status', 'Pending')
                                                        ->where('payment_collected', 'No')
                                                        ->where('work_done', 'No')
                                                        ->where('is_checkout', 'Processing')
                                                        ->orderBy('id', 'DESC')
                                                        ->first();

                                                    // Check if material charge is applied
                                                    $materialApplied = $card_info && (float) $card_info->material_charge > 0;
                                                ?>
                                                <li>
                                                    <label class="control" for="yes">
                                                        <input type="radio" name="yenno" id="yes" 
                                                            onclick="setMaterialStatus('Apply')" 
                                                            {{ $materialApplied ? 'checked' : '' }}>
                                                        <span class="control__content">
                                                            <i class="fal fa-check"></i> Yes
                                                        </span>
                                                    </label>
                                                </li>
                                                <li>
                                                    <label class="control" for="no">
                                                        <input type="radio" name="yenno" id="no" 
                                                            onclick="setMaterialStatus({{ !$materialApplied ? 'yes' : 'no' }})" 
                                                            {{ !$materialApplied ? 'checked' : '' }}>
                                                        <span class="control__content">
                                                            <i class="fal fa-check"></i> No
                                                        </span>
                                                    </label>
                                                </li>
                                            </ul>


                                                <input type="hidden" name="material_status" id="material_status" value="{{ !$materialApplied ? 'yes' : 'no' }}">

                                                <input type="hidden" name="service_id" id="service_id" value="{{$service->id}}">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="row mb-30">
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-5 mb-0">Want to share important information/details?</h3>
                                        </div>
                                        <div class="col-12">
                                            <textarea name="note" id="note" placeholder="Enter here">{{ App\Card::where('user_id', \Session::get('user_id'))->where('service_id', $service->id)->where('status', 'Pending')->where('payment_collected', 'No')->where('work_done', 'No')->first()->note ?? '' }}</textarea>
                                        </div>
                                    </div>

                                    @if($service->id == 10)
                                        <div class="row mb-30">
                                            <div class="col-12 mb-20">
                                                <h3 class="fs-5 mb-0">Select Your Package</h3>
                                            </div>
                                            
                                            <div class="col-12">
                                                <ul class="selector package-selector" id="package-holder">
                                                    
                                                    {{view('web.inc_package_list',['packages'=>$packages,'card_info'=>$card_info,'selected_package_id'=>$card_info->selected_packages??11])}}
                                                    
                                                </ul>
                                                <script>
                                                        document.addEventListener("DOMContentLoaded", function () {
                                                            
                                                                @if ($packages->isNotEmpty())
                                                                    collectAttributesData(
                                                                        {{ $packages[3]->amount }},
                                                                        {{ $packages[3]->id }},
                                                                        {{ $packages[3]->total_sessions ?? 0 }},
                                                                        {{ $packages[3]->free_sessions ?? 0 }},
                                                                        {{ $packages[3]->per_week ?? 1 }}
                                                                    );
                                                                @endif
                                                                
                                                        });
                                                    </script>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            @endif	
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="sidebar"  id="sticky-side">
                            <div class="card mb-20 card-body">
                                <h5 class="card-header fs-5 mb-2 text-start border border-0">Summary details</h5>
                                <div class="summary-cards"></div>
                                <div class="summary-cards-maid">
                                    <div class="base_price">
                                        <div class="d-flex justify-content-between gap-2 border-bottom rounded-0">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-quantity">0</span> (AED <span class="summary-service-single-price">0.00</span>x<span class="summary-service-quantity">0</span>)</h4>
                                            <h4 class="text-end mb-1 fs-6 fw-medium" style="white-space: nowrap;">AED <span class="summary-service-sub-total-maids">0.00</span></h4>
                                        </div>
                                        <div class="d-flex justify-content-between gap-2">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-hours">0</span> (AED <span class="summary-service-sub-total-maids">0.00</span>x<span class="summary-service-hours">0</span>) </h4>
                                            <h4 class="text-end mb-1 fs-6 fw-medium" style="white-space: nowrap;">AED <span class="summary-service-sub-total">0.00</span></h4>
                                        </div>
                                    </div>

                                        <?php 
                                            $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                                ->where('service_id', $service->id)
                                                                ->where('status', 'Pending')
                                                                ->where('payment_collected', 'No')
                                                                ->where('work_done', 'No')
                                                                ->where('is_checkout', 'Processing')
                                                                ->orderBy('id', 'DESC')
                                                                ->first(); 
                                            $material_charge = $card_info->material_charge ?? 0;
                                            $material_status = $card_info->material_status ?? "";
                                        ?>

                                        <div class="packageActiveShow" style="display: {{ (optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? '0') == '0' ? 'none' : 'block' }} !important;">
                                            <div class="d-flex justify-content-between gap-2 border-bottom rounded-0">
                                                <h4 class="mb-1 fs-6 text-start pe-3"><span class="summary-selected-sessions">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->total_sessions ?? "0" }} session + 
                                                </span> <span class="summary-free-sessions">0 free</span> - <span class="summary-service-quantity">0</span> x <span class="summary-service-hours">0</span></h4>
                                                <h4 class="text-end mb-1 fs-6 fw-medium" style="white-space: nowrap;">AED <span class="summary-selected-sessions-sub-total">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? "0" }}</span></h4>
                                                
                                            </div>
                                            
                                        </div>

                                        <div class="d-flex justify-content-between gap-2 summary-material-price-status {{ $material_status == 'Apply' ? '' : 'd-none' }} border-bottom py-2  rounded-0">
                                            <h4 class="mb-0 fs-6 pe-3">Material Price</h4>
                                            <h4 class="text-end mb-0 fs-6 fw-medium" style="white-space: nowrap;">AED <span class="summary-material-price">{{ $material_charge }}</span></h4>
                                        </div>

                                    </div>
                                <div class="d-flex justify-content-between gap-2 mt-2">
                                    @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)
                                        <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>
                              
                                       <h4 class="mb-0 fs-4 fw-600 pe-3">Total Amount</h4>
                                       <h4 class="text-end mb-0 fs-4 text-secondary fw-bold updated-price fw-medium" style="white-space: nowrap;">AED {{$card_info?(float)$card_info->g_total-(float)$card_info->coupon_amt+(float)$card_info->tip_id:''}}</h4>
                                        <?php $cart_val = $card_info->g_total ?? "0"; ?>
                                    @else
                                        <?php $cart_val = '0'; ?>
                                        <h4 class="mb-0 fs-4 fw-600  pe-3">Total</h4>
                                        <h4 class="text-end mb-0 fs-4 text-secondary fw-bold updated-price fw-medium" style="white-space: nowrap;">AED {{$cart_val}}</h4>
                                    @endif
                                </div>
                                
                                
                                    
                                    
                                </div>
                                @auth 
                                    <input type="button" name="next" class="next action-button w-100" id="first_btn" onclick="move('location')" value="Proceed" @if($cart_val <= 0) disabled @endif>
                                @else
                                    <input type="button" name="next" data-bs-toggle="modal" data-bs-target="#loginModal" class="next action-button w-100" onclick="move('location')" value="Proceed">
                                @endauth
                            </div>
                            </div>
                        </div>

                            
                            <!-- <style>
                                .bottom-bar-main{
                                    display: none;
                                }
                            </style>
                            <div class="action-bar-btm fixed-bottom bg-white ">
                                <div class="container d-flex justify-content-between">
                                    <div>
                                        @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)
                                            <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>
                                
                                        <h6 class="mb-0 fs-6 fw-600">Total Amount</h6>
                                        <h4 class="mb-0 fs-4 fw-bold text-secondary fw-600 updated-price">AED {{$card_info?$card_info->g_total:''}}</h4>
                                            <?php $cart_val = $card_info->g_total ?? "0"; ?>
                                        @else
                                            <?php $cart_val = '0'; ?>
                                            <h6 class="mb-0 fs-6 fw-600">Total</h6>
                                            <h4 class="mb-0 fw-bold fs-4 text-secondary fw-600 updated-price">AED {{$cart_val}}</h4>
                                        @endif
                                    </div>
                                    <button type="button" name="next" class="next action-button float-none" onclick="move('location')">Proceed</button>
                                </div>
                            </div> -->
                        </fieldset>

                        <fieldset class="location sticky-wrapper">
                            
                        <div class="row">
                            <div class="col-lg-8">
                            <div class="content">
                            <div class="form-card">
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <div class="d-flex gap-2 justify-content-between align-items-center">
                                            <h3 class="fs-5 mb-0">Location</h3>
                                            <a href="#!" class="btn btn-2" data-bs-toggle="modal" data-bs-target="#changelocation">Add or Change Location</a>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                
                                                @php
                                                    $activeAddresses = App\Address::where(['is_active' => 1, 'user_id' => auth()->id()])->count();
                                                    $activeAddress = App\Address::where(['is_active' => 1, 'user_id' => auth()->id()])->first();
                                                @endphp
                                                <h6 id="user-address-type" data-address="{{ ucfirst($activeAddress->address_type ?? '-') }}">
                                                    {{ ucfirst($activeAddress->address_type ?? '-') }}
                                                </h6>
                                                <h5 class="mb-0 fs-5" id="user-address" data-address="{{ $activeAddress->id ?? '-' }}">
                                                    {{ trim($activeAddress->flat_no ?? '') }}, 
                                                    {{ trim($activeAddress->building ?? '') }} - 
                                                    {{ trim($activeAddress->city->name ?? 'N/A') }}, 
                                                    {{ trim($activeAddress->locality_info->name ?? 'N/A') }}
                                                </h5>
                                                <div class="col-12 text-center mt-50 mb-50 empty-location">
                                                    <div class="row justify-content-center">
                                                        <div class="col-8 col-lg-6">
                                                            <div class="no-results-div">
                                                                <img src="{{ asset('images/no-locations.png') }}" class="img-fluid mb-3">
                                                                <h3 class="fs-5">No location found</h3>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <script>
                                                    document.addEventListener('DOMContentLoaded', function () {
                                                        let activeAddressCount = {{ $activeAddresses }};
                                                        activeAddressCount = Number(activeAddressCount);

                                                        if (activeAddressCount === 0) {
                                                            document.getElementById('user-address-type').style.display = "none";
                                                            document.getElementById('user-address').style.display = "none";
                                                            document.querySelector('.empty-location').style.display = "block";
                                                        } else {
                                                            document.getElementById('user-address-type').style.display = "block";
                                                            document.getElementById('user-address').style.display = "block";
                                                            document.querySelector('.empty-location').style.display = "none";
                                                        }
                                                    });
                                                </script>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-5 mb-0">Contact Details</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Name</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->name }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Mobile Number</h4>
                                                    @auth
														<h4 class="text-end mb-0 fs-5 ">+{{ ltrim(auth()->user()->dial_code ?? '971', '+') }} {{ auth()->user()->phone }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Email Address</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->email ?? "N/A" }}</h4>
													@else
														N/A
													@endauth
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-5 mb-0 text-start">Want to add an alternative number?</h3>
                                    </div>
                                    <!-- Include CSS for intl-tel-input (v24.6.0) -->
                                    <link rel="stylesheet" 
                                    href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
                                    integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
                                    crossorigin="anonymous" referrerpolicy="no-referrer" />


                                    <div class="form-group col-lg-6 mobile-no-area-wrap">
                                        <p class="numbererror error"></p>
                                        <div class="input-group">
                                            <!-- Dial Code Input with Flag -->
                                            <div class="input-group-prepend">
                                                <input type="hidden" name="dial_code" id="dial-code" 
                                                    class="form-control" value="+{{ ltrim(auth()->user()->dial_code ?? '971', '+') }}" 
                                                    required style="width:120px; text-align: center;">
                                            </div>

                                            <!-- Phone Number Input -->
                                            <input type="text" id="phone-number" class="form-control" name="phone" placeholder="Enter phone number" required="" maxlength="12" oninput="this.value = this.value.replace(/[^0-9]/g, '');" value="{{auth()->user()->phone ?? ''}}">

                                        </div>
                                    </div>

                                    <!-- Include JS for intl-tel-input (v24.6.0) -->
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
                                            integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
                                            crossorigin="anonymous" referrerpolicy="no-referrer"></script>

                                    <script>
                                        // Initialize intl-tel-input within an IIFE to avoid redeclaration errors
                                        (function() {
                                            const dialCodeInput = document.querySelector("#dial-code");

                                            const iti = intlTelInput(dialCodeInput, {
                                                initialCountry: "AE",            // Automatically detect the user's country
                                                separateDialCode: false,            // Display only the dial code in the input
                                                autoPlaceholder: "polite",         // Use a smart placeholder
                                                // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js", // Required for formatting
                                            });

                                            // Handle the country change event (optional)
                                            dialCodeInput.addEventListener("countrychange", function() {
                                                const countryData = iti.getSelectedCountryData();
                                                console.log(`Selected country: ${countryData.name}, Dial Code: ${countryData.dialCode}`);
                                            });
                                        })();
                                    </script>
                                    <div class="col-lg-6"></div>
                            </div>
                        </div>
                        </div>
                        <div class="col-lg-4">

                        <div class="sidebar"  id="sticky-side">
                            <div class="mb-30 card card-body">
                                <h5 class="card-header fs-5 mb-2 text-start border border-0">Summary details</h5>
                                <div class="summary-cards"></div>
                                <div class="summary-cards-maid">
                                    <div class="base_price">
                                        <div class="d-flex justify-content-between gap-2  border-bottom rounded-0">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-quantity">0</span> (AED <span class="summary-service-single-price">0.00</span>x<span class="summary-service-quantity">0</span>)</h4>
                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total-maids">0.00</span></h4>
                                        </div>
                                        <div class="d-flex justify-content-between gap-2 ">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-hours">0</span> (AED <span class="summary-service-sub-total-maids">0.00</span>x<span class="summary-service-hours">0</span>) </h4>
                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total">0.00</span></h4>
                                        </div>
                                    </div>
                                        
                                        <div class="packageActiveShow" style="display: {{ (optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? '0') == '0' ? 'none' : 'block' }} !important;">
                                            
                                            <div class="d-flex justify-content-between gap-2  border-bottom rounded-0">
                                                <h4 class="mb-1 fs-6 text-start pe-3"><span class="summary-selected-sessions">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->total_sessions ?? "0" }}
                                                session +</span> <span class="summary-free-sessions">0 free</span> - <span class="summary-service-quantity">0</span> x <span class="summary-service-hours">0</span></h4>
                                                <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-selected-sessions-sub-total">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? "0" }}</span></h4>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-between gap-2 d-none summary-material-price-status border-bottom py-2  rounded-0">
                                            <h4 class="mb-0 fs-6 pe-3">Material Price</h4>
                                            <h4 class="text-end mb-0 fs-6" style="white-space: nowrap;">AED <span class="summary-material-price">0.00</span></h4>
                                        </div>
                                    </div>
                                <!--<div class="text-end">-->
                                <!--    @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)-->
                                <!--        <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>-->
                                <!--        <h5 class="mb-0 fs-5 updated-price">AED {{$card_info?$card_info->g_total:''}}</h5>-->
                                <!--        <h6 class="fs-6 text-muted">Total Amount</h6>-->
                                <!--        <?php $cart_val = $card_info->g_total ?? "0"; ?>-->
                                <!--    @else-->
                                <!--        <?php $cart_val = '0'; ?>-->
                                <!--        <h5 class="mb-0 fs-5 updated-price">AED {{$cart_val}}</h5>-->
                                <!--        <h6 class="fs-6 text-muted">Total Amount</h6>-->
                                <!--    @endif-->
                                <!--</div>-->
                                
                                <div class="d-flex justify-content-between gap-2 mt-2">
                                     @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)
                                        <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>
                                       <h4 class="mb-0 fs-4 fw-600 pe-3">Total Amount</h4>
                                       <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$card_info?(float)$card_info->g_total-(float)$card_info->coupon_amt+(float)$card_info->tip_id:''}}</h4>
                                        <?php $cart_val = $card_info->g_total ?? "0"; ?>
                                    @else
                                        <?php $cart_val = '0'; ?>
                                        <h4 class="mb-0 fs-4 fw-600 pe-3">Total</h4>
                                        <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$cart_val}}</h4>
                                    @endif
                                </div>
                                
                                
                            </div>
                            <div class="d-flex align-items-center justify-content-between">
                               <input type="button" name="previous" class="previous action-button-previous w-100 me-3" onclick="move('selection')" value="Previous" />
                               <input type="button" name="next" class="next action-button w-100" onclick="move('choose_time')" value="Next">
                            </div>
                            </div>
                            </div>
                        </div>

                        </fieldset>

                        <fieldset class="choose_time sticky-wrapper">
                            <div class="row">
                                <div class="col-lg-8">
                                <div class="content">
                            <div class="form-card">
                               <select class="form-select d-none" name="hidden-time-slots" >
                                    <option disabled selected >Session Times</option>
                                    @foreach($slots as $index => $slot)
                                        <option @if($maid_slot_id == $slot->id) selected @endif value="{{ $slot->id }}" data-time="{{ $slot->check_in }}">{{ $slot->name }}</option>
                                    @endforeach
                                </select>
                                @if($service->id == 10)
                                    <div id="dynamic-heading" class="col-12 mb-20">
                                        <!-- Dynamic content will be injected here -->
                                    </div>

                                    <div id="dynamic-sessions"></div>
                                @endif

                                <div class="row mb-30">
                                    <!-- @if($service->id == 10)
                                        <div class="show_days">
                                            <div class="col-12 mb-20">
                                                <h3 class="fs-3 mb-0 text-start">Select <span class="per_week">2</span> Preferred Days</h3>
                                            </div>
                                            <div class="col-12 mb-20">
                                                <ul class="selector" id="preferred-days-list">
                                                </ul>
                                            </div>
                                        </div>
                                    @endif -->

                                    @if($service->id != 10)
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-5 mb-0 text-start">Choose Date</h3>
                                        </div>
                                        <div class="col-12 mb-3">
                                            <input type="date" 
                                            id="date-picker" 
                                            class="form-control" 
                                            onclick="this.showPicker()"
                                            name="date"
                                            value="{{ optional(App\Card::where('user_id', \Session::get('user_id'))
                                                                ->where('service_id', $service->id)
                                                                ->where('status', 'Pending')
                                                                ->where('payment_collected', 'No')
                                                                ->where('work_done', 'No')
                                                                ->orderBy('id', 'DESC')
                                                                ->first())->date ? \Carbon\Carbon::parse(optional(App\Card::where('user_id', \Session::get('user_id'))
                                                                ->where('service_id', $service->id)
                                                                ->where('status', 'Pending')
                                                                ->where('payment_collected', 'No')
                                                                ->where('work_done', 'No')
                                                                ->orderBy('id', 'DESC')
                                                                ->first())->date)->format('d-m-Y') : now()->format('d-m-Y') }}" 
                                            min="{{ now()->format('d-m-Y') }}" />

                                        </div>
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-5 mb-0 text-start">Choose Time Slot</h3>
                                        </div>
                                        <div class="col-12">
                                            <ul class="selector mb-3" id="time-slots-list">
                                                <!-- Time slots will be dynamically loaded here -->
                                            </ul>
                                        </div>
                                        <?php
                                            // Fetch the card with the necessary conditions
                                            $card_info = App\Card::where('user_id', \Session::get('user_id'))
                                                ->where('service_id', $service->id)
                                                ->where('status', 'Pending')
                                                ->where('payment_collected', 'No')
                                                ->where('work_done', 'No')
                                                ->where('is_checkout', 'Processing')
                                                ->orderBy('id', 'DESC')
                                                ->first();

                                            // Check if material charge is applied
                                            $is_revisit = $card_info->is_revisit ?? null;
                                        ?>
                                        @if($service->id == 13)
                                        <div class="col-12 mb-20">
                                            <h3 class="fs-5 mb-0 text-start">Do you need revisit?</h3>
                                        </div>
                                        <div class="col-12">
                                            <ul class="selector">
                                                <li>
                                                    <label class="control" for="is_revisit_yes">
                                                        <input type="radio" name="is_revisit" {{ $is_revisit == null || $is_revisit ? 'checked' : '' }} id="is_revisit_yes" value="1">
                                                        <span class="control__content">
                                                            <i class="fal fa-check"></i> Yes
                                                        </span>
                                                    </label>
                                                </li>
                                                <li>
                                                    <label class="control" for="is_revisit_no">
                                                        <input type="radio" name="is_revisit" {{ $is_revisit != null ? 'checked' : '' }} id="is_revisit_no" value="0">
                                                        <span class="control__content">
                                                            <i class="fal fa-check"></i> No
                                                        </span>
                                                    </label>
                                                </li>
                                            </ul>
                                        </div>

                                        @endif

                                    @endif


                                </div>
                                
                            </div>
                            </div>
                            </div>

                            <div class="col-lg-4">
                            <div class="sidebar"  id="sticky-side">
                            <div class="mb-30 card card-body">
                            <h5 class="card-header fs-5 mb-2 text-start border border-0">Summary details</h5>
                                <div class="summary-cards"></div>
                                <div class="summary-cards-maid">
                                    <div class="base_price">
                                        <div class="d-flex justify-content-between gap-2  border-bottom rounded-0">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-quantity">0</span> (AED <span class="summary-service-single-price">0.00</span>x<span class="summary-service-quantity">0</span>)</h4>
                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total-maids">0.00</span></h4>
                                        </div>
                                        <div class="d-flex justify-content-between gap-2 ">
                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-hours">0</span> (AED <span class="summary-service-sub-total-maids">0.00</span>x<span class="summary-service-hours">0</span>) </h4>
                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total">0.00</span></h4>
                                        </div>
                                    </div>
                                    
                                    <div class="packageActiveShow" style="display: {{ (optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? '0') == '0' ? 'none' : 'block' }} !important;">     
                                        <div class="d-flex justify-content-between gap-2  border-bottom rounded-0">
                                            <h4 class="mb-1 fs-6 text-start pe-3"><span class="summary-selected-sessions">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->total_sessions ?? "0" }}
                                            session +</span> <span class="summary-free-sessions">0 free</span> - <span class="summary-service-quantity">0</span> x <span class="summary-service-hours">0</span></h4>
                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-selected-sessions-sub-total">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? "0" }}</span></h4>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between gap-2 d-none summary-material-price-status border-bottom py-2  rounded-0">
                                        <h4 class="mb-0 fs-6 pe-3">Material Price</h4>
                                        <h4 class="text-end mb-0 fs-6" style="white-space: nowrap;">AED <span class="summary-material-price">0.00</span></h4>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between gap-2 mt-2">
                                    @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)
                                    <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>
                                    <h4 class="mb-0 fs-4 fw-600 pe-3">Total Amount</h4>
                                    <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$card_info?(float)$card_info->g_total-(float)$card_info->coupon_amt+(float)$card_info->tip_id:''}}</h4>
                                        <?php $cart_val = $card_info->g_total ?? "0"; ?>
                                    @else
                                        <?php $cart_val = '0'; ?>
                                        <h4 class="mb-0 fs-4 fw-600 pe-3">Total</h4>
                                        <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$cart_val}}</h4>
                                    @endif
                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-between">
                                <input type="button" name="previous" class="previous action-button-previous w-100 me-3" onclick="move('location')" value="Previous" />
                                <input type="button" name="next" class="next action-button w-100" onclick="move('payment')" value="Next">
                            </div>

                            </div>
                            </div>

                            </div>
                        </fieldset>

                        <fieldset class="payment sticky-wrapper">
                            <div class="row">
                                <div class="col-lg-8">
                                <div class="content">
                            <div class="form-card">

                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-5 mb-0">Location</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h6 id="user-address-edit-type" data-address="@auth
                                                        {{ ucfirst(App\Address::where(['is_active' => 1, 'user_id' => auth()->user()->id])->first()->address_type ?? '-') }}
                                                    @else
                                                        -
                                                    @endauth"> @auth
                                                        {{ ucfirst(App\Address::where(['is_active' => 1, 'user_id' => auth()->user()->id])->first()->address_type ?? '-') }} 
                                                    @else
                                                        -
                                                    @endauth</h6>
                                                <h5 class="mb-0 fs-5" id="user-address-edit" data-address="{{ $activeAddress->id ?? '-' }}">
                                                    {{ trim($activeAddress->flat_no ?? '') }}, 
                                                    {{ trim($activeAddress->building ?? '') }} - 
                                                    {{ trim($activeAddress->city->name ?? 'N/A') }}, 
                                                    {{ trim($activeAddress->locality_info->name ?? 'N/A') }}
                                                </h5>
											</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-30">
                                    <div class="col-12 mb-20">
                                        <h3 class="fs-5 mb-0">Contact Details</h3>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
												<div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Name</h4>
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->name }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Mobile Number</h4>
                                                    
													@auth
                                                    	<h4 class="text-end mb-0 fs-5 ">+{{ ltrim(auth()->user()->dial_code ?? '971', '+') }} {{ auth()->user()->phone }}</h4>
													@else
														-
													@endauth
												</div>
                                                <hr>
                                                <div class="d-flex justify-content-between gap-2">
                                                    <h4 class="mb-0 fs-5">Email Address</h4>
													
													@auth
                                                    	<h4 class="text-end mb-0 fs-5">{{ auth()->user()->email ?? "N/A" }}</h4>
													@else
                                                        N/A
													@endauth
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>

                            </div>
                            <div class="col-lg-4">

                            <div class="sidebar"  id="sticky-side">
                                <div class="row mb-30">
                                    <div class="col-12">
                                        <div class="card">
											<div class="card-body" id="summary-card">
                                            <h5 class="card-header fs-5 mb-2 text-start border border-0">Summary details</h5>
                                                <div class="summary-cards"></div>
                                                <div class="summary-cards-maid">
                                                    <div class="base_price">
                                                        <div class="d-flex justify-content-between gap-2  border-bottom rounded-0">
                                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-quantity">0</span> (AED <span class="summary-service-single-price">0.00</span>x<span class="summary-service-quantity">0</span>)</h4>
                                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total-maids">0.00</span></h4>
                                                        </div>
                                                        <div class="d-flex justify-content-between gap-2 ">
                                                            <h4 class="mb-1 fs-6 pe-3"><span class="summary-service-hours">0</span> (AED <span class="summary-service-sub-total-maids">0.00</span>x<span class="summary-service-hours">0</span>) </h4>
                                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-service-sub-total">0.00</span></h4>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="packageActiveShow" style="display: {{ (optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? '0') == '0' ? 'none' : 'block' }} !important;">
                                                        <div class="d-flex justify-content-between gap-2 border-bottom rounded-0">
                                                            <h4 class="mb-1 fs-6 text-start pe-3"><span class="summary-selected-sessions">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->total_sessions ?? "0" }}
                                                            session +</span> <span class="summary-free-sessions">0 free</span> - <span class="summary-service-quantity">0</span> x <span class="summary-service-hours">0</span> </h4>
                                                            <h4 class="text-end mb-1 fs-6" style="white-space: nowrap;">AED <span class="summary-selected-sessions-sub-total">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? "0" }}</span></h4>
                                                        </div>
                                                    </div>

                                                    <!-- <div class="d-flex justify-content-between gap-2">
                                                        <h4 class="mb-1 fs-5">Selected Slot (<span class="summary-selected-sessions">{{ (string) optional(App\Packages::find(optional($card_info)->selected_packages))->total_sessions ?? "0" }}
                                                        </span> Session) </h4>
                                                        <h4 class="text-end mb-1 fs-5">AED <span class="summary-selected-sessions-sub-total">0.00</span></h4>
                                                    </div>
                                                    <div class="d-flex justify-content-between gap-2">
                                                        <h4 class="mb-1 fs-5">Free Session (<span class="summary-free-sessions">0</span> Session) </h4>
                                                        <h4 class="text-end mb-1 fs-5">- AED <span class="summary-free-sessions-sub-total">0.00</span></h4>
                                                    </div> -->

                                                    
                                                    <div class="d-flex justify-content-between gap-2 d-none summary-material-price-status border-bottom py-2  rounded-0">
                                                        <h4 class="mb-0 fs-6 pe-3">Material Price</h4>
                                                        <h4 class="text-end mb-0 fs-6" style="white-space: nowrap;">AED <span class="summary-material-price">0.00</span></h4>
                                                    </div>
                                                </div>
                                                
                                                    <div class="d-flex justify-content-between gap-2 mt-2 border-bottom  pb-2  rounded-0">
                                                        @if(App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count()>0)
                                                        <?php $card_info = App\Card::where('user_id',\Session::get('user_id'))->where('service_id',$service->id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first(); ?>
                                                        <h4 class="mb-0 fs-4 fw-600 pe-3">Total Amount</h4>
                                                        <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$card_info?(float)$card_info->g_total-(float)$card_info->coupon_amt+(float)$card_info->tip_id:''}}</h4>
                                                            <?php $cart_val = $card_info->g_total ?? "0"; ?>
                                                        @else
                                                            <?php $cart_val = '0'; ?>
                                                            <h4 class="mb-0 fs-4 fw-600 pe-3">Total</h4>
                                                            <h4 class="text-end mb-0 fs-4 text-secondary fw-600 updated-price" style="white-space: nowrap;">AED {{$cart_val}}</h4>
                                                        @endif
                                                    </div>
												<!-- <hr>
												<div class="d-flex justify-content-between gap-2">
													<h4 class="mb-0 fs-5">Days</h4>
													<h4 class="text-end mb-0 fs-5"><span id="summary-selected-days">N/A</span></h4>
												</div> -->
												<!-- <hr> -->
                                                @if($service->id != 10)
                                                    <div class="d-flex justify-content-between gap-2 border-top rounded-0 py-2">
                                                        <h4 class="mb-0 fs-5">Date</h4>
                                                        <h4 class="text-end mb-0 fs-5"><span id="summary-selected-date">N/A</span></h4>
                                                    </div>
                                                    <!-- <hr> -->
                                                    <div class="d-flex justify-content-between gap-2 border-top rounded-0 py-2">
                                                        <h4 class="mb-0 fs-5">Time</h4>
                                                        <h4 class="text-end mb-0 fs-5"><span id="summary-selected-time">N/A</span></h4>
                                                    </div>
                                                @else
                                                    <div id="session-summary" class="mt-4">
                                                        <!-- Dynamic session summaries will be appended here -->
                                                    </div>
                                                @endif

											</div>

                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between flex-column mt-2">

                                <a onclick="checkout(event)" class="btn btn-2 w-100">Proceed to Pay</a>
                                <div class="d-flex align-items-center w-100 mt-3">
                                    <input type="button" name="previous" class="previous action-button-previous w-100 me-3" onclick="move('choose_time')" value="Previous" />
                                    <a class="btn btn-1 w-100" onclick="addToCart(event)">Add to Cart</a>
                                </div>
								<!-- href="{{ route('cart.list') }}" -->
                            </div>

                            </div>
                            </div>
                            </div>
                        </fieldset>

                    </form>

                </div>
            </div>
        </div>
    </section>


<!-- Change Location Modal -->
<div class="modal fade" id="changelocation" tabindex="-1" aria-labelledby="changelocationLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fs-5" id="changelocationLabel">Change Location</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <div class="mb-3">
                        <a href="#!" class="btn btn-1 w-100" data-bs-toggle="modal" data-bs-target="#addressmodal" data-bs-dismiss="modal">Add New Location</a>
                    </div>
                    <div class="row" id="address-list">
                        <!-- Address list will be dynamically loaded here -->
                    </div>
                    <!-- <div class="col-12">
                        <button type="button" class="btn btn-1 w-100" data-bs-dismiss="modal">Proceed</button>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>

    var formData = {};
    formData['service_id'] = '{{$service->id}}';
    jQuery.ajax({
        headers: {
            'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('get.card.booking') }}",
        data: formData, 
        dataType: 'json',
        success: function (data) {
            const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";
            if(isCategoryYes) {
                console.log('Success Response:', data);
                jQuery('.summary-cards').html(data.modal_view_services);   
                jQuery('.summary-cards-maid').html("");  
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            alert('Error: Could not process the request.');
        }
    });


</script>

<!-- Confirmation Modal -->
<div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this address?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteButton">Yes, Delete</button>
            </div>
        </div>
    </div>
</div>


<!-- Add Address Modal -->
<div class="modal fade" id="addressmodal" tabindex="-1" aria-labelledby="addressmodalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fs-5" id="addressmodalLabel">Add/Edit Address</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
                <div class="modal-body">

                <form id="addAddressForm" method="POST">
                @csrf
                    <!-- Map Section -->
                    <input id="autocomplete" type="text" placeholder="Enter a location" style="width: 100%; padding: 8px; margin-bottom: 10px;">
                    <div id="add-map" style="height: 300px; width: 100%; margin-bottom: 20px;"></div>

                    <div class="row">
                        <!-- Hidden Address Field -->
                        <input type="hidden" name="address" id="selected-address">
                        <input type="hidden" name="latitude" id="latitude">
                        <input type="hidden" name="longitude" id="longitude">

                        <div class="col-lg-12 mb-20">
                            <p class="selected-map-address"></p>
                        </div>

                        <div class="col-lg-6 mb-3">
                            <input type="text" class="form-input-1" name="flat_no" placeholder="Flat No/Office No/Villa" required>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <input type="text" class="form-input-1" name="building" placeholder="Building name" required>
                        </div>
                        <div class="col-12 mb-3">
                            <select id="citySelect" class="form-input-1" name="city_id" required>
                                <option value="">Select Emirates</option>
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <select id="localitySelect" class="form-input-1" name="locality" required>
                                <option value="">Select Locality</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <ul class="selector">
                                <li>
                                    <label class="control" for="home">
                                        <input type="radio" name="address_type" value="Home" id="home" checked>
                                        <span class="control__content">
                                            <i class="fal fa-check"></i> Home
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="office">
                                        <input type="radio" name="address_type" value="Office" id="office">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i> Office
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="work">
                                        <input type="radio" name="address_type" value="Work" id="work">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i> Work
                                        </span>
                                    </label>
                                </li>
                            </ul>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-1 w-100">Save Address</button>
                        </div>
                    </div>
                </form>
                </div>
            
        </div>
    </div>
</div>

<!-- Edit Address Modal -->
<div class="modal fade" id="editAddressModal" tabindex="-1" aria-labelledby="editAddressModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fs-5" id="editAddressModalLabel">Edit Address</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editAddressForm" method="POST">
                    @csrf
                    <input type="hidden" name="edit_address_id" id="editAddressId"> 
                    <input type="hidden" name="address_edit" id="selected-address-edit">
                    <input type="hidden" name="edit_latitude" id="edit-latitude">
                    <input type="hidden" name="edit_longitude" id="edit-longitude">
                    
                        
                        <!-- Map Section -->
                        

                        <div class="row">

                            <div class="col-lg-12 mb-20">
                                <input id="autocompleteedit" type="text" placeholder="Enter a location" style="width: 100%; padding: 8px; margin-bottom: 10px;">
                                <div id="edit-map" style="height: 300px; width: 100%;"></div> 
                            </div>
                            <div class="col-lg-12 mb-20">
                                <p class="selected-map-address-edit mb-0"></p>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="flat_no" id="editFlatNo" placeholder="Flat No/Office No/Villa" required>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text" class="form-input-1" name="building" id="editBuilding" placeholder="Building name" required>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="editCitySelect" class="form-input-1" name="city_id" required>
                                    <option value="">Select Emirates</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <select id="editLocalitySelect" class="form-input-1" name="locality" required>
                                    <option value="">Select Locality</option>
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <ul class="selector">
                                    <li>
                                        <label class="control" for="editaddress_typeHome">
                                            <input type="radio" name="address_type" value="Home" id="editaddress_typeHome">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Home
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="editaddress_typeOffice">
                                            <input type="radio" name="address_type" value="Office" id="editaddress_typeOffice">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Office
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control" for="editaddress_typeWork">
                                            <input type="radio" name="address_type" value="Work" id="editaddress_typeWork">
                                            <span class="control__content">
                                                <i class="fal fa-check"></i> Work
                                            </span>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-1 w-100">Update Address</button>
                            </div>
                        </div>
                    
                </form>
            </div>
        </div>
    </div>
</div>	

<script>

function updateSessionSummary() {
    const sessionDates = document.querySelectorAll(".session-date");
    const sessionTimes = document.querySelectorAll(".session-time");
    const sessionSummaryContainer = document.getElementById("session-summary");

    // Clear previous summary
    sessionSummaryContainer.innerHTML = "";

    // Iterate through sessions and create summaries
    sessionDates.forEach((dateInput, index) => {
        const sessionNumber = index + 1;
        const dateValue = dateInput.value
        ? new Date(dateInput.value).toLocaleDateString('en-GB') // Format to dd-mm-yyyy
        : "N/A";
        const timeSelect = sessionTimes[index];
        const timeValue = timeSelect ? timeSelect.options[timeSelect.selectedIndex]?.text.trim() || "N/A" : "N/A"; // Ensure correct time display

        const sessionSummaryHTML = `
            <div class="session-summary-item mb-2">
                <div class="d-flex justify-content-between gap-2">
                    <h4 class="mb-0 fs-5">Session ${sessionNumber}</h4>
                    <h4 class="text-end mb-0 fs-5">${dateValue} - ${timeValue}</h4>
                </div>
                <hr>
            </div>
        `;

        sessionSummaryContainer.innerHTML += sessionSummaryHTML;
    });
}

// Add event listeners to update the summary dynamically
document.addEventListener("change", function (event) {
    if (event.target.classList.contains("session-date") || event.target.classList.contains("session-time") || event.target.classList.contains("allSessionsSameTime")) {
        updateSessionSummary();
    }
});


</script>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="timetoast" class="toast align-items-center text-bg-warning border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                Select your time slot!
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="preferred_days" class="toast align-items-center text-bg-warning border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                Select your preferred days!
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU&libraries=places&callback=initMap" async defer></script>
<script>

	// Function to update address list dynamically in the Change Location modal
	function updateAddressList() {
		fetch("{{ route('address.list') }}")
			.then(response => response.json())
			.then(data => {
				const addressContainer = document.querySelector('#changelocation .row');
				addressContainer.innerHTML = '';

				data.forEach(address => {
					const addressHtml = 
						`<div class="col-12 mb-3">
							<div class="address-box card position-relative">
								<div class="card-body">
									<label class="w-100">
										<input type="radio" name="address" value="${address.id}" id="add${address.id}">
										<div class="content text-start position-relative">
											<div class="d-flex align-items-center justify-content-between mb-2">
												<h6 class="mb-0 fs-6 fw-bold" style="max-width: 55%;">${address.address}</h6>
												<div class="address-box-action d-flex align-items-center gap-3">
													<a href="#" class="address-box-delete-btn fs-5">
														<i class="fal fa-trash-alt"></i> Delete
													</a>
													<a href="#" class="address-box-edit-btn fs-5">
														<i class="fal fa-edit"></i> Edit
													</a>
												</div>
											</div>
											<p class="mb-0">${address.details}</p>
										</div>
									</label>
								</div>
							</div>
						</div>`;
					addressContainer.insertAdjacentHTML('beforeend', addressHtml);
				});
			})
			.catch(error => console.error('Error fetching address list:', error));
	}

	document.getElementById('addAddressForm').addEventListener('submit', function (event) {
		event.preventDefault();

		const formData = new FormData(this);

		fetch("{{ route('address.save') }}", {
			method: 'POST',
			headers: {
				'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
			},
			body: formData
		})
		.then(response => response.json())
		.then(data => {
			if (data.success) {
				const addressModal = bootstrap.Modal.getInstance(document.getElementById('addressmodal'));
				addressModal.hide();

				updateAddressList();

                let fullAddress = `${data.data.flat_no || ''}, ${data.data.building || ''} - ${data.data.city_name || 'N/A'}, ${data.data.locality_name || 'N/A'}`;
                
                jQuery('#selectedLocation').text(fullAddress);
                fetchAddresses();

				const changeLocationModal = new bootstrap.Modal(document.getElementById('changelocation'));
				changeLocationModal.show();

                const userAddressTypeFields = document.getElementById('user-address-type');
                userAddressTypeFields.textContent = data.data.address_type; 
                userAddressTypeFields.setAttribute('data-address', data.data.address_type);

                const userAddressEditTypeFields = document.getElementById('user-address-edit-type');
                userAddressEditTypeFields.textContent = data.data.address_type; 
                userAddressEditTypeFields.setAttribute('data-address', data.data.address_type);
                
                const userAddressFields = document.getElementById('user-address-edit');
                  
                userAddressFields.textContent = fullAddress; 
                userAddressFields.setAttribute('data-address', fullAddress);

                const userAddressField = document.getElementById('user-address');
                    
                userAddressField.textContent = fullAddress;
                userAddressField.setAttribute('data-address', data.data.id);

                jQuery('#user-address-type').css("display", "block");
                jQuery('#user-address').css("display", "block");
                jQuery('.empty-location').css("display", "none");
			}
		})
		.catch(error => console.error('Error saving address:', error));
	});

	// Function to load localities based on selected city
	function loadLocalities(cityId, localitySelectId) {
        const localitySelect = document.getElementById(localitySelectId);
        localitySelect.innerHTML = '<option value="">Select Locality</option>';

        if (cityId) {
            const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
            fetch(`${baseURL}/localities/${cityId}`)
                .then(response => response.json())
                .then(data => {
                    data.forEach(locality => {
                        const option = new Option(locality.name, locality.id);
                        localitySelect.add(option);
                    });
                })
                .catch(error => console.error('Error fetching localities:', error));
        }
    }

    // Attach change event to city select in Add Address modal to load localities
    document.getElementById('citySelect').addEventListener('change', function () {
        loadLocalities(this.value, 'localitySelect');
    });

    // Attach change event to city select in Edit Address modal to load localities
    document.getElementById('editCitySelect').addEventListener('change', function () {
        loadLocalities(this.value, 'editLocalitySelect');
    });

    // Load address list when the "Change Location" modal is shown
    document.getElementById('changelocation').addEventListener('show.bs.modal', function () {
        loadAddressList();
    });

    function loadAddressList() {
        const addressListContainer = document.getElementById('address-list');
        addressListContainer.innerHTML = '<p>Loading addresses...</p>'; 

        fetch("{{ route('address.list') }}")
        .then(response => response.json())
        .then(data => {
            addressListContainer.innerHTML = ''; 
            data.forEach(address => {
                const addressHtml = `
                    <div class="col-12 mb-3" id="address-${address.id}">
                        <div class="address-box card position-relative">
                            <div class="card-body">
                                <label class="w-100">
                                    <input type="radio" name="address" value="${address.id}" id="add${address.id}" ${address.is_active == '1' ? 'checked' : ''} onclick="updateAddress(${address.id})">
                                    <div class="content text-start position-relative">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h6 class="mb-0 fs-6 fw-bold" style="max-width: 55%;">${address.flat_no} , ${ address.building } - ${ address.city_name}, ${ address.locality_name }</h6>
                                            <div class="address-box-action d-flex align-items-md-center align-items-end flex-column flex-md-row">
                                                ${address.is_active == '1' ? '<i class="fal fa-check tick fs-5"></i>' : ''}
                                                <a href="#!" class="address-box-delete-btn fs-5 ms-2 mb-md-0 mb-2" data-address-id="${address.id}">
                                                    <i class="fal fa-trash-alt"></i> Delete
                                                </a>
                                                <a href="#!" class="address-box-edit-btn fs-5 ms-2 mb-md-0 mb-2" data-bs-toggle="modal" data-bs-target="#editAddressModal" data-address-id="${address.id}">
                                                    <i class="fal fa-edit"></i> Edit
                                                </a>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>`;
                addressListContainer.insertAdjacentHTML('beforeend', addressHtml);
            });

            // Update the active address in the `user-address` field
            // const activeAddress = data.find(address => address.is_active);
            // if (activeAddress) {
            //     const userAddressField = document.getElementById('user-address');
            //     userAddressField.textContent = activeAddress.address;
            //     userAddressField.setAttribute('data-address', activeAddress.address);
            // }
        })
        .catch(error => {
            console.error('Error fetching address list:', error);
            addressListContainer.innerHTML = '<p>Error loading addresses. Please try again later.</p>';
        });
    }

    function updateAddress(addressId) {
        fetch(`{{ url('update_address') }}/${addressId}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.message) {
                // loadAddressList();
                
                if(data.data.is_active == "1"){
                    jQuery('.empty-location').css("display", "none");

                    // Update header dropdown selected location dynamically
                    const selectedLocation = document.getElementById('selectedLocation');
                    let fullAddress = `${data.data.flat_no || ''}, ${data.data.building || ''} - ${data.data.city_name || 'N/A'}, ${data.data.locality_name || 'N/A'}`;
                    selectedLocation.textContent = truncateAddress(fullAddress, 20);
                    fetchAddresses();
                    
                    const userAddressTypeFields = document.getElementById('user-address-type');
                    userAddressTypeFields.textContent = data.data.address_type; 
                    userAddressTypeFields.setAttribute('data-address', data.data.address_type);

                    const userAddressEditTypeFields = document.getElementById('user-address-edit-type');
                    userAddressEditTypeFields.textContent = data.data.address_type; 
                    userAddressEditTypeFields.setAttribute('data-address', data.data.address_type);

                    const userAddressFields = document.getElementById('user-address-edit');
                    
                    userAddressFields.textContent = fullAddress; 
                    userAddressFields.setAttribute('data-address', fullAddress);

                    const userAddressField = document.getElementById('user-address');
                    
                    userAddressField.textContent = fullAddress;

                    userAddressField.setAttribute('data-address', data.data.id);
                }
            } else {
                alert(data.error || 'Failed to update the address.');
            }
        })
        .catch(error => {
            console.error('Error updating address:', error);
        });
    }

    // Call loadAddressList on page load
    document.addEventListener('DOMContentLoaded', loadAddressList);

    // Use event delegation for edit functionality
    document.getElementById('address-list').addEventListener('click', function (event) {
        const editButton = event.target.closest('.address-box-edit-btn');
        if (editButton) {
            const addressId = editButton.getAttribute('data-address-id');
            
            const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
                
            // Fetch address data for editing
            fetch(`${baseURL}/address/${addressId}/edit`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate form fields with the fetched data
                        document.getElementById('editAddressId').value = data.data.id;
                        document.getElementById('editFlatNo').value = data.data.flat_no;
                        document.getElementById('editBuilding').value = data.data.building;
                        document.getElementById('editCitySelect').value = data.data.city_id;
                        document.getElementById('autocompleteedit').value = data.data.address;

                        // Load localities for the selected city and set the selected locality
                        loadLocalities(data.data.city_id, 'editLocalitySelect');
                        setTimeout(() => {
                            document.getElementById('editLocalitySelect').value = data.data.locality;
                        }, 2000);

                        document.getElementById(`editaddress_type${data.data.address_type}`).checked = true;
                    } else {
                        console.error('Error: Address not found');
                    }
                });
        }
    });
let defaultLocation = { lat: 25.276987, lng: 55.296249 };
function initMap() {
            
            const UAE_BOUNDS = {
                north: 26.084,
                south: 22.633,
                east: 56.381,
                west: 51.484,
            };

            const map = new google.maps.Map(document.getElementById('add-map'), {
                center: defaultLocation,
                zoom: 12,
                restriction: {
                    latLngBounds: UAE_BOUNDS,
                    strictBounds: true,
                },
            });

            const marker = new google.maps.Marker({
                position: defaultLocation,
                map: map,
                draggable: true
            });

            const geocoder = new google.maps.Geocoder();

            function updateAddress(location) {
                console.log(location);
                geocoder.geocode({ location }, (results, status) => {
                    if (status === 'OK' && results[0]) {
                        console.log(results[0]);
                        document.getElementById('selected-address').value = results[0].formatted_address;
                        document.querySelectorAll('.selected-map-address').forEach(element => {
                            element.textContent = results[0].formatted_address;
                        });
                        let lat = results[0].geometry.location.lat();
                        let lng = results[0].geometry.location.lng();
                
                        console.log("Latitude:", lat, "Longitude:", lng);
                        document.getElementById('latitude').value = lat;
                        document.getElementById('longitude').value = lng;
                    } else {
                        console.error('Failed to retrieve address:', status);
                    }
                });
            }

            // Set default address
            updateAddress(defaultLocation);

            // Update address when the marker is dragged
            marker.addListener('dragend', function () {
                updateAddress(marker.getPosition());
            });

            // Autocomplete functionality
            const autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'), {
                bounds: new google.maps.LatLngBounds(
                    { lat: UAE_BOUNDS.south, lng: UAE_BOUNDS.west },
                    { lat: UAE_BOUNDS.north, lng: UAE_BOUNDS.east }
                ),
                strictBounds: true,
            });

            autocomplete.addListener('place_changed', function () {
                const place = autocomplete.getPlace();
                if (place.geometry && place.geometry.location) {
                    map.setCenter(place.geometry.location);
                    marker.setPosition(place.geometry.location);
                    updateAddress(place.geometry.location);
                }
            });
            initMapEdit();
        }
let defaultLocationEdit = { lat: 25.276987, lng: 55.296249 };
function initMapEdit() {
            
            const UAE_BOUNDS_EDIT = {
                north: 26.084,
                south: 22.633,
                east: 56.381,
                west: 51.484,
            };

            const map_edit = new google.maps.Map(document.getElementById('edit-map'), {
                center: defaultLocationEdit,
                zoom: 12,
                restriction: {
                    latLngBounds: UAE_BOUNDS_EDIT,
                    strictBounds: true,
                },
            });

            const marker = new google.maps.Marker({
                position: defaultLocationEdit,
                map: map_edit,
                draggable: true
            });

            const geocoder = new google.maps.Geocoder();

            function updateAddress(location) {
                geocoder.geocode({ location }, (results, status) => {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('selected-address-edit').value = results[0].formatted_address;
                        document.querySelectorAll('.selected-address-edit').forEach(element => {
                            element.textContent = results[0].formatted_address;
                        });
                        let lat = results[0].geometry.location.lat();
                        let lng = results[0].geometry.location.lng();
                
                        console.log("Latitude:", lat, "Longitude:", lng);
                        document.getElementById('edit-latitude').value = lat;
                        document.getElementById('edit-longitude').value = lng;
                    } else {
                        console.error('Failed to retrieve address:', status);
                    }
                });
            }

            // Set default address
            updateAddress(defaultLocationEdit);

            // Update address when the marker is dragged
            marker.addListener('dragend', function () {
                updateAddress(marker.getPosition());
            });

            // Autocomplete functionality
            const autocompleteedit = new google.maps.places.Autocomplete(document.getElementById('autocompleteedit'), {
                bounds: new google.maps.LatLngBounds(
                    { lat: UAE_BOUNDS_EDIT.south, lng: UAE_BOUNDS_EDIT.west },
                    { lat: UAE_BOUNDS_EDIT.north, lng: UAE_BOUNDS_EDIT.east }
                ),
                strictBounds: true,
            });

            autocompleteedit.addListener('place_changed', function () {
                const place2 = autocompleteedit.getPlace();
                if (place2.geometry && place2.geometry.location) {
                    map_edit.setCenter(place2.geometry.location);
                    marker.setPosition(place2.geometry.location);
                    updateAddress(place2.geometry.location);
                }
            });
        }
// function initMap() {
//     // Default location (Dubai, UAE)
//     const defaultLocation = { lat: 25.276987, lng: 55.296249 };
//     const UAE_BOUNDS = {
//         north: 26.084,
//         south: 22.633,
//         east: 56.381,
//         west: 51.484,
//     };

//     // Initialize the first map (add-map)
//     const map1 = new google.maps.Map(document.getElementById('add-map'), {
//         center: defaultLocation,
//         zoom: 12,
//         restriction: {
//             latLngBounds: UAE_BOUNDS,
//             strictBounds: true, // Enforce strict bounds
//         },
//     });

//     const marker1 = new google.maps.Marker({
//         position: defaultLocation,
//         map: map1,
//         draggable: true
//     });

//     const geocoder1 = new google.maps.Geocoder();

// // Set the default marker location address
// geocoder1.geocode({ location: defaultLocation }, function(results, status) {
//     if (status === 'OK' && results[0]) {
//         document.getElementById('selected-address').value = results[0].formatted_address;
//         document.querySelectorAll('.selected-map-address').forEach(element => {
//             element.textContent = results[0].formatted_address;
//         });
//     } else {
//         console.error('Failed to retrieve default address. Status:', status);
//     }
// });

//     google.maps.event.addListener(marker1, 'dragend', function() {
//         const position = marker1.getPosition();
//         geocoder1.geocode({ location: position }, function(results, status) {
//             if (status === 'OK' && results[0]) {
//                 document.getElementById('selected-address').value = results[0].formatted_address;
//                 document.querySelectorAll('.selected-map-address').forEach(element => {
//                     element.textContent = results[0].formatted_address;
//                 });
//             } else {
//                 alert('Failed to retrieve address for add-map. Try again.');
//             }
//         });
//     });

//     // Initialize the second map (edit-map)
//     const map2 = new google.maps.Map(document.getElementById('edit-map'), {
//         center: defaultLocation,
//         zoom: 12
//     });

//     const marker2 = new google.maps.Marker({
//         position: defaultLocation,
//         map: map2,
//         draggable: true
//     });

//     const geocoder2 = new google.maps.Geocoder();
    
//     // Set the default marker location address
//     geocoder2.geocode({ location: defaultLocation }, function(results, status) {
//         if (status === 'OK' && results[0]) {
//             document.getElementById('selected-address-edit').value = results[0].formatted_address;
//             document.querySelectorAll('.selected-map-address-edit').forEach(element => {
//                 element.textContent = results[0].formatted_address;
//             });
//         } else {
//             console.error('Failed to retrieve default address. Status:', status);
//         }
//     });


//     google.maps.event.addListener(marker2, 'dragend', function() {
//         const position = marker2.getPosition();
//         geocoder2.geocode({ location: position }, function(results, status) {
//             if (status === 'OK' && results[0]) {
//                 document.getElementById('selected-address-edit').value = results[0].formatted_address;
//                 document.querySelectorAll('.selected-map-address-edit').forEach(element => {
//                     element.textContent = results[0].formatted_address;
//                 });
//             } else {
//                 alert('Failed to retrieve address for edit-map. Try again.');
//                 }
//             });
//         });
//     }

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize the maps when their respective modals are shown
        document.getElementById('addressmodal').addEventListener('shown.bs.modal', function() {
            initMap();
        });

        document.getElementById('editAddressModal').addEventListener('shown.bs.modal', function() {
            
        });
    });

document.addEventListener('DOMContentLoaded', function () {
    let selectedAddressId;
    const changeLocationModal = new bootstrap.Modal(document.getElementById('changelocation'));
    const deleteConfirmationModal = new bootstrap.Modal(document.getElementById('deleteConfirmationModal'));

    document.getElementById('address-list').addEventListener('click', function (event) {
        const deleteButton = event.target.closest('.address-box-delete-btn');
        if (deleteButton) {
            selectedAddressId = deleteButton.getAttribute('data-address-id'); // Store address ID

            changeLocationModal.hide();

            // Show the delete confirmation modal
            deleteConfirmationModal.show();
        }
    });

    document.getElementById('confirmDeleteButton').addEventListener('click', function () {
        if (selectedAddressId) {
            const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];

            fetch(`${baseURL}/address/${selectedAddressId}/delete`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadAddressList(); 
                    changeLocationModal.show();
                    if(data.is_address == 0){
                        jQuery('#user-address-type').css("display", "none");
                        jQuery('#user-address').css("display", "none");
                        jQuery('.empty-location').css("display", "block");
                        
                        jQuery('#selectedLocation').text("-");
                    }
                } else {
                    alert(data.error || 'Failed to delete the address.');
                }
            })
            .catch(error => console.error('Error deleting address:', error))
            .finally(() => {
                deleteConfirmationModal.hide(); 
            });
        }
    });

    document.querySelector('#deleteConfirmationModal .btn-secondary').addEventListener('click', function () {
        // When cancel button is clicked, hide the delete confirmation modal and show changelocation modal
        deleteConfirmationModal.hide();
        changeLocationModal.show();
    });

    // Function to reload the address list
    function loadAddressList() {
        const addressListContainer = document.getElementById('address-list');
        const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];

        fetch(`${baseURL}/address/list`)
            .then(response => response.json())
            .then(data => {
                addressListContainer.innerHTML = ''; // Clear current list
                data?.addresses?.forEach(address => {
                    addressListContainer.innerHTML += `
                        <div class="col-lg-6 mb-20" id="address-${address.id}">
                            <div class="address-box card position-relative">
                                <div class="card-body">
                                    <label class="w-100" for="add${address.id}">
                                        <input type="radio" name="address" id="add${address.id}" ${address.is_active ? 'checked' : ''} onclick="setActiveAddress(${address.id})">
                                        <div class="content position-relative">
                                            <div class="d-flex align-items-center justify-content-between mb-10">
                                                <h6 class="mb-0 fs-6 fw-bold" style="max-width: 55%;">${address.address_type}</h6>
                                                <div class="address-box-action d-flex align-items-center gap-3">
                                                    <i class="fal fa-check tick fs-5"></i>
                                                    <a href="#!" class="address-box-delete-btn fs-5" data-address-id="${address.id}">
                                                        <i class="fal fa-trash-alt"></i> Delete
                                                    </a>
                                                    <a href="javascript:void(0)" data-id="${address.id}" class="address-box-edit-btn fs-5 edit-address">
                                                        <i class="fal fa-edit"></i> Edit
                                                    </a>
                                                </div>
                                            </div>
                                            <p class="mb-0">${address.flat_no}, ${address.building} - ${address.city}, ${address.locality}</p>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>
                    `;
                });
            })
            .catch(error => console.error('Error loading addresses:', error));
    }
});



    // Use event delegation for edit functionality
    document.getElementById('address-list').addEventListener('click', function (event) {
        const editButton = event.target.closest('.address-box-edit-btn');
        if (editButton) {
            const addressId = editButton.getAttribute('data-address-id');
            const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
            fetch(`${baseURL}/address/${addressId}/edit`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate form fields with the fetched data
                        document.getElementById('editAddressId').value = data.data.id;
                        document.getElementById('editFlatNo').value = data.data.flat_no;
                        document.getElementById('editBuilding').value = data.data.building;
                        document.getElementById('editCitySelect').value = data.data.city_id;

                        // Load localities for the selected city and set the selected locality
                        loadLocalities(data.data.city_id, 'editLocalitySelect');
                        setTimeout(() => {
                            document.getElementById('editLocalitySelect').value = data.data.locality;
                        }, 200);

                        document.getElementById(`editaddress_type${data.data.address_type}`).checked = true;
                        defaultLocationEdit = { lat: parseFloat(data.data.latitude), lng: parseFloat(data.data.longitude) };
                        initMapEdit();
                    } else {
                        console.error('Error: Address not found');
                    }
                })
                .catch(error => console.error('Error fetching address:', error));
        }
    });

    // Submit edited address with AJAX
    document.getElementById('editAddressForm').addEventListener('submit', function (event) {
        event.preventDefault();

        const addressId = document.getElementById('editAddressId').value;
        const formData = new FormData(this);
        const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
                
        // Fetch address data for editing
        fetch(`${baseURL}/address/${addressId}/update`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                if(data.data.is_active == "1"){
                    const userAddressField = document.getElementById('user-address');
                    let fullAddress = `${data.data.flat_no || ''}, ${data.data.building || ''} - ${data.data.city_name || 'N/A'}, ${data.data.locality_name || 'N/A'}`;
               
                    userAddressField.textContent = fullAddress;
                    userAddressField.setAttribute('data-address', data.data.id);
                    jQuery('.empty-location').css("display", "none");
                    const userAddressTypeFields = document.getElementById('user-address-type');
                    userAddressTypeFields.textContent = data.data.address_type; 
                    userAddressTypeFields.setAttribute('data-address', data.data.address_type);

                    const userAddressEditTypeFields = document.getElementById('user-address-edit-type');
                    userAddressEditTypeFields.textContent = data.data.address_type; 
                    userAddressEditTypeFields.setAttribute('data-address', data.data.address_type);
                    
                }
                
                const editModal = bootstrap.Modal.getInstance(document.getElementById('editAddressModal'));
                editModal.hide();
                loadAddressList(); 
				
                const changeLocation = bootstrap.Modal.getInstance(document.getElementById('changelocation'));
                changeLocation.show();
            } else {
                console.error('Error updating address:', data.message);
            }
        })
        .catch(error => console.error('Error updating address:', error));
    });
</script>

	  <!-- Modal -->
      <div class="modal fade" id="attributeModalSec" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
		    	<div class="modal-content">
				   <div class="modal-header">
				      <h5 class="modal-title subCateName" id="exampleModalLabel"></h5>
				      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				   </div>
			      <div class="modal-body attributelist">
				      <div class="card mb-2">
				            
				      </div>
			     	</div>
			     	<div class="modal-footer">
			        	<button type="button" class="btn btn-dark modelclose" data-bs-dismiss="modal">OK</button>
			      </div>
			   </div>
			</div>
		</div>

   <input type="hidden" value="{{$service->id}}" class="service_id">     
     <input type="hidden" value="{{$card?$card->id:''}}" class="card_id"> 
  

@endsection

<!-- <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script> -->
<script>
	function OpenAttrModel(child_id, subid, attrid) {
		
		var attritemmod 		= '#attributeModalSec';
		var sub_cat_name_cls = '.sub_cate_name'+subid;
		var attrmod 			= 'exampleModal'+attrid;
		var sub_cat_name 		= jQuery(sub_cat_name_cls).val();
		var service_id 		= jQuery('.service_id').val();
		jQuery('.subCateName').text(sub_cat_name);
		jQuery('.attributelist').html('')
		jQuery('.modelclose').click();
		if(child_id){
			jQuery.ajax({
              
               headers: {
	                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
	            },
	            type:"POST",
               url: "{{ url('get_child_cat_attr_items') }}",
               data: {
                        child_category_id: child_id, service_id : service_id, sub_cat_id : subid,
                    },
               success: function (res) {
                  console.log(res);

						jQuery('#attrclose').click();
                  jQuery("#attributeModalSec").modal('show');
                  
                  jQuery.each(res, function(key,val) {
			        		var formid =  'addattrformss'+val.id; 
			        		var buttonForm =  'buttonFormss'+val.id;
			        		var add_booking_from = 'add_booking_from'+val.id;
			        		var formqty = 'formqty'+val.id;
			        		var addbtn = val.id;
                          
			            jQuery('.attributelist').append('<div class="card mb-2"><div class="row align-items-center"> <div class="col-6"> <div class="card-body text-left mt-0" > <h6 class="card-title mb-0 fw-600 fs-5 text-muted">'+ val.attributename +'</h6> <p class="text-dark fw-bold"><small>Starting AED '+ val.attribute_price +'</small></p> </div></div><div class="col-6"><div class="card-body text-right " ><button class="add-button-color-change btn-smll-row" onclick="showForm('+formid+', '+buttonForm+', '+val.id+')" id="'+buttonForm+'">+ Add</button>	<form action="{{ route("add.attribute.card") }}" method="POST" style="display: none;" enctype="multipart/form-data" id="'+formid+'" class="'+add_booking_from+'">@csrf<input type="hidden" name="service_id" value="' + val.service_id + '"><input type="hidden" name="category_id" value="'+ val.category_id +'"><input type="hidden" name="sub_cate_id" value="'+ val.sub_cat_id +'"><input type="hidden" name="main_sub_cat_id" value="'+ val.main_sub_cat_id +'"><input type="hidden" name="child_category_id" value="'+ child_id +'"><input type="hidden" name="attribute_id" value="'+ val.attribute_id +'"><input type="hidden" name="attribute_name" value="'+ val.attribute_name +'"><input type="hidden" name="attribute_item_id" value="'+ val.attribute_item_id +'"><input type="hidden" name="attribute_item_name" value="'+ val.attribute_item_name +'"><input type="hidden" name="attribute_price" value="'+ val.attribute_price +'"><div class="quanity_form"><button type="button" id="sub" class="minus" onclick="minus_booking('+val.id+')">-</button><input type="number" id="1" value="1" min="1" class="quantity '+formqty+'" max="10" /><button type="button" onclick="add_booking('+val.id+')" id="add" class="plus '+addbtn+'">+</button></div></form></div></div></div></div>');
			        });
                  
                  
               },
               error: function (res) {
                   console.log(res);
               }
         });
		}
		
	}
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js" type="text/javascript"></script>


<script>
   document.addEventListener("DOMContentLoaded", function () {
  const wrappers = document.querySelectorAll(".sticky-wrapper");

  const isVisible = (element) => {
    return element.offsetWidth > 0 && element.offsetHeight > 0 && window.getComputedStyle(element).display !== "none";
  };

  const updateStickyPositions = () => {
    if (window.innerWidth >= 1024) {
      wrappers.forEach((wrapper) => {
        if (!isVisible(wrapper)) return;

        const sidebar = wrapper.querySelector(".sidebar");
        const content = wrapper.querySelector(".content");
        if (!sidebar || !content) return;

        const sidebarHeight = sidebar.offsetHeight;
        const contentHeight = content.offsetHeight;
        const wrapperRect = wrapper.getBoundingClientRect();
        const wrapperHeight = wrapper.offsetHeight;

        // Don't apply sticky if sidebar is taller than content
        if (sidebarHeight >= contentHeight) {
          sidebar.style.position = "relative";
          sidebar.style.top = "0";
          sidebar.style.width = ""; 
          return;
        }

        // Preserve sidebar width
        const sidebarWidth = sidebar.offsetWidth;
        sidebar.style.width = `${sidebarWidth}px`;

        if (wrapperRect.top <= 0 && wrapperRect.bottom >= sidebarHeight) {
          sidebar.style.position = "fixed";
          sidebar.style.top = "0";
        } else if (wrapperRect.bottom < sidebarHeight) {
          sidebar.style.position = "absolute";
          sidebar.style.top = wrapperHeight - sidebarHeight + "px";
        } else {
          sidebar.style.position = "relative";
          sidebar.style.top = "0";
          sidebar.style.width = "";
        }
      });
    } else {
      wrappers.forEach((wrapper) => {
        const sidebar = wrapper.querySelector(".sidebar");
        if (sidebar) {
          sidebar.style.position = "relative";
          sidebar.style.top = "0";
          sidebar.style.width = "";
        }
      });
    }
  };

  window.addEventListener("scroll", updateStickyPositions);
  window.addEventListener("resize", updateStickyPositions);
});


</script>

<script>
	jQuery('.v-c-d').hide();
	jQuery(".view-o-d").click(function(){
	   jQuery(".v-c-d").fadeToggle();
	});

    function showToast(message, type = 'warning') {
        // Create the toast container if it doesn't exist
        let toastContainer = document.querySelector('.toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
            document.body.appendChild(toastContainer);
        }

        // Create the toast element
        const toastElement = document.createElement('div');
        toastElement.className = `toast align-items-center text-bg-${type} border-0`;
        toastElement.setAttribute('role', 'alert');
        toastElement.setAttribute('aria-live', 'assertive');
        toastElement.setAttribute('aria-atomic', 'true');

        // Create the toast content
        const toastContent = `
            <div class="d-flex">
                <div class="toast-body">
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        `;
        toastElement.innerHTML = toastContent;

        // Append the toast element to the container
        toastContainer.appendChild(toastElement);

        // Initialize and show the toast
        const toast = new bootstrap.Toast(toastElement);
        toast.show();

        // Automatically remove the toast element after it's hidden
        toastElement.addEventListener('hidden.bs.toast', () => {
            toastElement.remove();
        });
    }

</script>

<!-- Checkout Validation Modal -->
<div class="modal fade" id="checkoutValidationModal" tabindex="-1" aria-labelledby="checkoutValidationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fs-5" id="checkoutValidationModalLabel">Minimum Amount Required</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <p id="validationMessage"></p>
            </div>
        </div>
    </div>
</div>

@section('script')
<script>
	function addToCart(event) {
		event.preventDefault(); 
        
        const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";

        let serviceData = {};
        let item_object_detail = null;
        let packageDetails = null; 
        if(!isCategoryYes){

            // Get selected maid details
            const maidSelected = document.querySelector('input[name="maid_id"]:checked');
            const maidDetails = maidSelected ? {
                maid_id: maidSelected.value,
                maid_name: maidSelected.nextElementSibling.textContent.trim(),
                attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
                category_id: maidSelected.getAttribute('data-category-id'),
                sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
                child_category_id: maidSelected.getAttribute('data-child-category-id')
            } : {};

            // Get selected hours
            const hourSelected = document.querySelector('input[name="hour_id"]:checked');
            const hourDetails = hourSelected ? {
                hour_id: hourSelected.value,
                hour_name: hourSelected.nextElementSibling.textContent.trim(),
                attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
                category_id: hourSelected.getAttribute('data-category-id'),
                sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
                child_category_id: hourSelected.getAttribute('data-child-category-id')
            } : {};


            item_object_detail = JSON.stringify([
				{
					attribute_item_id: maidDetails.attribute_item_id,
					category_id: maidDetails.category_id,
					sub_category_id: maidDetails.sub_category_id,
					child_category_id: maidDetails.child_category_id,
					attribute_qty: 1 
				},
				{
					attribute_item_id: hourDetails.attribute_item_id,
					category_id: hourDetails.category_id,
					sub_category_id: hourDetails.sub_category_id,
					child_category_id: hourDetails.child_category_id,
					attribute_qty: 1 
				}
			]);
        }

        // Get selected package
        const packageSelected = document.querySelector('input[name="package"]:checked');
        packageDetails = packageSelected ? {
            package_id: packageSelected.value,
            package_name: packageSelected.nextElementSibling.querySelector('h5').textContent.trim(),
            package_price: packageSelected.nextElementSibling.querySelector('h4').textContent.trim()
        } : {};
        
		// Get material preference
		const materialPreference = document.querySelector('input[name="yenno"]:checked');
		const materialDetails = materialPreference ? materialPreference.id === 'yes' ? 'Apply' : 'No' : 'No';

		// Get user note
		const userNote = document.getElementById('note').value;

		// Get preferred days
		// const preferredDays = Array.from(
        //     document.querySelectorAll('input[name="preferred_days"]:checked')
        // ).map(day => day.value).join(',');

		// Get alternate contact number details
		const dialCode = document.getElementById('dial-code').value;
		const phoneNumber = document.getElementById('phone-number').value;
		const alternateNumber = dialCode && phoneNumber ? `${dialCode}${phoneNumber}` : "";

        let addressData = jQuery('#user-address').attr('data-address');

        if(addressData == '-'){
            showToast('Please select address first!', 'warning');
            return move('location');
        } 
        let cartData = null;
        let is_revisit = null;
        if("{{$service->id}}" == 10){
            
            const sessionDates = Array.from(document.querySelectorAll(".session-date")).map(input => input.value);
            const sessionTimes = Array.from(document.querySelectorAll(".session-time"));

            // Combine session dates and times into an array of objects
            const sessionDetails = sessionDates.map((date, index) => {
                const timeSelect = sessionTimes[index]; // Get the corresponding time select for this session
                const timeValue = timeSelect ? timeSelect.options[timeSelect.selectedIndex]?.value || "N/A" : "N/A"; // Get display text
                return {
                    date: date || null, // Use null if the date is not set
                    time: timeValue !== "N/A" ? timeValue : null // Use null if the time is not set
                };
            });

            // Prepare data object
            cartData = {
                service_id: "{{ $service->id }}",
                item_object: item_object_detail,
                note: userNote,
                material_status: materialDetails,
                selected_packages: packageDetails?.package_id ?? null,
                address_id: addressData,
                alternative_number: alternateNumber,
                dial_code: dialCode,
                sessions: sessionDetails
            };
        }else{
            if("{{$service->id}}" == 13){
                const selected = document.querySelector('input[name="is_revisit"]:checked');
                is_revisit = selected ? selected.value : '0';
            }

            const selectedDate = document.getElementById('date-picker').value;
            if (!selectedDate) {
                showToast('Please select a date.', 'warning');
                return;
            }

            const selectedSlot = document.querySelector('input[name="time"]:checked');
            const slotId = selectedSlot ? selectedSlot.value : null;
            
            if (!slotId) {
                showToast('Please select a slot.', 'warning');
                return;
            }
            
            // Prepare data object
            cartData = {
                service_id: "{{ $service->id }}",
                is_revisit: is_revisit,
                item_object: item_object_detail,
                note: userNote,
                material_status: materialDetails,
                selected_packages: packageDetails?.package_id ?? null,
                slot_id: slotId,
                address_id: addressData,
                date: selectedDate,
                alternative_number: alternateNumber,
                dial_code: dialCode
            };
        }


		fetch("{{ route('cart.store') }}", {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
				"X-CSRF-TOKEN": "{{ csrf_token() }}"
			},
			body: JSON.stringify(cartData)
		})
		.then(response => response.json())
		.then(data => {
			if (data.success) {
                const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
                window.location.href = `${baseURL}/cart`;
			} else {
				console.error("Error adding item to cart:", data.message);
				//alert("Failed to add item to cart. Please try again.");
                showToast(data.message||'Please select address first!', 'warning');
			}
		})
		.catch(error => {
			console.error("Error:", error);
			alert("An error occurred. Please try again.");
		});
	}

    function checkout(event) {
		event.preventDefault(); 
       
        // Extract numeric value from .updated-price
        let totalPriceText = jQuery('.updated-price').html();
        let totalPrice = parseFloat(totalPriceText.replace(/[^\d.]/g, ''));

        // Fetch the minimum cart value from PHP variable
        let minCartValue = parseFloat("{{ \App\HomeSetting::select('min_cart_value')->first()->min_cart_value }}");

        if (totalPrice < minCartValue) {
            // Show the validation message inside the modal
            document.getElementById('validationMessage').innerHTML = 
                'Add remaining AED ' + (minCartValue - totalPrice).toFixed(2) + ' to proceed with booking.';
            
            // Show the modal
            jQuery('#checkoutValidationModal').modal('show');
            return;
        }
        
        
        const isCategoryYes = document.getElementsByClassName('is_cate_yes')[0].value === "yes";

        let serviceData = {};
        let item_object_detail = null;
        let packageDetails = null; 
        if(!isCategoryYes){

            // Get selected maid details
            const maidSelected = document.querySelector('input[name="maid_id"]:checked');
            const maidDetails = maidSelected ? {
                maid_id: maidSelected.value,
                maid_name: maidSelected.nextElementSibling.textContent.trim(),
                attribute_item_id: maidSelected.getAttribute('data-attribute-item-id'),
                category_id: maidSelected.getAttribute('data-category-id'),
                sub_category_id: maidSelected.getAttribute('data-sub-category-id'),
                child_category_id: maidSelected.getAttribute('data-child-category-id')
            } : {};

            // Get selected hours
            const hourSelected = document.querySelector('input[name="hour_id"]:checked');
            const hourDetails = hourSelected ? {
                hour_id: hourSelected.value,
                hour_name: hourSelected.nextElementSibling.textContent.trim(),
                attribute_item_id: hourSelected.getAttribute('data-attribute-item-id'),
                category_id: hourSelected.getAttribute('data-category-id'),
                sub_category_id: hourSelected.getAttribute('data-sub-category-id'),
                child_category_id: hourSelected.getAttribute('data-child-category-id')
            } : {};

            // Get selected package
            const packageSelected = document.querySelector('input[name="package"]:checked');
            packageDetails = packageSelected ? {
                package_id: packageSelected.value,
                package_name: packageSelected.nextElementSibling.querySelector('h5').textContent.trim(),
                package_price: packageSelected.nextElementSibling.querySelector('h4').textContent.trim()
            } : {};

            item_object_detail = JSON.stringify([
				{
					attribute_item_id: maidDetails.attribute_item_id,
					category_id: maidDetails.category_id,
					sub_category_id: maidDetails.sub_category_id,
					child_category_id: maidDetails.child_category_id,
					attribute_qty: 1 
				},
				{
					attribute_item_id: hourDetails.attribute_item_id,
					category_id: hourDetails.category_id,
					sub_category_id: hourDetails.sub_category_id,
					child_category_id: hourDetails.child_category_id,
					attribute_qty: 1 
				}
			]);
        }

		// Get material preference
		const materialPreference = document.querySelector('input[name="yenno"]:checked');
		const materialDetails = materialPreference ? materialPreference.id === 'yes' ? 'Apply' : 'No' : 'No';

		// Get user note
		const userNote = document.getElementById('note').value;

		// Get preferred days
		// const preferredDays = Array.from(
        //     document.querySelectorAll('input[name="preferred_days"]:checked')
        // ).map(day => day.value).join(',');

		// Get alternate contact number details
		const dialCode = document.getElementById('dial-code').value;
		const phoneNumber = document.getElementById('phone-number').value;
		const alternateNumber = dialCode && phoneNumber ? `${dialCode}${phoneNumber}` : "";

        let addressData = jQuery('#user-address').attr('data-address');
        let is_revisit = null;
        if(addressData == '-'){
            showToast('Please select address first!', 'warning');
            return move('location');
        } 

        if("{{$service->id}}" == 10){
            const sessionDates = Array.from(document.querySelectorAll(".session-date")).map(input => input.value);
            const sessionTimes = Array.from(document.querySelectorAll(".session-time"));

            const sessionDetails = sessionDates.map((date, index) => {
                const timeSelect = sessionTimes[index]; // Get the corresponding time select for this session
                const timeValue = timeSelect ? timeSelect.options[timeSelect.selectedIndex]?.value || "N/A" : "N/A"; // Get display text
                return {
                    date: date || null, // Use null if the date is not set
                    time: timeValue !== "N/A" ? timeValue : null // Use null if the time is not set
                };
            });
            // Prepare data object
            cartData = {
                service_id: "{{ $service->id }}",
                item_object: item_object_detail,
                note: userNote,
                material_status: materialDetails,
                selected_packages: packageDetails?.package_id ?? null,
                address_id: addressData,
                alternative_number: alternateNumber,
                dial_code: dialCode,
                sessions: sessionDetails
            };
        }else{
            if("{{$service->id}}" == 13){
                const selected = document.querySelector('input[name="is_revisit"]:checked');
                is_revisit = selected ? selected.value : '0';
            }
            const selectedDate = document.getElementById('date-picker').value;
            
            if (!selectedDate) {
                const toastElement = document.getElementById('timeToast');
                const toast = new bootstrap.Toast(toastElement);
                toast.show();
                return;
            }

            const selectedSlot = document.querySelector('input[name="time"]:checked');
            const slotId = selectedSlot ? selectedSlot.value : null;
            if(!slotId){
                const toastElement = document.getElementById('timeToast');
                const toast = new bootstrap.Toast(toastElement);
                toast.show();
                return;
            }

            // Prepare data object
            cartData = {
                service_id: "{{ $service->id }}",
                is_revisit: is_revisit,
                item_object: item_object_detail,
                note: userNote,
                material_status: materialDetails,
                selected_packages: packageDetails?.package_id ?? null,
                // preffered_days: preferredDays,
                slot_id: slotId,
                address_id: addressData,
                date: selectedDate,
                alternative_number: alternateNumber,
                dial_code: dialCode
            };
        }

		fetch("{{ route('cart.store') }}", {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
				"X-CSRF-TOKEN": "{{ csrf_token() }}"
			},
			body: JSON.stringify(cartData)
		})
		.then(response => response.json())
		.then(data => {
			if (data.success) {
				console.log("Item added to cart successfully:", data);
                const baseURL = window.location.origin + window.location.pathname.split('/service/booking')[0];
                window.location.href = `${baseURL}/checkout`;
			} else {
				console.error("Error adding item to cart:", data.message);
				alert("Failed to add item to cart. Please try again.");
			}
		})
		.catch(error => {
			console.error("Error:", error);
			alert("An error occurred. Please try again.");
		});
	}
</script>


<style type="text/css">
   .minus, .plus{
		width:34px!important;
		height:36px!important;
		/* background-image: linear-gradient(#feb83a, #d84e56)!important; */
        /* background: linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%) !important; */
		border-radius:4px!important;
		padding:8px 5px 8px 5px!important;
		border:1px solid transparent; 
        color: var(--primary-color) !important;
		display: inline-block!important;
		vertical-align: middle!important;
		text-align: center!important; margin:0!important;
        font-size: 24px;
	}

	.quantity {
		height:37px!important;
		width: 100px!important; margin:0!important;
		text-align: center!important;
		font-size: 14px!important; color:#fff!important;
		border:1px solid #ddd!important;
		border-radius:4px; 	
        /* background-image: linear-gradient(#feb83a, #d84e56)!important; */
        background: linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%) !important;
		display: inline-block!important!important;
		vertical-align: middle!important;
	}

</style>
<script type="text/javascript">
               var input = $('.quantity'),
         minValue =  parseInt(input.attr('min')),
         maxValue =  parseInt(input.attr('max'));


         $('.plus').on('click', function () {
         var inputValue = input.val();
         if (inputValue < maxValue) {
         input.val(parseInt(inputValue) + 1);
         }
         });

         $('.minus').on('click', function () {
         var inputValue = input.val();
         if (inputValue < maxValue) {
         input.val(parseInt(inputValue) - 1);
         }
         });

</script>
<script>
        function submitForm(argument, call = null) {
            let formData = jQuery('#msform').serialize(); 
            formData += `&apply=${argument}`;
            const packageSelected = document.querySelector('input[name="package"]:checked');
            
            if(call == null){
                
                const perWeekElementShow = document.querySelector('.per_week');
                if (packageSelected) {

                    const previouslySelected = localStorage.getItem('selected_package');
                    const isSamePackage = previouslySelected === packageSelected.value;

                    localStorage.setItem('selected_package', packageSelected.value);
                
                    formData += `&package_id=${packageSelected.value}`;
                    jQuery('.base_price').hide(); 
                    jQuery('.packageActiveShow').show();
                    jQuery('.show_days').show();
                    jQuery('input[name="package"]').removeClass('active');
                    const packageSelected3 = jQuery('input[name="package"]:checked');
                                
                    packageSelected3.addClass('active');
                } else {
                    perWeekElementShow.textContent = '0';
                }
            } else {
                    
                const maidId = document.querySelector('input[name="maid_id"]:checked')?.value || null;
                const hourId = document.querySelector('input[name="hour_id"]:checked')?.value || null;

                if (packageSelected) {
                    formData += `&package_id=${packageSelected.value}&maid_id=${maidId}&hour_id=${hourId}`;
                }
            }
            

            jQuery.ajax({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                },    
                type: 'Post',
                url: "{{ url('get_selected_price') }}",
                data: formData,
                dataType: 'json',
                success: function (data) {
                    console.log(data.data);
                    jQuery('.updated-price').html('AED '+data.data.total_amount); 
                    jQuery('#first_btn').attr("disabled",false);
                    updateSummary("service",data.data);
                    jQuery('#package-holder').html(data.package_view);
                },
                error: function (data) {
                    console.log(data);
                }
        });
        }
</script>
<script>
	let lasthur = '';
	function getSubItemid(datas) {
		var hurid = '#flexRadioDefault'+datas.id;
		jQuery(lasthur).prop('checked', false);
		lasthur = hurid;
		jQuery('.attribute_detail_id').val(datas.id);
		submitSubAttrForm();
	}
</script>
<script>
	let material = '';
	function submitSubAttrForm() {
		jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "{{ url('update/sub/attribute') }}",
            data: jQuery('.submitSubAttrForm').serialize(),
            dataType: 'json',
            success: function (data) {
            	console.log(data);
                 jQuery('.cardlist').html('');       
                 jQuery('.cardlist').html(data.modal_view); 
                 jQuery('.textgtotal').show();    
                 jQuery('.gtotal').text(data.peramt);  
                  material = data.peramt;
                  jQuery("#flexRadioDefault1").prop('checked', false);
                  jQuery("#flexRadioDefault2").prop('checked', false);
            },
            error: function (data) {
                console.log(data);
            }
      });
	}
    const isAuthenticated = {!! json_encode(Auth::check()) !!};
	function move(choose){
        const elementTop = document.getElementById('down');
		window.scrollTo({
            // top: 350,
            top: elementTop.offsetTop,
            behavior: 'smooth'
        });
			if(choose == "selection"){

				jQuery('.location').hide();    
				jQuery('.selection').show();    

				jQuery('#account').addClass("active");    
				jQuery('#personal').removeClass("active");    
				
				jQuery('.progress-bar').css('width', '25%');
			} else if(choose == 'location'){ 
                
                if(!isAuthenticated){
                    showlogin();
                    return;
                }

                if (jQuery("#first_btn").prop("disabled")) {
                    showToast('Please select one service', 'warning');
                    return;
                } 
                
                const dialCode = document.getElementById('dial-code').value;
                const phoneNumber = document.getElementById('phone-number').value;
                const alternateNumber = dialCode && phoneNumber ? `${dialCode}${phoneNumber}` : "";
                const updatedNumbers = document.querySelectorAll('.updated-number');

                // Iterate through each element and update its text content
                updatedNumbers.forEach(element => {
                    element.textContent = alternateNumber;
                });

				jQuery('.selection').hide();    
				jQuery('.choose_time').hide();    
				jQuery('.location').show();    
				jQuery('#payment').addClass("active");    
				
				jQuery('#personal').addClass("active");    
				jQuery('#account').removeClass("active");    
				jQuery('#payment').removeClass("active");    
				
				jQuery('.progress-bar').css('width', '50%');
			}  else if(choose == 'choose_time'){ 

                const dialCode = document.getElementById('dial-code').value;
                const phoneNumber = document.getElementById('phone-number').value;
                const alternateNumber = dialCode && phoneNumber ? `${dialCode}${phoneNumber}` : "";
                const updatedNumbers = document.querySelectorAll('.updated-number');

                // Iterate through each element and update its text content
                updatedNumbers.forEach(element => {
                    element.textContent = alternateNumber;
                });

                let phone_number = phoneNumber;
                let isValid = /^\d{9,12}$/.test(phone_number);

                if (!isValid) {
                    jQuery('.numbererror').text('Please enter a valid phone number between 9 and 12 digits');
                    return false;
                } else { 
                    jQuery('.numbererror').text('');
                    
                }

                let userAddresses = document.getElementById('user-address').style.display;

				if(userAddresses == 'none'){
                    showToast('Please select address first!', 'warning');
					return move('location');
				} 

				jQuery('.payment').hide();    
				jQuery('.location').hide();    
				jQuery('.choose_time').show();    

				jQuery('#payment').addClass("active");    
				jQuery('#personal').removeClass("active");    
				jQuery('#confirm').removeClass("active");   
				
				jQuery('.progress-bar').css('width', '75%');
			} else if(choose == 'payment'){  

                if("{{$service->id}}" == 10){
                    const sessionDates = document.querySelectorAll(".session-date");
                    const sessionTimes = document.querySelectorAll(".session-time");

                    let allFieldsValid = true;

                    sessionDates.forEach((input) => {
                        if (!input.value) {
                            allFieldsValid = false;
                            input.classList.add("is-invalid"); // Highlight invalid fields
                        } else {
                            input.classList.remove("is-invalid"); // Remove highlight for valid fields
                        }
                    });

                    sessionTimes.forEach((select, index) => {
                        if (index !== 0 && select.selectedIndex === 0) {
                            allFieldsValid = false;
                            select.classList.add("is-invalid"); // Highlight invalid field
                        } else if (!select.value || select.selectedIndex === 0) { // Check if the default value is still selected
                            allFieldsValid = false;
                            select.classList.add("is-invalid"); // Highlight invalid field
                        } else {
                            select.classList.remove("is-invalid"); // Remove invalid styling if valid
                        }
                    });


                    if (!allFieldsValid) {
                        showToast('Please fill all session dates and times!.');
                        return;
                    }
                }else{
                    let selectedSlot = document.querySelector('input[name="time"]:checked');
                
                    let selectedTime = selectedSlot ? selectedSlot.nextElementSibling.textContent.trim() : "N/A";

                    if(selectedTime == "N/A"){
                        
                        showToast('Please select time slot!', 'warning');
                        return;
                    }
                }
                const dialCode = document.getElementById('dial-code').value;
                const phoneNumber = document.getElementById('phone-number').value;
                const alternateNumber = dialCode && phoneNumber ? `${dialCode}${phoneNumber}` : "";
                const updatedNumbers = document.querySelectorAll('.updated-number');

                updatedNumbers.forEach(element => {
                    element.textContent = alternateNumber;
                });

				updateSummary("time", {});
				jQuery('.choose_time').hide();    
				jQuery('.payment').show();    
				jQuery('#confirm').addClass("active");   
				jQuery('#payment').removeClass("active");     
				
				jQuery('.progress-bar').css('width', '100%');
			}
	}
</script>
<script>

	function cleaningCheck(argument) {
		if(argument=='Yes'){
			var status = 'Apply';
		} else {
			var status = 'Not';
		}

		jQuery.ajax({
            headers: {
                   'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
               },    
            type: 'Post',
            url: "{{ url('update/material/charge') }}",
            data: {
            	card_id : jQuery('.cc_card_id').val(),
            	material_amt : material,
            	status : status,
            },
            dataType: 'json',
            success: function (data) {
            	console.log(data);
            	  jQuery('.cardlist').html('');       
                 jQuery('.cardlist').html(data.modal_view);    
                 jQuery('.textgtotal').show();    
                 jQuery('.gtotal').text(data.peramt);  
                  material = data.peramt; 
            },
            error: function (data) {
                console.log(data);
            }
      });
	}
</script>
<script>
	function reloadPage() {
		location.reload();
	}
</script>

<style type="text/css">
	
	#attributeModalSec .card-body p {
    	margin: 0em 0 !important;
    }
	#attributeModalSec .card-body{
			padding: 5px 15px 2px 15px !important;
		}

	#attributeModalSec .card-title {
    margin-bottom: 0px !important;
	}


@media only screen and (max-width: 768px) and (min-width: 200px)  {

	#personal_information input[type="date"]{
		height: 70px !important;
    	line-height: 20px !important;
	}

		#personal_information input[type="date"]{
		padding: 0rem 0.75rem !important;
	}

	}	

</style>

<script>
	function setMaterialStatus(value) {
	    //alert(value);
		document.getElementById('material_status').value = value;

        // Save the currently selected package in localStorage
        const selectedPackage = document.querySelector('input[name="package"]:checked');
        if (selectedPackage) {
            localStorage.setItem('selected_package', selectedPackage.value);
        }
        
		
        
        // Check if material price is not 0
        if (value == "Apply") {
            document.querySelectorAll('.summary-material-price-status').forEach(statusEl => {
                statusEl.classList.remove('d-none');
            });
        } else {
            // If material price is 0, add d-none class
            document.querySelectorAll('.summary-material-price-status').forEach(statusEl => {
                statusEl.classList.add('d-none');
            });
        }

        // Reapply the selected package after form submission
        const previouslySelectedPackage = localStorage.getItem('selected_package');
        if (previouslySelectedPackage) {
            document.querySelector(`input[name="package"][value="${previouslySelectedPackage}"]`).checked = true;
        }
        submitForm("apply", "call");
		fetchPackages();
	}

	function checkSubmitForm() {
		var checkAddress = jQuery('.checkAddress').val();
		if(checkAddress=='True'){
			jQuery('.profile_address_form').submit();
		} else {
			if(jQuery('.live_address').val()==''){
				jQuery('.addresserror').text('This field is required.');
			} else if(jQuery('.flat_no').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('This field is required.');
			} else if(jQuery('.building').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('');
				jQuery('.buildingerror').text('This field is required.');
			} else if(jQuery('.city_val').val()==''){
				jQuery('.addresserror').text('');
				jQuery('.flaterror').text('');
				jQuery('.buildingerror').text('');
				jQuery('.cityerror').text('This field is required.');
			} else {
				jQuery.ajax({
			         headers: {
			                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
			            },    
			         type: 'Post',
			         url: "{{ url('get/lat/long') }}",
			         data: {
			           location : jQuery('.live_address').val(),
			         },
			         dataType: 'json',
			         success: function (response) {
			              
			              if(response.status=='1'){
			                 jQuery('#latitude').val(response.latitude);
			                 jQuery('#longitude').val(response.longitude);
			                 map = new google.maps.Map(document.getElementById('add-map'), {
			                    center: { lat: response.latitude, lng: response.longitude }, // Default to centering at (0, 0)
			                    zoom: 15 // Adjust the zoom level as desired
			                 });

			                 // Create a marker at the default location (0, 0)
			                 marker = new google.maps.Marker({
			                    position: { lat: response.latitude, lng: response.longitude },
			                    map: map,
			                    draggable: true // Allow the marker to be dragged
			                 });

			                 // Add an event listener to update the latitude and longitude when the marker is dragged
			                 marker.addListener('dragend', function() {
			                    updateCoordinates2(marker.getPosition());
			                 });

                             map2 = new google.maps.Map(document.getElementById('edit-map'), {
			                    center: { lat: response.latitude, lng: response.longitude }, // Default to centering at (0, 0)
			                    zoom: 15 // Adjust the zoom level as desired
			                 });

			                 // Create a marker at the default location (0, 0)
			                 marker2 = new google.maps.Marker({
			                    position: { lat: response.latitude, lng: response.longitude },
			                    map: map2,
			                    draggable: true // Allow the marker to be dragged
			                 });

			                 // Add an event listener to update the latitude and longitude when the marker is dragged
			                 marker2.addListener('dragend', function() {
			                    updateCoordinates2(marker2.getPosition());
			                 });
			               } 
			               jQuery('.checkAddress').val('True');
								jQuery('.profile_address_form').submit();   
			         },
			         error: function (response) {
			            jQuery('.checkAddress').val('True');
							jQuery('.profile_address_form').submit();
			         }
			      });
				
			}
			
			// jQuery('.profile_address_form').submit();
		}
	}

	document.addEventListener("DOMContentLoaded", function () {
		// Fetch the preferred days from the API
		fetch("{{ route('preffered_days') }}")
			.then(response => response.json())
			.then(data => {
				if (data.status === "1") {
					const daysList = document.getElementById("preferred-days-list");
					const daysData = data.data;

					// Generate list items for each day
					daysData.forEach(day => {
						const listItem = document.createElement("li");

						listItem.innerHTML = `
							<label class="control" for="day_${day.id}">
								<input type="checkbox" name="preferred_days" id="day_${day.id}" value="${day.name}" onclick="handleDaySelection()">
								<span class="control__content">
									<i class="fal fa-check"></i> ${day.name}
								</span>
							</label>
						`;
						// daysList.appendChild(listItem);
					});
				} else {
					console.error("Failed to load days:", data.message);
				}
			})
			.catch(error => console.error("Error fetching preferred days:", error));
	});

	function handleDaySelection() {
        const checkboxes = document.querySelectorAll('input[name="preferred_days"]');
        
        // Attach event listeners to all checkboxes
        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', () => {
                const selectedDays = document.querySelectorAll('input[name="preferred_days"]:checked');
                const packageSelected = document.querySelector('input[name="package"]:checked');
                const perWeekElement = document.querySelector('.per_week_get_'+packageSelected.value);
           
                if (selectedDays.length >= parseInt(perWeekElement.textContent, 10)) {
                    // Disable other checkboxes if 2 are selected
                    checkboxes.forEach(cb => {
                        if (!cb.checked) {
                            cb.disabled = true;
                            cb.parentElement.classList.add('disabled'); // Add styling class
                        }
                    });
                } else {
                    // Re-enable all checkboxes if less than 2 are selected
                    checkboxes.forEach(cb => {
                        cb.disabled = false;
                        cb.parentElement.classList.remove('disabled'); // Remove styling class
                    });
                }
            });
        });
    }


	 // Set today's date as the minimum date for the date picker
	 function getTodayDate() {
        const today = new Date();
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const day = String(today.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    }

    document.addEventListener("DOMContentLoaded", function () {
        const datePicker = document.getElementById("date-picker");
        const slotsList = document.getElementById("time-slots-list");
        const serviceId = "{{$service->id}}";

        const today = getTodayDate();
        const lastPendingCardDate = `{{ optional(App\Card::where('user_id', \Session::get('user_id'))
        ->where('service_id', $service->id)
        ->where('status', 'Pending')
        ->where('payment_collected', 'No')
        ->where('work_done', 'No')
        ->orderBy('id', 'DESC')
        ->first())->date ? \Carbon\Carbon::parse(optional(App\Card::where('user_id', \Session::get('user_id'))
        ->where('service_id', $service->id)
        ->where('status', 'Pending')
        ->where('payment_collected', 'No')
        ->where('work_done', 'No')
        ->orderBy('id', 'DESC')
        ->first())->date)->format('d-m-Y') : now()->format('d-m-Y') }}`;
        const lastSlotId = `{{ optional(App\Card::where('user_id', \Session::get('user_id'))
        ->where('service_id', $service->id)
        ->where('status', 'Pending')
        ->where('payment_collected', 'No')
        ->where('work_done', 'No')
        ->orderBy('id', 'DESC')
        ->first())->slot_id ?? '' }}`;


        if("{{$service->id}}" != 10){
            datePicker.value = lastPendingCardDate || today;
            datePicker.min = today;
        }

        function fetchTimeSlots(date) {
            fetch("{{ route('slots_list') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ date: date, service_id: serviceId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "1") {
                    const slotsData = data.data;

                    // Clear any existing slots
                    slotsList.innerHTML = '';

                    let firstSlotSelected = false; // Track if the first slot is selected

                    // Generate list items for each available slot
                    slotsData.forEach((slot, index) => {
                        if (slot.available && !slot.is_past_slot) {
                            const listItem = document.createElement("li");
                            listItem.innerHTML = `
                                <label class="control" for="time_${slot.slot_id}">
                                    <input 
                                        type="radio" 
                                        name="time" 
                                        id="time_${slot.slot_id}" 
                                        value="${slot.slot_id}" 
                                        ${lastSlotId == slot.slot_id ? 'checked' : (!firstSlotSelected ? (firstSlotSelected = true, 'checked') : '')}>
                                    <span class="control__content">
                                        <i class="fal fa-check"></i> ${slot.slot_name}
                                    </span>
                                </label>
                            `;


                            slotsList.appendChild(listItem);

                            if (!firstSlotSelected) {
                                firstSlotSelected = true; // Ensure only the first slot gets selected
                            }
                        }
                    });

                    if (!firstSlotSelected) {
                        slotsList.innerHTML = '<li>No available slots for the selected date.</li>';
                    }
                } else {
                    console.error("Failed to load time slots:", data.message);
                }
            })
            .catch(error => console.error("Error fetching time slots:", error));
        }

        if("{{$service->id}}" != 10){
            fetchTimeSlots(today);
            datePicker.addEventListener("change", function () {
                const selectedDate = this.value;
                fetchTimeSlots(selectedDate);
            });
        }

        // If the date picker has a value, show the picker on page load
        
        if (datePicker.value) {
            fetchTimeSlots(datePicker.value);
        } else{
            datePicker.value = today;
        }
        @if(!empty($card) && $card->date)
            datePicker.value = '{{$card->date}}';
            
            fetchTimeSlots('{{$card->date}}');
        @endif

    });


	// Function to update the summary section
	function updateSummary(status, data) {
		let date = getTodayDate();
		let selectedSlot = document.querySelector('input[name="time"]:checked');
		let selectedTime = selectedSlot ? selectedSlot.nextElementSibling.textContent.trim() : "N/A";

        if("{{$service->id}}" != 10){
            const selectedDate = document.getElementById('date-picker').value;
            const [year, month, day] = selectedDate.split('-');
            const formattedDate = `${day}-${month}-${year}`;
            if(status == "time"){
                document.getElementById('summary-selected-date').textContent = formattedDate;
                document.getElementById('summary-selected-time').textContent = selectedTime;
            }
        }
		
		if(status == "time"){
		} else {
            
            document.querySelectorAll('.summary-service-single-price').forEach(el => el.textContent = data?.single_price || 0);
            document.querySelectorAll('.summary-service-sub-total').forEach(el => el.textContent = data?.sub_total || 0);
            document.querySelectorAll('.summary-service-sub-total-maids').forEach(el => el.textContent = data?.total_maids || 0);
            
            document.querySelectorAll('.summary-service-quantity').forEach(el => el.textContent = data?.attribute?.[0]?.name || 0);
            document.querySelectorAll('.summary-service-price').forEach(el => el.textContent = data?.total_amount || 0);
            document.querySelectorAll('.summary-service-hours').forEach(el => el.textContent = data?.attribute?.[1]?.name || 0);
            
            if(data?.package_free_sessions == 0){
                document.querySelectorAll('.summary-selected-sessions').forEach(el => el.textContent = "One Time Booking");
                document.querySelectorAll('.summary-free-sessions').forEach(el => el.textContent = "");
            } else{
                document.querySelectorAll('.summary-selected-sessions').forEach(el => el.textContent = (data?.package_total_sessions || 0)+" session + ");
                document.querySelectorAll('.summary-free-sessions').forEach(el => el.textContent = (data?.package_free_sessions || 0)+" free");
            }
            document.querySelectorAll('.summary-per-week-sessions').forEach(el => el.textContent = data?.package_per_week_sessions || 0);
            document.querySelectorAll('.summary-selected-sessions-sub-total').forEach(el => el.textContent = data?.package_amount || 0);
            document.querySelectorAll('.summary-selected-sessions-material-charge').forEach(el => el.textContent = data?.material || 0);
            document.querySelectorAll('.summary-free-sessions-sub-total').forEach(el => el.textContent = data?.package_free_sessions_sub_total || 0);
            
            document.querySelectorAll('.summary-service-count').forEach(el => el.textContent = data?.attribute?.[1]?.price || 0);
            document.querySelectorAll('.summary-material-price').forEach(el => {
                el.textContent = data?.material || 0;

            });

		}
	}

	document.addEventListener('DOMContentLoaded', function () {
        localStorage.removeItem('selected_package');
        if("{{(optional(App\Packages::find(optional($card_info)->selected_packages))->amount ?? '0')}}" == '0'){
            jQuery('.packageActiveShow').hide();
            jQuery('.show_days').hide();
        }else{
            jQuery('.packageActiveShow').show();
            
            jQuery('.show_days').show();
        }
        if("{{$material_status}}" == 'Apply'){
            
		    document.getElementById('material_status').value = 'Apply';
            document.querySelectorAll('.summary-material-price-status').forEach(statusEl => {
                statusEl.classList.remove('d-none');
            });
        }else{
		    document.getElementById('material_status').value = 'No';
            document.querySelectorAll('.summary-material-price-status').forEach(statusEl => {
                statusEl.classList.add('d-none');
            });
        }
        collectAttributesData();
    const changeLocationModal = document.getElementById('changelocation');

    // Ensure modal backdrop is properly removed after closing
    changeLocationModal.addEventListener('hidden.bs.modal', function () {
        const modalBackdrop = document.querySelector('.modal-backdrop');
        if (modalBackdrop) {
            modalBackdrop.remove(); // Remove leftover backdrop if it exists
        }

        document.body.classList.remove('modal-open'); // Remove 'modal-open' class
        document.body.style.paddingRight = ''; // Reset any padding added to prevent scrollbar shifting
    });
});

</script>

<!-- <script>
    $(".action-button, .action-button-previous").on("click", function() {
        $("html").animate({ scrollTop: 0 }, "slow");
});
 -->
</script>

<style type="text/css">
	
	#sub-desc-cat{
		font-size: 13px !important;
	}


	.add-button-color-change{
    background: var(--primary-color);
    background: linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%);
    color: #fff !important;
    padding: 0px 20px !important;
    /* font-size: 17px !important; */
    border-radius: 20px !important;
    /* font-weight: 600 !important; */
    /* -webkit-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
    /* -moz-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
    /* box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
    margin-left: auto !important;
}

	.attributelist .add-button-color-change, .btn-sm{
    background: var(--primary-color);
    background: linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%);
    color: #fff !important;
    padding: 0px 20px !important;
    /* font-size: 17px !important; */
    border-radius: 20px !important;
    /* font-weight: 600 !important; */
    /* -webkit-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
    /* -moz-box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
    /* box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.25) !important; */
}

@media(max-width:991px){
    .add-button-color-change{
        margin-left: auto !important;
        margin-top: 5px;
        margin-bottom: 5px;
    }
}

.card-title{
	font-size: 16px !important;
	color:#6a6d7a !important;
}

.service_d_content h1, .service_d_content h2, .service_d_content h3, .service_d_content h4, .service_d_content h5, .service_d_content h6{
	color:#6a6d7a !important;
}

 /*.cardlist h1, .cardlist h2, .cardlist h3, .cardlist h4, .cardlist h5, .cardlist h6{*/
 /*	color:#6a6d7a !important;	*/
 /*}*/


@media only screen and (max-width: 720px) and (min-width: 200px)  {
	.sub-category-popup .col-8, .sub-category-popup .col-4{
		width: 50% !important;
	}
	
}



</style>


<script>
 let map, map2, marker3, marker2;


 function initMap(elementId, latitude = 25.276987, longitude = 55.296249, mapType) {
//   const center = { lat: latitude, lng: longitude };
//   const UAE_BOUNDS = {
//     north: 26.084,
//     south: 22.633,
//     east: 56.381,
//     west: 51.484,
//   };

//   const mapInstance = new google.maps.Map(document.getElementById(elementId), {
//     center: center,
//     zoom: 15,
//     restriction: {
//         latLngBounds: UAE_BOUNDS,
//         strictBounds: true, // Enforce strict bounds
//     },
//   });

//   const marker = new google.maps.Marker({
//     position: center,
//     map: mapInstance,
//     draggable: true,
//   });

//   updateCoordinates2(marker.getPosition(), mapType);

//   if (mapType === 'add') {
//     map = mapInstance;
//     marker3 = marker;
//   } else if (mapType === 'edit') {
//     map2 = mapInstance;
//     marker2 = marker;
//   }
// }

function updateCoordinates2(latLng, mapType) {
 
  if (mapType === 'add') {
    document.getElementById('latitude').value = latLng.lat().toFixed(6);
    document.getElementById('longitude').value = latLng.lng().toFixed(6);
  } else if (mapType === 'edit') {
    document.getElementById('edit-latitude').value = latLng.lat().toFixed(6);
    document.getElementById('edit-longitude').value = latLng.lng().toFixed(6);
  }
}

function fetchLocationAndInitializeMaps() {

  if (navigator.geolocation) {
    
    navigator.geolocation.getCurrentPosition(
      function (position) {
        const lat = position.coords.latitude;
        const lng = position.coords.longitude;
        // Initialize both maps with user's current location
        initMap('add-map', lat, lng, 'add');
        initMap('edit-map', lat, lng, 'edit');
      },
      function (error) {
        console.warn('Geolocation error:', error.message);
        // Fallback to default location (Dubai, UAE)
        initMap('add-map', 25.276987, 55.296249, 'add');
        initMap('edit-map', 25.276987, 55.296249, 'edit');
      }
    );
  } else {
    console.error('Geolocation is not supported by this browser.');
    // Fallback if Geolocation API isn't supported
    initMap('add-map', 25.276987, 55.296249, 'add');
    initMap('edit-map', 25.276987, 55.296249, 'edit');
  }
}

document.addEventListener('DOMContentLoaded', function () {
  fetchLocationAndInitializeMaps();
  
    function fetchPackages() {
        const maidId = document.querySelector('input[name="maid_id"]:checked')?.value || null;
        const hourId = document.querySelector('input[name="hour_id"]:checked')?.value || null;
        const material = document.getElementById('material_status').value;
    
        if (!maidId && !hourId) {
            console.error("Both attributes are missing!");
            return;
        }
    
        // Make an AJAX request to fetch the packages based on the selected attributes
        fetch("{{ route('get.packages') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
            },
            body: JSON.stringify({
                maid_id: maidId,
                hour_id: hourId,
                material: material
            })
        })
        .then(response => response.json())
        .then(data => {
            const packageList = document.querySelector(".package-selector");
    
            // Clear previous packages
            packageList.innerHTML = "";
    
            if (data.success && data.packages.length > 0) {
                data.packages.forEach((packageItem, index) => {
                    const isChecked = index === 0 ? 'checked' : '';  // Select the first package by default
                    const isActive = index === 0 ? 'active' : ''; 
    
                    const packageHtml = `
                        <li class="w-100">
                            <label class="control w-100" for="package${index + 1}">
                                <input 
                                    type="radio" 
                                    name="package" 
                                    id="package${index + 1}" 
                                    value="${packageItem.id}" 
                                    onclick="collectAttributesData(${packageItem.amount}, ${packageItem.id}, ${packageItem.total_sessions ?? 0}, ${packageItem.free_sessions ?? 0}, ${packageItem.per_week ?? 1})" 
                                    class="${isActive}"
                                    ${isChecked}
                                >
                                <span class="control__content w-100">
                                    <i class="fal fa-check mb-4"></i>
                                    <div class="w-100">
                                        <div class="d-flex flex-column flex-md-row">
                                            <h5 class="fs-5 fw-bold">${packageItem.name}</h5>
                                            ${packageItem.total_sessions && packageItem.free_sessions ? `
                                                <h4 class="fs-5 text-muted fw-medium"><span class="d-none d-md-inline-block ms-2 me-1">-</span> ${packageItem.total_sessions} Sessions + ${packageItem.free_sessions} Free</h4>
                                            ` : ''}
                                        </div>
                                        <h4 class="mb-0 fs-5 d-flex justify-content-between fw-bold" style="margin-right: -20px;">
                                            AED ${parseFloat(packageItem.amount).toFixed(2)}
                                            ${packageItem.save_amount ? `<span class="text-primary fw-medium fs-6">Save AED ${parseFloat(packageItem.save_amount).toFixed(2)}</span>` : ''}
                                        </h4>
                                    </div>
                                </span>
                            </label>
                        </li>
                    `;
                    packageList.innerHTML += packageHtml;
                });
    
                // Auto-select the first package
                if (data.packages.length > 0) {
                    collectAttributesData(
                        data.packages[0].amount, 
                        data.packages[0].id, 
                        data.packages[0].total_sessions ?? 0,
                        data.packages[0].free_sessions ?? 0,
                        data.packages[0].per_week ?? 1
                    );
                }
            } else {
                packageList.innerHTML = "<li>No packages available for this selection.</li>";
            }
        })
        .catch(error => {
            console.error("Error fetching packages:", error);
        });
    }
});


</script>

@endsection    
