@extends('web.layout.header')
@section('title','Saved Locations')
@section('content')
<style>
    .pac-container {
    z-index: 9999 !important;
    position: absolute !important;
    background-color: white;
    border: 1px solid #ccc;
}
</style>
<section class="mt-30 mb-30">
    <div class="container">
        <div class="row mb-4 justify-content-center align-items-center">
            <div class="col-md-7 mb-0">
                <h3 class="fs-4 mb-0">Saved Locations</h3>
            </div>
            <div class="col-md-5">
                <div class="w-100">
                    <a href="#!" data-bs-toggle="modal" data-bs-target="#addressmodal" class="btn btn-1 float-end"> <i class="fal fa-plus"></i> Add Address </a>
                </div>
            </div>
        </div>
        @if($addresses->isEmpty())
            <div class="col-12 text-center mt-50 mb-50">
                <div class="row justify-content-center">
                    <div class="col-8 col-lg-6">
                        <div class="no-results-div">
                            <img src="{{asset('images/no-locations.png')}}" class="img-fluid mb-3">
                            <h3> No location found </h3>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="row gx-3 mt-20">
                @foreach ($addresses as $address)
                    <div class="col-lg-6 mb-20">
                        <div class="address-box card position-relative">
                            <div class="card-body">
                                <label class="w-100" for="add{{ $address->id }}">
                                    <input type="radio" name="address" id="add{{ $address->id }}" 
                                        {{ $address->is_active ? 'checked' : '' }} 
                                        onclick="setActiveAddress({{ $address->id }})">
                                    <div class="content position-relative">
                                        <div class="d-flex align-items-center justify-content-between mb-10">
                                            <h6 class="mb-0 fs-6 fw-bold" style="max-width: 55%;">{{ ucfirst($address->address_type) }}</h6>
                                            <div class="address-box-action d-flex align-items-end flex-column">
                                                <div class="">
                                                    <i class="fal fa-check tick fs-5 me-2"></i>
                                                    <a href="#!" class="address-box-delete-btn fs-5 me-3" data-address-id="{{ $address->id }}">
                                                        <i class="fal fa-trash-alt"></i> Delete
                                                    </a>
                                                    <a href="javascript:void(0)" data-id="{{ $address->id }}" class="address-box-edit-btn fs-5 edit-address">
                                                        <i class="fal fa-edit"></i> Edit
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="mb-0 mt-2">{{ $address->flat_no }}, {{ $address->building }} - {{ $address->city->name ?? 'N/A' }}, {{ $address->locality_info->name ?? 'N/A' }}</p>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        @endif
    </div>
</section>

<!-- Add Address Modal -->
<div class="modal fade" id="addressmodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add Address</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                <form action="{{ route('store.address') }}" method="POST">
                @csrf
                    <!-- Map Section -->
                    <input id="autocomplete" type="text" placeholder="Enter a location" style="width: 100%; padding: 8px; margin-bottom: 10px;">
                    <div id="map" style="height: 300px; width: 100%; margin-bottom: 20px;"></div>

                    <div class="row">
                        <!-- Hidden Address Field -->
                        <input type="hidden" name="address" id="selected-address">
                        <input type="hidden" name="latitude" id="latitude">
                        <input type="hidden" name="longitude" id="longitude">
                        <div class="col-lg-12 mb-20">
                            <p class="selected-map-address"></p>
                        </div>

                        <div class="col-lg-6 mb-20">
                            <input type="text" name="plot_off_no" class="form-input-1" placeholder="Flat/Office No/Villa" required>
                        </div>
                        <div class="col-lg-6 mb-20">
                            <input type="text" name="building_name" class="form-input-1" placeholder="Building name" required>
                        </div>
                        <div class="col-12 mb-20">
                            <select name="emirate" id="emirate-select" class="form-input-1" required>
                                <option value="">Select Emirates</option>
                                @foreach($emirates as $emirate)
                                    <option value="{{ $emirate->id }}">{{ $emirate->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-20">
                            <select name="locality" id="locality-select" class="form-input-1" required>
                                <option value="">Select Locality</option>
                            </select>
                        </div>
                        <div class="col-12 mb-20">
                            <ul class="selector">
                                <li>
                                    <label class="control" for="home">
                                        <input type="radio" name="address_type" value="home" id="home" checked="">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Home
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="office">
                                        <input type="radio" name="address_type" value="office" id="office">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Office
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="work">
                                        <input type="radio" name="address_type" value="work" id="work">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Work
                                        </span>
                                    </label>
                                </li>
                            </ul>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-1 w-100">Save Address</button>
                        </div>
                    </div>

                    </form>
                </div>
            
        </div>
    </div>
</div>

<!-- Edit Address Modal -->
<div class="modal fade" id="editAddressModal" tabindex="-1" aria-labelledby="editAddressModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
        
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="editAddressModalLabel">Edit Address</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                <form action="{{ route('update.addresses', ['id' => '']) }}" method="POST" id="editAddressForm">
                @csrf
                    <input type="hidden" name="address_edit" id="selected-address-edit">
                    <input type="hidden" name="latitude" id="editLatitude" value="">
                    <input type="hidden" name="longitude" id="editLongitude" value="">

                    <!-- Map Section -->
                    <input id="autocompleteedit" type="text" placeholder="Enter a location" style="width: 100%; padding: 8px; margin-bottom: 10px;">
                    <div id="editMap" style="height: 300px; width: 100%; margin-bottom: 20px;"></div>

                    <input type="hidden" name="address" id="editAddressInput" class="form-input-1" placeholder="Address" required>
                   
                    <div class="row">
                        
                        <div class="col-lg-12 mb-20">
                            <p class="selected-map-address"></p>
                        </div>

                        <div class="col-lg-6 mb-20">
                            <input type="text" name="plot_off_no" id="editPlotOffNo" class="form-input-1" placeholder="Flat No/Office No/Villa" required>
                        </div>
                        <div class="col-lg-6 mb-20">
                            <input type="text" name="building_name" id="editBuildingName" class="form-input-1" placeholder="Building name" required>
                        </div>
                        <div class="col-12 mb-20">
                            <select name="emirate" id="editEmirateSelect" class="form-input-1" required>
                                <option value="">Select Emirates</option>
                                @foreach($emirates as $emirate)
                                    <option value="{{ $emirate->id }}">{{ $emirate->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-20">
                            <select name="locality" id="editLocalitySelect" class="form-input-1" required>
                                <option value="">Select Locality</option>
                            </select>
                        </div>
                        <div class="col-12 mb-20">
                            <ul class="selector">
                                <li>
                                    <label class="control" for="editHome">
                                        <input type="radio" name="address_type_edit" value="home" id="editHome">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Home
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="editOffice">
                                        <input type="radio" name="address_type_edit" value="office" id="editOffice">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Office
                                        </span>
                                    </label>
                                </li>
                                <li>
                                    <label class="control" for="editWork">
                                        <input type="radio" name="address_type_edit" value="work" id="editWork">
                                        <span class="control__content">
                                            <i class="fal fa-check"></i>
                                            Work
                                        </span>
                                    </label>
                                </li>
                            </ul>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-1 w-100">Update Address</button>
                        </div>
                    </div>
                </form>
                </div>
            
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.address-box-edit-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            const addressId = this.dataset.id;

            fetch(`{{ url('edit-address') }}/${addressId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate the edit modal with the retrieved data
                        document.getElementById('editPlotOffNo').value = data.address.plot_off_no;
                        document.getElementById('editBuildingName').value = data.address.building_name;
                        document.getElementById('autocompleteedit').value = data.address.address;
                        document.querySelectorAll('.selected-map-address').forEach(element => {
                                element.textContent =data.address.address;
                            });

                        // Update select fields
                        document.getElementById('editEmirateSelect').value = data.address.emirate_id;
                        loadLocalities(data.address.emirate_id, data.address.locality_id);

                        const addressTypeRadios = document.querySelectorAll(`input[name="address_type_edit"]`);

                        // Iterate through all radio buttons and select the correct one
                        addressTypeRadios.forEach(radio => {
                            if (radio.value === data.address.address_type) {
                                radio.checked = true;
                            }
                        });

                        // Dynamically update the form action with the correct address ID
                        document.getElementById('editAddressForm').action = `{{ url('update-address') }}/${addressId}`;
                        
                        DEFAULT_UAE_LOCATION = { 
                            lat: parseFloat(data.address.latitude), 
                            lng: parseFloat(data.address.longitude) 
                        };
                        console.log(DEFAULT_UAE_LOCATION);
                        initMapEdit();
                        // Show the modal
                        const editModal = new bootstrap.Modal(document.getElementById('editAddressModal'));
                        editModal.show();
                    }
                })
                .catch(error => console.error('Error fetching address:', error));
        });
    });

    function loadLocalities(emirateId, selectedLocalityId) {
    const localitySelect = document.getElementById('editLocalitySelect');
    localitySelect.innerHTML = '<option value="">Select Locality</option>';

    if (emirateId) {
        const baseURL = window.location.origin + window.location.pathname.split('/saved-locations')[0];
        fetch(`${baseURL}/localities/${emirateId}`)
            .then(response => response.json())
            .then(data => {
                data.forEach(locality => {
                    const option = new Option(locality.name, locality.id);
                    option.selected = locality.id == selectedLocalityId; // Preselect the correct locality
                    localitySelect.add(option);
                });
            })
            .catch(error => console.error('Error fetching localities:', error));
    }
}

});
</script>


<script>
    document.getElementById('emirate-select').addEventListener('change', function () {
        const emirateId = this.value;
        const localitySelect = document.getElementById('locality-select');

        localitySelect.innerHTML = '<option value="">Select Locality</option>';

        if (emirateId) { 
            const baseURL = window.location.origin + window.location.pathname.split('/saved-locations')[0];
            fetch(`${baseURL}/localities/${emirateId}`)
                .then(response => response.json())
                .then(data => {
                    data.forEach(locality => {
                        const option = new Option(locality.name, locality.id);
                        localitySelect.add(option);
                    });
                })
                .catch(error => console.error('Error fetching localities:', error));
        }
    });
</script>

<!-- Confirmation Modal -->
<div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Delete Address</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <!-- <img src="{{asset('images/delete.gif')}}" width="120" class="img-fluid mb-2 rounded"> -->
                    <h5 class="mb-3 mt-0">Are you sure you want to delete this address?</h5>
                    <div class="d-flex align-items-center justify-content-center gap-2 mb-3">
                        <button type="button" class="btn btn-dark" data-bs-dismiss="modal" style="width:94px">No</button>
                        <button type="button" class="btn btn-1" id="confirmDeleteButton" style="width:94px">Yes</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let selectedAddressId;

        document.querySelectorAll('.address-box-delete-btn').forEach(btn => {
            btn.addEventListener('click', function (e) {
                e.preventDefault();
                selectedAddressId = this.dataset.addressId; // Get the address ID
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteConfirmationModal'));
                deleteModal.show(); // Show confirmation modal
            });
        });

        document.getElementById('confirmDeleteButton').addEventListener('click', function () {
            if (selectedAddressId) {
                fetch(`{{ route('delete.address', '') }}/${selectedAddressId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! Status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.message) {
                        // alert('Address deleted successfully.');
                        location.reload(); 
                    } else {
                        alert(data.error || 'Failed to delete the address.');
                    }
                })
                .catch(error => {
                    console.error('Error deleting address:', error);
                    alert('An error occurred. Please try again later.');
                })
                .finally(() => {
                    const deleteModal = bootstrap.Modal.getInstance(document.getElementById('deleteConfirmationModal'));
                    deleteModal.hide();
                });
            }
        });
    });
</script>


<script>
let map;
let marker_create;
const UAE_BOUNDS = {
    north: 26.084,
    south: 22.633,
    east: 56.381,
    west: 51.484
};
let DEFAULT_UAE_LOCATION = { lat: 25.276987, lng: 55.296249 }; // Dubai coordinates
function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: DEFAULT_UAE_LOCATION,
            zoom: 12,
            restriction: {
                latLngBounds: UAE_BOUNDS,
                strictBounds: true
            }
        });

        marker_create = new google.maps.Marker({
            position: DEFAULT_UAE_LOCATION,
            map: map,
            draggable: true
        });

        const geocoder = new google.maps.Geocoder();
        
        function updateAddress(location) {
            geocoder.geocode({ location }, (results, status) => {
                if (status === 'OK' && results[0]) {
                    document.getElementById('selected-address').value = results[0].formatted_address;
                    document.querySelectorAll('.selected-map-address').forEach(element => {
                        element.textContent = results[0].formatted_address;
                    });
                    let lat = results[0].geometry.location.lat();
                    let lng = results[0].geometry.location.lng();
            
                    console.log("Latitude:", lat, "Longitude:", lng);
                    document.getElementById('latitude').value = lat;
                    document.getElementById('longitude').value = lng;
                } else {
                    console.error('Failed to retrieve address:', status);
                }
            });
        }

        updateAddress(DEFAULT_UAE_LOCATION);

        marker_create.addListener('dragend', function () {
            updateAddress(marker_create.getPosition());
        });

        // Initialize autocomplete inside the modal event
        const autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'), {
            bounds: new google.maps.LatLngBounds(
                { lat: UAE_BOUNDS.south, lng: UAE_BOUNDS.west },
                { lat: UAE_BOUNDS.north, lng: UAE_BOUNDS.east }
            ),
            strictBounds: true,
        });

        autocomplete.addListener('place_changed', function () {
            const place = autocomplete.getPlace();
            if (place.geometry && place.geometry.location) {
                map.setCenter(place.geometry.location);
                marker_create.setPosition(place.geometry.location);
                updateAddress(place.geometry.location);
            }
        });
    }
    document.addEventListener('DOMContentLoaded', function () {
    

    

    document.getElementById('addressmodal').addEventListener('shown.bs.modal', function () {
        initMap();
    });
});
function initMapEdit() {
        map = new google.maps.Map(document.getElementById('editMap'), {
            center: DEFAULT_UAE_LOCATION,
            zoom: 12,
            restriction: {
                latLngBounds: UAE_BOUNDS,
                strictBounds: true
            }
        });

        marker_create = new google.maps.Marker({
            position: DEFAULT_UAE_LOCATION,
            map: map,
            draggable: true
        });

        const geocoder = new google.maps.Geocoder();
        
        function updateAddress(location) {
            geocoder.geocode({ location }, (results, status) => {
                if (status === 'OK' && results[0]) {
                    console.log(results[0]);
                    document.getElementById('selected-address-edit').value = results[0].formatted_address;
                    document.querySelectorAll('.selected-map-address').forEach(element => {
                        element.textContent = results[0].formatted_address;
                    });
                    document.getElementById('editLatitude').value = results[0].geometry.location.lat();
                    document.getElementById('editLongitude').value = results[0].geometry.location.lng();
                } else {
                    console.error('Failed to retrieve address:', status);
                }
            });
        }

        updateAddress(DEFAULT_UAE_LOCATION);

        marker_create.addListener('dragend', function () {
            updateAddress(marker_create.getPosition());
        });

        // Initialize autocomplete inside the modal event
        const autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocompleteedit'), {
            bounds: new google.maps.LatLngBounds(
                { lat: UAE_BOUNDS.south, lng: UAE_BOUNDS.west },
                { lat: UAE_BOUNDS.north, lng: UAE_BOUNDS.east }
            ),
            strictBounds: true,
        });

        autocomplete.addListener('place_changed', function () {
            const place = autocomplete.getPlace();
            if (place.geometry && place.geometry.location) {
                map.setCenter(place.geometry.location);
                marker_create.setPosition(place.geometry.location);
                updateAddress(place.geometry.location);
            }
        });
    }
</script>

   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU&libraries=places&callback=initMap"></script>
<script>
    let editMap, editMarker;

    // Initialize Map for Editing
    function initEditMap(latitude, longitude) {
        // UAE bounds for restricting map selection
        const UAE_BOUNDS = {
            north: 26.084,
            south: 22.633,
            east: 56.381,
            west: 51.484,
        };

        // Default location (Dubai, UAE)
        const defaultLocation = { lat: latitude, lng: longitude };

        // Initialize the map
        editMap = new google.maps.Map(document.getElementById('editMap'), {
            center: defaultLocation,
            zoom: 12,
            restriction: {
                latLngBounds: UAE_BOUNDS,
                strictBounds: true, // Enforce strict bounds
            },
        });

        // Create a draggable marker at the default location
        editMarker = new google.maps.Marker({
            position: defaultLocation,
            map: editMap,
            draggable: true,
        });

        const geocoder = new google.maps.Geocoder();

        // Update address on drag end
        google.maps.event.addListener(editMarker, 'dragend', function () {
            const position = editMarker.getPosition();
            const lat = position.lat();
            const lng = position.lng();

            // Check if the marker is within UAE bounds
            if (
                lat >= UAE_BOUNDS.south &&
                lat <= UAE_BOUNDS.north &&
                lng >= UAE_BOUNDS.west &&
                lng <= UAE_BOUNDS.east
            ) {
                // If within bounds, update the address and coordinates
                geocoder.geocode({ location: position }, function (results, status) {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('editAddressInput').value = results[0].formatted_address;
                        document.getElementById('editLatitude').value = position.lat();
                        document.getElementById('editLongitude').value = position.lng();
                        document.getElementById('selected-address').value = results[0].formatted_address;

                        const selectedMapAddresses = document.querySelectorAll('.selected-map-address');

                        // Update all elements with the selected address
                        selectedMapAddresses.forEach(element => {
                            element.textContent = results[0].formatted_address;
                        });
                    } else {
                        alert('Failed to retrieve address. Try again.');
                    }
                });
            } else {
                // Reset marker to the default location if moved outside UAE
                alert('Selected location is outside the UAE. Defaulting to Dubai.');
                editMarker.setPosition(defaultLocation);
                editMap.setCenter(defaultLocation);

                document.getElementById('editAddressInput').value = 'Dubai, UAE';
                document.getElementById('editLatitude').value = defaultLocation.lat;
                document.getElementById('editLongitude').value = defaultLocation.lng;

                const selectedMapAddresses = document.querySelectorAll('.selected-map-address');
                selectedMapAddresses.forEach(element => {
                    element.textContent = 'Dubai, UAE';
                });
            }
        });
    }

    // Initialize map with default Dubai location
    initMapEdit(25.276987, 55.296249);
</script>

<!-- Include Google Maps JavaScript API -->
<!--<script>-->
<!--    function initMap() {-->
        
<!--        const UAE_BOUNDS = {-->
<!--            north: 26.084,-->
<!--            south: 22.633,-->
<!--            east: 56.381,-->
<!--            west: 51.484-->
<!--        };-->

        
<!--        const defaultLocation = { lat: 25.276987, lng: 55.296249 };-->

        
<!--        map = new google.maps.Map(document.getElementById('map'), {-->
<!--            center: defaultLocation,-->
<!--            zoom: 12,-->
<!--            restriction: {-->
<!--                latLngBounds: UAE_BOUNDS,-->
<!--                strictBounds: true-->
<!--            }-->
<!--        });-->

        
<!--        marker = new google.maps.Marker({-->
<!--            position: defaultLocation,-->
<!--            map: map,-->
<!--            draggable: true-->
<!--        });-->

        
<!--        const geocoder = new google.maps.Geocoder();-->

        
<!--        google.maps.event.addListener(marker, 'dragend', function () {-->
<!--            const position = marker.getPosition();-->
<!--            const lat = position.lat();-->
<!--            const lng = position.lng();-->

            
<!--            if (-->
<!--                lat >= UAE_BOUNDS.south &&-->
<!--                lat <= UAE_BOUNDS.north &&-->
<!--                lng >= UAE_BOUNDS.west &&-->
<!--                lng <= UAE_BOUNDS.east-->
<!--            ) {-->
<!--                geocoder.geocode({ location: position }, function (results, status) {-->
<!--                    if (status === 'OK' && results[0]) {-->
<!--                        document.getElementById('selected-address').value = results[0].formatted_address;-->
<!--                        const selectedMapAddresses = document.querySelectorAll('.selected-map-address');-->

                        
<!--                        selectedMapAddresses.forEach(element => {-->
<!--                            element.textContent = results[0].formatted_address;-->
<!--                        });-->
<!--                    } else {-->
<!--                        console.error('Failed to retrieve address. Try again.');-->
<!--                    }-->
<!--                });-->
<!--            } else {-->
                
<!--                marker.setPosition(defaultLocation);-->
<!--                map.setCenter(defaultLocation);-->

<!--                document.getElementById('selected-address').value = 'Dubai, UAE';-->
<!--                const selectedMapAddresses = document.querySelectorAll('.selected-map-address');-->

               
<!--                selectedMapAddresses.forEach(element => {-->
<!--                    element.textContent = 'Dubai, UAE';-->
<!--                });-->
<!--                alert('Selected location is outside the UAE. Defaulting to Dubai.');-->
<!--            }-->
<!--        });-->
<!--    }-->

   
<!--    document.getElementById('addressmodal').addEventListener('shown.bs.modal', function () {-->
<!--        initMap();-->
<!--    });-->
<!--</script>-->
@endsection
