@extends('web.layout.header')
@section('title','Home')
@section('content')

<!-- team area start -->
<section id="testimonialBubble" class="tp-testimonial-2-area p-relative pt-50 pb-20">
    <div class="container">
    <div class="row">
        <div class="col-lg-12">
            <div class="text-start">
                <h4 class="mb-2 h5">Customer Reviews <br/></h4>
                <p class="fs-6 text-black mb-4 mt-1">Join The hundreds of satisfied customers who have booked our cleaning services.
                Don't miss out, book now!</p>
                
            </div>
        </div>
    </div>
    
    <div class="row gx-3">
        @foreach($reviews as $review)
            <div class="col-lg-4 mb-4">
                <div class="tp-testimonial-2-wrapper p-3">
                    <div class="user-info mb-1">
                        <div class="user-name d-flex align-items-center w-100">
                            <i class="fa-sharp fa-solid fa-circle-{{ Str::lower(substr($review->user->name ?? 'Anonymous', 0, 1)) }} fs-40 text-green me-2"></i>
                            <div class="">
                                <p class="text-black mt-0 mb-0">{{ $review->user->name ?? 'Anonymous' }}</p>
                                <div id="position" class="review_star">
                                    @for ($i = 1; $i <= 5; $i++)
                                        <span class="p-0 star-icon {{ $i <= $review->rating ? 'full' : '' }}">&starf;</span>
                                    @endfor
                                </div>
                            </div>
                        </div>
                    </div>
                    <p class="review-opinion mb-0 mt-1 fs-14">{{ $review->opinion }}</p>
                    <!-- <span class="t-rel-t">{{ $review->service->name ?? 'Service' }}</span> -->
                </div>
            </div>
        @endforeach


    </div>
    </div>
</section>
<!-- team area end -->

@endsection