@extends('web.layout.header')
@section('title','My Rewards')
@section('meta_tags')

<meta name="description" content="Urbanmop My Rewards">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
@section('content')

<section class="mt-30 mb-30">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-12 mb-20">
                <h3 class="fs-4 mb-0">My Rewards</h3>
            </div>

            <div class="col-12 mb-20">
                <div class="wallet-info" style="background: url( {{ url('web/assets/img/wallet-05454545405054.png') }} ),
				 #FFF7EF ;background-size: contain;background-position: left bottom;background-repeat: no-repeat; border:2px solid #FFBC00" >
                    <div class="row align-items-center">
                        <div class="col-4 col-lg-5 text-center">
                            <img src="{{asset('images/reward-coin.png')}}" class="img-fluid" alt="">
                            
                        </div>
                        <div class="col-8 col-lg-7">
                            <div class="wallet-info-content">
                                <h1 class="text-black">
                                    <b class="text-secondary">{{ $totals['total_points'] }}</b> Pts
                                </h1>
                                <h2 class="fs-4 mb-0 text-black">= AED {{ number_format($totals['total_amount'], 2) }}</h2>
                            </div>
                        </div>
                    </div>                    
                </div>
            </div>

            <div class="col-12 mb-20">
                <div class="row">
                    <span class="col-lg-9 mb-15 mb-lg-0">
                        <h3 class="fs-3 mb-10 fw-600">Transaction</h3>
                        <p class="mb-0">Last Updated {{ $totals['last_date'] ?? 'N/A' }}</p>
                    </span>
                    <div class="col-lg-3"> 
                        <a href="#!" class="btn btn-1 w-100" data-bs-toggle="modal" data-bs-target="#invitefriends">Refer and Earn</a>
                    </div>
                </div>
            </div>

            @forelse ($rewards as $reward)
                <div class="col-lg-6 mb-15">
                    <div class="card">
                        <div class="card-body">
                            <div class="mb-10 d-flex align-items-center justify-content-between w-100 gap-2">
                                <h4 class="mb-0 fs-5 fw-600">#{{ $reward->id }}</h4>
                                <h5 class="mb-0 fs-14 text-muted">{{ \Carbon\Carbon::parse($reward->date)->format('d M Y - h:i A') }}</h5>
                            </div>
                            <div class="mb-0 d-flex align-items-center justify-content-between w-100 gap-2">
                                <h4 class="mb-0 fs-14">{{ $reward->booking_type ?? 'Earn' }}</h4>
                                <h5 class="mb-0 fs-6 fw-600"><b class="text-secondary">{{ $reward->points }}</b> Pts</h5>
                            </div>
                        </div>
                    </div>
                </div>
            @empty

                <div class="col-12 text-center">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="text-center no-results-div"> 
                                <img src="{{asset('images/no-rewards.svg')}}" class="img-fluid mb-3" alt="">
                                <h3>No Rewards Found!</h3>
                            </div>
                        </div>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</section>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="inviteToast" class="toast align-items-center text-bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                Invite Code Copied
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<div class="modal fade" id="invitefriends" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Refer and Earn</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <div class="mb-20">
                        <img src="assets/images/invite.png" class="img-fluid" alt="">
                    </div>
                    <h3 class="fw-600 fs-3 text-secondary mb-20">Share with friends and earn</h3>
                    <p class="mb-20 mx-auto" style="max-width:95%">Give this code to friends, and after their first request, both of you will earn rewards.</p>
                    <a href="#!" class="btn-2 mb-20 mx-auto gap-3" 
                        style="border: 2px dashed #FF9100 !important;" 
                        onclick="copyInviteCode()">
                        <span id="invite-code">{{ $totals['invite_code'] ?? 'N/A' }}</span> <i class="fal fa-clone"></i>
                    </a>
                   
                    <script>
                        function copyInviteCode() {
                            const inviteCode = document.getElementById('invite-code').innerText;

                            if (navigator.clipboard) {
                                // Use the modern Clipboard API
                                navigator.clipboard.writeText(inviteCode)
                                    .then(() => {
                            
                                        const toastElement = document.getElementById('inviteToast');
                                        const toastBody = toastElement.querySelector('.toast-body');
                                        // toastBody.textContent = `Invite code copied: ${inviteCode}`;
                                        toastBody.textContent = `Invite Code Copied`;

                                        toastElement.classList.remove('bg-primary', 'bg-danger'); 
                                        toastElement.classList.add('bg-success'); 

                                        const toast = new bootstrap.Toast(toastElement);
                                        toast.show();

                                    })
                                    .catch(err => {
                                        console.error('Failed to copy: ', err);
                                        alert('Failed to copy invite code. Please try again.');
                                    });
                            } else {
                                // Fallback for older browsers
                                const tempInput = document.createElement('input');
                                tempInput.value = inviteCode;
                                document.body.appendChild(tempInput);
                                tempInput.select();
                                try {
                                    document.execCommand('copy');
                                    console.log('Invite code copied: ' + inviteCode);
                                } catch (err) {
                                    console.error('Fallback: Failed to copy', err);
                                }
                                document.body.removeChild(tempInput);
                            }
                        }
                    </script>

                    <a href="#!" class="btn btn-1 w-100" onclick="shareInvite()">Share</a>

                    <div id="inviteToast" class="toast align-items-center text-white bg-success border-0 position-fixed top-0 end-0 m-3" style="z-index: 1055; display: none;" role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body">
                                Invite code copied successfully!
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                    </div>

                    <script>
                        function shareInvite() {
                            const referenceId = document.getElementById('invite-code').innerText || 'N/A'; // Reference ID
                            const shareText = `
Hi! 👋

Sign up using this Reference ID: *_${referenceId}_* and earn *10 points* instantly!
Download the app here: {!! html_entity_decode(url('share?id=0&type=home')) !!} and enter the ID during sign-up to claim your reward.

Don’t miss out—start earning today! 🚀
`;


                            if (navigator.clipboard) {
                                navigator.clipboard.writeText(shareText)
                                    .then(() => {
                                        showToast('Invite message copied to clipboard!');
                                    })
                                    .catch(err => {
                                        console.error('Failed to copy invite message: ', err);
                                        showToast('Failed to copy invite message. Please try again.', true);
                                    });
                            } else {
                                // Fallback for older browsers
                                const tempInput = document.createElement('textarea');
                                tempInput.value = shareText;
                                document.body.appendChild(tempInput);
                                tempInput.select();
                                try {
                                    document.execCommand('copy');
                                    showToast('Invite message copied to clipboard!');
                                } catch (err) {
                                    console.error('Fallback: Failed to copy invite message', err);
                                    showToast('Failed to copy invite message. Please try again.', true);
                                }
                                document.body.removeChild(tempInput);
                            }
                        }

                        function showToast(message, isError = false) {
                            const toastElement = document.getElementById('inviteToast');
                            const toastBody = toastElement.querySelector('.toast-body');
                            toastBody.textContent = message;

                            toastElement.classList.remove('bg-success', 'bg-danger');
                            toastElement.classList.add(isError ? 'bg-danger' : 'bg-success');
                            toastElement.style.display = 'block';

                            const toast = new bootstrap.Toast(toastElement);
                            toast.show();
                        }

                    </script>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
