@extends('web.layout.header')
@section('title','My Profile - UrbanMop')
@section('meta_tags')

<meta name="description" content="Urbanmop My Profile">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
@section('content')

<main>
<section class="mt-30 mb-30">
    <div class="container">
        <div class="row mb-20 justify-content-center align-items-center">
            <div class="col-12 mb-0">
                <h3 class="fs-4 mb-0">My Profile</h3>
            </div>
        </div>
		<form action="{{ route('update.profiles') }}" method="POST" enctype="multipart/form-data">
		@csrf
		<input type="hidden" name="data_from" value="my_profile">
        <div class="row">
            <div class="col-12 mb-20">
                <div class="profile-img" style="background: url( {{ url('web/assets/img/bg-pattern-349820136.png') }} ),
				 linear-gradient(0deg, #FF8A00 11.32%, #FFBC00 94.74%);background-size: contain;background-position: center;background-repeat: no-repeat;">
					<div class="p-image">
						@if(Auth::user()->profile)
							<img class="profile-pic img-fluid" src="{{ asset('uploads/user/'.Auth::user()->profile) }}" alt="{{ Auth::user()->name }}">
						@else
							<img class="profile-pic img-fluid" src="https://dxbitprojects.com/urbanmob/v2/assets/images/profile-icon.png">
						@endif
						<label class="upload-button" for="file-upload">
							<i class="fal fa-camera-alt"></i> 
						</label>
						<input id="file-upload" name="profile" class="file-upload" type="file" accept="image/*">
					</div>
                </div>
            </div>
            <div class="col-lg-6 mb-20">
				<input type="text" class="form-input-1" name="name" value="{{ $user->name }}" placeholder="Name" required>
			</div>
			<div class="col-lg-6 mb-20">
				<select name="gender" class="form-control" required>
					<option value="" disabled {{ is_null(Auth::user()->gender) ? 'selected' : '' }}>Select Gender</option>
					<option value="Male" {{ Auth::user()->gender == 'Male' ? 'selected' : '' }}>Male</option>
					<option value="Female" {{ Auth::user()->gender == 'Female' ? 'selected' : '' }}>Female</option>
				</select>
			</div>

            <div class="col-lg-6 mb-20">
                <input type="email" class="form-input-1" name="email" placeholder="Email" value="{{ $user->email }}" >
            </div>
            <div class="col-lg-6 mb-20">
				<input type="text" class="form-input-1 flatpickr-input" name="date" placeholder="Select Date" value="{{ $user->DOB }}" id="datePicker">
			</div>
			<script>
				document.addEventListener('DOMContentLoaded', function () {
					flatpickr("#datePicker", {
						maxDate: new Date(),
						dateFormat: "d-m-Y", 
						defaultDate: "{{ \Carbon\Carbon::parse($user->DOB)->format('d-m-Y') }}" 
					});
				});
			</script>
           
			<!-- Include CSS for intl-tel-input (v24.6.0) -->
			<link rel="stylesheet" 
			href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/css/intlTelInput.min.css" 
			integrity="sha512-X3pJz9m4oT4uHCYS6UjxVdWk1yxSJJIJOJMIkf7TjPpb1BzugjiFyHu7WsXQvMMMZTnGUA9Q/GyxxCWNDZpdHA==" 
			crossorigin="anonymous" referrerpolicy="no-referrer" />

			<div class="form-group col-lg-6 mb-20 mobile-no-area-wrap">
				<div class="input-group">
					<!-- Dial Code Input with Flag -->
					<div class="input-group-prepend">
						<input type="hidden" name="dial_code" id="dial-code" 
							class="form-control" value="{{ ltrim(auth()->user()->dial_code ?? '971', '+') }}" 
							required style="width:120px; text-align: center;">
					</div>

					<!-- Phone Number Input -->
					<input type="text" id="phone-number" name="phone" class="form-control" 
						value="{{ $user->phone }}" placeholder="Enter phone number">
				</div>
			</div>

			<!-- Include JS for intl-tel-input (v24.6.0) -->
			<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/build/js/intlTelInput.min.js" 
					integrity="sha512-/sRFlFRbcvObOo/SxW8pvmFZeMLvAF6hajRXeX15ekPgT4guXnfNSjLC98K/Tg2ObUgKX8vn9+Th5/mGHzZbEw==" 
					crossorigin="anonymous" referrerpolicy="no-referrer"></script>

			<script>
				document.addEventListener("DOMContentLoaded", function () {
					const dialCodeInput = document.querySelector("#dial-code");

					const iti = intlTelInput(dialCodeInput, {
						initialCountry: "AE",            // Automatically detect the user's country
						separateDialCode: false,         // Display only the dial code in the input
						autoPlaceholder: "polite",       // Use a smart placeholder
						utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/24.6.0/js/utils.js",
					});
				});
			</script>
			
			@if(auth()->user()->DOB == null)
				<div class="col-lg-6 mb-20">
					<input type="text" class="form-input-1" name="invite_code" value="" placeholder="Referral Code">
				</div>
			@endif
            
			<div class="col-lg-6">
                <button class="btn btn-1 w-100">Submit</button>
            </div>
        </div>
	</form>

    </div>
</section>
</main>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const fileUploadInput = document.getElementById('file-upload');
        const profilePic = document.querySelector('.profile-pic');

        fileUploadInput.addEventListener('change', function (event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    profilePic.src = e.target.result; // Set the preview image source
                };
                reader.readAsDataURL(file); // Read the file to get the data URL
            }
        });
    });
</script>



@endsection
