@extends('web.layout.header')
@section('title','My Booking - UrbanMop')
@section('meta_tags')

<meta name="description" content="Urbanmop My Booking">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
@section('content')

<!-- Firebase and Required Scripts -->
<script src="https://www.gstatic.com/firebasejs/9.6.10/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.6.10/firebase-database-compat.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/rateYo/2.3.4/jquery.rateyo.min.css" integrity="sha512-JEUoTOcC35/ovhE1389S9NxeGcVLIqOAEzlpcJujvyUaxvIXJN9VxPX0x1TwSo22jCxz2fHQPS1de8NgUyg+nA==" crossorigin="anonymous" referrerpolicy="no-referrer">

<section class="pageBannerSection" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url(assets/images/maid_service.jpg);">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="pageBannerContent text-center">
                    <h1 class="text-white">My Booking</h1>
                    <div class="pageBannerPath">
                        <a href="index.php">Home</a> &gt; 
                        <span>My Booking</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="arrow-down">
        <a href="#down"><i class="fal fa-chevron-down"></i></a>
    </div>
</section>

<section class="sec-m-top mb-30" id="down">
    <div class="container">
        <div class="row gx-3">
            @if (empty($cartItems['card']))
                <div class="col-12 text-center mt-50 mb-50">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="no-results-div">
                                <img src="{{asset('images/no-booking.png')}}" class="img-fluid mb-3">
                                <h3>No Bookings Found!</h3>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                @foreach ($cartItems['card'] as $cartItem)
                <div class="col-lg-6 mb-4">
                    <div class="card cart-card overflow-hidden" data-cart-id="{{ $cartItem['id'] }}">
                        <div class="card-body">
                            <div class="cart-item">
                                <div class="cart-item-product d-flex gap-3 align-items-center">
                                    <div class="cart-item-img bg-1">
                                        @php
                                            $service = \App\Service::find($cartItem['service_id']);
                                        @endphp
                                        <img src="{{ asset('uploads/service/' . ($service->thumbnail_img ?? 'default.jpg')) }}" class="img-fluid" alt="Service Image">
                                    </div>
                                    <div class="card-item-details w-100">
                                        <div class="d-flex w-100 gap-2 align-items-center justify-content-between">
                                            <h4 class="mb-2 fw-600 fs-4" style="max-width: 70%; text-align: start">#{{$cartItem['id']}} {{ $cartItem['service_name'] }}</h4>
                                            <h4 class="mb-2 fw-600 fs-4 text-secondary">
                                                @switch($cartItem['status'])
                                                    @case('Accept')
                                                        Accepted
                                                        @break

                                                    @case('Mark As Arrived')
                                                        En route to work
                                                        @break

                                                    @default
                                                        {{ $cartItem['status'] }}
                                                @endswitch
                                            </h4>

                                        </div>
                                        <div class="d-flex w-100 gap-2 align-items-end justify-content-between">
                                            @if (!empty($cartItem['card_attribute']))
                                                <div class="mt-2">
                                                    @foreach ($cartItem['card_attribute'] as $attribute)
                                                        <span class="mb-0">{{ $attribute['attribute_item_name'] }}</span>
                                                        @if (!$loop->last)
                                                            x 
                                                        @endif
                                                    @endforeach 
                                                </div>
                                            @endif
                                            @php
                                                $order = \App\Order::find($cartItem['order_id']);
                                                $order_count = \App\Card::where('order_id',$cartItem['order_id'])->count();
                                                $cod_charges = $cartItem['cod_charge'];
                                                if(isset($order->payment_type) && $order->payment_type != 2){
                                                $cod_charges=0;
                                                }
                                                $parent_cart_id = (string) optional(\App\Card::where('revisit_id', $cartItem['id'])->first())->id ?? "";                ;
                                              
                                                if(empty($parent_cart_id)){
                                                    $total = 
                                                    (float) ($cartItem['amount'] ?? 0) - 
                                                    (float) ($cartItem['coupon_amt']) + 
                                                    (float) ($cartItem['surcharge'] ?? 0)+
                                                    (float) ($cod_charges ?? 0)+
                                                    (float) ($cartItem['tip_id'] ?? 0);
                                                }else{
                                                    $total = 0;
                                                }

                                            @endphp
                                            <h4 class="mb-0 fw-600 fs-4">AED {{ number_format($cartItem['g_total'], 2) }} </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-header bg-1 border-0">
                            <div class="cart-item-footer">
                                <div class="cart-item-timing">
                                    @if($cartItem['service_id'] == 10)
                                        <h4 class="mb-1 fw-600 fs-4">{{ App\Slot::find($cartItem['session_time'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-5 mt-0">{{ \Carbon\Carbon::parse($cartItem['session_date'])->format('d-m-Y')  ?? 'Not specified' }}</p>
                                    @else
                                        <h4 class="mb-1 fw-600 fs-4">{{ App\Slot::find($cartItem['slot_id'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-5 mt-0">{{ \Carbon\Carbon::parse($cartItem['date'])->format('d-m-Y') ?? 'Not specified' }}</p>
                                    @endif
                                </div>
                                <div class="cart-item-btns">
                                    @if($cartItem['status'] == "Mark As Arrived")
                                        <!-- <a 
                                            href="https://www.google.com/maps/search/?api=1&query={{ \App\Address::find($cartItem['address_id'])->latitude ?? '' }},{{ \App\Address::find($cartItem['address_id'])->longitude ?? '' }}" 
                                            target="_blank" 
                                            class="btn btn-secondary p-2 ms-2"
                                            style="text-decoration: none;"
                                        >
                                            <img src="{{ asset('images/location.svg') }}" class="img-fluid" width="24" alt="">
                                        </a> -->
                                    @endif
                                    
                                    @if($cartItem['status'] != "Completed" && $cartItem['status'] != "Pending")
                                        <a href="{{route('contact.support')}}" class="btn btn-secondary p-2 ms-2"><img src="{{ asset('images/support_img.svg') }}" class="img-fluid" width="24" alt=""></a>
                                    @endif

                                    @if($cartItem['status'] == "Completed")
                                        <a href="javascript:void(0)" 
                                        class="btn btn-secondary p-2 reorder-btn ms-2" 
                                        data-card-id="{{ $cartItem['id'] }}"
                                        onclick="handleReorder({{ $cartItem['id'] }})">
                                            <img src="{{ asset('images/return.svg') }}" class="img-fluid" width="24" alt="Reorder">
                                        </a>
                                        @php
                                        $rating = \App\Review::find($cartItem['id']); 
                                       
                                        @endphp
                                        @if(empty($rating))
                                        <a href="#!" 
                                            class="btn btn-2 ms-2" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#reviewrating" 
                                            data-service-id="{{ $cartItem['service_id'] }}"
                                            data-cart-id="{{ $cartItem['id'] }}">Rating</a>
                                        @endif
                                    @endif
                                    
                                    @if($cartItem['status'] == "Pending")
                                        <a href="#!" 
                                            class="btn btn-2 ms-2" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#modifyModal" 
                                            data-service-id="{{ $cartItem['service_id'] }}"
                                            data-cart-date="{{ $cartItem['date'] }}"
                                            data-cart-slot="{{ $cartItem['slot_id'] }}"
                                            data-cart-id="{{ $cartItem['id'] }}">Modify?</a>
                                    @endif
                                 </div> 
                            </div>
                        </div>

                        <a href="{{ route('booking-detail',$cartItem['id']) }}" class="overlay-link-service"></a>
                    </div>
                </div>
                @endforeach
                <div class="pagination-wrapper">
                    {{ $card->links() }}
                </div>
            @endif
        </div>
    </div>
</section>

<div class="modal fade" id="modifyModal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="exampleModalLabel">Modify Booking</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <div class="row">
                  <div class="col-12 mb-20">
                        <a href="#!" 
                            class="btn-outline w-100" 
                            data-bs-toggle="modal" 
                            data-bs-target="#rescheduleModal" 
                            data-bs-dismiss="modal" 
                            id="rescheduleButton" 
                            data-service-id=""
                            data-cart-id=""
                            data-cart-date=""
                            data-cart-slot=""
                        > 
                            <span class="d-flex gap-2 align-items-center">
                                <i class="fal fa-calendar-alt"></i> Reschedule Booking
                            </span> 
                            <i class="far fa-angle-right text-secondary"></i>
                        </a>

                  </div>
                  <div class="col-12 mb-20">
                        <a href="#!" class="btn-outline w-100" data-bs-toggle="modal" data-bs-target="#cancelModal" data-bs-dismiss="modal"> <span class="d-flex gap-2 align-items-center"><i class="fal fa-calendar-times"></i> Cancel Booking</span> <i class="far fa-angle-right text-secondary"></i></a>
                  </div>
                  <div class="col-12">
                        <a href="{{route('contact.support')}}" class="btn-outline w-100"> <span class="d-flex gap-2 align-items-center"><i class="fal fa-headset"></i> Get Support</span> <i class="far fa-angle-right text-secondary"></i></a>
                  </div>
               </div>
            </div>
      </div>
   </div>
</div>

<div class="modal fade" id="rescheduleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Modify Date and Time</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 mb-4">
                        <input type="date" class="form-input-1 form-control" id="date-picker" placeholder="Select Date">
                    </div>
                    <div class="col-12 mb-4">
                        <ul id="time-slots-list" class="row gx-2">
                            <!-- Time slots will be dynamically generated here -->
                        </ul>
                    </div>
                    <div class="col-12">
                        <button id="proceedButton" class="btn btn-1 text-center w-100">Proceed</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
            <div class="modal-header">
               <h1 class="modal-title fs-5" id="exampleModalLabel">Cancel Booking</h1>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <div class="row">
                  <div class="col-12 text-center">
                        <p class="mb-10">Would you like to proceed with canceling? <br>
                        This will cancel your booking.</p>

                        <p class="text-secondary mb-20 fw-600">25 AED Cancellation Fees Will Apply</p>
                        <div class="d-flex align-items-center gap-3 justify-content-between">
                           <a href="#!" class="btn btn-2 w-100" data-bs-dismiss="modal">No</a>
                           <a href="javascript:void(0)" class="btn btn-1 w-100" id="confirmCancelButton" data-cart-id="">Yes, Proceed</a>
                        </div>
                  </div>
               </div>
            </div>
      </div>
   </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    jQuery.noConflict();
    function handleReorder(cardId) {
       
        console.log("Button clicked, Card ID:", cardId);

        if (!cardId) {
            alert('Card ID not found.');
            return;
        }

        fetch('{{ url("reorder") }}/' + cardId, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            console.log("Server response:", data);
            if (data.success) {
                showToast('Reorder successful!', 'success');

                setTimeout(() => {
                window.location.href = '{{ url("cart") }}';
            }, 2000);
            } else {
                alert('Reorder failed: ' + data.message);
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert('An error occurred while processing your request.');
        });
    }

    function showToast(message, type = 'warning') {
        // Create the toast container if it doesn't exist
        let toastContainer = document.querySelector('.toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
            document.body.appendChild(toastContainer);
        }

        // Create the toast element
        const toastElement = document.createElement('div');
        toastElement.className = `toast align-items-center text-bg-${type} border-0`;
        toastElement.setAttribute('role', 'alert');
        toastElement.setAttribute('aria-live', 'assertive');
        toastElement.setAttribute('aria-atomic', 'true');

        // Create the toast content
        const toastContent = `
            <div class="d-flex">
                <div class="toast-body">
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        `;
        toastElement.innerHTML = toastContent;

        // Append the toast element to the container
        toastContainer.appendChild(toastElement);

        // Initialize and show the toast
        const toast = new bootstrap.Toast(toastElement);
        toast.show();

        // Automatically remove the toast element after it's hidden
        toastElement.addEventListener('hidden.bs.toast', () => {
            toastElement.remove();
        });
    }

    document.addEventListener("DOMContentLoaded", function () {
        const rescheduleButton = document.getElementById("rescheduleButton");
        const datePicker = document.getElementById("date-picker");
        const slotsList = document.getElementById("time-slots-list");
        const proceedButton = document.getElementById("proceedButton");
        let currentCartId = null;
        let currentCartDate = null;
        let currentCartSlot = null;
        let serviceId = null;

        document.querySelectorAll('[data-bs-target="#modifyModal"]').forEach(modifyBtn => {
            modifyBtn.addEventListener("click", function () {
                const serviceIds = this.getAttribute("data-service-id");
                rescheduleButton.setAttribute("data-service-id", serviceIds);

                const cartId = this.getAttribute("data-cart-id");
                rescheduleButton.setAttribute("data-cart-id", cartId);
                
                const cartDate = this.getAttribute("data-cart-date");
                rescheduleButton.setAttribute("data-cart-date", cartDate);
                
                const cartSlot = this.getAttribute("data-cart-slot");
                rescheduleButton.setAttribute("data-cart-slot", cartSlot);
            });
        });

        rescheduleButton.addEventListener("click", function () {
            serviceId = this.getAttribute("data-service-id");
            currentCartId = this.getAttribute("data-cart-id");
            currentCartDate = this.getAttribute("data-cart-date");
            currentCartSlot = this.getAttribute("data-cart-slot");

            fetchTimeSlots(currentCartDate, currentCartSlot);
        });

        function getTodayDate() {
            const today = new Date();
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, '0');
            const day = String(today.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        const today = getTodayDate();
        datePicker.value = today;
        datePicker.min = today;

        function fetchTimeSlots(date, preselectedSlot = null) {

            fetch("{{ route('slots_list') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ date: date, service_id: serviceId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "1") {
                    const slotsData = data.data;

                    datePicker.value = date;
                    datePicker.min = getTodayDate(); 

                    slotsList.innerHTML = ''; 
                    slotsData.forEach(slot => {
                        if (slot.available && !slot.is_past_slot) {
                            const listItem = document.createElement("li");
                            listItem.className = 'col-6 mb-2';
                            listItem.innerHTML = `
                                <label class="control w-100" for="time_${slot.slot_id}">
                                    <input type="radio" name="time" id="time_${slot.slot_id}" value="${slot.slot_id}" ${slot.slot_id === preselectedSlot ? 'checked' : ''}>
                                    <span class="control__content fs-14 text-center w-100 justify-content-center">
                                        ${slot.slot_name}
                                    </span>
                                </label>
                            `;
                            slotsList.appendChild(listItem);
                        }
                    });
                } else {
                    console.error("Failed to load time slots:", data.message);
                }
            })
            .catch(error => console.error("Error fetching time slots:", error));
        }

        fetchTimeSlots(today); 
        datePicker.addEventListener("change", function () {
            const selectedDate = this.value;
            fetchTimeSlots(selectedDate);
        });

        proceedButton.addEventListener("click", function () {
            const selectedSlot = document.querySelector('input[name="time"]:checked');
            if (!selectedSlot) {
                alert('Please select a time slot.');
                return;
            }

            fetch("{{ route('reschedule') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    date: datePicker.value,
                    slot_id: selectedSlot.value,
                    card_id: currentCartId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showToast('Reschedule successful!', 'success');
                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                } else {
                    alert('Failed to reschedule: ' + data.message);
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert('An error occurred while processing your request.');
            });
        });
    });

</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/rateYo/2.3.4/jquery.rateyo.min.js" integrity="sha512-09bUVOnphTvb854qSgkpY/UGKLW9w7ISXGrN0FR/QdXTkjs0D+EfMFMTB+CGiIYvBoFXexYwGUD5FD8xVU89mw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<div class="modal fade" id="reviewrating" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Make a Review Rating</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body">
                <form action="javascript:;" id="reviewForm">
                    <div class="mb-3 text-center">
                        <div id="rateYo" class="mx-auto" style="width: 150px;"></div>
                        <input type="hidden" name="rating" id="rating" value="0">
                    </div>

                    <div class="mb-3">
                        <h3 class="fs-5 mb-3">You can write your detailed review here</h3>
                        <textarea name="review" id="review" placeholder="Enter here" class="form-control" required></textarea>
                    </div>
                    
                    <input type="hidden" name="cart_id" id="cart_id">
                    <input type="hidden" name="service_id" id="service_id">
                    
                    <button type="submit" class="btn btn-1 w-100">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Attach click event to buttons that trigger the review form modal
        document.querySelectorAll('[data-bs-target="#reviewrating"]').forEach(button => {
            button.addEventListener("click", function () {
                const cartId = button.getAttribute('data-cart-id');
                const serviceId = button.getAttribute('data-service-id');

                // Set values in the modal form
                document.getElementById('cart_id').value = cartId;
                document.getElementById('service_id').value = serviceId;
            });
        });

        // Handle review form submission
        const reviewForm = document.getElementById('reviewForm');
        if (reviewForm) {
            reviewForm.addEventListener('submit', function (e) {
                e.preventDefault(); // Prevent the default form submission

                const formData = new FormData(reviewForm);
                const formDataObject = {};
                formData.forEach((value, key) => {
                    formDataObject[key] = value;
                });

                fetch("{{ route('submit-review') }}", {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token for security
                    },
                    body: JSON.stringify(formDataObject)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showToast(data.message, 'success');
                        const modal = document.getElementById('reviewrating');
                        const backdrop = document.querySelector('.modal-backdrop');

                        modal.classList.remove('show'); // Hide modal
                        document.body.classList.remove('modal-open'); // Remove body class
                        if (backdrop) backdrop.remove(); // Remove backdrop
                        reviewForm.reset();
                        // location.reload(); 
                    } else {
                        alert('Something went wrong. Please try again.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while processing your request.');
                });
            });
        }
    });
</script>

<script>
jQuery("#rateYo").rateYo({
                starWidth: "20px",
                rating: jQuery('#rating').val(),
                spacing: "2px",
                ratedFill: "#ed5636",
                'starSvg':`<svg version="1.1"
                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:a="http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"
                x="0px" y="0px" width="528.1px" height="512.1px" viewBox="0 0 528.1 512.1" style="enable-background:new 0 0 528.1 512.1;"
                xml:space="preserve">
                <path d="M292.8,18C287.5,7,276.3,0,264,0s-23.4,7-28.8,18l-64.3,132.3L27.3,171.5c-12,1.8-22,10.2-25.7,21.7s-0.7,24.2,7.9,32.7
                L113.7,329L89.1,474.7c-2,12,3,24.2,12.9,31.3s23,8,33.8,2.3l128.3-68.5l128.3,68.5c10.8,5.7,23.9,4.9,33.8-2.3s14.9-19.3,12.9-31.3
                L414.4,329l104.2-103.1c8.6-8.5,11.7-21.2,7.9-32.7s-13.7-19.9-25.7-21.7l-143.7-21.2L292.8,18z"/>
                </svg>`,
                // halfStar: true,
                onChange: function (rating, rateYoInstance) {

                    jQuery('#rating').val(rating);
                }
            });
        </script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let currentCartIdForCancel = null;

        // Attach cart ID to cancel modal when Modify button is clicked
        document.querySelectorAll('[data-bs-target="#reviewrating"]').forEach(modifyBtn => {
            modifyBtn.addEventListener("click", function () {
                const cartId = this.getAttribute("data-cart-id");
            });
        });

        // Attach cart ID to cancel modal when Modify button is clicked
        document.querySelectorAll('[data-bs-target="#modifyModal"]').forEach(modifyBtn => {
            modifyBtn.addEventListener("click", function () {
                const cartId = this.getAttribute("data-cart-id");
                document.querySelector('#cancelModal #confirmCancelButton').setAttribute('data-cart-id', cartId);
            });
        });

        // Firebase configuration
        // const firebaseConfig = {
        //     apiKey: 'AIzaSyBcj7bzjCKrdXDrVa7WC5vjFagQ5z0RZAM',
        //     authDomain: 'urban-75edf.firebaseapp.com',
        //     databaseURL: 'https://urban-75edf-default-rtdb.firebaseio.com',
        //     projectId: 'urban-75edf',
        //     storageBucket: 'urban-75edf.firebasestorage.app',
        //     messagingSenderId: '332817317533',
        //     appId: '1:332817317533:web:d7e0124e6f8fd251455e74',
        // };

        const firebaseConfig = {
            apiKey: "AIzaSyBwYmALuC1s46dRc0QlkEbLR0maOjE6yQs", // Use the new API key if you have it, or keep the old one if it hasn't changed.
            authDomain: "urbenmopadmin.firebaseapp.com",
            databaseURL: "https://urbenmopadmin-default-rtdb.firebaseio.com",
            projectId: "urbenmopadmin",
            storageBucket: "urbenmopadmin.appspot.com",
            messagingSenderId: "154150532215", // Replace with the new messaging sender ID
            appId: "1:154150532215:android:b5adaa9576302388bf4272", // Use the provided App ID
        };

        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);
        const database = firebase.database();

        // Handle cancel confirmation
        document.getElementById('confirmCancelButton').addEventListener('click', function () {
            currentCartIdForCancel = this.getAttribute('data-cart-id');
            if (!currentCartIdForCancel) {
                alert('Invalid booking ID.');
                return;
            }

            const currentURL = window.location.href;
            const baseURL = currentURL.split('/my-bookings')[0] + '/';
            // Send cancel request to the backend
            fetch(`${baseURL}booking/cancel`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    booking_id: currentCartIdForCancel
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update the Firebase Realtime Database for real-time updates
                    const statusRef = firebase.database().ref(`cart/${currentCartIdForCancel}/status`);
                    statusRef.set("Canceled")
                        .then(() => {
                            
                            showToast('Your booking has been successfully canceled.', 'success');
                            setTimeout(function () {
                                location.reload();
                            }, 2000);
                            
                        })
                        .catch(error => {
                            console.error("Error updating Firebase status:", error);
                            alert('An error occurred while updating the booking status in Firebase.');
                        });
                } else {
                    alert('Failed to cancel the booking: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while processing your request.');
            });
        });
    });
</script>

<script>
    // Firebase configuration
    // const firebaseConfig = {
    //     apiKey: 'AIzaSyBcj7bzjCKrdXDrVa7WC5vjFagQ5z0RZAM',
    //     authDomain: 'urban-75edf.firebaseapp.com',
    //     databaseURL: 'https://urban-75edf-default-rtdb.firebaseio.com',
    //     projectId: 'urban-75edf',
    //     storageBucket: 'urban-75edf.firebasestorage.app',
    //     messagingSenderId: '332817317533',
    //     appId: '1:332817317533:web:d7e0124e6f8fd251455e74',
    // };

    const firebaseConfig = {
        apiKey: "AIzaSyBwYmALuC1s46dRc0QlkEbLR0maOjE6yQs", // Use the new API key if you have it, or keep the old one if it hasn't changed.
        authDomain: "urbenmopadmin.firebaseapp.com",
        databaseURL: "https://urbenmopadmin-default-rtdb.firebaseio.com",
        projectId: "urbenmopadmin",
        storageBucket: "urbenmopadmin.appspot.com",
        messagingSenderId: "154150532215", // Replace with the new messaging sender ID
        appId: "1:154150532215:android:b5adaa9576302388bf4272", // Use the provided App ID
    };


    // Initialize Firebase
    firebase.initializeApp(firebaseConfig);
    const database = firebase.database();

    document.addEventListener("DOMContentLoaded", function () {
        const cartItems = document.querySelectorAll('.cart-card'); 

        cartItems.forEach((cartItem) => {
            const cartId = cartItem.getAttribute('data-cart-id');
            if (cartId) {
                const statusRef = firebase.database().ref(`cart/${cartId}/status`);

                // Attach Firebase listener
                statusRef.on('value', (snapshot) => {
                    const newStatus = snapshot.val();

                    // if (newStatus) {
                    //     const statusElement = cartItem.querySelector('.text-secondary');
                    //     if (statusElement) {
                    //         switch (newStatus) {
                    //             case "Accept":
                    //                 statusElement.textContent = "Accepted";
                    //                 break;
                    //             case "Mark As Arrived":
                    //                 statusElement.textContent = "En route to work";
                    //                 break;
                    //             default:
                    //                 statusElement.textContent = newStatus; // Default to the original status
                    //                 break;
                    //         }

                    //     }
                    // }
                });
            }
        });
    });
</script>
@endsection
