@extends('web.layout.header')
@section('title','Checkout - UrbanMop')
@section('meta_tags')

<meta name="description" content="Urbanmop Checkout">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
@section('content')

<section class="pageBannerSection d-none d-md-block" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url(assets/images/maid_service.jpg);">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="pageBannerContent text-center">
                    <h1 class="text-white">Checkout</h1>
                    <div class="pageBannerPath">
                        <a href="index.php">Home</a> &gt; 
                        <span>Checkout</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="arrow-down">
        <a href="#down"><i class="fal fa-chevron-down"></i></a>
    </div>
</section>

<section class="sec-m-top mb-30 sticky-wrapper" id="down">
    <div class="container">
        
    @php
        $founds = 0;
    @endphp
    <div class="row">
                <div class="col-lg-8">
            @if (empty($cartItems['card']))
            <div class="row">
                <div class="col-12 text-center mt-50 mb-50">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="no-results-div">
                                <img src="{{asset('images/empty-cart.png')}}" class="img-fluid mb-3">
                                <h3> Your cart is empty </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @else
                @php
                    $found = false;
                @endphp
                <div class="row gx-3">
                @foreach ($cartItems['card'] as $cartItem)
                    @php
                        if($cartItem['service_id'] == 10){
                            $selected_packages = $cartItem['selected_packages'];
                            if($selected_packages != 11){
                                $found = true;
                            }
                        }
                    @endphp
                <div class="col-lg-6 mb-4">
                    <div class="card cart-card overflow-hidden">
                        <div class="card-body">
                            <div class="cart-item">
                                <div class="cart-item-product d-flex align-items-center">
                                    <div class="cart-item-img bg-1">
                                        @php
                                            // Retrieve the service thumbnail by service_id
                                            $service = \App\Service::find($cartItem['service_id']);
                                        @endphp
                                        <img src="{{ asset('uploads/service/' . ($service->thumbnail_img ?? 'default.jpg')) }}" class="img-fluid" alt="Service Image">
                                    </div>

                                    <div class="card-item-details w-100">
                                       <b> <h4 class="mb-0 fw-600 fs-5">{{ $cartItem['service_name'] }}</h4> </b>
                                        <div class="d-flex w-100 gap-2 align-items-end justify-content-between">

                                            <!-- Attributes -->
                                            @if (!empty($cartItem['card_attribute']))
                                                <div class="mt-2 text-muted" style=" width: 75%; ">
                                                    @foreach ($cartItem['card_attribute'] as $attribute)
                                                        <span class="mb-0 fs-6">{{ $attribute['attribute_item_name'] }}</span>
                                                        @if (!$loop->last)
                                                            x 
                                                        @endif
                                                    @endforeach
                                                </div>
                                            @endif
                                            <h4 class="mb-0 fw-600 fs-6 amount">AED {{ number_format($cartItem['sub_total'], 2) }} </h4>
                                        </div>
                                    </div>
                                </div>
                                
                               
                            </div>
                        </div>

                        <div class="card-header bg-1 border-0">
                            <div class="cart-item-footer">
                                <div class="cart-item-timing">
                                    @if($cartItem['service_id'] == 10)
                                        <h4 class="mb-1 fw-600 fs-5">{{ \App\Slot::find((int) $cartItem['session_time'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-6 mt-0">{{\Carbon\Carbon::parse($cartItem['session_date'])->format('d-m-Y')  ?? 'Not specified' }}</p>
                                    @else
                                        <h4 class="mb-1 fw-600 fs-5">{{ $cartItem['slot'] ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-6 mt-0">{{ isset($cartItem['date']) ? \Carbon\Carbon::parse($cartItem['date'])->format('d-m-Y') : 'Not specified' }}</p>
                                    @endif
                                </div>
                               
                                @if($cartItem['cod_charge'] > 0)
                                    <div>
                                        @php
                                            $founds = 1;
                                        @endphp
                                        Surcharge: AED {{ $cartItem['cod_charge'] ?? "-" }}
                                        @if($cartItem['material_charge'] > 0 )
                                        <br>
                                        Material Charge: AED {{ $cartItem['material_charge'] ?? "-" }}
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                </div>
                    <div class="row">
                    <div class="col-lg-6 mb-30">
                        <div class="row" style="padding-right: 0">
                            <div class="col-12 mb-2">
                                <h3 class="fs-4 mb-0">Tip Amount</h3>
                            </div>
                            <div class="col-12" style="padding-right: 0">
                                <ul class="selector tip-amount">
                                    <li>
                                        <label class="control h-100 mb-2" for="aed10">
                                            <input type="radio" class="{{ (isset($cartItems['tip_amount']) && $cartItems['tip_amount'] == 10) ? 'active' : '' }}" name="tipamount" id="aed10" onclick="toggleTipSelection(this, 10)">
                                            <span class="control__content h-100 flex-column justify-content-center">
                                                AED 10
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control h-100 mb-2" for="aed20">
                                            <input type="radio" class="{{ (isset($cartItems['tip_amount']) && $cartItems['tip_amount'] == 20) ? 'active' : '' }}" name="tipamount" id="aed20" onclick="toggleTipSelection(this, 20)">
                                            <span class="control__content text-center h-100 flex-column justify-content-center">
                                                AED 20
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="control h-100 mb-2" for="aed30">
                                            <input type="radio" name="tipamount" class="{{ (isset($cartItems['tip_amount']) && $cartItems['tip_amount'] == 30) ? 'active' : '' }}" id="aed30" onclick="toggleTipSelection(this, 30)">
                                            <span class="control__content h-100 flex-column justify-content-center">
                                                AED 30
                                            </span>
                                        </label>
                                    </li>
                                    <li>
                                        <div class="input-group mb-2" style="max-width: 180px;">
                                            <input type="text" class="form-input-1" id="customTipInput" placeholder="Enter Amount" style="padding-left: 10px; border-radius: 6px !important;" 
                                                oninput=" this.value = this.value.replace(/[^0-9]/g, '')">
                                            <button type="button" id="applyCustomTip" class="btn btn-primary" onclick="applyCustomTip()">Apply</button>
                                            <button type="button" id="clearCustomTip" class="btn btn-secondary d-none" onclick="clearAllSelections()">Clear</button>
                                        </div>
                                    </li>
                                </ul>



                            </div>
                            
                        </div>
                        
                        <div class="row mt-20">
                            <div class="col-12">
                                <h3 class="fs-4 mb-2">Have Coupon Code?</h3>
                                <div class="position-relative coupon-input">
                                    <input type="text" value="{{ isset($cartItems['coupon_code']) ? $cartItems['coupon_code'] : '' }}" class="form-input-1 coupon-text" placeholder="Enter Coupon Code">
                                    
                                        <a href="javascript:void(0);" 
                                        style="display: {{ isset($cartItems['coupon_amount']) ? 'none' : 'block' }};" 
                                        onclick="applyCoupon()">Apply</a>

                                        <a href="javascript:void(0);" 
                                        style="display: {{ isset($cartItems['coupon_amount']) ? 'block' : 'none' }};" 
                                        onclick="applyCouponClear()">Clear</a>

                                </div>
                            </div>
                            
                        </div>
                    </div>

                    <div class="col-lg-6 mb-30">
                        
                    <div class="col-12 mb-20">
                        <h3 class="fs-4 mb-0">Payment Information</h3>
                    </div>

                    <div class="col-12">
                        <div class="row package-selector">
                            <div class="col-lg-12 mb-2">
                                <label class="control w-100" for="pi1">
                                    <input type="radio" name="paymentselect" id="pi1">
                                    <span class="control__content w-100 align-items-start">
                                        <i class="fal fa-check mx-0 mt-2"></i>
                                        <div class="w-100">
                                            <h5 class="h6 d-flex gap-2 align-items-center"><img src="{{ asset('web/assets/img/reward-coin.svg') }}" class="img-fluid"> Reward</h5>
                                            <h4 class="mb-0 fs-5 d-flex justify-content-between"><span class="text-muted h6 mb-0">Reward Balance</span> <span>AED <b class="text-secondary">{{ auth()->check() ? \App\RewardUser::where('user_id', auth()->user()->id)->sum('amounts') : 0 }}
                                            </b></span></h4>
                                        </div>
                                    </span>
                                </label>
                            </div>

                            <div class="col-lg-12 mb-2">
                                <label class="control w-100" for="pi2">
                                    <input type="radio" name="paymentselect" id="pi2">
                                    <span class="control__content w-100 align-items-start">
                                        <i class="fal fa-check mx-0 mt-2"></i>
                                        <div class="w-100">
                                            <h5 class="h6 d-flex gap-2 align-items-center"><img src="{{ asset('web/assets/img/wallet.svg') }}" class="img-fluid"> Wallet</h5>
                                            <h4 class="mb-0 fs-5 d-flex justify-content-between"><span class="text-muted h6 mb-0">Wallet Balance</span> <span>AED <b class="text-secondary">{{auth()->user()->wallet_balance}}</b></span></h4>
                                        </div>
                                    </span>
                                </label>
                            </div>

                            <div class="col-lg-12 mb-2">
                                <label class="control w-100" for="pi3">
                                    <input type="radio" name="paymentselect" id="pi3">
                                    <span class="control__content w-100">
                                        <i class="fal fa-check mx-0"></i>
                                        <div class="w-100">
                                            <h5 class="h6 mb-0 d-flex gap-2 align-items-center"><img src="{{ asset('web/assets/img/telr-logo.svg') }}" class="img-fluid"> Debit/Credit Card</h5>
                                        </div>
                                    </span>
                                </label>
                            </div>
                            
                            
                            <div class="col-lg-12 mb-2" style="{{($found) ? 'display:none !important;' : '' }}">
                                <label class="control w-100" for="pi4">
                                    <input type="radio" name="paymentselect" id="pi4">
                                    <span class="control__content w-100">
                                        <i class="fal fa-check mx-0"></i>
                                        <div class="w-100">
                                            <h5 class="h6 mb-0 d-flex gap-2 align-items-center"><img src="{{ asset('web/assets/img/card.svg') }}" class="img-fluid"> Cash</h5>
                                        </div>
                                    </span>
                                </label>
                            </div>

                            <div class="col-lg-12 mb-2">
                                <label class="control w-100" for="pi5">
                                    <input type="radio" name="paymentselect" id="pi5">
                                    <span class="control__content w-100">
                                        <i class="fal fa-check mx-0"></i>
                                        <div class="w-100">
                                            <h5 class="h6 mb-0 d-flex gap-2 align-items-center"><img src="{{ asset('web/assets/img/tabby.svg') }}" class="img-fluid"></h5>
                                        </div>
                                    </span>
                                </label>
                            </div>

                            <div id="tabby" style="display: none;">Tabby Content</div>
                            <div id="tabbyCard" style="display: none;">Tabby Card Content</div>

                            <script>
                                document.addEventListener('DOMContentLoaded', function () {
                                    const paymentOptions = document.querySelectorAll('input[name="paymentselect"]');
                                    const tabby = document.getElementById('tabby');
                                    const tabbyCard = document.getElementById('tabbyCard');
                                    const cod_charge = document.getElementById('cod_charge');
                                    const surcharge = document.getElementById('surcharge');
                                    // cod_charge.style.display = 'flex';

                                    paymentOptions.forEach(option => {
                                        option.addEventListener('change', function () {
                                            if (document.getElementById('pi5').checked) {
                                                surcharge.style.display = 'none';
                                                const totalAmount = parseFloat(
                                                    "{{ 
                                                        (float) ($cartItems['total'] ?? 0) + 
                                                        (float) ($cartItems['cod_charge'] ?? 0) + 
                                                        (float) ($cartItems['tip_amount'] ?? 0) - 
                                                        (float) ($cartItems['coupon_amount'] ?? 0) 
                                                    }}"
                                                );

                                                if (totalAmount > 500) {
                                                    const tabby = document.getElementById('tabby');
                                                    const tabbyCard = document.getElementById('tabbyCard');
                                                    if (tabby && tabbyCard) {
                                                        tabby.style.display = 'flex';
                                                        tabbyCard.style.display = 'flex';
                                                    }
                                                }

                                                applyCod(0);
                                            } else if(document.getElementById('pi4').checked) {
                                                surcharge.style.display = 'flex';
                                                applyCod(1);
                                                tabby.style.display = 'none'; 
                                                tabbyCard.style.display = 'none'; 
                                            } else {
                                                surcharge.style.display = 'none';
                                                tabby.style.display = 'none'; 
                                                tabbyCard.style.display = 'none'; 
                                                applyCod(0);
                                            }
                                        });
                                    });
                                });
                            </script>
                            
                        </div>
                    </div>
                    </div>
                    </div>
                    </div>
                    


                    <div class="col-lg-4 mb-20">
                    <div class="sidebar"  id="sticky-side">
                    <div class="card">
                                <div class="card-body">
                                        <div class="text-end">

                                        <h4 class="mb-0 fs-5 d-flex justify-content-between border-bottom rounded-0 py-2">Sub Total: <span class="subtotal">AED {{ $cartItems['total'] ?? 0 }}</span></h4>
                                        <h5 class="mb-0 fs-5 justify-content-between border-bottom rounded-0 py-2 " style="display:none;" id="surcharge">COD Charge: <span class="original_cod">AED {{ $cartItems['surcharge'] ?? 0 }}</span></h5>
                                        <h5 
                                            class="mb-0 fs-5 justify-content-between border-bottom rounded-0 py-2" 
                                            style="display: {{ ($cartItems['cod_charge'] == 0) ? 'none' : 'flex' }};"
                                            id="cod_charge"
                                        >
                                            Surcharge: <span>AED {{ number_format($cartItems['cod_charge'] ?? 0, 2) }}</span>
                                        </h5>
                                        @if(isset($cartItems['coupon_amount']))
                                            <h5 class="mb-0 fs-5 d-flex justify-content-between border-bottom rounded-0 py-2 coupon-container">Coupon: <span class="coupon">AED -{{ (float) $cartItems['coupon_amount'] ?? 0 }}</span></h5>
                                        @else
                                            <h5 class="mb-0 fs-5 d-flex justify-content-between border-bottom rounded-0 py-2 coupon-container" style="display:none !important;">Coupon: <span class="coupon">AED 0</span></h5>
                                        @endif

                                        @if(isset($cartItems['tip_amount']) && ($cartItems['tip_amount'])!=0)
                                            <h5 class="mb-0 fs-5 d-flex justify-content-between border-bottom rounded-0 py-2 tip-container">Tip: <span class="tip">AED {{ $cartItems['tip_amount'] ?? 0 }}</span></h5>
                                        @else
                                            <h5 class="mb-0 fs-5 d-flex justify-content-between border-bottom rounded-0 py-2 tip-container" style="display:none !important;">Tip: <span class="tip">AED 0</span></h5>
                                        @endif

                                        
                                        

                                        <input type="hidden" name="s" value="{{ 
                                                    (float) ($cartItems['total'] ?? 0) + 
                                                    (float) ($cartItems['tip_amount'] ?? 0) - 
                                                    (float) ($cartItems['coupon_amount'] ?? 0) 
                                                }}" class="grand_total">
                                        <h5 class="mb-0 fs-5 text-muted d-flex justify-content-between pt-2">Total Amount:  
                                            <span class="total">AED
                                                {{ 
                                                    (float) ($cartItems['total'] ?? 0) + 
                                                    (float) ($cartItems['cod_charge'] ?? 0) + 
                                                    (float) ($cartItems['tip_amount'] ?? 0) - 
                                                    (float) ($cartItems['coupon_amount'] ?? 0) 
                                                }}
                                            </span>
                                        </h5>

                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <a href="javascript:void(0);" onclick="submitCheckout()" class="btn btn-1 w-100 mt-3">Proceed</a>
                            </div>
                        </div>
                    
                </div>
            @endif
        
    </div>
</section>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="orderInompleteToast" class="toast align-items-center text-bg-warning border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
            Order is incomplete. Please fill the required details.
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="paymentMethodToast" class="toast align-items-center text-bg-warning border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                Please select payment method!
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="couponToast" class="toast align-items-center text-bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                Coupon Applied Successfully
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="tipErrorToast" class="toast align-items-center text-bg-warning border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
            Please enter a valid tip amount.
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<script>

    let lastSelectedTip = null; // Variable to track the last selected tip

    function toggleTipSelection(radio, tipValue) {
        const applyCustomTip = document.getElementById('applyCustomTip');
        const clearButton = document.getElementById('clearCustomTip');
        const customTipInput = document.getElementById('customTipInput');

        customTipInput.value = ''; // Clear custom tip input

        // Find all radio buttons with the name 'tipamount' and remove the 'active' class
        document.querySelectorAll('input[name="tipamount"]').forEach((input) => {
            input.classList.remove('active');
        });

        if (lastSelectedTip === tipValue) {
            radio.checked = false; // Uncheck the radio button
            lastSelectedTip = null; // Reset the last selected tip
            applyTip(0); // Apply a 0 tip when deselected
        } else {
            radio.classList.add('active'); // Add the 'active' class to the selected radio
            lastSelectedTip = tipValue; // Set the last selected tip
            applyTip(tipValue); // Apply the selected tip value
        }
    }


    function applyCustomTip() {
        const customTipInput = document.getElementById('customTipInput');
        const applyCustomTip = document.getElementById('applyCustomTip');
        const clearButton = document.getElementById('clearCustomTip');

        const customTipValue = parseFloat(customTipInput.value.trim()) || 0;

        if (customTipValue > 0) {
            clearRadioSelection(); 
            applyTip(customTipValue); 
            clearButton.classList.remove('d-none'); 
            applyCustomTip.classList.add('d-none'); 
        } else {
            const toastElement = document.getElementById('tipErrorToast');
            const toast = new bootstrap.Toast(toastElement);
            toast.show();
        }
    }

    function showClearButton() {
        document.getElementById('clearCustomTip').classList.remove('d-none');
        document.getElementById('applyCustomTip').classList.add('d-none');
    }

    function clearRadioSelection() {
        document.querySelectorAll('input[name="tipamount"]').forEach(radio => {
            radio.checked = false;
        });
        lastSelectedTip = null;
    }

    function clearAllSelections() {
        document.getElementById('customTipInput').value = ''; 
        clearRadioSelection(); 
        document.getElementById('clearCustomTip').classList.add('d-none'); 
        document.getElementById('applyCustomTip').classList.remove('d-none'); 
        applyTip(0);
    }

    function applyCod(status){
        const couponCode = document.querySelector('.coupon-input input')?.value.trim() || null; // Get coupon code if available
        const tipAmount = document.querySelector('.tip-input input')?.value.trim() || null; // Get tip amount if available

        fetch("{{ url('get_selected_price_cod') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body:  JSON.stringify({
                status: status,
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === "1") {
                document.querySelector('.total').textContent = `AED ${data.data?.after_total ?? 0}`;
                document.querySelector('.original_cod').textContent = `AED ${data.data?.original_cod ?? 0}`;
                applyCoupon(0);
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Tip Application Error:', error);
        });
    }

    function applyTip(tipAmount) {
        const couponCode = document.querySelector('.coupon-input input')?.value.trim() || null; // Get coupon code if available

        const paymentMethod = document.querySelector('input[name="paymentselect"]:checked')?.id || null;
        fetch("{{ route('tip.apply') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                payment_method: paymentMethod,
                tip_amount: tipAmount,
                ...(couponCode && { coupon_code: couponCode }) // Include coupon_code only if it's not null
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === "1") {
                
                document.querySelector('.grand_total').value = `AED ${data.data?.after_total ?? 0}`;

                document.querySelector('.total').textContent = `AED ${data.data?.after_total ?? 0}`;

                if(data.data?.tip == 0){
                    jQuery('.tip-container').each(function() {
                        this.style.setProperty('display', 'none', 'important');
                    });
                }else{
                    jQuery('.tip-container').show();
                }
                document.querySelector('.tip').textContent = `AED ${data.data?.tip ?? 0}`;
                document.querySelector('.coupon').textContent = `AED -${data.data?.coupon ?? 0}`;
                document.querySelector('.subtotal').textContent = `AED ${data.data?.before_total ?? 0}`;
                 tabbyCardSniped();

            } else {
                alert(data.message || "Failed to apply tip. Please try again.");
            }
        })
        .catch(error => {
            console.error('Tip Application Error:', error);
        });
    }

    function applyCoupon(show_alert=1) {
        const paymentMethod = document.querySelector('input[name="paymentselect"]:checked')?.id || null;
        const couponCode = document.querySelector('.coupon-input input').value.trim();
        const tipAmount = document.querySelector('.tip-input input')?.value.trim() || null; // Get tip amount if available

        // Validate if a coupon code is entered
        if (!couponCode) {
           // alert("Please enter a coupon code.");
            return;
        }

        fetch("{{ route('coupon.apply') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                payment_method: paymentMethod,
                coupon_code: couponCode,
                ...(tipAmount && { tip_amount: tipAmount }) // Include tip_amount only if it's not null
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                 // Hide the Apply button
                document.querySelector('[onclick="applyCoupon()"]').style.display = 'none';

                // Show the Clear button
                document.querySelector('[onclick="applyCouponClear()"]').style.display = 'block';
    
                document.querySelector('.grand_total').value = `AED ${data.data.after_total}`;
                document.querySelector('.total').textContent = `AED ${data.data.after_total}`;
                document.querySelector('.tip').textContent = `AED ${data.data.tip}`;
                
                
                if(data.data?.coupon == 0){
                    jQuery('.coupon-container').each(function() {
                        this.style.setProperty('display', 'none', 'important');
                    });
                }else{
                    jQuery('.coupon-container').show();
                }

                document.querySelector('.coupon').textContent = `AED -${data.data.coupon}`;
                document.querySelector('.subtotal').textContent = `AED ${data.data.before_total}`;
                if(show_alert==1){
                    const toastElement = document.getElementById('couponToast');
                    const toastBody = toastElement.querySelector('.toast-body');
                    toastBody.textContent = "Coupon Applied Successfully";

                    toastElement.classList.add('bg-primary', 'bg-success'); 
                    toastElement.classList.remove('bg-danger'); 

                    const toast = new bootstrap.Toast(toastElement);
                    toast.show();
                }
            } else {
                if(show_alert==1){
                    const toastElement = document.getElementById('couponToast');
                    const toastBody = toastElement.querySelector('.toast-body');
                    toastBody.textContent = data.message || "Failed to apply coupon. Please try again.";

                    toastElement.classList.remove('bg-primary', 'bg-success'); 
                    toastElement.classList.add('bg-danger'); 

                    const toast = new bootstrap.Toast(toastElement);
                    toast.show();
                }
            }
        })
        .catch(error => {
            console.error('Coupon Application Error:', error);
            alert('An error occurred while applying the coupon. Please try again.');
        });
    }

    function applyCouponClear() {
        document.querySelector('[onclick="applyCouponClear()"]').style.display = 'none';

        // Show the Apply button
        document.querySelector('[onclick="applyCoupon()"]').style.display = 'block';
        jQuery('.coupon-text').val('');
        const tipAmount = document.querySelector('.tip-input input')?.value.trim() || null; // Get tip amount if available

        fetch("{{ route('coupon.apply') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                coupon_code: 0,
                ...(tipAmount && { tip_amount: tipAmount }) 
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                
                document.querySelector('.grand_total').value = `AED ${data.data.after_total ?? 0}`;
                document.querySelector('.total').textContent = `AED ${data.data.after_total}`;
                document.querySelector('.tip').textContent = `AED ${data.data.tip}`;
                document.querySelector('.coupon').textContent = `AED -${data.data.coupon}`;
                document.querySelector('.subtotal').textContent = `AED ${data.data.before_total}`;
                
                const toastElement = document.getElementById('couponToast');
                const toastBody = toastElement.querySelector('.toast-body'); // Assuming the toast has a .toast-body element
                toastBody.textContent = "Coupon Applied Successfully"; // Set error message

                toastElement.classList.add('bg-primary', 'bg-success'); 
                toastElement.classList.remove('bg-danger'); 

                jQuery('.coupon-container').each(function() {
                    this.style.setProperty('display', 'none', 'important');
                });

                // const toast = new bootstrap.Toast(toastElement);
                // toast.show();
            } else {
                const toastElement = document.getElementById('couponToast');
                const toastBody = toastElement.querySelector('.toast-body'); // Assuming the toast has a .toast-body element
                toastBody.textContent = data.message || "Failed to apply coupon. Please try again."; // Set error message

                toastElement.classList.remove('bg-primary', 'bg-success'); 
                toastElement.classList.add('bg-danger'); 

                // const toast = new bootstrap.Toast(toastElement);
                // toast.show();
            }
        })
        .catch(error => {
            console.error('Coupon Application Error:', error);
            alert('An error occurred while applying the coupon. Please try again.');
        });
    }

    function submitCheckout() {
        // Collect selected payment method
        const paymentMethod = document.querySelector('input[name="paymentselect"]:checked')?.id || null;

        // Collect selected tip amount
        let tipAmount = 0; // Default to 0
        const selectedTip = document.querySelector('input[name="tipamount"]:checked');

        if (selectedTip) {
            // Extract numeric value from the label associated with the selected radio
            const tipValueText = selectedTip.nextElementSibling.textContent.trim();
            const tipValue = parseFloat(tipValueText.match(/[\d.]+/)[0]); // Ensure numeric extraction
            tipAmount = !isNaN(tipValue) ? tipValue : 0; // Fallback to 0 if NaN
        } else {
            // Get custom tip input value
            const customTipInput = document.querySelector('.tip-amount input[type="text"]');
            tipAmount = parseFloat(customTipInput.value.trim()) || 0; // Fallback to 0 if invalid/empty
        }

        tipAmount = parseFloat(tipAmount) || 0; 



        // Validate required fields
        if (!paymentMethod) {
            const toastElement = document.getElementById('paymentMethodToast');
            const toast = new bootstrap.Toast(toastElement);
            toast.show();
            return;
        }

        // Define payment type mapping based on your backend logic
        let paymentType;
        switch (paymentMethod) {
            case 'pi3': // Debit/Credit Card
                paymentType = 1;
                break;
            case 'pi4': // Cash
                paymentType = 2;
                break;
            case 'pi2': // Wallet
                paymentType = 3;
                break;
            case 'pi5': // Tabby
                paymentType = 4;
                break;
            case 'pi1': // Reward
                paymentType = 5;
                break;
            default:
                paymentType = 3;
                break;
        }
        
        // First AJAX request to wallet_payment_init
        fetch("{{ route('wallet_payment_init') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                payment_type: paymentType,
                tip_amount: tipAmount,
                coupon_code: document.querySelector('.coupon-input input').value.trim() || null
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === "1") {
                if (data.oData?.is_draft === "yes") {
                    const toastElement = document.getElementById('orderIncompleteToast');
                    const toast = new bootstrap.Toast(toastElement);
                    toast.show();
                    return Promise.reject(); 
                }

                console.log("Wallet payment initialized successfully:", data);

                // Redirect to Stripe checkout via webhook_url
                if (data.oData?.checkout_url) {
                    window.location.href = data.oData.checkout_url; // Redirects to Stripe
                } else {
                    throw new Error("Stripe checkout URL not found.");
                }
            }else if (data.status === "3") {
                const toastElement = document.getElementById('couponToast');
                const toastBody = toastElement.querySelector('.toast-body');
                toastBody.textContent = data.message;

                toastElement.classList.add('bg-primary', 'bg-success'); 
                toastElement.classList.remove('bg-danger'); 

                const toast = new bootstrap.Toast(toastElement);
                toast.show();
                setTimeout(() => {
                    if (data.oData?.checkout_url) {
                        window.location.href = data.oData.checkout_url; // Redirects to Stripe
                    } else {
                        throw new Error(data.message);
                    }
                }, 2500);
                    
            } else {
                throw new Error(data.message || "Failed to initialize wallet payment.");
            }
        })
        .catch(error => {
            console.error('Checkout Initialization Error:', error);
            
            if(paymentType == 3){
                showWalletModal();
            }else{
                alert(error.message || 'An error occurred during the initialization. Please try again.');
            }
        });
    }
    function topUpWallet() {
        window.location.href = "/my-wallet"; // Redirect to the top-up page or handle the action
    }
    function showWalletModal() {
        const walletModal = new bootstrap.Modal(document.getElementById('walletModal'));
        walletModal.show();
    }
</script>
<div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h5 class="modal-title" id="walletModalLabel">Insufficient Wallet Balance</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <div class="modal-body text-center">
                <p>Insufficient Wallet Balance</p>
            </div>

            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="topUpWallet()">Top Up</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<script src="https://js.stripe.com/v3/?cache_bust={{ time() }}"></script>

<script>
function initRecharge() {
    const amount = document.getElementById('rechargeAmount').value;
    const paymentType = document.querySelector('input[name="rechargewallet"]:checked')?.id;

    if (!amount || amount <= 0) {
        alert('Please enter a valid amount.');
        return;
    }

    if (!paymentType) {
        alert('Please select a payment method.');
        return;
    }

    fetch('{{ url("wallet/init") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            amount: amount,
            payment_type: paymentType
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === "1" && data.data.checkout_url) {
            window.location.href = data.data.checkout_url; 
        } else {
            alert(data.message || 'Failed to initialize recharge.');
        }
    })
    .catch(error => console.error('Error:', error));
}
</script>
<script src="https://checkout.tabby.ai/tabby-card.js"></script>
<script src="https://checkout.tabby.ai/tabby-promo.js"></script>
<script>
    jQuery('#tabby').html('');
    new TabbyPromo({
        selector: '#tabby',
        price: parseFloat(jQuery('.grand_total').val()) || 0,
    });

    function tabbyCardSniped() {
        
        jQuery('#tabbyCard').html('');
        new TabbyCard({
            selector: '#tabbyCard',
            currency: 'AED', 
            lang: 'en', 
            price: parseFloat(jQuery('.grand_total').val()) || 0,
            size: 'narrow', 
            theme: 'black',
            header: false 
        });
    }
    jQuery(window).on('load', function(){
        tabbyCardSniped();
    });    
    jQuery(document).ready(function () {
        tabbyCardSniped();

        
    });
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
  const wrappers = document.querySelectorAll(".sticky-wrapper");

  const isVisible = (element) => {
    return element.offsetWidth > 0 && element.offsetHeight > 0 && window.getComputedStyle(element).display !== "none";
  };

  const updateStickyPositions = () => {
    // Only apply sticky behavior if the screen width is 1024px or greater
    if (window.innerWidth >= 1024) {
      wrappers.forEach((wrapper) => {
        if (!isVisible(wrapper)) return; // Skip hidden elements

        const sidebar = wrapper.querySelector(".sidebar");
        if (!sidebar) return; // Skip if no .sidebar inside this .location

        const wrapperRect = wrapper.getBoundingClientRect();
        const sidebarHeight = sidebar.offsetHeight;
        const wrapperHeight = wrapper.offsetHeight;

        // Preserve the sidebar width
        const sidebarWidth = sidebar.offsetWidth;
        sidebar.style.width = `${sidebarWidth}px`;

        if (wrapperRect.top <= 0 && wrapperRect.bottom >= sidebarHeight) {
          // Fix the sidebar to the top of the viewport
          sidebar.style.position = "fixed";
          sidebar.style.top = "0";
        } else if (wrapperRect.bottom < sidebarHeight) {
          // Stop the sidebar at the bottom of the wrapper
          sidebar.style.position = "absolute";
          sidebar.style.top = wrapperHeight - sidebarHeight + "px";
        } else {
          // Reset the sidebar to its default relative position
          sidebar.style.position = "relative";
          sidebar.style.top = "0";
          sidebar.style.width = ""; // Reset width
        }
      });
    } else {
      // Reset all sidebars for smaller screens
      wrappers.forEach((wrapper) => {
        const sidebar = wrapper.querySelector(".sidebar");
        if (sidebar) {
          sidebar.style.position = "relative";
          sidebar.style.top = "0";
          sidebar.style.width = ""; // Reset width
        }
      });
    }
  };

  window.addEventListener("scroll", updateStickyPositions);
  window.addEventListener("resize", updateStickyPositions); // Reapply logic on window resize
});

</script>
@endsection
