@extends('web.layout.header')
@section('title','Cart - UrbanMop')
@section('meta_tags')

<meta name="description" content="Urbanmop Cart">

<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">


@endsection
@section('content')

<section class="pageBannerSection  d-none d-md-block" style="background: linear-gradient(0deg, rgba(0, 0, 0, 0.8), rgba(0, 0, 0, 0.8)), url(assets/images/maid_service.jpg);">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="pageBannerContent text-center">
                    <h1 class="text-white">Cart</h1>
                    <div class="pageBannerPath">
                        <a href="{{route('shop')}}">Home</a> &gt; 
                        <span>Cart</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="arrow-down">
        <a href="#down"><i class="fal fa-chevron-down"></i></a>
    </div>
</section>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this item from the cart?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <a href="#" id="confirmDeleteButton" class="btn btn-danger">Yes, Delete</a>
            </div>
        </div>
    </div>
</div>


<section class="sec-m-top mb-30" id="down">
    <div class="container">
        <div class="row gx-3">
            @if (empty($cartItems['card']))
                <div class="col-12 text-center mt-50 mb-50">
                    <div class="row justify-content-center">
                        <div class="col-8 col-lg-6">
                            <div class="no-results-div">
                                <img src="{{asset('images/empty-cart.png')}}" class="img-fluid mb-3">
                                <h3>Your Cart is Empty!</h3>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                @php
                    // Check if any cart item is in "Draft" (missing slot_id or date)
                    $hasDraft = collect($cartItems['card'])->contains(function ($item) {
                         if($item['service_id'] == 10){
                            return empty($item['session_date']) || empty($item['session_time']);
                        } else {
                            return empty($item['slot_id']) || empty($item['date']);
                        }
                       // return empty($item['slot_id']) || empty($item['date']);
                    });
                    //dd($hasDraft);
                @endphp
                @foreach ($cartItems['card'] as $cartItem)
                <div class="col-lg-6 mb-4">
                    <div class="card cart-card overflow-hidden">
                        <div class="card-body">
                            <div class="cart-item">
                                <div class="cart-item-product d-flex align-items-center">
                                    <div class="cart-item-img bg-1">
                                        @php
                                            // Retrieve the service thumbnail by service_id
                                            $service = \App\Service::find($cartItem['service_id']);
                                        @endphp
                                        <img src="{{ asset('uploads/service/' . ($service->thumbnail_img ?? 'default.jpg')) }}" class="img-fluid" alt="Service Image">
                                    </div>

                                    <div class="card-item-details w-100">
                                       <b> <h4 class="mb-1 fw-600 fs-5">{{ $cartItem['service_name'] }}</h4> </b>
                                        <div class="d-flex w-100 gap-2 align-items-end justify-content-between">

                                            <!-- Attributes -->
                                            @if (!empty($cartItem['card_attribute']))
                                                <div class="mt-1" style=" width: 75%; ">
                                                    @foreach ($cartItem['card_attribute'] as $attribute)
                                                        <span class="mb-0  fs-6 text-muted">{{ $attribute['attribute_item_name'] }}</span>
                                                        @if (!$loop->last)
                                                            x 
                                                        @endif
                                                    @endforeach
                                                </div>
                                            @endif
                                            <h4 class="mb-0 fw-600 fs-6 amount">AED {{ number_format(($cartItem['amount'] ?? 0) > 0 ? $cartItem['amount'] : $cartItem['g_total'], 2) }} </h4>
                                        </div>
                                    </div>
                                </div>
                                
                               
                            </div>
                        </div>

                        <div class="card-header bg-1 border-0">
                            <div class="cart-item-footer">
                                <div class="cart-item-timing">
                                    @if($cartItem['service_id'] == 10)
                                        @if(isset($cartItem['session_time']))
                                        <h4 class="mb-1 fw-600 fs-5">{{ \App\Slot::find((int) $cartItem['session_time'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-14 mt-0">{{ \Carbon\Carbon::parse($cartItem['session_date'])->format('d-m-Y') ?? 'Not specified' }}</p>
                                        @endif
                                    @else
                                        <h4 class="mb-1 fw-600 fs-5">{{ App\Slot::find($cartItem['slot_id'])->name ?? "-" }}</h4>
                                        <p class="mb-0 text-muted fs-14 mt-0">{{ isset($cartItem['date']) ? \Carbon\Carbon::parse($cartItem['date'])->format('d-m-Y') : 'Not specified' }}</p>
                                    @endif
                                </div>
                                <div class="cart-item-btns">
                                    <a href="{{ route('cart.remove', $cartItem['id']) }}" class="btn btn-secondary btn-smll-row p-0"><i class="fal fa-trash-alt"></i></a>
                                    <?php
                                    	$serviceAttribute = App\ServiceAttributeValueItem::where('service_id', $service->id)
                                        ->with('sub_category')
                                        ->first();
                            
                                        $sub_cate_yes = $serviceAttribute && $serviceAttribute->sub_category ? 'Yes' : 'No';

                                    ?>
                                    @if($cartItem['service_id'] == 10)
                                        <a href="{{ route('service.booking', $service->slug) }}" class="btn btn-1 btn-smll-row">Edit</a>
                                    @else
                                        @if($cartItem['slot_id'] && $cartItem['date'])
                                            <a href="{{ route('service.booking', $service->slug) }}" class="btn btn-1 btn-smll-row">Edit</a>
                                        @else
                                            <a href="{{ route('service.booking', $service->slug) }}" class="btn btn-1 btn-smll-row">Draft</a>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                <div class="col-12">
                    <div class="text-end mb-10">
                        <!-- <h5 class="mb-0 fs-5">Subtotal: AED {{ number_format($cartItems['sub_total'], 2) }}</h5> -->
                    <!-- <h5 class="mb-0 fs-5">Reward: -AED {{ number_format($cartItems['reward_amount'], 2) }}</h5> -->
                        <h5 class="mb-0 fs-5">Total: AED {{ number_format($cartItems['total'], 2) }}</h5>
                        <!-- <h6 class="fs-6 text-muted">User Balance: AED {{ number_format($cartItems['user_balance'], 2) }}</h6> -->
                    </div>
                    
                        <a href="{{ !$hasDraft ? route('checkout') : '#' }}" 
                        class="btn btn-1 mt-2 float-end {{ $hasDraft ? 'disabled' : '' }}" 
                        style="{{ $hasDraft ? 'pointer-events: none; opacity: 0.6;' : '' }}">
                            Check Out
                        </a>
                   
                </div>
            @endif
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let deleteUrl = ''; // Store the delete URL for confirmation

        // Attach event listeners to delete buttons
        document.querySelectorAll('.cart-item-btns .btn-secondary').forEach(btn => {
            btn.addEventListener('click', function (e) {
                e.preventDefault();
                deleteUrl = this.href; // Store the delete URL

                // Show the confirmation modal
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteConfirmationModal'));
                deleteModal.show();
            });
        });

        // Handle delete confirmation
        document.getElementById('confirmDeleteButton').addEventListener('click', function () {
            if (deleteUrl) {
                window.location.href = deleteUrl; // Redirect to the delete URL
            }
        });
    });
</script>


@endsection
