@extends('web.layout.header')
@section('title',$blog->meta_title)
@php
                                $imagePaths = public_path('uploads/blog/' . $blog->image);
                            @endphp

@section('meta_tags')
<meta name="description" content="{{$blog->meta_description}}">
<meta name="keywords" content="{{$blog->meta_keyword}}">

<meta property="og:type" content="website" />
<meta property="og:image" content="{{ file_exists($imagePaths) && !empty($blog->image) ? asset('/uploads/blog/'.$blog->image) : asset('web/img_placeholder.jpg') }}" />
<meta property="og:url" content="{{url('blogs/'.$blog->slug)}}" />
<meta property="og:title" content="{{$blog->meta_title}}" />
<meta property="og:description" content="{{$blog->meta_description}}" />
<meta property="twitter:card" content="summary_large_image" />
<meta property="twitter:url" content="{{url('blogs/'.$blog->slug)}}" />
<meta property="twitter:title" content="$blog->meta_title" />
<meta property="twitter:description" content="{{$blog->meta_description}}" />
<meta property="twitter:image" content="{{ file_exists($imagePaths) && !empty($blog->image) ? asset('/uploads/blog/'.$blog->image) : asset('web/img_placeholder.jpg') }}" />


@endsection


@section('content')
   <main>
   <style>
    .blog-title{
        color:#000 !important;
    }
    </style>

        <section class="pt-50 pb-50 p-relative">
            <div class="container">

                <!--<h4 class="mb-4">Blogs Detail</h4>-->
                <h1 class="card-title blog-title mb-4"> {{$blog->name}} </h1>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            @php
                                $imagePath = public_path('uploads/blog/' . $blog->image);
                            @endphp
                            <!--<img class="card-img-top" width="100%" src="{{ url('/uploads/blog/'.$blog->banner) }}" alt="{{$blog->name}}" title="{{$blog->name}}">-->
                            <img class="card-img-top mb-0" src="{{ file_exists($imagePath) && !empty($blog->image) ? asset('/uploads/blog/'.$blog->image) : asset('web/img_placeholder.jpg') }}" alt="{{$blog->image_alt_tag}}" title="{{$blog->name}}">
                            <div class="card-body pt-0 blog_details_content">
                                
                                <p class="card-text ">{!! $blog->details !!}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection
 

