@extends('web.layout.header')
@section('title','Blogs - UrbanMop')
@section('meta_tags')
<meta name="description" content="Stay tuned with the latest updates about UrbanMop and UAE. Explore the cleaning tips and complete guides.">
<meta name="keywords" content="clean service dubai, cleaning services dubai, cleaning agency dubai, ubai cleaning company, maid cleaning service dubai, maid service in uae, maid service dubai, cleaning maid services near me, best maid companies in dubai, painting services in dubai, wall painting services in dubai, painting service, ac service dubai, ac cleaning dubai, ac repair in sharjah, air conditioning service in dubai, ac clean service, ac cleaning service, ac cleaning services, pest control services, pest control in abu dhabi, pest control near me, best pest control dubai, best pest control sharjah, pesticide control near me">
@endsection
@section('content')
    <main>
   <style>
    @media (min-width:767px){
        .blogs_urban img{height:250px; object-fit: cover;}
    }

    .blog-title{
    	color:#000 !important;
    	font-size: 22px !important;
        line-height: 32px !important;
        font-weight: 700 !important;
        overflow: hidden;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        line-clamp: 2;
        -webkit-box-orient: vertical;
    }
    .link-overall {
        position: absolute;
        width: 100%;
        height: 100%;
        left: 0;
        top: 0;
    }
    .card-text-description{
         overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        line-clamp: 2;
        -webkit-box-orient: vertical;
        margin-bottom: 0 !important;
    }
    </style>
        <section class="pt-50  p-relative">
            <div class="container">
                <h1 class="mb-4 h4">Blogs</h1>
                @if($blogs && count($blogs))
                     <div class="row gx-3">
                        @foreach($blogs as $blog)
                            
                               
                            <div class="col-lg-4 col-md-6 mb-3">
                                    <div class="card blogs_urban h-100">
                                    <div class="card-body">
                                        @php
                                            $imagePath = public_path('uploads/blog/' . $blog->image);
                                        @endphp
                                        <img class="card-img-top mb-3" src="{{ file_exists($imagePath) && !empty($blog->image) ? asset('/uploads/blog/'.$blog->image) : asset('web/img_placeholder.jpg') }}" alt="{{$blog->image_alt_tag}}" title="{{$blog->name}}">
                                            <h2 class="card-title blog-title" title="{{$blog->name}}">{{ $blog->name }}</h2>
                                            <p class="card-text">{{$blog->blogcategory?$blog->blogcategory->name:''}}</p>
                                            <p class="card-text-description">{{ $blog->meta_description ?? '' }}</p>
                                            <a class="link-overall" href="{{url('blogs/'.$blog->slug)}}"></a>
                                        </div>
                                    </div>
                            </div>
                            
                        @endforeach
                    </div>
                    <div class="d-flex justify-content-center mt-4 mb-50">
                        {{ $blogs->links('pagination::bootstrap-4') }} 
                    </div>
               @else
                    <h5>No Blogs</h5>
               @endif

            </div>
        </section>

   </main>
@endsection