@extends('layouts.dashboard')

@section('content')

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">View Vendor</h3>

                        </div>

                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                        <a href="{{ url('vendors') }}">

                            <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                                <span class="btn-icon-left text-primary">

                                    <i class="fa fa-arrow-left color-primary"></i> 

                                </span>Back

                            </button>

                        </a>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-lg-6">

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Personal Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-8"><b>Total Bookings Received</b></div>
                                    <?php
                                        $serviceIds = \App\SellerService::where('seller_id', $seller->id)->pluck('service_id')->toArray();
                                    ?>
                                    <div class="col-lg-4">: {{ \App\Card::whereIn('service_id', $serviceIds)->count() }}</div>
                                    
                                    <div class="col-12"><hr></div>
                                    <div class="col-lg-8"><b>Total Bookings Accepted</b></div>
                                    <div class="col-lg-4">: {{ \App\Card::where(['accept_user_id'=>$seller?$seller->user_id:''])->whereIn('service_id', $serviceIds)->whereIn('status', ['Accept','Completed','Mark As Arrived','In Progress'])->count() }}</div>
                                    
                                    <div class="col-12"><hr></div>
                                    <div class="col-lg-8"><b>Revenue Lost due to unaccepted orders</b></div>
                                    <div class="col-lg-4">: 
                                        {{ 
                                            \App\Card::where('accept_user_id', '!=', $seller ? $seller->user_id : '')
                                                ->whereIn('service_id', $serviceIds)
                                                ->whereIn('status', ['Accept', 'Completed', 'Mark As Arrived', 'In Progress'])
                                                ->sum('amount') 
                                        }}
                                    </div>

                                    <div class="col-12"><hr></div>

                                    <div class="col-lg-8"><b>Company Name</b></div>
                                    
                                    <div class="col-lg-4">: {{ $seller?$seller->company_name:'NA' }}</div>
                                    <div class="col-12"><hr></div>
                                    <div class="col-lg-3"><b>Vendor Name</b></div>
                                    
                                    <div class="col-lg-9">: {{ $value->name }}</div>

                                    <div class="col-12"><hr></div>
                                    <div class="col-lg-3"><b>Email Address</b></div>
                                    
                                    <div class="col-lg-9">: {{ $value->email }}</div>
                                    <div class="col-12"><hr></div>

                                    <div class="col-lg-3"><b>Mobile Number</b></div>
                                    
                                    <div class="col-lg-9">: {{ $value->phone }}</div>
                                    <div class="col-12"><hr></div>

                                    <div class="col-lg-3"><b>Emirates</b></div>
                                    
                                    <div class="col-lg-9">: @if($seller && $seller->city_info && isset($seller->city_info) && isset($seller->city_info)){{ $seller->city_info?$seller->city_info->name:'No City' }}@endif</div>
                                    <div class="col-12"><hr></div>

                                    

                                    <div class="col-lg-3"><b>Address</b></div>
                                    
                                    <div class="col-lg-9">: {{ $seller?$seller->address:'NA' }}</div>
                                </div>
                            </div>

                        </div>



                        
                    </div>

                    <div class="col-lg-6">

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Service & License</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    

                                    <div class="col-lg-3"><b>Services Added</b></div>
                                    
                                    <div class="col-lg-9">: 
                                        @foreach($seller_service_id as $key => $serv)
                                            {{$serv}}, 
                                        @endforeach
                                    </div>
                                    <div class="col-12"><hr></div>
                                    <div class="col-lg-3"><b>License</b></div>
                                    
                                    <div class="col-lg-9">: 
                                        @if($seller && $seller->licence_file)
                                            <a href="{{ asset('/storage/' . ltrim(str_replace('public/', '', $seller->licence_file))) }}" target="_blank">Download Licence</a>
                                        @endif
                                    </div>

                                    

                                    
                                </div>
                            </div>

                        </div>


                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Bank Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-3"><b>Bank Name</b></div>
                                    
                                    <div class="col-lg-9">: {{ $seller->bank_name?$seller->bank_name:'NA' }}</div>
                                    <div class="col-12"><hr></div>

                                    <div class="col-lg-3"><b> Account Holder</b></div>
                                    
                                    <div class="col-lg-9">: {{ $seller->ac_holder_name?$seller->ac_holder_name:'NA' }}</div>
                                    <div class="col-12"><hr></div>

                                    <div class="col-lg-3"><b>Account Number</b></div>
                                    
                                    <div class="col-lg-9">: {{ $seller->ac_number?$seller->ac_number:'NA' }}</div>
                                    
                                </div>
                            </div>

                        </div>
                    </div>



                    

                    <div class="col-12 d-none">


                       
                        

                        <div class="card">

                            <div class="card-body">

                                <div class="row">
                                        
                                    <div class="col-lg-2"><b>Vendor Name</b></div>
                                    
                                    <div class="col-lg-10">: {{ $value->name }}</div>

                                    <div class="col-lg-2"><b>Vendor Email</b></div>
                                    
                                    <div class="col-lg-10">: {{ $value->email }}</div>

                                    <div class="col-lg-2"><b>Vendor Phone</b></div>
                                    
                                    <div class="col-lg-10">: {{ $value->phone }}</div>

                                    <div class="col-lg-2"><b>Emirates</b></div>
                                    
                                    <div class="col-lg-10">: @if($seller && $seller->city_info && isset($seller->city_info) && isset($seller->city_info)){{ $seller->city_info?$seller->city_info->name:'No City' }}@endif</div>

                                    <div class="col-lg-2"><b>Status</b></div>
                                    
                                    <div class="col-lg-10">: {{ $value->is_active=='1'?"Active":'Inactive' }}</div>

                                    <div class="col-lg-2"><b>Registered By</b></div>
                                    
                                    <div class="col-lg-10">: {{ $value->registered_by ?? 'App' }}</div>

                                    <div class="col-lg-2"><b>Company Name</b></div>
                                    
                                    <div class="col-lg-10">: {{ $seller?$seller->company_name:'NA' }}</div>

                                    <div class="col-lg-2"><b>Address</b></div>
                                    
                                    <div class="col-lg-10">: {{ $seller?$seller->address:'NA' }}</div>

                                    <div class="col-lg-2"><b>Bank Name</b></div>
                                    
                                    <div class="col-lg-10">: {{ $seller?$seller->bank_name:'NA' }}</div>

                                    <div class="col-lg-2"><b> Account Holder Name</b></div>
                                    
                                    <div class="col-lg-10">: {{ $seller?$seller->ac_holder_name:'NA' }}</div>

                                    <div class="col-lg-2"><b>Account Number</b></div>
                                    
                                    <div class="col-lg-10">: {{ $seller?$seller->ac_number:'NA' }}</div>

                                    <div class="col-lg-2"><b>License</b></div>
                                    
                                    <div class="col-lg-10">: 
                                        @if($seller && $seller->licence_file)
                                            <a href="{{ asset('/storage/' . ltrim(str_replace('public/', '', $seller->licence_file))) }}" target="_blank">Download Licence</a>
                                        @endif
                                    </div>

                                    <div class="col-lg-2"><b>Services</b></div>
                                    
                                    <div class="col-lg-10">: 
                                        @foreach($seller_service_id as $key => $serv)
                                            {{$serv}}, 
                                        @endforeach
                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->


@endsection      



       