@extends('layouts.dashboard')
<style>
    .count-card {
        color: aliceblue;
        padding: 2%;
    }
    .count {
        float: right;
    }
</style>
@section('content')

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">Vendor Detail</h3>

                        </div>

                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                        

                    </div>

                

                <div class="container-fluid">

                    <div class="row">

                        <div class="col-lg-12">

                            @include('vendor.top')

                        </div>

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-body">

                                    <div class="custom-tab-2">

                                        @include('vendor.menu')

                                        <div class="table-responsive">

                                            <table class="table table-border table-hover table-sm" >

                                                <thead>

                                                    <tr>

                                                        <th>S.N.</th>

                                                        <th>Booking ID</th>

                                                        <th>Customer</th>

                                                        <th>Service</th>

                                                        <th>Staff</th>

                                                        <th>Payment</th>

                                                        <th>Status</th>

                                                        <th>Action</th>

                                                    </tr>

                                                </thead>

                                                <tbody>

                                                    @if(!empty($today_booking))

                                                    @foreach($today_booking as $key=>$value)

                                                    <tr>

                                                        <td>{{ ++$key }}</td>

                                                        <td>{{ $value->id }}</td>

                                                        <td>{{ $value->user?$value->user->name:'' }}</td>

                                                        <td>{{ $value->service?$value->service->name:'' }}</td>
                                                        <?php
                                                            if ($value->service_id != 10) {
                                                                // Fetch staff for non-session-based services
                                                                $staffCards = \App\StaffCard::where('card_id', $value->id)->get();
                                                                $staffNames = $staffCards->map(function ($staffCard) {
                                                                    return optional($staffCard->staff)->first_name . ' ' . optional($staffCard->staff)->last_name;
                                                                })->filter()->toArray();
                                                            
                                                                // Display staff names or N/A
                                                                echo "<td>" . (!empty($staffNames) ? implode(', ', $staffNames) : 'N/A') . "</td>";
                                                            } else {
                                                                // Fetch session-based staff
                                                                $sessions = \App\SessionPackages::where('cart_id', $value->id)->get();
                                                                $sessionStaffList = []; // Initialize an empty array to store session-wise staff
                                                            
                                                                foreach ($sessions as $key => $session) {
                                                                    $staffCards = \App\StaffSession::where('session_id', $session->id)->get();
                                                            
                                                                    // Get staff names for this session
                                                                    $staffNames = $staffCards->map(function ($staffCard) {
                                                                        return optional($staffCard->staff)->first_name . ' ' . optional($staffCard->staff)->last_name;
                                                                    })->filter()->toArray();
                                                            
                                                                    // Only add non-empty staff lists
                                                                    if (!empty($staffNames)) {
                                                                        $sessionStaffList[] = "Session " . ($key + 1) . " : " . implode(', ', $staffNames);
                                                                    }
                                                                }
                                                            
                                                                // Display session-wise staff assignments
                                                                echo "<td>" . (!empty($staffNames) ? implode(' | ', $sessionStaffList) : 'N/A')  . "</td>";
                                                            }
                                                                                                                
                                                        ?>


                                                        
                                                        <td>{{ $value->payment_moad ?? 'Card' }}</td>

                                                        <td>{{ $value->status }}</td>

                                                        <td>
                                                            <a href="{{ route('booking.view',$value->id) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit"><i class="fa fa-eye" aria-hidden="true"></i></button></a>
                                                        </td>

                                                    </tr>

                                                    @endforeach

                                                        @if ($today_booking->count() == 0)

                                                        <tr class="text-center">

                                                            <td colspan="6">No booking to display.</td>

                                                        </tr>

                                                        @endif

                                                    @endif

                                                </tbody>

                                                <tfoot>

                                                    <tr>

                                                        <th>S.N.</th>

                                                        <th>Booking ID</th>

                                                        <th>Customer</th>

                                                        <th>Service</th>

                                                        <th>Payment</th>

                                                        <th>Status</th>

                                                        <th>Action</th>

                                                    </tr>

                                                </tfoot>

                                            </table>

                                        </div>

                                        <div class="text-left float-left mt-1">

                                            <p>Displaying {{$today_booking->count()}} of {{ $today_booking->total() }} bookings.</p>

                                        </div>

                                        <div class="text-right float-right">

                                            {{ $today_booking->appends(request()->all())->links() }}

                                        </div>      

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->



@endsection      



       