@extends('layouts.dashboard')
@section('content')
<style>
.switch {
    position: relative;
    display: inline-block;
    width: 34px;
    height: 20px;
}

.switch input {
    display: none;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 20px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 14px;
    width: 14px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #4CAF50;
}

input:checked + .slider:before {
    transform: translateX(14px);
}

</style>
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="breadcrumb-range-picker">
                            <h3 class="ml-1">Packages</h3> 
                            
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                    <a href="{{ route('packages.create') }}" type="button" class="btn btn-rounded bg-grad-4 ml-3"><span class="btn-icon-left text-primary"><i class="fa fa-plus color-primary"></i> </span>Create Package</a>
                    </div>
                </div>
            <div class="container-fluid">
                @include('flash_msg')
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table  class="display table table-border table-hover table-sm">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Description</th>
                                                <th>Save Amount</th>
                                                <th>Total Sessions</th>
                                                <th>Free Sessions</th>
                                                <th>Per Week</th>
                                                <th>Total Amount</th>
                                                <th>Enable / Disable</th>
                                                <th>Created</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if(!empty($packages))
                                            @foreach($packages as $key=>$value)  
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{ $value->name }}</td>
                                                <td>{{ $value->description }}</td>
                                                <td>{{ $value->save_amount }}</td>
                                                <td>{{ $value->total_sessions }}</td>
                                                <td>{{ $value->free_sessions }}</td>
                                                <td>{{ $value->per_week }}</td>
                                                <td>{{ $value->amount }}</td>
                                                <td>
                                                    <label class="switch">
                                                        <input type="checkbox" class="toggle-status" 
                                                            data-id="{{ $value->id }}" 
                                                            {{ $value->status == 1 ? 'checked' : '' }}>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </td>
                                                <td>{{ changeDateFormate($value->created_at) }}</td>
                                                <td>
                                                    <a href="{{ route('package.detail',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft">View</button></a>
                                                    <a href="{{ route('packages.edit', encrypt($value->id)) }}" class="btn btn-primary btn-sm">Edit</a>
                                                    <form action="{{ route('packages.destroy', encrypt($value->id)) }}" method="POST" style="display: inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this package?')">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                            @endforeach
                                                @if ($packages->count() == 0)
                                                <tr class="text-center">
                                                    <td colspan="7">No data(s) to display.</td>
                                                </tr>
                                                @endif
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-left float-left mt-1">
                                    <p>Displaying {{$packages->count()}} of {{ $packages->total() }} data(s).</p>
                                </div>
                                <div class="text-right float-right">
                                    {{ $packages->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.toggle-status').forEach(function (toggle) {
            toggle.addEventListener('change', function () {
                const packageId = this.getAttribute('data-id');
                const status = this.checked ? "1" : "0";
                const baseURL = document.querySelector('meta[name="base-url"]').getAttribute('content');

                // Send AJAX request
                fetch(`${baseURL}/packages/toggle-status/${packageId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    },
                    body: JSON.stringify({ status }),
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert('Status updated successfully!');
                    } else {
                        alert('Failed to update status.');
                        this.checked = !this.checked; // Revert toggle in case of failure
                    }
                })
                .catch(error => {
                    console.error('Error updating status:', error);
                    alert('An error occurred.');
                    this.checked = !this.checked; // Revert toggle in case of error
                });
            });
        });
    });
</script>

@endsection      

       