@extends('layouts.dashboard')

@section('content')
<div class="content-body">
<div class="container-fluid">
    <div class="card shadow-sm mt-4">
        <div class="card-header">
            <h3 class="card-title mb-0">Edit Package</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('packages.update', encrypt($package->id)) }}" method="POST">
                @csrf
                @method('PUT') <!-- HTTP PUT method for update -->

                <div class="row">
                    <div class="form-group col-md-6 mb-3">
                        <label for="name" class="form-label">Package Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $package->name) }}" placeholder="Enter package name" required>
                    </div>

                    <div class="form-group col-md-3 mb-3">
                        <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="amount" name="amount" value="{{ old('amount', $package->amount) }}" placeholder="Enter package amount" min="0" required>
                    </div>

                    <div class="form-group col-md-3 mb-3">
                        <label for="save_amount" class="form-label">Save Amount</label>
                        <input type="number" class="form-control" id="save_amount" name="save_amount" value="{{ old('save_amount', $package->save_amount) }}" placeholder="Enter save amount" min="0">
                    </div>

                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            const amountInput = document.getElementById('amount');
                            const saveAmountInput = document.getElementById('save_amount');

                            // Prevent negative values for both amount and save_amount
                            amountInput.addEventListener('input', function () {
                                const amount = parseInt(amountInput.value, 10); // Convert to integer

                                // Prevent negative values
                                if (amount < 0) {
                                    amountInput.value = 0; // Set to 0 if negative
                                }

                                // Update the max attribute of save_amount when amount changes
                                if (!isNaN(amount) && amount >= 0) {
                                    saveAmountInput.max = amount; // Set max to the amount value
                                }

                                // Adjust save_amount if it exceeds the updated max
                                const saveAmount = parseInt(saveAmountInput.value, 10);
                                if (saveAmount > amount) {
                                    saveAmountInput.value = amount; // Automatically adjust the value
                                }
                            });

                            saveAmountInput.addEventListener('input', function () {
                                const saveAmount = parseInt(saveAmountInput.value, 10); // Get value

                                // Prevent negative value
                                if (saveAmount < 0) {
                                    saveAmountInput.value = 0; // Set to 0 if negative
                                }

                                const maxAllowed = parseInt(saveAmountInput.max, 10);

                                // Prevent save_amount from exceeding the amount value
                                if (!isNaN(saveAmount) && saveAmount > maxAllowed) {
                                    saveAmountInput.value = maxAllowed; // Adjust to the maximum allowed value
                                }
                            });

                            // Prevent spinner for number input fields
                            amountInput.setAttribute('inputmode', 'numeric');
                            saveAmountInput.setAttribute('inputmode', 'numeric');
                        });
                    </script>

                    <style>
                        /* Hide the number input spinner in Chrome, Safari, and Edge */
                        input[type="number"]::-webkit-outer-spin-button,
                        input[type="number"]::-webkit-inner-spin-button {
                            -webkit-appearance: none;
                            margin: 0;
                        }

                        /* Hide spinner in Firefox */
                        input[type="number"] {
                            -moz-appearance: textfield;
                        }
                    </style>

                </div>

                <div class="row">
                <div class="form-group col-md-6 mb-3">
                    <label for="total_sessions" class="form-label">Total Sessions</label>
                    <input type="number" class="form-control" id="total_sessions" name="total_sessions" value="{{ old('total_sessions', $package->total_sessions) }}" placeholder="Enter total sessions" min="0">
                </div>

                <div class="form-group col-md-6 mb-3">
                    <label for="free_sessions" class="form-label">Free Sessions</label>
                    <input type="number" class="form-control" id="free_sessions" name="free_sessions" value="{{ old('free_sessions', $package->free_sessions) }}" placeholder="Enter free sessions" min="0">
                </div>

                <div class="form-group col-md-6 mb-3">
                    <label for="per_week" class="form-label">Enter Weekly Sessions</label>
                    <input type="number" class="form-control" id="per_week" name="per_week" value="{{ old('per_week', $package->per_week) }}" placeholder="Enter free sessions" min="0">
                </div>

                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const perWeekInput = document.getElementById('per_week');

                        perWeekInput.addEventListener('input', function () {
                            const value = parseInt(perWeekInput.value, 10);

                            if (value > 6) {
                                perWeekInput.value = 6; // Limit to max value
                            } else if (value < 1) {
                                perWeekInput.value = 1; // Limit to min value
                            }
                        });
                    });
                </script>

                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const totalSessionsInput = document.getElementById('total_sessions');
                        const freeSessionsInput = document.getElementById('free_sessions');

                        // Prevent negative values for both total_sessions and free_sessions
                        totalSessionsInput.addEventListener('input', function () {
                            const totalSessions = parseInt(totalSessionsInput.value, 10); // Convert to integer

                            // Prevent negative values
                            if (totalSessions < 0) {
                                totalSessionsInput.value = 0; // Set to 0 if negative
                            }

                            // Update the max attribute of free_sessions when total_sessions changes
                            if (!isNaN(totalSessions) && totalSessions >= 0) {
                                freeSessionsInput.max = totalSessions; // Set max to the total_sessions value
                            }

                            // Adjust free_sessions if it exceeds the updated max
                            const freeSessions = parseInt(freeSessionsInput.value, 10);
                            if (freeSessions > totalSessions) {
                                freeSessionsInput.value = totalSessions; // Automatically adjust the value
                            }
                        });

                        freeSessionsInput.addEventListener('input', function () {
                            const freeSessions = parseInt(freeSessionsInput.value, 10); // Get value

                            // Prevent negative value
                            if (freeSessions < 0) {
                                freeSessionsInput.value = 0; // Set to 0 if negative
                            }

                            const maxAllowed = parseInt(freeSessionsInput.max, 10);

                            // Prevent free_sessions from exceeding the total_sessions value
                            if (!isNaN(freeSessions) && freeSessions > maxAllowed) {
                                freeSessionsInput.value = maxAllowed; // Adjust to the maximum allowed value
                            }
                        });

                        // Prevent spinner for number input fields
                        totalSessionsInput.setAttribute('inputmode', 'numeric');
                        freeSessionsInput.setAttribute('inputmode', 'numeric');
                    });
                </script>

                <style>
                    /* Hide the number input spinner in Chrome, Safari, and Edge */
                    input[type="number"]::-webkit-outer-spin-button,
                    input[type="number"]::-webkit-inner-spin-button {
                        -webkit-appearance: none;
                        margin: 0;
                    }

                    /* Hide spinner in Firefox */
                    input[type="number"] {
                        -moz-appearance: textfield;
                    }
                </style>

                </div>

                <div class="form-group mb-3">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description" rows="4" placeholder="Enter package description">{{ old('description', $package->description) }}</textarea>
                </div>

                <!-- <div class="form-group mb-3">
                    <label for="days" class="form-label">Select Days</label>
                    <select class="form-control select2" id="days" name="days[]" multiple>
                        @php
                            $selectedDays = json_decode($package->days, true) ?? [];
                        @endphp
                        <option value="Monday" {{ in_array('Monday', $selectedDays) ? 'selected' : '' }}>Monday</option>
                        <option value="Tuesday" {{ in_array('Tuesday', $selectedDays) ? 'selected' : '' }}>Tuesday</option>
                        <option value="Wednesday" {{ in_array('Wednesday', $selectedDays) ? 'selected' : '' }}>Wednesday</option>
                        <option value="Thursday" {{ in_array('Thursday', $selectedDays) ? 'selected' : '' }}>Thursday</option>
                        <option value="Friday" {{ in_array('Friday', $selectedDays) ? 'selected' : '' }}>Friday</option>
                        <option value="Saturday" {{ in_array('Saturday', $selectedDays) ? 'selected' : '' }}>Saturday</option>
                        <option value="Sunday" {{ in_array('Sunday', $selectedDays) ? 'selected' : '' }}>Sunday</option>
                    </select>
                </div> -->

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-success bg-grad-4 mx-2">Update Package</button>
                    <a href="{{ route('packages') }}" class="btn btn-danger">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const amountInput = document.getElementById('amount');
        const saveAmountInput = document.getElementById('save_amount');
        const totalSessionsInput = document.getElementById('total_sessions');
        const freeSessionsInput = document.getElementById('free_sessions');

        // Handle Save Amount
        amountInput.addEventListener('input', function () {
            const amount = parseInt(amountInput.value, 10);
            if (!isNaN(amount) && amount > 0) {
                saveAmountInput.max = amount;
                const saveAmount = parseInt(saveAmountInput.value, 10);
                if (saveAmount > amount) {
                    saveAmountInput.value = amount;
                }
            } else {
                saveAmountInput.removeAttribute('max');
            }
        });

        saveAmountInput.addEventListener('input', function () {
            const saveAmount = parseInt(saveAmountInput.value, 10);
            const maxAllowed = parseInt(saveAmountInput.max, 10);
            if (!isNaN(saveAmount) && saveAmount > maxAllowed) {
                saveAmountInput.value = maxAllowed;
            }
        });

        // Handle Free Sessions
        totalSessionsInput.addEventListener('input', function () {
            const totalSessions = parseInt(totalSessionsInput.value, 10);
            if (!isNaN(totalSessions) && totalSessions > 0) {
                freeSessionsInput.max = totalSessions;
                const freeSessions = parseInt(freeSessionsInput.value, 10);
                if (freeSessions > totalSessions) {
                    freeSessionsInput.value = totalSessions;
                }
            } else {
                freeSessionsInput.removeAttribute('max');
            }
        });

        freeSessionsInput.addEventListener('input', function () {
            const freeSessions = parseInt(freeSessionsInput.value, 10);
            const maxAllowed = parseInt(freeSessionsInput.max, 10);
            if (!isNaN(freeSessions) && freeSessions > maxAllowed) {
                freeSessionsInput.value = maxAllowed;
            }
        });
    });
</script>
@endsection
