@extends('layouts.dashboard')

@section('content')
<div class="content-body">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <h3 class="ml-1">Cities</h3>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end d-flex">
            <a href="{{ route('locality.create') }}" class="btn btn-rounded bg-grad-4 ml-4">
                <i class="fa fa-plus color-primary"></i> Add City
            </a>
        </div>
    </div>

    <div class="container-fluid">
        @include('flash_msg')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table id="example" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Locality Name</th>
                                    <th>Emirates</th>
                                    <th class="text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($localities as $key => $locality)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $locality->name }}</td>
                                        <td>{{ $locality->city->name }}</td>
                                        <td class="text-right">
                                            <a href="{{ route('locality.edit', $locality->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                            <a href="{{ route('locality.delete', $locality->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
