@extends('layouts.dashboard')
<style>
    .qty-w {
        width: 35% !important;
    }

    .attr_w {
        width: 40% !important;
    }
</style>
@section('content')

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">Service</h3>

                        </div>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            <div class="card-body">

                                <div class="custom-tab-2">
                                    <?php $data['active'] = 'Service'; ?>
                                    @include('offline.menu',$data)
                                    <form action="{{ route('step3') }}" method="post">
                                    @csrf
                                        <div class="row">

                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label>Service (Category)</label>
                                                    <select class="form-control select2 service" name="service_id">
                                                        <option value="">Select Service</option>
                                                        @foreach($services as $key => $service)
                                                        <option value="{{$service->id}}">{{$service->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label>Sub Category</label>
                                                    <select class="form-control select2 sub_category" name="sub_category_id">
                                                        <option value="">Select Sub Category</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label>Child Category</label>
                                                    <select class="form-control select2 child_category" name="child_category_id">
                                                        <option value="">Select Child Category</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <!-- <label>Choose Maids</label> -->
                                                    <div class="attribute_list_maid"></div>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 mt-4">
                                                <table class="table show_table">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">#</th>
                                                            <th scope="col" class="attr_w">Attribute</th>
                                                            <th scope="col">Price</th>
                                                            <th scope="col" class="remove_qty">Qty</th>
                                                            <th scope="col" class="text-right">Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="attribute_list">
                                                        
                                                    </tbody>
                                                </table>

                                            </div>

                                            <div id="package-section" class="col-lg-12 mt-4 d-none px-0">
                                                <div class="row mb-30">
                                                    
                                                </div>
                                            </div>
                                            

                                            <div class="col-lg-12">
                                                <div class="card" id="Materialscharge" style="background: #e2e2e285;">
                                                    
                                                </div>
                                            </div>

                                            

                                            <div class="col-lg-12 mt-4">
                                                
                                                <table class="table total_service">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">#</th>
                                                            @if(optional(optional(\App\OfflineBooking::find(Session::get('off_line_booking_id')))->service)->id == 10)
                                                                <th scope="col " style="width:20%;" class="remove_package">Package</th>
                                                            @endif
                                                            <th scope="col" style="width:20%;">Attribute</th>
                                                            <th scope="col"  style="width:20%;"class="">Attribute Item</th>
                                                            <th scope="col">Price</th>
                                                            @if(optional(optional(\App\OfflineBooking::find(Session::get('off_line_booking_id')))->service)->id != 10)
                                                                <th scope="col" class="remove_qty">Qty</th>
                                                            @endif
                                                            <th scope="col" class="text-right">Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="cart_list">
                                                        @include('offline.service.add_to_cart_list')
                                                    </tbody>
                                                </table>

                                            </div>

                                        </div>
                                        
                                        <div class="row mt-4">
                                            <div class="col-lg-6">
                                                <div class="text-left">
                                                    <a href="{{ route('offline.booking') }}"><button class="btn btn-primary" type="button">Back</button></a>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="text-right">
                                                    <button class="btn btn-primary" type="submit">Next</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->

@endsection 

@section('script')
<script>
    let service = 'normal';
    let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
    let Servic_id = '';
    let Sub_cate_id = '';
    let Child_cate_id = '';
    $('.service').on('change', function() {
        if(this.value){   
            $('.attribute_list').html(''); 
            $('.attribute_list_maid').html(''); 
            $('.cart_list').html(''); 
            $('#Materialscharge').html('');      
            Servic_id = this.value;    
            $.ajax({
                type: 'Post',
                url: "{{ route('get.sub.catgeory.service') }}",
                data: {
                        _token: CSRF_TOKEN,
                        service_id: this.value,
                    },
                dataType: 'json',
                success: function (data) {
                    console.log(data);
                    if(data.status){
                        $('.sub_category').html(data.modal_view);  
                        service = data.service;
                    }                                     
                },
                error: function (data) {
                    console.log(data);
                }
            });
        }
    });
</script>

<script>
    $('.sub_category').on('change', function() {
        if (this.value) {
            $('.attribute_list').html('');
            $('.attribute_list_maid').html('');
            $('.child_category').html('');
            Sub_cate_id = this.value;

            $.ajax({
                type: 'POST',
                url: "{{ route('get.sub.child.catgeory.service') }}",
                data: {
                    _token: CSRF_TOKEN,
                    service_id: $('.service').val(),
                    sub_category_id: this.value,
                    service: service,
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);

                    if (data.status) {
                        if (data.from === 'child') {
                            $('.child_category').html(data.modal_view);
                            $('.show_table').show();
                        } else {
                            if ($('.service').val() == 10) {
                                $('.attribute_list_maid').html(data.modal_view); // Populate the maid attribute list
                                $('.show_table').hide(); // Hide other tables or elements if needed

                                $('#Materialscharge').html('');   
                                $('#package-section').removeClass('d-none'); // Show package section
                                $('#package-section').html(""); // Clear previous content

                                $('.cart_list').html(data.updated_cart.modal_view);
                            } else {
                                $('.attribute_list').html(data.modal_view);
                                $('.show_table').show();
                                $('#package-section').addClass('d-none'); // Hide the package section for other services
                            }
                        }
                    }
                },
                error: function(data) {
                    console.log(data);
                }
            });
        }
    });

    function populatePackageSection(packages, selectedPackage = null) {
        $('#package-section').removeClass('d-none'); // Show package section
        $('#package-section').html(""); // Clear previous content

        let packageHtml = `
            <div class="col-12 mb-20">
                <h3 class="fs-5 mb-0">Select Your Package</h3>
            </div>
            <div class="col-12">
                <ul class="selector package-selector">`;

        packages.forEach((package, index) => {
            let isChecked = (package.id == selectedPackage) ? 'checked' : '';
            let isActive = (package.id == selectedPackage) ? 'active' : '';

            packageHtml += `
                <li class="w-100">
                    <label class="control w-100" for="package${index + 1}">
                        <input 
                            type="radio" 
                            name="package" 
                            id="package${index + 1}" 
                            value="${package.id}" 
                            data-package='${JSON.stringify({
                                totalSessions: package.total_sessions || 0,
                                freeSessions: package.free_sessions || 0,
                                perWeek: package.per_week || 1,
                                price: package.amount || 0
                            })}' 
                            class="package-input ${isActive}"
                            ${isChecked}>
                        <span class="control__content w-100">
                            <i class="icon-check mb-4"></i>
                            <div class="w-100">
                                <div class="d-flex flex-column flex-md-row">
                                    <h5 class="fs-5 fw-bold">${package.name}</h5>
                                </div>
                                <h4 class="mb-0 fs-5 d-flex justify-content-between fw-bold" style="margin-right: -20px;">
                                    AED ${parseFloat(package.amount).toFixed(2)}
                                    ${package.save_amount
                                        ? `<span class="text-primary fw-medium fs-6">Save AED ${parseFloat(package.save_amount).toFixed(2)}</span>` 
                                        : ''}
                                </h4>
                            </div>
                        </span>
                    </label>
                </li>`;
        });

        packageHtml += `</ul></div>`;

        // Inject the HTML into the package section
        $('#package-section').html(packageHtml);

        // **Ensure all package inputs are cleared of active class when loading**
        $('#package-section .package-input').removeClass('active');

        // Manage the "active" class on package selection change
        $('#package-section').off('change', 'input[name="package"]').on('change', 'input[name="package"]', function () {
            $('#package-section .package-input').removeClass('active'); // Remove active class from all inputs
            $(this).addClass('active'); // Add active class to the selected package input
        });
    }

</script>


<script>
    $('.child_category').on('change', function() {
        if(this.value){
            Child_cate_id = this.value;
            $.ajax({
                type: 'Post',
                url: "{{ route('get.sub.child.attribute') }}",
                data: {
                        _token: CSRF_TOKEN,
                        service_id: $('.service').val(),
                        sub_category_id: $('.sub_category').val(),
                        child_category_id: this.value,
                    },
                dataType: 'json',
                success: function (data) {
                    console.log(data);
                    if(data.status){
                        $('.attribute_list').html(data.modal_view);   
                    }                                     
                },
                error: function (data) {
                    console.log(data);
                }
            });
        }
    });
</script>

<script>
    let Global_last_attr_id = '';
    let selectedPackageId = null; // To track the selected package

    // Function to handle package selection
    function collectAttributesData(attributeId, totalSessions = 1, freeSessions = 0, perWeek = 1, price = 100) {
        selectedPackageId = attributeId; // Update the selected package ID
        console.log(
            `Package Selected: ${attributeId}, Total Sessions: ${totalSessions}, Free Sessions: ${freeSessions}, Per Week: ${perWeek}, Price: ${price}`
        );

        // If an attribute was previously selected, recalculate material for the selected package
        if (Global_last_attr_id) {
            console.log(`Recalculating material for Attribute ID: ${Global_last_attr_id} with Package ID: ${attributeId}`);
            calculateMaterial({
                id: Global_last_attr_id,
                package_id: attributeId, // Pass the selected package ID
                total_sessions: totalSessions,
                free_sessions: freeSessions,
                per_week: perWeek,
                price: price,
            }, "1");
        }
    }

    function calculateMaterial(params, count = "0") {
        Global_last_attr_id = params.id;
        let package_id = count == 1 ? params.package_id : null;

        if ($('.service').val() == 10) {
            const attribute_detail_id = params.id;

            if (attribute_detail_id) {
                Global_last_attr_id = attribute_detail_id;


                $.ajax({
                    type: 'POST',
                    url: "{{ route('get.material.price') }}",
                    data: {
                        _token: CSRF_TOKEN,
                        service_id: $('.service').val(),
                        sub_category_id: $('.sub_category').val(),
                        attribute_detail_id: attribute_detail_id,
                    },
                    dataType: 'json',
                    success: function (data) {
                        console.log(data);
                        if (data.status) {
                            $('#Materialscharge').html(data.modal_view);

                            if (count == 1) {
                                addToCart(attribute_detail_id, 'maid', package_id);
                            } else {
                                // Store currently selected package ID before making the request
                                let selectedPackage = $("input[name='package']:checked").val();
                                $('.cart_list').html(data.updated_cart.modal_view);
                                populatePackageSection(data.packages || [], selectedPackage);
                            }

                            // Update the package section while keeping the previously s
                        } else {
                            // If no packages exist, clear and hide the package section
                            $('#package-section').addClass('d-none').html("");
                        }
                    },
                    error: function (data) {
                        console.log(data);
                    }
                });
            }
            return;
        } else {
            $('#package-section').addClass('d-none');
        }
    }

    // Example: Handle package selection
    $(document).on('click', '.package-selector input[type="radio"]', function () {
        const packageId = $(this).val();
        const packageData = JSON.parse($(this).attr('data-package')); // Parse package data from the attribute
        console.log(`Package ${packageId} selected.`);

        // Trigger collectAttributesData with package details
        collectAttributesData(
            packageId,
            packageData.totalSessions,
            packageData.freeSessions,
            packageData.perWeek,
            packageData.price
        );
    });
</script>

<script>
    function calculate_material(req) {
        addToCart(Global_last_attr_id, 'maid');        
    }
</script>

<script>
    function increaseValue(atrid) {
        var numberid = 'number'+atrid;
        var checkboxid = '#checkbox'+atrid;
        var value = parseInt(document.getElementById(numberid).value, 10);
        value = isNaN(value) ? 0 : value;
        value++;
        document.getElementById(numberid).value = value;

        if($(checkboxid).prop('checked')==true){
            addToCart(atrid, 'Normal')
        }
    }

    function decreaseValue(atrid) {
        var numberid = 'number'+atrid;
        var checkboxid = '#checkbox'+atrid;
        var value = parseInt(document.getElementById(numberid).value, 10);
        value = isNaN(value) ? 0 : value;
        value < 1 ? value = 1 : '';
        value--;
        document.getElementById(numberid).value = value;

        if($(checkboxid).prop('checked')==true){
            addToCart(atrid, 'Normal')
        }
    }
</script>

<script>
    function addToCart(attr_id, service_type, selected_packages = 0) {
     
        var numberid = '#number'+attr_id;
        if(service_type=='maid'){
            if($('.yes').prop('checked')==true){
                var materialscharge = 'Yes';
                var material_charge = $('.material_charge').val();
            } else {
                var materialscharge = 'NO';
                var material_charge = '0';
            }
        } else {
            var materialscharge = 'NO';
            var material_charge = '0';
        }
        
        if(attr_id){
            $.ajax({
                type: 'Post',
                url: "{{ route('add.attr.in.cart') }}",
                data: {
                        _token          : CSRF_TOKEN,
                        selected_packages      : selected_packages,
                        service_id      : $('.service').val(),
                        sub_category_id : $('.sub_category').val(),
                        child_category_id : Child_cate_id,
                        attribute_id    : attr_id,
                        qty             : $(numberid).val(),
                        service         : service_type,
                        materialscharge : materialscharge,
                        material_charge : material_charge,
                    },
                dataType: 'json',
                success: function (data) {
                    console.log(data);                    
                    if(data.status){
                        $('.cart_list').html(data.modal_view);   
                        populatePackageSection(data.packages || [], selected_packages); 
                    } else {
                        alert('Try Again');
                    }  
                },
                error: function (data) {
                    console.log(data);
                    alert('Try Again');
                }
            });
        }
    }
</script>

<script>
    function removeAttr(attr_id) {
       
        if(attr_id){
            $.ajax({
                type: 'Post',
                url: "{{ route('remove.attr.in.cart') }}",
                data: {
                        _token          : CSRF_TOKEN,
                        attribute_id    : attr_id,
                    },
                dataType: 'json',
                success: function (data) {
                    console.log(data);                    
                    if(data.status){
                        // **Ensure all package inputs are cleared of active class when loading**
                        $('#package-section .package-input').removeClass('active');
                        $('.cart_list').html(data.modal_view);   
                    } else {
                        alert('Try Again');
                    }  
                },
                error: function (data) {
                    console.log(data);
                    alert('Try Again');
                }
            });
        }
    }

    $(document).ready(function () {
        const serviceDropdown = $('.service'); // Service dropdown selector

        const childCategoryDropdown = $('.child_category').closest('.form-group'); // Parent div of the child category dropdown

        // Function to toggle the visibility of the child category dropdown
        function toggleChildCategoryDropdown(serviceId) {
            if (serviceId == 10) {
                childCategoryDropdown.hide(); // Hide child category for service ID 10
                
            } else {
                childCategoryDropdown.show(); // Show child category for other service IDs
                $('#package-section').removeClass('d-none'); // Show package section
                $('#package-section').html(""); // Clear previous content
            }
        }

        // Listen for service selection changes
        serviceDropdown.on('change', function () {
            const selectedServiceId = $(this).val(); // Get the selected service ID
            toggleChildCategoryDropdown(selectedServiceId); // Toggle the visibility of the child category dropdown
        });

        // Trigger the function initially based on the default selected service
        toggleChildCategoryDropdown(serviceDropdown.val());
        
        const specificTable = $('.table.total_service'); // Correctly target the specific table

        // Function to add or remove the "Package" column dynamically
        function togglePackageColumn(serviceId) {
            const tableHeader = specificTable.find('thead tr'); // Header row of the target table

            // Check if the column is already added
            const packageColumnExists = tableHeader.find('th.package-column').length > 0;

            if (serviceId == 10 && !packageColumnExists) {
                $('.remove_qty').hide();
                // Add "Package" column after the first column
                tableHeader.find('th:first').after('<th scope="col" class="package-column">Package</th>');
            } else if (serviceId != 10 && packageColumnExists) {
                $('.remove_qty').show();
                // Remove "Package" column if it exists
                tableHeader.find('th.package-column').remove();
            }
        }

        // Listen for service selection changes
        serviceDropdown.on('change', function () {
            const selectedServiceId = $(this).val();
            $('.remove_package').hide();
            
            togglePackageColumn(selectedServiceId); 
        });

        // Trigger the function initially based on the default selected service
        togglePackageColumn(serviceDropdown.val());
    });

</script>
@endsection



       