@extends('layouts.dashboard')

@section('content')

        <div class="content-body">
            <div class="row page-titles mx-0">
                <div class="col-sm-6 p-md-0">
                    <div class="breadcrumb-range-picker">
                        <h3 class="ml-1">Schedule</h3>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
                @include('flash_msg')

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="custom-tab-2">
                                    <?php $data['active'] = 'Schedule'; ?>
                                    @include('offline.menu', $data)

                                    <form action="{{ route('step4') }}" method="post">
                                        @csrf

                                        <!-- Slot Date and Time for Service ID not equal to 10 -->
                                        @if ($off_line_booking->service_id != 10)
                                            <div class="row">
                                                <!-- Slot Date Section -->
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label>Slot Date</label>
                                                        <input 
                                                            type="date" 
                                                            name="slot_date" 
                                                            class="form-control slot_date" 
                                                            id="slot_date_input" 
                                                            value="{{ $off_line_booking->date }}" 
                                                            required
                                                        />
                                                        <input 
                                                            type="hidden" 
                                                            value="{{ date('Y-m-d') }}" 
                                                            class="current_date"
                                                        />
                                                    </div>
                                                </div>

                                                <!-- Time Slot Section -->
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label>Choose The Preferred Time Slot</label>
                                                        <select 
                                                            name="slot_id" 
                                                            class="form-control select2" 
                                                            id="timeSlotSelect" 
                                                            required
                                                        >
                                                            <option value="">Select Slot</option>
                                                            @foreach($slots as $slot)
                                                                <option 
                                                                    value="{{ $slot->id }}" 
                                                                    data-check-in="{{ $slot->check_in }}" 
                                                                    {{ $off_line_booking->slot_id == $slot->id ? 'selected' : '' }}
                                                                >
                                                                    {{ $slot->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                        @endif

                                        <!-- Dynamic Sessions for Service ID 10 -->
                                        @if ($off_line_booking->service_id == 10)
                                            <div id="dynamic-sessions-container" class="mt-4">
                                                <div id="dynamic-heading" class="mb-4"></div>
                                                <div id="dynamic-sessions"></div>
                                            </div>
                                        @endif

                                        <!-- Booking Instructions -->
                                        <div class="col-lg-12 mt-4 px-0">
                                            <div class="form-group">
                                                <label>Booking Instructions</label>
                                                <textarea 
                                                    name="booking_instruction" 
                                                    class="form-control" 
                                                    placeholder="Instructions for professional"
                                                ></textarea>
                                            </div>
                                        </div>

                                        <!-- Navigation Buttons -->
                                        <div class="row mt-4">
                                            <div class="col-lg-6 text-left">
                                                <a href="{{ route('offline.service') }}">
                                                    <button class="btn btn-primary" type="button">Back</button>
                                                </a>
                                            </div>
                                            <div class="col-lg-6 text-right">
                                                <button class="btn btn-primary" type="submit">Next</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection 

@section('script')

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const serviceId = "{{ $off_line_booking->service_id }}"; // Dynamically fetch service_id

        // Only generate sessions if service_id == 10
        if (serviceId == 10) {
            generateSessions();
        }
    });

    // Function to dynamically generate sessions for service_id = 10
    function generateSessions() {
        const dynamicSessionsContainer = document.getElementById("dynamic-sessions");
        const dynamicHeading = document.getElementById("dynamic-heading");
        const today = new Date().toISOString().split("T")[0];
        const totalSessions = parseInt("{{ \App\Package::find($off_line_booking->selected_packages)->total_sessions ?? 0 }}"); 
        const freeSessions = parseInt("{{ \App\Package::find($off_line_booking->selected_packages)->free_sessions ?? 0 }}"); 
        const totalSessionsCount = totalSessions + freeSessions;

        // Pre-existing sessions
        const preExistingSessions = @json(\App\SessionPackages::where('offline_id', $off_line_booking->id)->get());

        // Update heading
        dynamicHeading.innerHTML = `
            <h3 class="fs-3 mb-0 text-start">${totalSessions} sessions + ${freeSessions} free</h3>
        `;

        // Clear previous session inputs
        dynamicSessionsContainer.innerHTML = "";

        // Generate session inputs dynamically
        for (let i = 1; i <= totalSessionsCount; i++) {
            const existingSession = preExistingSessions[i - 1] || {};
            const sessionDate = existingSession.date || '';
            const sessionTime = existingSession.time || '';

            const sessionHTML = `
                <div class="row mb-3">
                    <div class="col-12 mb-2 d-flex justify-content-between">
                        <h5 class="fs-5 mb-0 text-start">Session ${i}</h5>
                        ${(i === 1 && totalSessionsCount > 1) ? `
                        <div class="form-check">
                            <input class="form-check-input allSessionsSameTime" type="checkbox" id="allSessionsSameTime" onchange="toggleAllSessionsSameTime(this)">
                            <label class="form-check-label" for="allSessionsSameTime">
                                All sessions same time
                            </label>
                        </div>` : ''}
                    </div>
                    <div class="col-6">
                        <input 
                            type="date" 
                            class="form-control session-date" 
                            name="sessions[${i}][date]" 
                            value="${sessionDate}" 
                            
                            onchange="filterSlot(this.value, ${i})" 
                            required
                        />
                    </div>
                    <div class="col-6">
                        <select 
                            class="form-select session-time" 
                            name="sessions[${i}][time]" 
                            id="timeSlotSelect${i}" 
                            required
                        >
                            <option disabled selected>Select Session Time</option>
                            @foreach($slots as $slot)
                                <option 
                                    value="{{ $slot->id }}" 
                                    data-check-in="{{ $slot->check_in }}" 
                                    ${sessionTime == "{{ $slot->id }}" ? 'selected' : ''}
                                >
                                    {{ $slot->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            `;
            dynamicSessionsContainer.innerHTML += sessionHTML;
        }

    }

    // Add toggle functionality for "All sessions same time"
    function toggleAllSessionsSameTime(checkbox) {
        const allDates = document.querySelectorAll('.session-date');
        const allTimes = document.querySelectorAll('.session-time');

        if (checkbox.checked) {
            const firstDate = allDates[0].value;
            const firstTime = allTimes[0].value;

            allDates.forEach((dateInput, index) => {
                if (index > 0) {
                    // dateInput.value = firstDate;
                    // dateInput.readOnly = true;
                }
            });

            allTimes.forEach((timeSelect, index) => {
                if (index > 0) {
                    timeSelect.value = firstTime;
                    // timeSelect.disabled = true;
                }
            });
        } else {
            // allDates.forEach((dateInput) => {
            //     dateInput.readOnly = false;
            // });

            allTimes.forEach((timeSelect) => {
                timeSelect.disabled = false;
            });
        }
    }

    // Function to dynamically filter slots for a session
    function filterSlot(selectDate, sessionIndex) {
        const currentDate = new Date().toISOString().split("T")[0];
        const currentTime = new Date().toLocaleTimeString('it-IT', { hour12: false });
        const timeSlotSelect = document.getElementById(`timeSlotSelect${sessionIndex}`);
        const options = timeSlotSelect.options;

        for (let i = 0; i < options.length; i++) {
            const option = options[i];
            const checkInTime = option.getAttribute('data-check-in');

            if (selectDate === currentDate && checkInTime) {
                //option.disabled = checkInTime <= currentTime;
            } else {
                option.disabled = false;
            }
        }
    }

    document.addEventListener("DOMContentLoaded", function () {
        const slotDateInput = document.getElementById("slot_date_input");
        const timeSlotSelect = document.getElementById("timeSlotSelect");

        function disablePastTimeSlots() {
            const selectedDate = slotDateInput.value;
            const today = new Date().toISOString().split("T")[0];
            const currentTime = new Date().toLocaleTimeString("it-IT", { hour12: false });

            // Iterate through each option in the time slot dropdown
            for (let i = 0; i < timeSlotSelect.options.length; i++) {
                const option = timeSlotSelect.options[i];
                const checkInTime = option.getAttribute("data-check-in");

                if (selectedDate === today && checkInTime) {
                    //option.disabled = checkInTime <= currentTime;
                } else {
                    option.disabled = false;
                }
            }
        }

        // Disable past time slots on page load
        disablePastTimeSlots();

        // Run the function whenever the date is changed
        slotDateInput.addEventListener("change", disablePastTimeSlots);
    });

</script>

@endsection
