@extends('layouts.dashboard')

@section('content')
<div class="content-body">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="breadcrumb-range-picker">
                <h3 class="ml-1">Edit Contact</h3>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <a href="{{ url('contacts') }}" class="btn btn-rounded bg-grad-4 ml-4">
                <span class="btn-icon-left text-primary">
                    <i class="fa fa-arrow-left color-primary"></i> 
                </span>Back
            </a>
        </div>
    </div>

    <div class="container-fluid">
        @include('flash_msg')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ url('update/contact') }}" method="POST">
                            <input type="hidden" name="id" value="{{ $contact->id }}">
                            @csrf
                            <div class="row">
                                <div class="form-group col-lg-6">
                                    <label>Name</label>
                                    <input type="text" class="form-control" name="name" value="{{ $contact->name }}" placeholder="Name">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Email</label>
                                    <input type="email" class="form-control" name="email" value="{{ $contact->email }}" placeholder="Email">
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Message</label>
                                    <textarea class="form-control" name="message" placeholder="Message">{{ $contact->message }}</textarea>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-success bg-grad-4">Update</button>
                            </div>                                    
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
