@extends('layouts.dashboard')

@section('content')
<div class="content-body">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <h3 class="ml-1">Create Emirate</h3>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <a href="{{ route('cities.index') }}" class="btn btn-rounded bg-grad-4 ml-4">
                <span class="btn-icon-left text-primary">
                    <i class="fa fa-arrow-left color-primary"></i> 
                </span>Back
            </a>
        </div>
    </div>

    <div class="container-fluid">
        @include('flash_msg')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('city.store') }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label>Emirate Name</label>
                                <input type="text" class="form-control" name="name" value="{{ old('name') }}" placeholder="City Name">
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-success bg-grad-4">Submit</button>
                            </div>                                    
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
