@extends('layouts.dashboard')

@section('content')

<style>
    .mt-18 {
        margin-top: 4%;
    }
    .print {
            margin-right: 5%;
    }
</style>

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h5 class="ml-1">
                           <strong> Source - {{ $card->booking_from }} </strong><br>
                                Booking ID - {{$card->tran_id}}<br>
                                @if($card->cart_unique_id)
                                Cart Unique ID - {{$card->cart_unique_id}} <br>
                                @endif

                                    
                                    
                                    @if(isset($card->paymentLinkId) || isset($card->tabby_payment_response_id))
                                        Payment Transaction ID - 
                                        @if(isset($card->paymentLinkId))
                                            {{$card->paymentLinkId}}
                                        @else
                                            {{$card->tabby_payment_response_id}}
                                        @endif
                                    @endif
                               
                            </h5>
                            
                        </div>

                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                        <a href="{{ url()->previous() }}">

                            <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                                <span class="btn-icon-left text-primary">

                                    <i class="fa fa-arrow-left color-primary"></i> 

                                </span>Back

                            </button>

                        </a>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            <div class="card-body">

                                <div class="row">

                                    <div class="col-sm-2">
                                        <b>User : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{$card->user?$card->user->name:''}}
                                    </div>
                                    <div class="col-sm-2">
                                        <b>Service : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        @if(is_numeric($card->service_id))
                                            {{$card->service?$card->service->name:''}}
                                        @else
                                            {{$card->service_name}}
                                        @endif
                                    </div>

                                </div>

                                <div class="row mt-2"> 

                                    <div class="col-sm-2">
                                        <b>Category : </b>
                                    </div>
                                    <div class="col-sm-4">

                                @if($card->service_id == 10)
                                    @foreach($card->card_attribute as $key => $items)
                                    @foreach($sessions as $key => $items)
                                    {{$items->package->name}}
                                    @endforeach
                                    @endforeach
                                @else
                                    {{$card->category?$card->category->name:'No Category'}}
                                @endif
                                       

                                       
                                    </div>
                                    <div class="col-sm-2">
                                        <b>Slot Date : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        @if($card->service_id == 10)
                                            @if (!empty($card->sessionPackages) && isset($card->sessionPackages[0]->date))
                                                {{ date('d F Y', strtotime($card->sessionPackages[0]->date)) }}
                                            @else
                                                {{ date('d F Y', strtotime($card->date))}}
                                            @endif
                                        @else
                                            {{ date('d F Y', strtotime($card->date))}}
                                        @endif
                                       
                                    </div>

                                </div>

                                <div class="row mt-2">   

                                    <div class="col-sm-2">
                                        <b>Payment Mode : </b>
                                    </div>
                                    <div class="col-sm-4">
                                    @if($card->payment_type == 1)
                                        (Card)
                                    @elseif($card->payment_type == 2)
                                        (Cash)
                                    @elseif($card->payment_type == 3)
                                        (Wallet)
                                    @elseif($card->payment_type == 4)
                                        (Tabby)
                                    @elseif($card->payment_type == 5)
                                        (Reward)
                                    @elseif($card->payment_type == 6)
                                        (Apple Pay)
                                    @else
                                        (Unknown)
                                    @endif
                                    
                                    

                                    </div>
                                    @if($card->payment_link !='')
                                    <div class="col-sm-2">
                                        <b>Payment Link : </b>
                                    </div>
                                    <div class="col-sm-4">
                                    <p>{{$card->payment_link}}</p>
                                    </div>
                                    @endif
                                    
                                    <div class="col-sm-2">
                                        <b>Slot : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        <?php
                                        
                                        $slot_name = $card->slot?$card->slot->name:'';
                                        ?>
                                        @if($card->service_id == 10)
                                            {{ !empty($card->sessionPackages) && isset($card->sessionPackages[0]->time) 
                                                ? optional(\App\Slot::find($card->sessionPackages[0]->time))->name 
                                                : $slot_name
                                            }}
                                        @else
                                            {{$card->slot?$card->slot->name:''}}
                                        @endif
                                    </div>

                                </div>

                                <div class="row mt-2">   
                                <div class="col-sm-2">
                                        <b>Email : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{$card->user->email ?? "N/A"}}
                                    </div>
                                    <div class="col-sm-2">
                                        <b>Alternative No. : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{$card->alternative_number?'':''}}{{$card->alternative_number}}
                                    </div>
                                    <div class="col-sm-2">
                                        <b>Creation Date : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{date('d F Y', strtotime($card->updated_at))}}
                                    </div>
                                    
                                </div>

                                <div class="row mt-2">   

                                    <div class="col-sm-2">
                                        <b>Contact No. : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        @if($card->user && $card->user->phone)
                                            +971{{$card->user->phone}}
                                        @endif
                                        
                                    </div>
                                    <div class="col-sm-2">
                                        <b>Booking Instructions : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{$card->note ?? "N/A"}}
                                    </div>   
                                    
                                </div>

                                <div class="row mt-2">

                                    <div class="col-sm-2">
                                        <b>Address : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        @if(is_numeric($card->address_id))
                                            
                                            <strong>Address Type - {{$card->address?$card->address->address_type:''}}</strong>
                                            <br>
                                            Flat No. {{$card->address?$card->address->flat_no:''}}, {{$card->address?$card->address->building:''}}, 
                                            <br>
                                            @if($card->address && $card->address->locality_info)
                                            {{$card->address->locality_info?$card->address->locality_info->name:''}}, 
                                            @endif

                                            @if($card->address && $card->address->city)
                                            {{$card->address->city?$card->address->city->name:''}}, 
                                            @endif

                                            
                                            <br>
                                            {{$card->address?$card->address->address:''}}

                                        @elseif(json_decode($card->address_id))
                                            
                                            <strong>
                                                Address Type - {{json_decode($card->address_id)->address_type}}</strong>
                                            <br>
                                            Flat No. {{json_decode($card->address_id)->flat_no}}, {{json_decode($card->address_id)->building}}, 
                                            <br>
                                            {{json_decode($card->address_id)->locality}},
                                            
                                            @if(!empty($card->address_id) && json_decode($card->address_id) && isset(json_decode($card->address_id)->city) && isset(json_decode($card->address_id)->city->name))
                                                {{ json_decode($card->address_id)->city->name }},
                                            @endif


                                            
                                            <br>
                                            {{json_decode($card->address_id)->address}}
                                        @else

                                        @endif
                                        
                                        
                                        <br><br>
                                        @if(is_numeric($card->address_id))
                                        <a style="text-decoration: underline; color:blue; font-weight: 700;" target='_blank' href="https://www.google.com/maps?q={{$card->address?$card->address->latitude:''}},{{$card->address?$card->address->longitude:''}}"> Click here for location </a>
                                        @else
                                            @if(json_decode($card->address_id) && json_decode($card->address_id)->latitude && json_decode($card->address_id)->longitude)
                                            <a style="text-decoration: underline; color:blue; font-weight: 700;" target='_blank' href="https://www.google.com/maps?q={{json_decode($card->address_id)->latitude}},{{json_decode($card->address_id)->longitude}}"> Click here for location </a>
                                            @endif
                                        @endif

                                    </div> 

                                    <div class="col-sm-2">
                                        <b>Booking Status : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        
                                        @if($card->status=='Mark As Arrived')
                                        {{'En route to work"'}}
                                        @else
                                        {{$card->status}}
                                        @endif
                                    </div>  
                                </div>

                                <div class="row mt-2">

                                    <div class="col-sm-2">
                                        <b>Company Name : </b>
                                    </div>
                                    <div class="col-sm-4">
                                        {{ optional(App\Seller::where('user_id', $card->accept_user_id)->first())->company_name ?? 'N/A' }}
                                    </div> 

                                    @if($card->status == "Accepted" && $card->status == "Completed")
                                        <div class="col-sm-2">
                                            <b>Payment Method : </b>
                                        </div>
                                        <div class="col-sm-4">
                                            {{ $card->payment_moad ?? "-" }}
                                        </div>
                                    @endif 
                                </div>
                                  
                                <hr>
                                <div class="row">
                                    <div class="col-sm-12 mt-18">
                                        <table class="table table-border table-hover table-sm mt-4">
                                          <thead>
                                            <tr>
                                              <th scope="col">#</th>
                                                @if($card->service_id == 10)
                                                    <th scope="col">Category</th>
                                                    <th scope="col">Description</th>
                                                    <th scope="col">Quantity</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col">Amount</th>
                                                @else
                                                    <th scope="col">Sub Category</th>
                                                    <th scope="col">Attribute</th>
                                                    <th scope="col">Attribute Item</th>
                                                    <th scope="col">Quantity</th>
                                                    <th scope="col">Price</th>
                                                @endif
                                            </tr>
                                          </thead>
                                          <tbody>
                                          <?php $total = '0'; $subtotal = '0'; ?>
                                                @if($card->service_id == 10)
                                                    @if($sessions->isNotEmpty())
                                                        @foreach($sessions as $key => $items)
                                                            <?php
                                                            ++$key;
                                                            ?>
                                                            <tr>
                                                            <td>{{ $key === 1 ? $key : '' }}</td>
                                                            <td>{{ $key === 1 ? $items->package->name ?? '' : '' }}</td>
                                                            <td>Session {{$key}} - {{$items->date}} & {{$items->slot->name ?? ""}}</td>
                                                            <td>
                                                                @if(isset($card->card_attribute[0]) && isset($card->card_attribute[1]))
                                                                    {{ $card->card_attribute[0]->attribute_item_name }} x {{ $card->card_attribute[1]->attribute_item_name }}
                                                                @elseif(isset($card->card_attribute[0]))
                                                                    {{ $card->card_attribute[0]->attribute_name }} x {{ $card->card_attribute[0]->attribute_item_name }}
                                                                @else
                                                                    N/A
                                                                @endif
                                                            </td>
                                                            <td>{{$items->status}}</td>
                                                            
                                                            @if($card->booking_from == 'Offline')
                                                            <td>{{ $key === 1 ? Session::get('currencies').' '.$card->amount ?? '' : '' }} </td>
                                                            @else
                                                            <td>{{ $key === 1 ? Session::get('currencies').' '.$card->amount ?? '' : '' }} </td>
                                                            @endif
                                                            </tr>
                                                            @php
                                                            $total = $subtotal = $card->g_total;
                                                            @endphp
                                                        @endforeach
                                                    @else
                                                        $items = $card;
                                                       @foreach($card->card_attribute as $key => $items)
                                                            <tr>
                                                            <td>{{ ++$key }}</td>
                                                            <td>{{$items->main_sub_cat?$items->main_sub_cat->name:''}}</td>
                                                            <td>{{$items->attribute_name}}</td>
                                                            <td>{{$items->attribute_item_name}}</td>
                                                            <td>{{$items->attribute_qty}}</td>
                                                            
                                                            @if($card->booking_from == 'Offline')
                                                            <td>{{ $key === 1 ? Session::get('currencies').' '.$card->amount ?? '' : '' }} </td>
                                                            @else
                                                            <td>{{ $key === 1 ? Session::get('currencies').' '.$card->g_total ?? '' : '' }} </td>
                                                            @endif
                                                            </tr>
                                                                
                                                            <?php
                                                                if($card->booking_from == 'Offline'){
                                                                    $total += $items->attribute_price;
                                                                    $subtotal += $items->attribute_price;
                                                                }else {
                                                                    $total += $items->attribute_qty*$items->attribute_price;
                                                                    $subtotal += $items->attribute_qty*$items->attribute_price;
                                                                }
                                                            ?>
                                                        @endforeach
                                                    @endif
                                                @else
                                                @foreach($card->card_attribute as $key => $items)
                                                    <tr>
                                                    <td>{{ ++$key }}</td>
                                                    <td>{{$items->main_sub_cat?$items->main_sub_cat->name:''}}</td>
                                                    <td>{{$items->attribute_name}}</td>
                                                    <td>{{$items->attribute_item_name}}</td>
                                                    <td>{{$items->attribute_qty}}</td>
                                                    <td>{{ Session::get('currencies') }} {{$items->attribute_price}}</td>
                                                    </tr>
                                                    <?php
                                                    // $total += $items->attribute_qty*$items->attribute_price;
                                                    // $subtotal += $items->attribute_qty*$items->attribute_price;

                                                    if($card->booking_from == 'Offline'){
                                                        $total += $items->attribute_price;
                                                        $subtotal += $items->attribute_price;
                                                    }else {
                                                        $total += $items->attribute_price;
                                                        $subtotal += $items->attribute_price;
                                                    }

                                                    ?>
                                                @endforeach
                                                @endif
                                                @if($card && $card->material_status=='Apply')
                                            <tr>
                                              <td colspan="4"></td>
                                              <td>Material Charge</td>
                                              <td>{{ Session::get('currencies') }} {{price_format($card->material_charge)}}</td>
                                            </tr>
                                            <?php $total += $card->material_charge; ?>
                                            @endif
                                            <tr>
                                              <td colspan="4"></td>
                                              <td>Sub Total</td>
                                              @if($card->booking_from == 'Offline')
                                                <td>{{ Session::get('currencies') }} {{price_format($card->amount + $card->material_charge)}}</td>
                                              @else
                                                <td>{{ Session::get('currencies') }} {{price_format($card->amount + $card->material_charge)}}</td>
                                              @endif
                                              
                                             
                                            </tr>
                                            
                                            
                                          
                                            <?php
                                                $cod = (float) \App\Service::find($card->service_id)->cod_charge;
                                            ?>
                                            
                                            @php
                                                $order = \App\Order::find($card->order_id);
                                            @endphp
                                            <?php
                                            $order_count = \App\Card::where('order_id',$card->order_id)->count();
                                                if(App\CardCoupon::where('card_id',$card->id)->exists()){
                                                    $coupon = App\CardCoupon::where('card_id',$card?$card->id:'')->first();
                                                } else {
                                                    $coupon = App\Coupon::where('id',$card?$card->coupon_id:'')->first();
                                                }
                                            ?>
                                            @if($card && $card->coupon_amt)
                                                <tr>
                                                <td colspan="4"></td>
                                                <td>Coupon</td>
                                                <td>{{ Session::get('currencies') }} {{number_format($card->coupon_amt,2)}}</td>
                                                </tr>
                                            @endif
                                             
                                            @if($card && $card->tip_id)
                                            <tr>
                                              <td colspan="4"></td>
                                              <td>Tip</td>
                                              <td>{{ Session::get('currencies') }} {{$card->tip_id}}</td>
                                            </tr>
                                            @endif

                                            @if($card && $card->booking_from == 'Offline')
                                                @if($card && !empty($card->offline_id))
                                                    @if($card && $card->surcharge)
                                                    <tr>
                                                      <td colspan="4"></td>
                                                      <td>Surcharge</td>
                                                      <td>{{ Session::get('currencies') }} {{$card->surcharge}}</td>
                                                    </tr>
                                                    <?php $total += $card->surcharge; ?>
                                                    @endif
                                                @endif
                                            @else
                                                @if($card && $card->surcharge)
                                                    <tr>
                                                      <td colspan="4"></td>
                                                      <td>Surcharge</td>
                                                      <td>{{ Session::get('currencies') }} {{$card->surcharge}}</td>
                                                    </tr>
                                                    <?php $total += $card->surcharge; ?>
                                                @endif
                                            @endif
                                            
                                            @if($card && $card->offline_discount)
                                            <tr>
                                              <td colspan="4"></td>
                                              <td>Discount</td>
                                              <td>(-) {{ Session::get('currencies') }} {{$card->offline_discount}}</td>
                                            </tr>
                                            <?php $total -= $card->offline_discount; ?>
                                            @endif
                                            
                                           
                                            @if($card && $card->booking_from == 'Offline')
                                                @if($card && !empty($card->offline_id))
                                                    @if($card && $card->payment_type == 2)
                                                        @if($card && $card->cod)
                                                            <tr>
                                                            <td colspan="4"></td>
                                                            <td>COD Charge</td>
                                                            <td>{{ Session::get('currencies') }} {{$card->cod}}</td>
                                                            </tr>
                                                            <?php $total += $card->cod; ?>
                                                        @endif
                                                    @endif
                                                @endif
                                            @else
                                                @if($card && $card->payment_type == 2)
                                                    @if($card && $card->cod)
                                                        <tr>
                                                        <td colspan="4"></td>
                                                        <td>COD Charge</td>
                                                        <td>{{ Session::get('currencies') }} {{$card->cod}}</td>
                                                        </tr>
                                                        <?php $total += $card->cod; ?>
                                                    @endif
                                                @endif
                                            @endif

                                            <tr>
                                              <td colspan="4"></td>
                                              <td>Grand Total</td>
                                              @php
                                                    $order = \App\Order::find($card->order_id);
                                                    if($order && $order->tip_amount){
                                                        $tip=$order->tip_amount?number_format($order->tip_amount/$order_count,2):0;
                                                    }else{
                                                        $tip=0;
                                                    }
                                                    
                                                    if($order && $order->coupon_amount){
                                                        $coupon=$order->coupon_amount?number_format($order->coupon_amount/$order_count,2):0;
                                                    }else{
                                                        $coupon=0;
                                                    }
                                                    $coupon = $card->coupon_amt;
                                                    $total += 
                                                        number_format((float) $tip - (float) $coupon,2);
                                                @endphp

                                                <td>{{ Session::get('currencies') }} {{ price_format($card->g_total) }}</td>

                                            </tr>
                                          </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="text-right print"><a href="{{url('/booking/invoice/'.$card->id)}}"><i class="fa fa-print" style="font-size:36px"></i></a></div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->

@endsection      



       