@extends('layouts.dashboard')
<!-- <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.2.0/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet"> -->
@section('content')
<style>
    .dt-buttons {
            display: none;
    }
    tfoot input {
        width: 100%;
        padding: 3px;
        box-sizing: border-box;
    }

    .card-card-body {
    padding: 0rem .25rem !important;
        }

        table.dataTable tbody td {
    padding: 5px !important;
    line-height: 24px !important;
    font-size: 13px !important;
        }

    #action-buttons-booking .btn{
        margin: 2px 4px !important;
    }

    .f-left {
        flex: left !important;
    }

</style>

        <!--**********************************

            Content body start

        ***********************************-->

        <div class="content-body">

            <div class="row page-titles mx-0">

                    <div class="col-sm-6 p-md-0">

                        <div class="breadcrumb-range-picker">

                            <h3 class="ml-1">Bookings</h3>

                        </div>

                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                      
                        <a href="{{ route('draft.bookings') }}">

                            <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                                <span class="btn-icon-left text-primary">

                                    <i class="fa fa-list color-primary"></i> 

                                </span>
                                Draft Bookings

                            </button>

                        </a>

                    </div>

                </div>

            <div class="container-fluid">

                @include('flash_msg')

                <div class="row">

                    <div class="col-12">

                        <div class="card">
                            
                            <div class="card-body">

                                <form action="" method="Get">
                                    
                                    <div class="row">
                                    
                                        <div class="col-lg-3 form-group">

                                            <label>Booking ID</label>
                                            
                                            <input type="text" name="booking_id" class="form-control" value="{{ $request->booking_id }}" placeholder="Search By Trans ID">

                                        </div>
                                        <div class="col-lg-3 form-group">

                                            <label>Payment Transaction ID</label>
                                            
                                            <input type="text" name="payment_id" class="form-control" value="{{ $request->payment_id }}" placeholder="Search By payment Transaction ID">

                                        </div>

                                        <!-- <div class="col-lg-3 form-group">

                                            <label>Slot Date</label>
                                            
                                            <input type="date" name="slot_date" class="form-control" value="{{ $request->slot_date }}" placeholder="Search By Slot Date">

                                        </div> -->
                                        <div class="col-lg-3 form-group">
                                            <label>From Date</label>
                                            <input type="date" name="from_date" id="from_date" class="form-control" placeholder="From Date">
                                        </div>
                                        <div class="col-lg-3 form-group">
                                            <label>To Date</label>
                                            <input type="date" name="to_date" id="to_date" class="form-control" placeholder="To Date">
                                        </div>

                                        <script>
                                            document.addEventListener('DOMContentLoaded', function () {
                                                // Get URL parameters
                                                const urlParams = new URLSearchParams(window.location.search);

                                                // Set the `from_date` and `to_date` input values if present in the URL
                                                const fromDate = urlParams.get('from_date');
                                                const toDate = urlParams.get('to_date');

                                                if (fromDate) {
                                                    document.getElementById('from_date').value = fromDate;
                                                }

                                                if (toDate) {
                                                    document.getElementById('to_date').value = toDate;
                                                }

                                                // Add event listeners for date validation
                                                const fromDateInput = document.getElementById('from_date');
                                                const toDateInput = document.getElementById('to_date');

                                                fromDateInput.addEventListener('change', function () {
                                                    // Ensure `to_date` is greater than or equal to `from_date`
                                                    if (toDateInput.value && new Date(toDateInput.value) < new Date(this.value)) {
                                                        alert("To Date cannot be earlier than From Date");
                                                        toDateInput.value = ""; // Clear the `to_date` field
                                                    }
                                                    toDateInput.min = this.value; // Set `to_date` minimum to `from_date`
                                                });

                                                toDateInput.addEventListener('change', function () {
                                                    // Ensure `to_date` is greater than or equal to `from_date`
                                                    if (fromDateInput.value && new Date(this.value) < new Date(fromDateInput.value)) {
                                                        alert("To Date cannot be earlier than From Date");
                                                        this.value = ""; // Clear the `to_date` field
                                                    }
                                                });
                                            });
                                        </script>


                                        <div class="col-lg-3 form-group">

                                            <label>Vendor Company</label>

                                            <select class="form-control vendor_name" name="vendor_name">
                                                <option value="">Select Company</option>
                                                @foreach($vendors as $vendor)
                                                <option {{ $request->vendor_name==$vendor->seller->company_name?'selected':'' }} value="{{$vendor->seller?$vendor->seller->company_name:'No Company'}}"> {{$vendor->seller?$vendor->seller->company_name:'No Company'}}</option>
                                                @endforeach
                                            </select>
                                            
                                           
                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Customer Name</label>

                                            <select class="form-control customer_name" name="customer_name">
                                                <option value="">Select Customer</option>
                                                @foreach($customers as $vendor)
                                                <option {{ $request->customer_name==$vendor->name?'selected':'' }} value="{{$vendor->name?$vendor->name:''}}"> {{$vendor->name?$vendor->name:''}}</option>
                                                @endforeach
                                            </select>
                                            

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Customer Mobile No.</label>
                                            
                                            <input type="number" name="customer_number" class="form-control" value="{{ $request->customer_number }}" placeholder="Search By Customer Mobile Number">

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Service Name</label>
                                            
                                            <input type="text" name="service_name" class="form-control" value="{{ $request->service_name }}" placeholder="Search By Service Name">

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Service Status</label>
                                            
                                            <select class="form-control" name="service_status">
                                                <option value="">Select Service Status</option>
                                                <option value="Pending" {{ $request->service_status=='Pending'?'selected':'' }}>Pending</option>
                                                <option value="Accept" {{ $request->service_status=='Accept'?'selected':'' }}>Accept</option>
                                                <option value="In Progress" {{ $request->service_status=='In Progress'?'selected':'' }}>In Progress</option>
                                                <option value="Mark As Arrived" {{ $request->service_status=='Mark As Arrived'?'selected':'' }}>Mark As Arrived</option>
                                                <option value="Completed" {{ $request->service_status=='Completed'?'selected':'' }}>Completed</option>
                                                <option value="Canceled" {{ $request->service_status=='Canceled'?'selected':'' }}>Canceled</option>
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Payment Mode</label>
                                            
                                            <select class="form-control" name="payment_mode">
                                                <option value="">Select Payment Mode</option>
                                                <option value="2" {{ $request->payment_mode=='Cash'?'selected':'' }}>Cash</option>
                                                <option value="1" {{ $request->payment_mode=='Card'?'selected':'' }}>Card</option>
                                                <option value="3" {{ $request->payment_mode=='3'?'selected':'' }}>Wallet</option>
                                                <option value="5" {{ $request->payment_mode=='5'?'selected':'' }}>Reward Points</option>
                                                <option value="6" {{ $request->payment_mode=='6'?'selected':'' }}>Apple Pay</option>
                                                <option value="4" {{ $request->payment_mode=='4'?'selected':'' }}>Tabby</option>
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Payment Status</label>
                                            
                                            <select class="form-control" name="payment_status">
                                                <option value="">Select Payment Status</option>
                                                <option value="True" {{ $request->payment_status=='True'?'selected':'' }}>True</option>
                                                <option value="False" {{ $request->payment_status=='False'?'selected':'' }}>False</option>
                                            </select>

                                        </div>

                                        <div class="col-lg-3 form-group">

                                            <label>Pending Approval</label>
                                            
                                            <select class="form-control" name="pending_approval">
                                                <option value="">Select Pending Approval</option>
                                                <option value="Not Approved" {{ $request->pending_approval=='Not Approved'?'selected':'' }}>Approved</option>
                                                <option value="Approved" {{ $request->pending_approval=='Approved'?'selected':'' }}>Not Approved</option>
                                            </select>

                                        </div>

                                        <!-- <div class="col-lg-3 form-group">

                                            <label>Payment ID</label>
                                            
                                            <input type="text" name="payment_id" class="form-control" value="{{ $request->payment_id }}" placeholder="Search By Payment ID">

                                        </div> -->

                                        <div class="col-lg-4 form-group mt-4">
                                            <button class="btn btn-primary mt-1" type="submit">Search</button>
                                            <a href="{{ route('bookings') }}"><button class="btn btn-danger mt-1" type="button">Clear</button></a>
                                            <button id="exportButton" class="btn btn-secondary mt-1" type="button">Export</button>
                                        </div>

                                    </div>

                                </form>
                                
                            </div>

                        </div>

                        <div class="card">

                            <div class="card-body card-card-body">                                

                                <div class="table-responsive">

                                    <table id="example" class="table table-striped" >

                                        <thead>

                                            <tr>

                                                <th>#</th>

                                                <th>Booking ID</th>
                                                <th>Slot ID</th>
                                                <th>Slot Date </th>

                                                <th>SLOT TIME</th>
                                                
                                                <th>Company<br> Name</th>

                                                <th style="width: 65px;">Customer<br> Name</th>

                                                <th>Service<br> Name</th>
                                                <th>Booking<br> Price</th>

                                                <th>Service <br>Status</th>

                                                <th>Payment <br>Type / Collect</th>

                                                <th>Payment <br>Status</th>

                                                <th class="text-center">Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>

                                            @if(!empty($bookings))

                                            @foreach($bookings as $key=>$value)

                                            <tr>

                                                <td>{{ ++$key }}</td>

                                                <td> <strong> Source - {{ $value->booking_from }} </strong>
                                                
                                                <br> <strong>Booking ID : </strong>{{ $value->tran_id }}
                                                <br> <strong>Cart Unique ID : </strong>{{ $value->cart_unique_id }}
                                                <br> <strong>Payment Trans ID: : </strong>{{ $value->paymentLinkId }}
                                                <br> {{ date('d F Y', strtotime($value->created_at)) }}
                                                </td>
                                                @php
                                                $slot_id = '';
                                                    if($value->service_id == 10){
                                                        if($value->ses_date){
                                                            $slot_date = date('d F Y', strtotime($value->ses_date));
                                                            $slot_id = $value->sess_id;
                                                        }else{
                                                            $slot_date = date('d F Y', strtotime($value->date));
                                                        }
                                                        
                                                        
                                                        
                                                    } else {
                                                        $slot_date = date('d F Y', strtotime($value->date));
                                                    }
                                                @endphp
                                                <td><strong>{{$slot_id}}</strong></td>
                                                <td>
                                                
												<strong> <u> {{ $slot_date }}  </u></strong>

                                                </td>
                                                
                                                <td>
                                                <p style=" font-size: 14px !important;  margin-bottom: 0rem !important;  line-height: 18px; ">
                                                    @if($value->service_id == 10)
                                                    
                                                        @foreach($value->sessionPackages as $s=>$v)
                                                            @if($v->id==$value->sess_id)
                                                                {{$v->slot->name??($value->slot->name??'')}}
                                                            @endif
                                                        @endforeach
                                                        
                                                    @else
                                                    
                                                     {{ $value->slot->name ?? '' }} </p>
                                                    @endif
                                             	</td>

                                                <td>
                                                    @if($value->seller && $value->seller->company_name)
                                                    {{  $value->seller->company_name ?? 'No Company' }}
                                                    @else
                                                    <?php
                                                        $seller  = App\Seller::where('user_id',$value->accept_user_id)->first();
                                                    ?>
                                                    {{ $seller?$seller->company_name:'No Company' }}
                                                    @endif
                                                </td>

                                                <td>
                                                	{{ $value->user->name ?? '' }}
                                                </td>



                                                <td>
                                                    
                                                    @if(isset($value->service_name))
                                                        {{ $value->service_name }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($value->service_id == 10)
                                                        @php
                                                            $g_total = $value->g_total;
                                                            if(isset($value->sessionPackages) && $value->sessionPackages->count() > 0){
                                                                $g_total = $g_total/ $value->sessionPackages->count();
                                                            }
                                                        @endphp
                                                        {{$g_total}}
                                                    @else
                                                    {{$value->g_total}}
                                                    @endif
                                                </td>
                                                
                                                <td>
                                                    @if($value->status=='Accept')
                                                    <span class="text-success">Accepted</span>
                                                    @elseif($value->status=='Completed')
                                                    <span class="text-success">Completed</span>
                                                    @elseif($value->status=='Mark As Arrived')
                                                    <span class="text-info">Mark As Arrived</span>
                                                    @elseif($value->status=='Canceled')
                                                    <span class="text-danger">Canceled</span>
                                                    @elseif($value->status=='In Progress')
                                                    <span class="text-warning">In Progress</span>
                                                    @else
                                                    <span class="text-warning">Pending</span>
                                                    @endif
                                                </td>

                                                <td>
                                                    @if($value->payment_type==4)
                                                        Tabby
                                                        
                                                    @endif
                                                     @if($value->payment_type==3)
                                                        Wallet
                                                        
                                                    @endif
                                                     @if($value->payment_type==6)
                                                        Apple Pay
                                                        @if($value->payment_collected=='Yes')
                                                            (<small class="text-success">Paid</small>)
                                                        @else
                                                            (<small class="text-warning">Pending</small>)
                                                        @endif
                                                    @endif
                                                     @if($value->payment_type==5)
                                                        Reward Points
                                                        
                                                    @endif
                                                    @if($value->payment_type==2)
                                                        Cash
                                                        @if($value->payment_collected=='Yes')
                                                            (<small class="text-success">Paid</small>)
                                                        @else
                                                            (<small class="text-warning">Pending</small>)
                                                        @endif
                                                    @endif

                                                    @if($value->payment_type==1)
                                                        Card
                                                        @if($value->payment_collected=='Yes')
                                                            (<small class="text-success">Paid</small>)
                                                        @else
                                                            (<small class="text-warning">Pending</small>)
                                                        @endif
                                                    @endif
                                                </td>

                                                <td>{{ $value->payment_status }}</td>

                                                
                                                <td class="text-center" id="action-buttons-booking">
                                                    @if($value->service_complete_approval =='Approved' && $value->status !=='Completed')  
                                                    <a href="{{ route('booking.completed',$value->id) }}" onclick="return confirm('Do you want to complete this service?')"><button type="button" class="btn btn-outline-dark btn-ft btn-sm" title="Service Completed" alt="Service Completed"><i class="fa fa-paper-plane" aria-hidden="true"></i></button></a>
                                                    @endif

                                                    @if($value->status !=='Canceled' && $value->status !=='Completed')
                                                    <button type="button" class="btn btn-outline-warning btn-ft btn-sm" data-toggle="modal" data-target="#exampleModal{{$value->id}}" title="Change Vendor" alt="Change Vendor"><i class="fa fa-cog" aria-hidden="true"></i></button>
                                                    @endif

                                                    <a href="{{ route('booking.view',$value->id) }}" target='_blank'><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit"><i class="fa fa-eye" aria-hidden="true"></i></button></a>

                                                    @if($value->status !=='Completed')
                                                    <a href="javascript:" onclick="payPayment({{$value->id}})" data-toggle="modal" data-target="#payPayment{{$value->id}}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Pay Payment" alt="Pay Payment"><i class="fa fa-money" aria-hidden="true"></i></button></a>
                                                    @endif
                                                    
                                                    @if($value->status !=='Completed')
                                                    <a href="{{ route('booking.delete',$value->id) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete"><i class="fa fa-trash-o" aria-hidden="true"></i></button></a>
                                                    @endif

                                                    @if($value->status !=='Canceled' && $value->status !=='Completed')
                                                    <a href="{{ route('booking.cencal',$value->id) }}" onclick="return confirm('Do you want to cancel the booking?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Cancel Booking" alt="Cancel Booking"><i class="fa fa-ban" aria-hidden="true"></i></button></a>
                                                    @endif

                                                    @if($value->status !=='Canceled' && $value->status !=='Completed')
                                                    <a href="{{ route('change.booking.date.time',encrypt($value->id)) }}" target="_blank"><button type="button" class="btn btn-outline-dark btn-ft btn-sm" title="Change Booking Slot and Date" alt="Change Booking Slot and Date"><i class="fa fa-calendar" aria-hidden="true"></i></button></a>
                                                    @endif

                                                    <!-- Modal -->
                                                    <div class="modal fade" id="exampleModal{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel">Change Company</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <form action="{{ route('change.vendor') }}" method="POST" enctype="multipart/form-data">
                                                                    @csrf
                                                                    <input type="hidden" name="booking_id" value="{{$value->id}}">
                                                                    <div class="modal-body">
                                                                        <div class="row">
                                                                             <div class="form-group col-lg-12">
                                                                                    <select class="form-control" name="vendor_id">
                                                                                        <option value="">Select Company</option>
                                                                                        @foreach($vendors as $vendor)
                                                                                        <option value="{{$vendor->id}}" {{ $value->accept_user_id==$vendor->id?'selected':'' }}>
                                                                                            {{$vendor->seller?$vendor->seller->company_name:'No Company'}}</option>
                                                                                        @endforeach
                                                                                    </select>
                                                                             </div>
                                                                        </div>
                                                                        
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                                        <button type="submit" class="btn btn-primary">Change</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <!-- Modal -->
                                                    <div class="modal fade" id="payPayment{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="payPaymentLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="payPaymentLabel">Update Payment</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <form action="{{ route('update.live.payment') }}" method="POST">
                                                                @csrf
                                                                    <div class="modal-body">
                                                                        <input type="hidden" name="booking_id" value="{{$value->id}}" class="booking_id">
                                                                        <div class="form-group">
                                                                            <label for="" style="float: left;">Payment Mode</label>
                                                                            <select name="payment_moad" class="form-control payment_moad" required>
                                                                                <option value="">Select Payment Mode</option>
                                                                                <option value="2" {{ $value->payment_moad=='Cash'?'selected':'' }}>Cash</option>
                                                                                <option value="1" {{ $value->payment_moad=='Card'?'selected':'' }}>Card</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="" style="float: left;">Payment Transaction ID </label>
                                                                            <input type="text" name="tran_id" value="{{ $value->paymentTranId ?? $value->tabby_payment_response_id }}" class="form-control tran_id" required>
                                                                        </div>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                                        <button type="submit" class="btn btn-primary">Update</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </td>

                                            </tr>

                                            @endforeach
                                            @endif

                                        </tbody>

                                        <tfoot>

                                            <tr>

                                                 <th>#</th>

                                                <th>Booking ID</th>
                                                <th>Slot ID</th>
                                                <th>SLOT Date</th>

                                                <th>SLOT TIME</th>

                                                <th>Company Name</th>
                                                
                                                <th>Customer Name</th>

                                                <th>Service Name</th>
                                                <th>Booking Price</th>

                                                <th>Service <br>Status</th>

                                                <th>Payment <br>Type</th>

                                                <th>Payment <br>Status</th>

                                                <th class="text-center">Action</th>

                                            </tr>

                                        </tfoot>

                                    </table>

                                </div>

                                

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <!--**********************************

            Content body end

        ***********************************-->

        

@endsection 

  
@section('script')


<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
    

    <script>
        $(document).ready(function() {
            
    $('select').each(function () {
        var placeholder = $(this).data('placeholder') || "Select an option";
        $(this).select2({
            placeholder: placeholder,
            allowClear: true
        });
    });
    
            var table = $('#example').DataTable( {
                "dom": 'Bfrtip', 
                "buttons": [
                    {
                        extend: 'csv',
                        className: 'btn btn-primary',
                        text: 'Export CSV'
                    }
                ],
                "searching": false
            } );
            
            
            // Trigger DataTable export functionality when the custom Export button is clicked
            $('#exportButton').on('click', function () {
                table.button('.buttons-csv').trigger(); // Trigger CSV export
            });
        } );
        
    </script>  

     <script>
        function changeVendor(params) {
            $('.booking_id').val(params);
            // $('.vendor_id').val(params.accept_user_id);
        }
    </script>

    <script>
        function payPayment(params) {
            $('.booking_id').val(params);
            // $('.payment_moad').val(params.payment_moad);
            // $('.tran_id').val(params.paymentLinkId);
        }
    </script>
@endsection         