<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorCardStatusTable extends Migration
{
    public function up()
    {
        Schema::create('vendor_card_status', function (Blueprint $table) {
            $table->id();
            $table->integer('vendor_id');  
            $table->integer('card_id');  
            $table->string('status', 255)
            ->nullable() 
            ->collation('utf8mb3_unicode_ci');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('vendor_card_status');
    }
}
