<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSessionsWeekPackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->string('total_sessions', 100)
                ->nullable()
                ->collation('utf8mb3_unicode_ci'); 
            $table->string('free_sessions', 100)
                ->nullable()
                ->collation('utf8mb3_unicode_ci'); 
            $table->string('days', 100)
                ->nullable()
                ->collation('utf8mb3_unicode_ci'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->dropColumn(['total_sessions', 'free_sessions', 'days']); 
        });
    }
}
